/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.NullValue;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.dao.hibernate.RuleSetDao;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleBean;
import org.akaza.openclinica.domain.rule.action.DiscrepancyNoteActionBean;
import org.akaza.openclinica.domain.rule.action.RuleActionBean;
import org.akaza.openclinica.domain.rule.expression.Context;
import org.akaza.openclinica.domain.rule.expression.ExpressionBean;
import org.akaza.openclinica.domain.rule.expression.ExpressionObjectWrapper;
import org.akaza.openclinica.domain.rule.expression.ExpressionProcessor;
import org.akaza.openclinica.domain.rule.expression.ExpressionProcessorFactory;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.rule.RulesPostImportContainerService;
import org.akaza.openclinica.service.rule.expression.ExpressionService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRuleServlet
extends SecureController {
    private static final long serialVersionUID = 9116068126651934226L;
    protected final Logger log = LoggerFactory.getLogger(TestRuleServlet.class);
    Locale locale;
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    RuleSetRuleDao ruleSetRuleDao;
    RuleSetDao ruleSetDao;
    ItemDAO itemDAO;
    ItemFormMetadataDAO itemFormMetadataDAO;
    RulesPostImportContainerService rulesPostImportContainerService;
    private ExpressionService expressionService;
    private final String TARGET = "target";
    private final String RULE = "rule";
    private final String RULE_SET_RULE_ID = "ruleSetRuleId";
    private final String RULE_SET_ID = "ruleSetId";

    void putDummyActionInSession() {
        ArrayList<DiscrepancyNoteActionBean> actions = new ArrayList<DiscrepancyNoteActionBean>();
        DiscrepancyNoteActionBean discNoteAction = new DiscrepancyNoteActionBean();
        discNoteAction.setExpressionEvaluatesTo(Boolean.valueOf(true));
        discNoteAction.setMessage("TEST DISCREPANCY");
        actions.add(discNoteAction);
        this.session.setAttribute("testRuleActions", actions);
    }

    void populteFormFields(FormProcessor fp) {
        String targetSess;
        String targetForm = fp.getString("target").trim().replaceAll("(\n|\t|\r)", "");
        String testRulesTarget = (String)this.session.getAttribute("testRulesTarget");
        if (testRulesTarget != null && !targetForm.equals(targetSess = testRulesTarget.trim().replaceAll("(\n|\t|\r)", ""))) {
            this.putDummyActionInSession();
            this.session.removeAttribute("testRulesTarget");
        }
        String[] textFields = new String[]{"target", "rule", "ruleSetRuleId"};
        fp.setCurrentStringValuesAsPreset(textFields);
        HashMap presetValues = fp.getPresetValues();
        this.setPresetValues(presetValues);
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String action = this.request.getParameter("action");
        Validator v = new Validator(this.request);
        if (StringUtil.isBlank((String)action)) {
            this.request.setAttribute("result", (Object)resword.getString("test_rule_default_result"));
            Integer ruleSetRuleId = fp.getInt("ruleSetRuleId");
            if (ruleSetRuleId != 0) {
                RuleSetRuleBean rsr = (RuleSetRuleBean)this.getRuleSetRuleDao().findById(ruleSetRuleId);
                rsr.getActions().size();
                HashMap<String, String> presetValues = new HashMap<String, String>();
                presetValues.put("target", rsr.getRuleSetBean().getTarget().getValue());
                presetValues.put("rule", rsr.getRuleBean().getExpression().getValue());
                presetValues.put("ruleSetRuleId", String.valueOf(ruleSetRuleId));
                fp.setPresetValues(presetValues);
                this.setPresetValues(presetValues);
                this.session.setAttribute("testRuleActions", (Object)rsr.getActions());
                this.session.setAttribute("testRulesTarget", (Object)rsr.getRuleSetBean().getTarget().getValue());
                this.request.setAttribute("ruleSetRuleId", (Object)ruleSetRuleId);
                this.request.setAttribute("ruleSetId", (Object)rsr.getRuleSetBean().getId());
                ItemBean item = this.getExpressionService().getItemBeanFromExpression(rsr.getRuleSetBean().getTarget().getValue());
                if (item != null) {
                    this.request.setAttribute("itemName", (Object)item.getName());
                    this.request.setAttribute("itemDefinition", (Object)item.getDescription());
                } else {
                    StudyEventDefinitionBean studyEventDef = this.getExpressionService().getStudyEventDefinitionFromExpressionForEvents(rsr.getRuleSetBean().getTarget().getValue(), this.currentStudy);
                    this.request.setAttribute("itemName", (Object)studyEventDef.getName());
                    this.request.setAttribute("itemDefinition", (Object)studyEventDef.getDescription());
                }
                this.request.setAttribute("ruleSetRuleAvailable", (Object)true);
            } else {
                this.putDummyActionInSession();
            }
            this.session.removeAttribute("testValues");
            this.request.setAttribute("action", (Object)"validate");
            this.forwardPage(Page.TEST_RULES);
        } else if (action.equals("validate")) {
            HashMap result = this.validate(v);
            if (((String)result.get("ruleValidation")).equals("rule_valid")) {
                this.addPageMessage(resword.getString("test_rules_message_valid"));
            } else {
                this.addPageMessage(resword.getString("test_rules_message_invalid"));
            }
            this.request.setAttribute("ruleValidation", result.get("ruleValidation"));
            this.request.setAttribute("validate", (Object)"on");
            this.request.setAttribute("ruleEvaluatesTo", (Object)resword.getString("test_rules_validate_message"));
            this.request.setAttribute("ruleValidationFailMessage", result.get("ruleValidationFailMessage"));
            this.request.setAttribute("action", (Object)(((String)result.get("ruleValidation")).equals("rule_valid") ? "test" : "validate"));
            result.remove("result");
            result.remove("ruleValidation");
            result.remove("ruleEvaluatesTo");
            result.remove("ruleValidationFailMessage");
            this.populateTooltip(result);
            this.session.setAttribute("testValues", (Object)result);
            this.populteFormFields(fp);
            this.forwardPage(Page.TEST_RULES);
        } else if (action.equals("test")) {
            HashMap result = this.validate(v);
            HashMap errors = v.validate();
            if (!errors.isEmpty()) {
                this.setInputMessages(errors);
                if (((String)result.get("ruleValidation")).equals("rule_valid")) {
                    this.addPageMessage(resword.getString("test_rules_message_valid"));
                } else {
                    this.addPageMessage(resword.getString("test_rules_message_invalid"));
                }
                this.request.setAttribute("ruleValidation", result.get("ruleValidation"));
                this.request.setAttribute("validate", (Object)"on");
                this.request.setAttribute("ruleEvaluatesTo", (Object)(resword.getString("test_rules_rule_fail_invalid_data_type") + " " + resword.getString("test_rules_rule_fail_invalid_data_type_desc")));
                this.request.setAttribute("ruleValidationFailMessage", result.get("ruleValidationFailMessage"));
                this.request.setAttribute("action", (Object)"test");
            } else {
                if (((String)result.get("ruleValidation")).equals("rule_valid")) {
                    this.addPageMessage(resword.getString("test_rules_message_valid"));
                } else {
                    this.addPageMessage(resword.getString("test_rules_message_invalid"));
                }
                this.request.setAttribute("action", (Object)(((String)result.get("ruleValidation")).equals("rule_valid") ? "test" : "validate"));
                this.request.setAttribute("ruleValidation", result.get("ruleValidation"));
                this.request.setAttribute("ruleEvaluatesTo", result.get("ruleEvaluatesTo"));
                this.request.setAttribute("ruleValidationFailMessage", result.get("ruleValidationFailMessage"));
            }
            if (((String)result.get("ruleValidation")).equals("rule_invalid")) {
                this.session.setAttribute("testValues", new HashMap());
            } else {
                this.session.setAttribute("testValues", (Object)result);
            }
            result.remove("result");
            result.remove("ruleValidation");
            result.remove("ruleEvaluatesTo");
            result.remove("ruleValidationFailMessage");
            this.populateTooltip(result);
            this.populteFormFields(fp);
            this.forwardPage(Page.TEST_RULES);
        }
    }

    private void itemDataTypeToValidatorId(String key, ItemBean item, Validator v) {
        switch (item.getItemDataTypeId()) {
            case 6: {
                v.addValidation(key, 10);
                break;
            }
            case 7: {
                v.addValidation(key, 2);
                break;
            }
            case 9: {
                v.addValidation(key, 4);
                break;
            }
        }
    }

    private void itemDataTypeToValidatorIdMultiSelect(String key, ItemBean item, Validator v, ResponseSetBean responseSet) {
        v.addValidation(key, 38, responseSet);
    }

    private void populateTooltip(HashMap<String, String> testVariablesAndValues) {
        if (testVariablesAndValues != null) {
            for (Map.Entry<String, String> entry : testVariablesAndValues.entrySet()) {
                ItemBean item = this.getExpressionService().getItemBeanFromExpression(entry.getKey());
                if (item != null) {
                    DisplayItemBean dib = new DisplayItemBean();
                    dib.setItem(item);
                    this.request.setAttribute(entry.getKey() + "-tooltip", (Object)(item.getName() + ": " + ItemDataType.get((int)item.getItemDataTypeId()).getName()));
                    this.request.setAttribute(entry.getKey() + "-dib", (Object)dib);
                } else {
                    StudyEventDefinitionBean sed = this.getExpressionService().getStudyEventDefinitionFromExpressionForEvents(entry.getKey(), this.currentStudy);
                    if (entry.getKey().contains(".STARTDATE")) {
                        this.request.setAttribute(entry.getKey() + "-tooltip", (Object)(sed.getName() + ": date"));
                        this.request.setAttribute("studyEventProperty", (Object)new Integer(9));
                    } else if (entry.getKey().contains(".STATUS")) {
                        this.request.setAttribute(entry.getKey() + "-tooltip", (Object)(sed.getName() + ": status"));
                        this.request.setAttribute("studyEventProperty", (Object)new Integer(5));
                    }
                }
                if ((item == null || item.getItemDataTypeId() != 9) && (item != null || !entry.getKey().contains(".STARTDATE"))) continue;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(resformat.getString("date_format_string"));
                    SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                    if (entry.getValue().isEmpty()) continue;
                    Date date = sdf2.parse(entry.getValue());
                    entry.setValue(sdf.format(date));
                }
                catch (Exception e) {
                    logger.error(e.toString());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> validate(Validator v) throws ParseException {
        ArrayList actions;
        StudyEventDefinitionBean sed;
        HashMap p;
        FormProcessor fp = new FormProcessor(this.request);
        String targetString = fp.getString("target");
        String ruleString = fp.getString("rule");
        ruleString = ruleString.trim().replaceAll("(\n|\t|\r)", " ");
        targetString = targetString.trim().replaceAll("(\n|\t|\r)", "");
        HashMap hashMap = p = this.session.getAttribute("testValues") != null ? (HashMap)this.session.getAttribute("testValues") : new HashMap();
        if (p != null) {
            for (Map.Entry entry : p.entrySet()) {
                ItemFormMetadataBean itemFormMetadataBean;
                entry.setValue(fp.getString((String)entry.getKey()));
                if (((String)entry.getKey()).startsWith("SE_") && (((String)entry.getKey()).endsWith(".STATUS") || ((String)entry.getKey()).endsWith(".STARTDATE"))) {
                    sed = this.getExpressionService().getStudyEventDefinitionFromExpressionForEvents((String)entry.getKey(), this.currentStudy);
                    if (((String)entry.getKey()).endsWith(".STATUS") || !((String)entry.getKey()).endsWith(".STARTDATE")) continue;
                    try {
                        v.addValidation((String)entry.getKey(), 4);
                        SimpleDateFormat sdf = new SimpleDateFormat(resformat.getString("date_format_string"));
                        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                        if (((String)entry.getValue()).isEmpty()) continue;
                        Date date = sdf2.parse((String)entry.getValue());
                        entry.setValue(sdf.format(date));
                    }
                    catch (Exception e) {
                        logger.error(e.toString());
                    }
                    continue;
                }
                ItemBean item = this.getExpressionService().getItemBeanFromExpression((String)entry.getKey());
                ArrayList itemFormMetadataBeans = this.getItemFormMetadataDAO().findAllByItemId(item.getId());
                ItemFormMetadataBean itemFormMetadataBean2 = itemFormMetadataBean = itemFormMetadataBeans.size() > 0 ? (ItemFormMetadataBean)itemFormMetadataBeans.get(0) : null;
                if (!((String)entry.getValue()).equals("") && NullValue.getByName((String)((String)entry.getValue())) == NullValue.INVALID && itemFormMetadataBean != null) {
                    if (itemFormMetadataBean.getResponseSet().getResponseType() == ResponseType.SELECTMULTI || itemFormMetadataBean.getResponseSet().getResponseType() == ResponseType.CHECKBOX) {
                        v.addValidation((String)entry.getKey(), 38, itemFormMetadataBean.getResponseSet());
                    }
                    if (itemFormMetadataBean.getResponseSet().getResponseType() == ResponseType.SELECT || itemFormMetadataBean.getResponseSet().getResponseType() == ResponseType.RADIO) {
                        v.addValidation((String)entry.getKey(), 24, itemFormMetadataBean.getResponseSet());
                    } else {
                        this.itemDataTypeToValidatorId((String)entry.getKey(), item, v);
                    }
                }
                if (item.getItemDataTypeId() != 9) continue;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(resformat.getString("date_format_string"));
                    SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                    if (((String)entry.getValue()).isEmpty()) continue;
                    Date date = sdf.parse((String)entry.getValue());
                    entry.setValue(sdf2.format(date));
                }
                catch (Exception sdf) {}
            }
        }
        List list = actions = this.session.getAttribute("testRuleActions") != null ? (List)this.session.getAttribute("testRuleActions") : new ArrayList();
        if (actions != null) {
            void var7_9;
            boolean bl = false;
            while (var7_9 < actions.size()) {
                ((RuleActionBean)actions.get((int)var7_9)).setExpressionEvaluatesTo(Boolean.valueOf(fp.getBoolean("actions" + (int)var7_9)));
                ++var7_9;
            }
        }
        try {
            this.getExpressionService().ruleSetExpressionChecker(targetString);
        }
        catch (OpenClinicaSystemException openClinicaSystemException) {
            HashMap<String, String> result = new HashMap<String, String>();
            MessageFormat mf = new MessageFormat("");
            mf.applyPattern(respage.getString(openClinicaSystemException.getErrorCode()));
            Object[] arguments = openClinicaSystemException.getErrorParams();
            result.put("ruleValidation", "target_invalid");
            result.put("ruleValidationFailMessage", openClinicaSystemException.getErrorCode() + " : " + mf.format(arguments));
            result.put("ruleEvaluatesTo", "");
            this.request.setAttribute("targetFail", (Object)"on");
            return result;
        }
        ItemBean itemBean = this.getExpressionService().getItemBeanFromExpression(targetString);
        sed = null;
        if (itemBean != null) {
            this.request.setAttribute("itemName", (Object)itemBean.getName());
            this.request.setAttribute("itemDefinition", (Object)itemBean.getDescription());
        } else {
            sed = this.getExpressionService().getStudyEventDefinitionFromExpressionForEvents(targetString, this.currentStudy);
            if (sed != null) {
                this.request.setAttribute("itemName", (Object)sed.getName());
                this.request.setAttribute("itemDefinition", (Object)sed.getDescription());
            }
        }
        RuleSetBean ruleSet = new RuleSetBean();
        ExpressionBean target = new ExpressionBean();
        target.setContext(Context.OC_RULES_V1);
        target.setValue(targetString);
        ruleSet.setTarget(target);
        RuleSetBean persistentRuleSet = this.getRuleSetDao().findByExpressionAndStudy(ruleSet, Integer.valueOf(this.currentStudy.getId()));
        if (persistentRuleSet != null) {
            if (itemBean != null) {
                this.request.setAttribute("ruleSetId", (Object)itemBean.getId());
            } else {
                this.request.setAttribute("ruleSetId", (Object)sed.getId());
            }
        }
        ExpressionBean rule = new ExpressionBean();
        rule.setContext(Context.OC_RULES_V1);
        rule.setValue(ruleString);
        ExpressionObjectWrapper eow = new ExpressionObjectWrapper(this.sm.getDataSource(), this.currentStudy, rule, ruleSet);
        ExpressionProcessor ep = ExpressionProcessorFactory.createExpressionProcessor((ExpressionObjectWrapper)eow);
        ep.setRespage(respage);
        DateTime start = new DateTime();
        HashMap result = ep.testEvaluateExpression(p);
        DateTime end = new DateTime();
        Duration dur = new Duration((ReadableInstant)start, (ReadableInstant)end);
        PeriodFormatter yearsAndMonths = new PeriodFormatterBuilder().printZeroAlways().appendSecondsWithMillis().appendSuffix(" second", " seconds").toFormatter();
        yearsAndMonths.print((ReadablePeriod)dur.toPeriod());
        HashMap k = new HashMap();
        HashMap theResult = ep.testEvaluateExpression(k);
        if (((String)theResult.get("ruleValidation")).equals("rule_valid") && ((String)result.get("ruleValidation")).equals("rule_invalid")) {
            result.put("ruleValidation", "rule_valid");
            result.put("ruleEvaluatesTo", resword.getString("test_rules_rule_fail") + " " + (String)result.get("ruleValidationFailMessage"));
            result.remove("ruleValidationFailMessage");
        }
        this.request.setAttribute("duration", (Object)yearsAndMonths.print((ReadablePeriod)dur.toPeriod()));
        return result;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    private RuleSetRuleDao getRuleSetRuleDao() {
        this.ruleSetRuleDao = this.ruleSetRuleDao != null ? this.ruleSetRuleDao : (RuleSetRuleDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetRuleDao");
        return this.ruleSetRuleDao;
    }

    private RuleSetDao getRuleSetDao() {
        this.ruleSetDao = this.ruleSetDao != null ? this.ruleSetDao : (RuleSetDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetDao");
        return this.ruleSetDao;
    }

    private ItemDAO getItemDAO() {
        this.itemDAO = this.itemDAO != null ? this.itemDAO : new ItemDAO(this.sm.getDataSource());
        return this.itemDAO;
    }

    private ItemFormMetadataDAO getItemFormMetadataDAO() {
        this.itemFormMetadataDAO = this.itemFormMetadataDAO != null ? this.itemFormMetadataDAO : new ItemFormMetadataDAO(this.sm.getDataSource());
        return this.itemFormMetadataDAO;
    }

    private RulesPostImportContainerService getRulesPostImportContainerService() {
        this.rulesPostImportContainerService = this.rulesPostImportContainerService != null ? this.rulesPostImportContainerService : (RulesPostImportContainerService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("rulesPostImportContainerService");
        this.rulesPostImportContainerService.setCurrentStudy(this.currentStudy);
        this.rulesPostImportContainerService.setRespage(respage);
        this.rulesPostImportContainerService.setUserAccount(this.ub);
        return this.rulesPostImportContainerService;
    }

    private ExpressionService getExpressionService() {
        this.expressionService = this.expressionService != null ? this.expressionService : new ExpressionService(new ExpressionObjectWrapper(this.sm.getDataSource(), this.currentStudy, (ExpressionBean)null, (RuleSetBean)null));
        this.expressionService.setExpressionWrapper(new ExpressionObjectWrapper(this.sm.getDataSource(), this.currentStudy, (ExpressionBean)null, (RuleSetBean)null));
        return this.expressionService;
    }
}

