/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.rule.FileProperties;
import org.akaza.openclinica.bean.rule.FileRenamePolicy;
import org.akaza.openclinica.bean.rule.FileUploadHelper;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.UploadFileServlet;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;

public class UploadFileServlet
extends SecureController {
    Locale locale;
    FileUploadHelper uploadHelper = new FileUploadHelper(new FileProperties(CoreResources.getField((String)"crf.file.extensions"), CoreResources.getField((String)"crf.file.extensionSettings")));

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if ("false".equals(this.session.getAttribute("mayProcessUploading"))) {
            this.addPageMessage(respage.getString("you_not_have_permission_upload_file"));
            this.request.setAttribute("uploadFileStauts", (Object)"noPermission");
        }
    }

    public void processRequest() throws Exception {
        String submitted;
        FormProcessor fp = new FormProcessor(this.request);
        HashMap<String, String> newUploadedFiles = (HashMap<String, String>)this.session.getAttribute("newUploadedFiles");
        if (newUploadedFiles == null) {
            newUploadedFiles = new HashMap<String, String>();
        }
        String string = submitted = fp.getString("submitted") != null ? fp.getString("submitted") : "";
        if ("no".equalsIgnoreCase(submitted)) {
            this.request.setAttribute("fileItemId", (Object)fp.getString("itemId"));
            this.request.setAttribute("inputName", (Object)fp.getString("inputName"));
            this.forwardPage(Page.FILE_UPLOAD);
        } else {
            String dir = Utils.getAttachedFilePath((StudyBean)this.currentStudy);
            if (dir == null || dir.length() <= 0) {
                this.request.setAttribute("uploadFileStauts", (Object)"failed");
                this.forwardPage(Page.FILE_UPLOAD);
            } else {
                if (!new File(dir).isDirectory()) {
                    new File(dir).mkdirs();
                    logger.info("Made the directory " + dir);
                }
                this.request.setAttribute("attachedFilePath", (Object)dir);
                try {
                    List files = this.uploadHelper.returnFiles(this.request, this.context, dir, (FileRenamePolicy)new OCFileRename(this));
                    String fileName = "";
                    for (File temp : files) {
                        if (temp == null || temp.getName() == null) {
                            fileName = "";
                            continue;
                        }
                        fileName = temp.getName();
                        logger.info("fileName=" + fileName);
                    }
                    logger.info("===== fileName=" + fileName);
                    this.request.setAttribute("fileName", (Object)fileName);
                    this.request.setAttribute("uploadFileStatus", (Object)"successed");
                    String key = "";
                    String inputName = (String)this.request.getAttribute("inputName");
                    String itemId = (String)this.request.getAttribute("itemId");
                    this.request.setAttribute("fileItemId", (Object)(itemId + ""));
                    key = inputName != null && inputName.length() > 0 ? fileName : itemId;
                    if (fileName.length() > 0) {
                        newUploadedFiles.put(key, dir + File.separator + fileName);
                        this.addPageMessage(fileName + " " + respage.getString("uploaded_successfully_go_to_data_entry_page_to_save_into_database"));
                    } else {
                        this.request.setAttribute("uploadFileStatus", (Object)"empty");
                        this.addPageMessage(respage.getString("no_file_uploaded_please_specify_file"));
                    }
                    if (inputName != null && inputName.length() > 0) {
                        this.request.setAttribute("inputName", (Object)inputName);
                    }
                    this.session.setAttribute("newUploadedFiles", newUploadedFiles);
                }
                catch (OpenClinicaSystemException e) {
                    this.request.setAttribute("uploadFileStauts", (Object)"failed");
                    MessageFormat mf = new MessageFormat("");
                    mf.applyPattern(respage.getString(e.getErrorCode()));
                    Object[] arguments = e.getErrorParams();
                    this.addPageMessage(respage.getString("file_uploading_failed_please_check_logs_and_upload_again") + mf.format(arguments));
                    logger.error("File upload is failed: ", (Throwable)e);
                }
                this.forwardPage(Page.FILE_UPLOAD);
            }
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    static /* synthetic */ Logger access$300() {
        return logger;
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }

    static /* synthetic */ Logger access$500() {
        return logger;
    }
}

