/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemBeanWrapper;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ODMContainer;
import org.akaza.openclinica.bean.submit.crfdata.SubjectDataBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.logic.rulerunner.ExecutionMode;
import org.akaza.openclinica.logic.rulerunner.ImportDataRuleRunnerContainer;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.job.CrfBusinessLogicHelper;
import org.akaza.openclinica.web.job.ImportSpringJob;

public class VerifyImportedCRFDataServlet
extends SecureController {
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.INVESTIGATOR) || r.equals((Term)Role.RESEARCHASSISTANT) || r.equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    public static DiscrepancyNoteBean createDiscrepancyNote(ItemBean itemBean, String message, EventCRFBean eventCrfBean, DisplayItemBean displayItemBean, Integer parentId, UserAccountBean uab, DataSource ds, StudyBean study) {
        DiscrepancyNoteBean note = new DiscrepancyNoteBean();
        StudySubjectDAO ssdao = new StudySubjectDAO(ds);
        note.setDescription(message);
        note.setDetailedNotes("Failed Validation Check");
        note.setOwner(uab);
        note.setCreatedDate(new Date());
        note.setResolutionStatusId(ResolutionStatus.OPEN.getId());
        note.setDiscrepancyNoteTypeId(DiscrepancyNoteType.FAILEDVAL.getId());
        if (parentId != null) {
            note.setParentDnId(parentId.intValue());
        }
        note.setField(itemBean.getName());
        note.setStudyId(study.getId());
        note.setEntityName(itemBean.getName());
        note.setEntityType("itemData");
        note.setEntityValue(displayItemBean.getData().getValue());
        note.setEventName(eventCrfBean.getName());
        note.setEventStart(eventCrfBean.getCreatedDate());
        note.setCrfName(displayItemBean.getEventDefinitionCRF().getCrfName());
        StudySubjectBean ss = (StudySubjectBean)ssdao.findByPK(eventCrfBean.getStudySubjectId());
        note.setSubjectName(ss.getName());
        note.setEntityId(displayItemBean.getData().getId());
        note.setColumn("value");
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(ds);
        note = (DiscrepancyNoteBean)dndao.create((EntityBean)note);
        dndao.createMapping(note);
        return note;
    }

    public void processRequest() throws Exception {
        ItemDataDAO itemDataDao = new ItemDataDAO(this.sm.getDataSource());
        itemDataDao.setFormatDates(false);
        EventCRFDAO eventCrfDao = new EventCRFDAO(this.sm.getDataSource());
        CrfBusinessLogicHelper crfBusinessLogicHelper = new CrfBusinessLogicHelper(this.sm.getDataSource());
        String action = this.request.getParameter("action");
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.setToPanel(resword.getString("create_CRF"), respage.getString("br_create_new_CRF_entering"));
        this.setToPanel(resword.getString("create_CRF_version"), respage.getString("br_create_new_CRF_uploading"));
        this.setToPanel(resword.getString("revise_CRF_version"), respage.getString("br_if_you_owner_CRF_version"));
        this.setToPanel(resword.getString("CRF_spreadsheet_template"), respage.getString("br_download_blank_CRF_spreadsheet_from"));
        this.setToPanel(resword.getString("example_CRF_br_spreadsheets"), respage.getString("br_download_example_CRF_instructions_from"));
        if ("confirm".equalsIgnoreCase(action)) {
            List displayItemBeanWrappers = (List)this.session.getAttribute("importedData");
            logger.info("Size of displayItemBeanWrappers : " + displayItemBeanWrappers.size());
            this.forwardPage(Page.VERIFY_IMPORT_CRF_DATA);
        }
        if ("save".equalsIgnoreCase(action)) {
            RuleSetServiceInterface ruleSetService = (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
            List containers = this.ruleRunSetup(this.sm.getDataSource(), this.currentStudy, this.ub, ruleSetService);
            List displayItemBeanWrappers = (List)this.session.getAttribute("importedData");
            HashMap importedCRFStatuses = (HashMap)this.session.getAttribute("importedCRFStatuses");
            for (DisplayItemBeanWrapper wrapper : displayItemBeanWrappers) {
                boolean resetSDV = false;
                int eventCrfBeanId = -1;
                EventCRFBean eventCrfBean = new EventCRFBean();
                logger.info("right before we check to make sure it is savable: " + wrapper.isSavable());
                if (!wrapper.isSavable()) continue;
                ArrayList<Integer> eventCrfInts = new ArrayList<Integer>();
                for (DisplayItemBean displayItemBean : wrapper.getDisplayItemBeans()) {
                    eventCrfBeanId = displayItemBean.getData().getEventCRFId();
                    eventCrfBean = (EventCRFBean)eventCrfDao.findByPK(eventCrfBeanId);
                    logger.info("found value here: " + displayItemBean.getData().getValue());
                    logger.info("found status here: " + eventCrfBean.getStatus().getName());
                    ItemDataBean itemDataBean = new ItemDataBean();
                    itemDataBean = itemDataDao.findByItemIdAndEventCRFIdAndOrdinal(displayItemBean.getItem().getId(), eventCrfBean.getId(), displayItemBean.getData().getOrdinal());
                    if (wrapper.isOverwrite() && itemDataBean.getStatus() != null) {
                        if (!itemDataBean.getValue().equals(displayItemBean.getData().getValue())) {
                            resetSDV = true;
                        }
                        logger.info("just tried to find item data bean on item name " + displayItemBean.getItem().getName());
                        itemDataBean.setUpdatedDate(new Date());
                        itemDataBean.setUpdater(this.ub);
                        itemDataBean.setValue(displayItemBean.getData().getValue());
                        itemDataDao.update((EntityBean)itemDataBean);
                        logger.info("updated: " + itemDataBean.getItemId());
                        displayItemBean.getData().setId(itemDataBean.getId());
                    } else {
                        resetSDV = true;
                        itemDataDao.create((EntityBean)displayItemBean.getData());
                        logger.info("created: " + displayItemBean.getData().getItemId() + "event CRF ID = " + eventCrfBean.getId() + "CRF VERSION ID =" + eventCrfBean.getCRFVersionId());
                        ItemDataBean itemDataBean2 = itemDataDao.findByItemIdAndEventCRFIdAndOrdinal(displayItemBean.getItem().getId(), eventCrfBean.getId(), displayItemBean.getData().getOrdinal());
                        logger.info("found: id " + itemDataBean2.getId() + " name " + itemDataBean2.getName());
                        displayItemBean.getData().setId(itemDataBean2.getId());
                    }
                    ItemDAO idao = new ItemDAO(this.sm.getDataSource());
                    ItemBean ibean = (ItemBean)idao.findByPK(displayItemBean.getData().getItemId());
                    String itemOid = displayItemBean.getItem().getOid() + "_" + wrapper.getStudyEventRepeatKey() + "_" + displayItemBean.getData().getOrdinal() + "_" + wrapper.getStudySubjectOid();
                    if (wrapper.getValidationErrors().containsKey(itemOid)) {
                        ArrayList messageList = (ArrayList)wrapper.getValidationErrors().get(itemOid);
                        for (int iter = 0; iter < messageList.size(); ++iter) {
                            String message = (String)messageList.get(iter);
                            DiscrepancyNoteBean parentDn = ImportSpringJob.createDiscrepancyNote((ItemBean)ibean, (String)message, (EventCRFBean)eventCrfBean, (DisplayItemBean)displayItemBean, null, (UserAccountBean)this.ub, (DataSource)this.sm.getDataSource(), (StudyBean)this.currentStudy);
                            ImportSpringJob.createDiscrepancyNote((ItemBean)ibean, (String)message, (EventCRFBean)eventCrfBean, (DisplayItemBean)displayItemBean, (Integer)parentDn.getId(), (UserAccountBean)this.ub, (DataSource)this.sm.getDataSource(), (StudyBean)this.currentStudy);
                        }
                    }
                    if (eventCrfInts.contains(new Integer(eventCrfBean.getId()))) continue;
                    String eventCRFStatus = (String)importedCRFStatuses.get(new Integer(eventCrfBean.getId()));
                    if (eventCRFStatus != null && eventCRFStatus.equals(DataEntryStage.INITIAL_DATA_ENTRY.getName()) && eventCrfBean.getStatus().isAvailable()) {
                        crfBusinessLogicHelper.markCRFStarted(eventCrfBean, this.ub);
                    } else {
                        crfBusinessLogicHelper.markCRFComplete(eventCrfBean, this.ub);
                    }
                    eventCrfInts.add(new Integer(eventCrfBean.getId()));
                }
                if (eventCrfBean == null || !resetSDV) continue;
                eventCrfDao.setSDVStatus(false, this.ub.getId(), eventCrfBean.getId());
            }
            this.addPageMessage(respage.getString("data_has_been_successfully_import"));
            this.addPageMessage(this.ruleActionWarnings(this.runRules(this.currentStudy, this.ub, containers, ruleSetService, ExecutionMode.SAVE)));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
        }
    }

    private List<ImportDataRuleRunnerContainer> ruleRunSetup(DataSource dataSource, StudyBean studyBean, UserAccountBean userBean, RuleSetServiceInterface ruleSetService) {
        ArrayList<ImportDataRuleRunnerContainer> containers = new ArrayList<ImportDataRuleRunnerContainer>();
        ODMContainer odmContainer = (ODMContainer)this.session.getAttribute("odmContainer");
        if (odmContainer != null) {
            ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
            if (ruleSetService.getCountByStudy(studyBean) > 0) {
                for (SubjectDataBean subjectDataBean : subjectDataBeans) {
                    ImportDataRuleRunnerContainer container = new ImportDataRuleRunnerContainer();
                    container.initRuleSetsAndTargets(dataSource, studyBean, subjectDataBean, ruleSetService);
                    if (!container.getShouldRunRules().booleanValue()) continue;
                    containers.add(container);
                }
                if (containers != null && !containers.isEmpty()) {
                    ruleSetService.runRulesInImportData(containers, studyBean, userBean, ExecutionMode.DRY_RUN);
                }
            }
        }
        return containers;
    }

    private List<String> runRules(StudyBean studyBean, UserAccountBean userBean, List<ImportDataRuleRunnerContainer> containers, RuleSetServiceInterface ruleSetService, ExecutionMode executionMode) {
        List<String> messages = new ArrayList<String>();
        if (containers != null && !containers.isEmpty()) {
            HashMap summary = ruleSetService.runRulesInImportData(containers, studyBean, userBean, executionMode);
            messages = this.extractRuleActionWarnings(summary);
        }
        return messages;
    }

    private List<String> extractRuleActionWarnings(HashMap<String, ArrayList<String>> summaryMap) {
        ArrayList<String> messages = new ArrayList<String>();
        if (summaryMap != null && !summaryMap.isEmpty()) {
            for (String key : summaryMap.keySet()) {
                StringBuilder mesg = new StringBuilder(key + " : ");
                for (String s : summaryMap.get(key)) {
                    mesg.append(s + ", ");
                }
                messages.add(mesg.toString());
            }
        }
        return messages;
    }

    private String ruleActionWarnings(List<String> warnings) {
        if (warnings.isEmpty()) {
            return "";
        }
        StringBuilder mesg = new StringBuilder("Rule Action Warnings: ");
        for (String s : warnings) {
            mesg.append(s + "; ");
        }
        return mesg.toString();
    }
}

