/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends DefaultHandler {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    List<HashMap<String, String>> allCrfData = new ArrayList();
    private HashMap<String, String> crfData;
    private String tempVal;

    public List<HashMap<String, String>> getData(File f) {
        this.parseDocument(f);
        this.printData();
        return this.allCrfData;
    }

    private void parseDocument(File f) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(f, (DefaultHandler)this);
        }
        catch (SAXException se) {
            this.logger.error("Error in SAX instance creation", (Throwable)se);
        }
        catch (ParserConfigurationException pce) {
            this.logger.error("Error in Parsing SAX configuration", (Throwable)pce);
        }
        catch (IOException ie) {
            this.logger.error("Error  in File: ", (Throwable)ie);
        }
    }

    private void printData() {
        this.logger.info("No of Records '" + this.allCrfData.size() + "'.");
        Iterator it = this.allCrfData.iterator();
        while (it.hasNext()) {
            this.logger.info(it.next().toString());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempVal = "";
        if (qName.equalsIgnoreCase("crf_data")) {
            this.crfData = new HashMap();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempVal = new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("crf_data")) {
            this.allCrfData.add(this.crfData);
        } else if (!qName.equalsIgnoreCase("data")) {
            this.crfData.put(qName, this.tempVal);
        }
    }
}

