/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.UserType;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.login.UserDTO;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.dao.hibernate.AuditUserLoginDao;
import org.akaza.openclinica.dao.hibernate.AuthoritiesDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.technicaladmin.AuditUserLoginBean;
import org.akaza.openclinica.domain.technicaladmin.LoginStatus;
import org.akaza.openclinica.domain.user.AuthoritiesBean;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/accounts"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class AccountController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ServletContext context;
    @Autowired
    AuthenticationManager authenticationManager;
    public static final String FORM_CONTEXT = "ecid";
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String INPUT_EMAIL = "";
    public static final String INPUT_INSTITUTION = "PFORM";
    UserDTO uDTO;
    AuthoritiesDao authoritiesDao;
    ParticipantPortalRegistrar participantPortalRegistrar;
    private AuditUserLoginDao auditUserLoginDao;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public ResponseEntity<HashMap> getAccountByUserName(@RequestBody HashMap<String, String> requestMap) throws Exception {
        ArrayList rolesDTO;
        String userName = requestMap.get("username").trim();
        String password = requestMap.get("password").trim();
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userName, (Object)password);
        try {
            authentication = this.authenticationManager.authenticate((Authentication)authentication);
        }
        catch (Exception bce) {
            return new ResponseEntity(new HashMap(), HttpStatus.UNAUTHORIZED);
        }
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        UserAccountDAO userAccountDAO = new UserAccountDAO((DataSource)this.dataSource);
        StudyDAO studyDAO = new StudyDAO((DataSource)this.dataSource);
        HashMap<String, Object> userDTO = new HashMap<String, Object>();
        UserAccountBean userAccountBean = (UserAccountBean)userAccountDAO.findByUserName(userName);
        if (null != userAccountBean) {
            userDTO.put("username", userName);
            userDTO.put("password", userAccountBean.getPasswd());
            userDTO.put("firstName", userAccountBean.getFirstName());
            userDTO.put("lastName", userAccountBean.getLastName());
            userDTO.put("apiKey", userAccountBean.getApiKey());
            rolesDTO = new ArrayList();
            for (StudyUserRoleBean role : userAccountBean.getRoles()) {
                if (!role.getStatus().isAvailable()) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("roleName", role.getRoleName());
                map.put("studyOID", ((StudyBean)studyDAO.findByPK(role.getStudyId())).getOid());
                rolesDTO.add(map);
            }
        } else {
            return new ResponseEntity(new HashMap(), HttpStatus.UNAUTHORIZED);
        }
        userDTO.put("roles", rolesDTO);
        return new ResponseEntity(userDTO, HttpStatus.OK);
    }

    @RequestMapping(value={"/study/{studyOid}/crc/{crcUserName}"}, method={RequestMethod.GET})
    public ResponseEntity<UserDTO> getAccount1(@PathVariable(value="studyOid") String studyOid, @PathVariable(value="crcUserName") String crcUserName) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        this.uDTO = null;
        StudyBean parentStudy = this.getParentStudy(studyOid);
        Integer pStudyId = parentStudy.getId();
        String oid = parentStudy.getOid();
        if (this.isStudyASiteLevelStudy(studyOid).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (!this.mayProceed(oid)) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isStudyDoesNotExist(oid).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isCRCUserAccountDoesNotExist(crcUserName).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.doesCRCNotHaveStudyAccessRole(crcUserName, pStudyId).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        UserAccountBean userAccountBean = (UserAccountBean)udao.findByUserName(crcUserName);
        this.buildUserDTO(userAccountBean);
        return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
    }

    public Boolean isCRCHasAccessToStudySubject(String studyOid, String crcUserName, String studySubjectId) {
        this.uDTO = null;
        StudyBean parentStudy = this.getParentStudy(studyOid);
        Integer pStudyId = parentStudy.getId();
        String oid = parentStudy.getOid();
        if (this.isStudySubjecAndCRCRolesMatch(studySubjectId, crcUserName, studyOid).booleanValue()) {
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/study/{studyOid}/accesscode/{accessCode}"}, method={RequestMethod.GET})
    public ResponseEntity<UserDTO> getAccount2(@PathVariable(value="studyOid") String studyOid, @PathVariable(value="accessCode") String accessCode) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        this.uDTO = null;
        accessCode = URLDecoder.decode(accessCode, "UTF-8");
        StudyBean parentStudy = this.getParentStudy(studyOid);
        String oid = parentStudy.getOid();
        if (this.isStudyASiteLevelStudy(studyOid).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (!this.mayProceed(oid)) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isStudyDoesNotExist(oid).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isAccessCodeIsNull(accessCode).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        UserAccountBean accessCodeAccountBean = this.getAccessCodeAccount(accessCode);
        if (!accessCodeAccountBean.isActive()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (accessCodeAccountBean.getApiKey() == null || accessCodeAccountBean.getApiKey().isEmpty()) {
            String apiKey = null;
            while (this.isApiKeyExist(apiKey = this.getRandom32ChApiKey()).booleanValue()) {
            }
            accessCodeAccountBean.setEnableApiKey(true);
            accessCodeAccountBean.setApiKey(apiKey);
            this.updateUserAccount(accessCodeAccountBean);
        }
        this.buildUserDTO(accessCodeAccountBean);
        if (accessCodeAccountBean.isEnableApiKey()) {
            this.uDTO.setApiKey(accessCodeAccountBean.getApiKey());
        }
        return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
    }

    @RequestMapping(value={"/study/{studyOid}/studysubject/{studySubjectId}"}, method={RequestMethod.GET})
    public ResponseEntity<UserDTO> getAccount3(@PathVariable(value="studyOid") String studyOid, @PathVariable(value="studySubjectId") String studySubjectId) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        this.uDTO = null;
        StudyBean parentStudy = this.getParentStudy(studyOid);
        String oid = parentStudy.getOid();
        StudySubjectBean studySubjectBean = this.getStudySubject(studySubjectId, parentStudy);
        if (this.isStudyASiteLevelStudy(studyOid).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (!this.mayProceed(oid, studySubjectBean)) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isStudyDoesNotExist(oid).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isStudySubjectDoesNotExist(studySubjectBean).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        HashMap mapValues = this.buildParticipantUserName(studySubjectBean);
        String pUserName = (String)mapValues.get("pUserName");
        UserAccountBean userAccountBean = (UserAccountBean)udao.findByUserName(pUserName);
        if (!userAccountBean.isActive()) {
            this.uDTO = new UserDTO();
            return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
        }
        this.buildUserDTO(userAccountBean);
        return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public ResponseEntity<UserDTO> createOrUpdateAccount(@RequestBody HashMap<String, String> map) throws Exception {
        this.uDTO = null;
        StudyBean parentStudy = this.getParentStudy(map.get("studyOid"));
        String oid = parentStudy.getOid();
        String studySubjectId = map.get("studySubjectId");
        String fName = map.get("fName");
        String lName = map.get("lName");
        String mobile = map.get("mobile");
        String accessCode = map.get("accessCode");
        String crcUserName = map.get("crcUserName");
        String email = map.get("email");
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        UserAccountBean uBean = null;
        StudySubjectBean studySubjectBean = this.getStudySubject(studySubjectId, parentStudy);
        UserAccountBean ownerUserAccount = this.getUserAccount(crcUserName);
        if (!this.mayProceed(oid, studySubjectBean)) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isStudyDoesNotExist(oid).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isStudySubjectDoesNotExist(studySubjectBean).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isFistNameInValid(fName).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isPhoneFieldIsNull(mobile).booleanValue() && this.isEmailIsNull(email).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isAccessCodeIsNull(accessCode).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.isAccessCodeExistInSystem(accessCode).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        HashMap mapValues = this.buildParticipantUserName(studySubjectBean);
        String pUserName = (String)mapValues.get("pUserName");
        String studySubjectOid = (String)mapValues.get("studySubjectOid");
        Integer pStudyId = Integer.valueOf((String)mapValues.get("pStudyId"));
        if (this.isCRCUserAccountDoesNotExist(crcUserName).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        if (this.doesCRCNotHaveStudyAccessRole(crcUserName, pStudyId).booleanValue()) {
            return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
        }
        uBean = this.buildUserAccount(oid, studySubjectOid, fName, lName, mobile, accessCode, ownerUserAccount, pUserName, email);
        UserAccountBean participantUserAccountBean = this.getUserAccount(pUserName);
        if (!participantUserAccountBean.isActive()) {
            this.createUserAccount(uBean);
            uBean.setUpdater(uBean.getOwner());
            this.updateUserAccount(uBean);
            this.disableUserAccount(uBean);
            this.logger.info("***New User Account is created***");
            this.uDTO = this.buildUserDTO(uBean);
            return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
        }
        uBean.setId(this.getUserAccount(uBean.getName()).getId());
        uBean.setUpdater(uBean.getOwner());
        this.updateUserAccount(uBean);
        this.logger.info("***User Account already exist in the system and data is been Updated ***");
        this.uDTO = this.buildUserDTO(uBean);
        return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
    }

    @RequestMapping(value={"/timezone"}, method={RequestMethod.POST})
    public ResponseEntity<UserDTO> updateTimezone(@RequestBody HashMap<String, String> map) throws Exception {
        this.uDTO = null;
        StudyBean parentStudy = this.getParentStudy(map.get("studyOid"));
        String oid = parentStudy.getOid();
        String studySubjectId = map.get("studySubjectId");
        String timeZone = map.get("timeZone");
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        StudySubjectBean studySubjectBean = this.getStudySubjectByOidAndStudy(studySubjectId, parentStudy.getId());
        HashMap mapValues = this.buildParticipantUserName(studySubjectBean);
        String pUserName = (String)mapValues.get("pUserName");
        udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean userAccountBean = (UserAccountBean)udao.findByUserName(pUserName);
        if (studySubjectBean.isActive()) {
            studySubjectBean.setTime_zone(timeZone);
            studySubjectBean.setUpdater(userAccountBean);
            this.updateStudySubjectBean(studySubjectBean);
            return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
        }
        return null;
    }

    private UserDTO buildUserDTO(UserAccountBean userAccountBean) {
        this.uDTO = new UserDTO();
        this.uDTO.setfName(userAccountBean.getFirstName());
        this.uDTO.setlName(userAccountBean.getLastName());
        this.uDTO.setMobile(userAccountBean.getPhone());
        this.uDTO.setUserName(userAccountBean.getName());
        this.uDTO.setAccessCode(userAccountBean.getAccessCode());
        this.uDTO.setPassword(userAccountBean.getPasswd());
        this.uDTO.setEmail(userAccountBean.getEmail());
        return this.uDTO;
    }

    private UserAccountBean buildUserAccount(String studyOid, String studySubjectOid, String fName, String lName, String mobile, String accessCode, UserAccountBean ownerUserAccount, String pUserName, String email) throws Exception {
        UserAccountBean createdUserAccountBean = new UserAccountBean();
        createdUserAccountBean.setName(pUserName);
        createdUserAccountBean.setFirstName(fName);
        createdUserAccountBean.setLastName(lName);
        createdUserAccountBean.setEmail(INPUT_EMAIL);
        createdUserAccountBean.setInstitutionalAffiliation(INPUT_INSTITUTION);
        createdUserAccountBean.setLastVisitDate(null);
        createdUserAccountBean.setActiveStudyId(this.getStudy(studyOid).getId());
        createdUserAccountBean.setPasswdTimestamp(null);
        createdUserAccountBean.setPasswdChallengeQuestion(INPUT_EMAIL);
        createdUserAccountBean.setPasswdChallengeAnswer(INPUT_EMAIL);
        createdUserAccountBean.setOwner(ownerUserAccount);
        createdUserAccountBean.setRunWebservices(Boolean.valueOf(false));
        createdUserAccountBean.setPhone(mobile);
        createdUserAccountBean.setAccessCode(accessCode);
        createdUserAccountBean.setPasswd("5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8");
        createdUserAccountBean.setEmail(email);
        String apiKey = null;
        while (this.isApiKeyExist(apiKey = this.getRandom32ChApiKey()).booleanValue()) {
        }
        createdUserAccountBean.setEnableApiKey(true);
        createdUserAccountBean.setApiKey(apiKey);
        Role r = Role.RESEARCHASSISTANT2;
        createdUserAccountBean = this.addActiveStudyRole(createdUserAccountBean, this.getStudy(studyOid).getId(), r, ownerUserAccount);
        UserType type = UserType.get((int)2);
        createdUserAccountBean.addUserType(type);
        this.authoritiesDao = (AuthoritiesDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("authoritiesDao");
        this.authoritiesDao.saveOrUpdate((DomainObject)new AuthoritiesBean(createdUserAccountBean.getName()));
        return createdUserAccountBean;
    }

    private void createUserAccount(UserAccountBean userAccountBean) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        udao.create((EntityBean)userAccountBean);
    }

    private void updateUserAccount(UserAccountBean userAccountBean) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        udao.update((EntityBean)userAccountBean);
    }

    private void disableUserAccount(UserAccountBean userAccountBean) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        udao.delete(userAccountBean);
    }

    private UserAccountBean addActiveStudyRole(UserAccountBean createdUserAccountBean, int studyId, Role r, UserAccountBean ownerUserAccount) {
        StudyUserRoleBean studyUserRole = new StudyUserRoleBean();
        studyUserRole.setStudyId(studyId);
        studyUserRole.setRoleName(r.getName());
        studyUserRole.setStatus(Status.AUTO_DELETED);
        studyUserRole.setOwner(ownerUserAccount);
        createdUserAccountBean.addRole(studyUserRole);
        createdUserAccountBean.setLockCounter(Integer.valueOf(3));
        createdUserAccountBean.setAccountNonLocked(Boolean.valueOf(false));
        return createdUserAccountBean;
    }

    private ArrayList<UserAccountBean> getUserAccountByStudy(String userName, ArrayList allStudies) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        ArrayList userAccountBeans = udao.findStudyByUser(userName, allStudies);
        return userAccountBeans;
    }

    private UserAccountBean getUserAccount(String userName) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean userAccountBean = (UserAccountBean)udao.findByUserName(userName);
        return userAccountBean;
    }

    private UserAccountBean getAccessCodeAccount(String accessCode) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean userAccountBean = (UserAccountBean)udao.findByAccessCode(accessCode);
        return userAccountBean;
    }

    private StudyBean getStudy(String oid) {
        StudyDAO sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = sdao.findByOid(oid);
        return studyBean;
    }

    private StudyBean getStudy(Integer id) {
        StudyDAO sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = (StudyBean)sdao.findByPK(id.intValue());
        return studyBean;
    }

    private StudySubjectBean getStudySubjectByOidAndStudy(String oid, int studyId) {
        StudySubjectDAO ssdao = new StudySubjectDAO((DataSource)this.dataSource);
        StudySubjectBean studySubjectBean = ssdao.findByOidAndStudy(oid, studyId);
        return studySubjectBean;
    }

    private StudySubjectBean getStudySubject(String label, StudyBean study) {
        StudySubjectDAO ssdao = new StudySubjectDAO((DataSource)this.dataSource);
        StudySubjectBean studySubjectBean = ssdao.findByLabelAndStudy(label, study);
        return studySubjectBean;
    }

    private StudySubjectBean getStudySubject(String oid) {
        StudySubjectDAO ssdao = new StudySubjectDAO((DataSource)this.dataSource);
        StudySubjectBean studySubjectBean = ssdao.findByOid(oid);
        return studySubjectBean;
    }

    private void updateStudySubjectBean(StudySubjectBean sBean) {
        StudySubjectDAO ssdao = new StudySubjectDAO((DataSource)this.dataSource);
        ssdao.update((EntityBean)sBean);
    }

    private Boolean isStudyDoesNotExist(String studyOid) {
        StudyBean studyBean = this.getStudy(studyOid);
        if (studyBean == null) {
            this.logger.info("***Study  Does Not Exist ***");
            return true;
        }
        return false;
    }

    private Boolean isStudyASiteLevelStudy(String studyOid) {
        StudyBean studyBean = this.getStudy(studyOid);
        if (studyBean.getParentStudyId() != 0) {
            this.logger.info("***Study provided in the URL is a Site study***");
            return true;
        }
        return false;
    }

    private Boolean isStudySubjectDoesNotExist(StudySubjectBean studySubjectBean) {
        if (studySubjectBean == null || !studySubjectBean.isActive()) {
            this.logger.info("***Study Subject Does Not Exist OR the Study Subject is not associated with the Study_Oid in the URL   ***");
            return true;
        }
        return false;
    }

    private Boolean isFistNameInValid(String fName) {
        if (fName.length() < 1) {
            this.logger.info("***     First Name length is less than 1 characters    ***");
            return true;
        }
        return false;
    }

    private Boolean isPhoneFieldIsNull(String mobile) {
        if (mobile.length() == 0) {
            this.logger.info("***     Phone # is a Required Field   ***");
            return true;
        }
        return false;
    }

    private Boolean isAccessCodeIsNull(String accessCode) {
        if (accessCode.length() == 0) {
            this.logger.info("***Access Code is a Required field and can't be null ***");
            return true;
        }
        return false;
    }

    private Boolean isAccessCodeExistInSystem(String accessCode) {
        UserAccountBean accessCodeAccountBean = this.getAccessCodeAccount(accessCode);
        if (accessCodeAccountBean.isActive()) {
            this.logger.info("***Access Code already Exist in the User Table ***");
            return true;
        }
        return false;
    }

    private Boolean isCRCUserAccountDoesNotExist(String crcUserName) {
        UserAccountBean ownerUserAccount = this.getUserAccount(crcUserName);
        if (!ownerUserAccount.isActive()) {
            this.logger.info("***  CRC user acount does not Exist in the User Table ***");
            return true;
        }
        return false;
    }

    private Boolean isEmailIsNull(String email) {
        if (email.length() == 0) {
            this.logger.info("***Email Address is a Required field and can't be null ***");
            return true;
        }
        return false;
    }

    private HashMap buildParticipantUserName(StudySubjectBean studySubjectBean) {
        HashMap<String, String> map = new HashMap<String, String>();
        String studySubjectOid = studySubjectBean.getOid();
        Integer studyId = studySubjectBean.getStudyId();
        StudyBean study = this.getParentStudy(studyId);
        Integer pStudyId = study.getId();
        String pUserName = study.getOid() + "." + studySubjectOid;
        map.put("pUserName", pUserName);
        map.put("pStudyId", pStudyId.toString());
        map.put("studySubjectOid", studySubjectOid);
        return map;
    }

    private Boolean doesCRCNotHaveStudyAccessRole(String crcUserName, Integer pStudyId) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        boolean found = false;
        ArrayList studyUserRoleBeans = (ArrayList)udao.findAllRolesByUserName(crcUserName);
        for (StudyUserRoleBean studyUserRoleBean : studyUserRoleBeans) {
            StudyBean study = this.getParentStudy(Integer.valueOf(studyUserRoleBean.getStudyId()));
            if (study.getId() != pStudyId.intValue() || !studyUserRoleBean.getRoleName().equals("ra") && !studyUserRoleBean.getRoleName().equals("ra2") || !studyUserRoleBean.getStatus().isAvailable()) continue;
            found = true;
            this.logger.info("if found : {}", (Object)found);
            break;
        }
        if (!found) {
            this.logger.info("*** CRC Does not have access to the study/site OR CRC Does not have 'Data Entry Person' role ***");
            return true;
        }
        return false;
    }

    private Boolean doesStudySubjecAndCRCRolesMatch(String crcUserName, Integer subjectStudyId) {
        boolean found = false;
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        ArrayList studyUserRoleBeans = (ArrayList)udao.findAllRolesByUserName(crcUserName);
        for (StudyUserRoleBean studyUserRoleBean : studyUserRoleBeans) {
            if (studyUserRoleBean.getStudyId() == this.getParentStudy(subjectStudyId).getId()) {
                subjectStudyId = this.getParentStudy(subjectStudyId).getId();
            }
            if (studyUserRoleBean.getStudyId() != subjectStudyId.intValue() || !studyUserRoleBean.getRoleName().equals("ra") && !studyUserRoleBean.getRoleName().equals("ra2") || !studyUserRoleBean.getStatus().isAvailable()) continue;
            found = true;
            break;
        }
        if (!found) {
            this.logger.info("*** CRC Role does not match with StudySubject assignment ***");
            return true;
        }
        this.logger.info("*** CRC Role does match with StudySubject assignment ***");
        return false;
    }

    private Boolean isStudySubjecAndCRCRolesMatch(String studySubjectId, String crcUserName, String studyOid) {
        StudyBean parentStudy = this.getParentStudy(studyOid);
        Integer studyIdFromStudyOid = parentStudy.getId();
        StudySubjectBean studySubjectBean = this.getStudySubject(studySubjectId, parentStudy);
        Integer studyIdFromStudySubjectId = studySubjectBean.getStudyId();
        return this.doesStudySubjecAndCRCRolesMatch(crcUserName, studyIdFromStudySubjectId);
    }

    private StudyBean getParentStudy(Integer studyId) {
        StudyDAO sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean study = this.getStudy(studyId);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = (StudyBean)sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyDAO sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = (StudyBean)sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private boolean mayProceed(String studyOid, StudySubjectBean ssBean) throws Exception {
        boolean accessPermission = false;
        if (ssBean.isActive() && this.mayProceed(studyOid) && ssBean.getStatus() == Status.AVAILABLE) {
            accessPermission = true;
        }
        return accessPermission;
    }

    private boolean mayProceed(String studyOid) throws Exception {
        boolean accessPermission = false;
        StudyBean siteStudy = this.getStudy(studyOid);
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(study.getOid()).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        String siteStatus = siteStudy.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus + "   siteStatus: " + siteStatus);
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && siteStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE")) {
            accessPermission = true;
        }
        return accessPermission;
    }

    @RequestMapping(value={"/study/{studyOid}"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<UserDTO>> getAllParticipantPerStudy(@PathVariable(value="studyOid") String studyOid) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        ArrayList<UserDTO> uDTOs = null;
        StudyBean parentStudy = this.getParentStudy(studyOid);
        String oid = parentStudy.getOid();
        if (this.isStudyDoesNotExist(oid).booleanValue()) {
            return new ResponseEntity(uDTOs, HttpStatus.NOT_ACCEPTABLE);
        }
        udao = new UserAccountDAO((DataSource)this.dataSource);
        ArrayList uBeans = (ArrayList)udao.findAllParticipantsByStudyOid(oid);
        if (uBeans != null) {
            uDTOs = new ArrayList<UserDTO>();
            for (UserAccountBean uBean : uBeans) {
                UserDTO uDTO = new UserDTO();
                String username = uBean.getName();
                String studySubjectOid = username.substring(username.indexOf(".") + 1);
                StudySubjectDAO ssdao = new StudySubjectDAO((DataSource)this.dataSource);
                String studySubjectId = ssdao.findByOid(studySubjectOid).getLabel();
                uDTO.setfName(uBean.getFirstName());
                uDTO.setEmail(uBean.getEmail());
                uDTO.setMobile(uBean.getPhone());
                uDTO.setAccessCode(uBean.getAccessCode());
                uDTO.setUserName(uBean.getName());
                uDTO.setPassword(uBean.getPasswd());
                uDTO.setlName(uBean.getLastName());
                uDTO.setStudySubjectId(studySubjectId);
                uDTOs.add(uDTO);
            }
            return new ResponseEntity(uDTOs, HttpStatus.OK);
        }
        return new ResponseEntity(uDTOs, HttpStatus.NOT_ACCEPTABLE);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseEntity<UserDTO> updateAccount(@RequestBody HashMap<String, String> map) throws Exception {
        this.uDTO = null;
        StudyBean parentStudy = this.getParentStudy(map.get("studyOid"));
        String oid = parentStudy.getOid();
        String studySubjectId = map.get("studySubjectId");
        String fName = map.get("fName");
        String lName = map.get("lName");
        String mobile = map.get("mobile");
        String accessCode = map.get("accessCode");
        String crcUserName = map.get("crcUserName");
        String email = map.get("email");
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        UserAccountBean uBean = null;
        StudySubjectBean studySubjectBean = this.getStudySubject(studySubjectId, parentStudy);
        UserAccountBean ownerUserAccount = this.getUserAccount(crcUserName);
        HashMap mapValues = this.buildParticipantUserName(studySubjectBean);
        String pUserName = (String)mapValues.get("pUserName");
        String studySubjectOid = (String)mapValues.get("studySubjectOid");
        Integer pStudyId = Integer.valueOf((String)mapValues.get("pStudyId"));
        uBean = this.buildUserAccount(oid, studySubjectOid, fName, lName, mobile, accessCode, ownerUserAccount, pUserName, email);
        UserAccountBean participantUserAccountBean = this.getUserAccount(pUserName);
        if (!participantUserAccountBean.isActive()) {
            this.createUserAccount(uBean);
            uBean.setUpdater(uBean.getOwner());
            this.updateUserAccount(uBean);
            this.disableUserAccount(uBean);
            this.logger.info("***New User Account is created***");
            this.uDTO = this.buildUserDTO(uBean);
            return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
        }
        uBean.setId(this.getUserAccount(uBean.getName()).getId());
        uBean.setUpdater(uBean.getOwner());
        this.updateUserAccount(uBean);
        this.logger.info("***User Account already exist in the system and data is been Updated ***");
        this.uDTO = this.buildUserDTO(uBean);
        return new ResponseEntity((Object)this.uDTO, HttpStatus.OK);
    }

    @RequestMapping(value={"/auditcrc"}, method={RequestMethod.POST})
    public ResponseEntity<HashMap> auditcrc(@RequestBody HashMap<String, String> requestMap) throws Exception {
        HashMap map = new HashMap();
        String crcUserName = requestMap.get("crcUserName");
        String studyOid = requestMap.get("studyOid");
        String studySubjectId = requestMap.get("studySubjectId");
        StudyBean parentStudy = this.getParentStudy(studyOid);
        StudySubjectBean studySubjectBean = this.getStudySubject(studySubjectId, parentStudy);
        HashMap mapValues = this.buildParticipantUserName(studySubjectBean);
        String pUserName = (String)mapValues.get("pUserName");
        AuditUserLoginBean auditUserLogin = new AuditUserLoginBean();
        UserAccountBean userAccount = this.getUserAccount(crcUserName);
        auditUserLogin.setUserName(userAccount.getName());
        auditUserLogin.setLoginStatus(LoginStatus.ACCESS_CODE_VIEWED);
        auditUserLogin.setLoginAttemptDate(new Date());
        auditUserLogin.setUserAccountId(userAccount != null ? Integer.valueOf(userAccount.getId()) : null);
        auditUserLogin.setDetails(pUserName);
        this.getAuditUserLoginDao().save((DomainObject)auditUserLogin);
        return new ResponseEntity(map, HttpStatus.OK);
    }

    public AuditUserLoginDao getAuditUserLoginDao() {
        this.auditUserLoginDao = this.auditUserLoginDao != null ? this.auditUserLoginDao : (AuditUserLoginDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("auditUserLoginDao");
        return this.auditUserLoginDao;
    }

    public Boolean isApiKeyExist(String uuid) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean uBean = (UserAccountBean)udao.findByApiKey(uuid);
        if (uBean == null || !uBean.isActive()) {
            return false;
        }
        return true;
    }

    public String getRandom32ChApiKey() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", INPUT_EMAIL);
    }
}

