/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.controller.AnonymousFormControllerV2;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.web.pform.PFormCache;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/api/v2/anonymousform"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class AnonymousFormControllerV2 {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ServletContext context;
    public static final String FORM_CONTEXT = "ecid";
    ParticipantPortalRegistrar participantPortalRegistrar;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    UserAccountDAO udao;
    StudyDAO sdao;

    @RequestMapping(value={"/form"}, method={RequestMethod.POST})
    public ResponseEntity<AnonymousUrlResponse> getEnketoForm(@RequestBody HashMap<String, String> map) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        EventDefinitionCrfTagService tagService = (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        String formUrl = null;
        String studyOid = map.get("studyOid");
        if (!this.mayProceed(studyOid)) {
            return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
        }
        String submissionUri = map.get("submissionUri");
        if (submissionUri != "" && submissionUri != null) {
            EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO((DataSource)this.dataSource);
            StudyBean study = this.getStudy(studyOid);
            ArrayList edcBeans = edcdao.findAllSubmissionUriAndStudyId(submissionUri, study.getId());
            if (edcBeans.size() != 0) {
                EventDefinitionCRFBean edcBean = (EventDefinitionCRFBean)edcBeans.get(0);
                CRFDAO crfdao = new CRFDAO((DataSource)this.dataSource);
                CRFVersionDAO cvdao = new CRFVersionDAO((DataSource)this.dataSource);
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO((DataSource)this.dataSource);
                CRFVersionBean crfVersionBean = (CRFVersionBean)cvdao.findByPK(edcBean.getDefaultVersionId());
                CRFBean crf = (CRFBean)crfdao.findByPK(crfVersionBean.getCrfId());
                StudyBean sBean = (StudyBean)this.sdao.findByPK(edcBean.getStudyId());
                StudyEventDefinitionBean sedBean = (StudyEventDefinitionBean)seddao.findByPK(edcBean.getStudyEventDefinitionId());
                String tagPath = sedBean.getOid() + "." + crf.getOid();
                boolean isOffline = tagService.getEventDefnCrfOfflineStatus(2, tagPath, true);
                String offline = null;
                offline = isOffline ? "true" : "false";
                formUrl = this.createAnonymousEnketoUrl(sBean.getOid(), crfVersionBean, edcBean, isOffline);
                AnonymousUrlResponse anonResponse = new AnonymousUrlResponse(this, formUrl, offline, crf.getName(), crfVersionBean.getDescription());
                return new ResponseEntity((Object)anonResponse, HttpStatus.OK);
            }
            return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
        }
        return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = (StudyBean)this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private StudyBean getStudy(String oid) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByOid(oid);
        return studyBean;
    }

    private String createAnonymousEnketoUrl(String studyOID, CRFVersionBean crfVersion, EventDefinitionCRFBean edcBean, boolean isOffline) throws Exception {
        StudyBean parentStudyBean = this.getParentStudy(studyOID);
        PFormCache cache = PFormCache.getInstance((ServletContext)this.context);
        String enketoURL = cache.getPFormURL(parentStudyBean.getOid(), crfVersion.getOid(), isOffline);
        String contextHash = cache.putAnonymousFormContext(studyOID, crfVersion.getOid(), edcBean.getStudyEventDefinitionId());
        String url = null;
        url = isOffline ? enketoURL.split("#", 2)[0] + "?" + FORM_CONTEXT + "=" + contextHash + "#" + enketoURL.split("#", 2)[1] : enketoURL + "?" + FORM_CONTEXT + "=" + contextHash;
        this.logger.debug("Enketo URL for " + crfVersion.getName() + "= " + url);
        return url;
    }

    private boolean mayProceed(String studyOid) throws Exception {
        boolean accessPermission = false;
        StudyBean siteStudy = this.getStudy(studyOid);
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(study.getOid()).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        String siteStatus = siteStudy.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus + "   siteStatus: " + siteStatus);
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && siteStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE")) {
            accessPermission = true;
        }
        return accessPermission;
    }
}

