/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.controller.SidebarEnumConstants;
import org.akaza.openclinica.controller.SidebarInit;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.StudyInfoPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="changeCRFVersionController")
public class ChangeCRFVersionController {
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    @Autowired
    CoreResources coreResources;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Autowired
    @Qualifier(value="sidebarInit")
    private SidebarInit sidebarInit;
    ResourceBundle resword;
    ResourceBundle resformat;
    ResourceBundle respage;

    @RequestMapping(value={"/managestudy/chooseCRFVersion"}, method={RequestMethod.GET})
    public ModelMap chooseCRFVersion(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="crfId") int crfId, @RequestParam(value="crfName") String crfName, @RequestParam(value="crfversionId") int crfVersionId, @RequestParam(value="crfVersionName") String crfVersionName, @RequestParam(value="studySubjectLabel") String studySubjectLabel, @RequestParam(value="studySubjectId") int studySubjectId, @RequestParam(value="eventCRFId") int eventCRFId, @RequestParam(value="eventDefinitionCRFId") int eventDefinitionCRFId) {
        EventDefinitionCRFDAO edfdao;
        EventDefinitionCRFBean edf;
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Redirecting response failed: ", (Throwable)e);
            }
            return null;
        }
        this.resetPanel(request);
        ModelMap gridMap = new ModelMap();
        request.setAttribute("eventCRFId", (Object)eventCRFId);
        request.setAttribute("studySubjectLabel", (Object)studySubjectLabel);
        request.setAttribute("eventDefinitionCRFId", (Object)eventDefinitionCRFId);
        request.setAttribute("studySubjectId", (Object)studySubjectId);
        request.setAttribute("crfId", (Object)crfId);
        request.setAttribute("crfName", (Object)crfName);
        request.setAttribute("crfversionId", (Object)crfVersionId);
        request.setAttribute("crfVersionName", (Object)crfVersionName.trim());
        ArrayList pageMessages = this.initPageMessages(request);
        String errorMessage = request.getParameter("errorMessage");
        if (errorMessage != null) {
            pageMessages.add(errorMessage);
        }
        this.setupResource(request);
        StudyBean study = (StudyBean)request.getSession().getAttribute("study");
        CRFDAO cdao = new CRFDAO(this.dataSource);
        CRFBean crfBean = (CRFBean)cdao.findByPK(crfId);
        CRFVersionDAO crfVersionDao = new CRFVersionDAO(this.dataSource);
        ArrayList<CRFVersionBean> versions = (ArrayList<CRFVersionBean>)crfVersionDao.findAllActiveByCRF(crfId);
        StudyEventDefinitionDAO sfed = new StudyEventDefinitionDAO(this.dataSource);
        StudyEventDefinitionBean sedb = sfed.findByEventDefinitionCRFId(eventDefinitionCRFId);
        request.setAttribute("eventName", (Object)sedb.getName());
        EventCRFDAO ecdao = new EventCRFDAO(this.dataSource);
        EventCRFBean ecb = (EventCRFBean)ecdao.findByPK(eventCRFId);
        StudyEventDAO sedao = new StudyEventDAO(this.dataSource);
        StudyEventBean seb = (StudyEventBean)sedao.findByPK(ecb.getStudyEventId());
        request.setAttribute("eventCreateDate", (Object)this.formatDate(seb.getCreatedDate()));
        if (sedb.isRepeating()) {
            request.setAttribute("eventOrdinal", (Object)seb.getSampleOrdinal());
        }
        if (study.getParentStudyId() > 0 && !(edf = (EventDefinitionCRFBean)(edfdao = new EventDefinitionCRFDAO(this.dataSource)).findByPK(eventDefinitionCRFId)).getSelectedVersionIds().equals("")) {
            String[] version_ids = edf.getSelectedVersionIds().split(",");
            HashMap<String, String> tmp = new HashMap<String, String>(version_ids.length);
            for (String vs : version_ids) {
                tmp.put(vs, vs);
            }
            ArrayList<CRFVersionBean> site_versions = new ArrayList<CRFVersionBean>(versions.size());
            for (CRFVersionBean vs : versions) {
                if (tmp.get(String.valueOf(vs.getId())) == null) continue;
                site_versions.add(vs);
            }
            versions = site_versions;
        }
        crfBean.setVersions((ArrayList)versions);
        gridMap.addAttribute("numberOfVersions", (Object)(crfBean.getVersions().size() + 1));
        gridMap.addAttribute("crfBean", (Object)crfBean);
        return gridMap;
    }

    @RequestMapping(value={"/managestudy/confirmCRFVersionChange"}, method={RequestMethod.POST})
    public ModelMap confirmCRFVersionChange(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="crfId", required=false) int crfId, @RequestParam(value="crfName", required=false) String crfName, @RequestParam(value="crfversionId", required=false) int crfVersionId, @RequestParam(value="crfVersionName", required=false) String crfVersionName, @RequestParam(value="studySubjectLabel", required=false) String studySubjectLabel, @RequestParam(value="studySubjectId", required=false) int studySubjectId, @RequestParam(value="eventCRFId", required=false) int eventCRFId, @RequestParam(value="eventDefinitionCRFId", required=false) int eventDefinitionCRFId, @RequestParam(value="selectedVersionId", required=false) int selectedVersionId, @RequestParam(value="selectedVersionName", required=false) String selectedVersionName, @RequestParam(value="eventName", required=false) String eventName, @RequestParam(value="eventCreateDate", required=false) String eventCreateDate, @RequestParam(value="eventOrdinal", required=false) String eventOrdinal, @RequestParam(value="confirmCRFVersionSubmit") String as) {
        if (!this.mayProceed(request) && this.redirect(request, response, "/MainMenu?message=authentication_failed") == null) {
            return null;
        }
        this.resetPanel(request);
        request.setAttribute("eventCRFId", (Object)eventCRFId);
        request.setAttribute("studySubjectLabel", (Object)studySubjectLabel);
        request.setAttribute("eventDefinitionCRFId", (Object)eventDefinitionCRFId);
        request.setAttribute("studySubjectId", (Object)studySubjectId);
        request.setAttribute("crfId", (Object)crfId);
        request.setAttribute("crfName", (Object)crfName);
        request.setAttribute("crfversionId", (Object)crfVersionId);
        request.setAttribute("crfVersionName", (Object)crfVersionName.trim());
        request.setAttribute("selectedVersionId", (Object)selectedVersionId);
        if (selectedVersionName != null) {
            selectedVersionName = selectedVersionName.trim();
        }
        request.setAttribute("selectedVersionName", (Object)selectedVersionName);
        request.setAttribute("eventName", (Object)eventName);
        request.setAttribute("eventCreateDate", (Object)eventCreateDate);
        request.setAttribute("eventOrdinal", (Object)eventOrdinal);
        ModelMap gridMap = new ModelMap();
        ArrayList pageMessages = this.initPageMessages(request);
        this.setupResource(request);
        if (selectedVersionId == -1) {
            String errorMessage = this.resword.getString("confirm_crf_version_em_select_version");
            StringBuffer params = new StringBuffer();
            params.append("/pages/managestudy/chooseCRFVersion?crfId=" + crfId);
            params.append("&crfName=" + crfName);
            params.append("&crfversionId=" + crfVersionId);
            params.append("&crfVersionName=" + crfVersionName);
            params.append("&studySubjectLabel=" + studySubjectLabel);
            params.append("&studySubjectId=" + studySubjectId);
            params.append("&eventCRFId=" + eventCRFId);
            params.append("&eventDefinitionCRFId=" + eventDefinitionCRFId);
            params.append("&errorMessage=" + errorMessage);
            if (this.redirect(request, response, params.toString()) == null) {
                return null;
            }
        }
        request.getSession().removeAttribute("pageMessages");
        ArrayList rows = new ArrayList();
        int cur_counter = 0;
        int new_counter = 0;
        try {
            ItemDAO item_dao = new ItemDAO(this.dataSource);
            Object d_bean = null;
            ItemGroupMetadataDAO dao_item_form_mdata = new ItemGroupMetadataDAO(this.dataSource);
            List beans_item_form_mdata = dao_item_form_mdata.findByCrfVersion(Integer.valueOf(crfVersionId));
            HashMap<Integer, ItemGroupMetadataBean> hash_item_form_mdata = new HashMap<Integer, ItemGroupMetadataBean>(beans_item_form_mdata.size());
            for (ItemGroupMetadataBean bn : beans_item_form_mdata) {
                hash_item_form_mdata.put(new Integer(bn.getItemId()), bn);
            }
            List bn_new_item_form_mdata = dao_item_form_mdata.findByCrfVersion(Integer.valueOf(selectedVersionId));
            HashMap<Integer, ItemGroupMetadataBean> hash_new_item_form_mdata = new HashMap<Integer, ItemGroupMetadataBean>(bn_new_item_form_mdata.size());
            for (ItemGroupMetadataBean bn : bn_new_item_form_mdata) {
                hash_new_item_form_mdata.put(new Integer(bn.getItemId()), bn);
            }
            ArrayList cur_items_with_data = item_dao.findAllWithItemDataByCRFVersionId(crfVersionId, eventCRFId);
            HashMap<String, Object> hash_items_with_data = new HashMap<String, Object>(cur_items_with_data.size());
            for (ItemBean item : cur_items_with_data) {
                hash_items_with_data.put(item.getOid(), item);
            }
            ArrayList cur_items = item_dao.findAllItemsByVersionId(crfVersionId);
            ItemBean temp = null;
            for (Object item : cur_items) {
                temp = (ItemBean)hash_items_with_data.get(item.getOid());
                if (temp == null) continue;
                item.setItemDataElements(temp.getItemDataElements());
            }
            ArrayList new_items_with_data = item_dao.findAllWithItemDataByCRFVersionId(selectedVersionId, eventCRFId);
            hash_items_with_data = new HashMap(new_items_with_data.size());
            for (Object item : new_items_with_data) {
                hash_items_with_data.put(item.getOid(), item);
            }
            ArrayList new_items = item_dao.findAllItemsByVersionId(selectedVersionId);
            for (ItemBean item : new_items) {
                temp = (ItemBean)hash_items_with_data.get(item.getOid());
                if (temp == null) continue;
                item.setItemDataElements(temp.getItemDataElements());
            }
            ItemBean cur_element = null;
            ItemBean new_element = null;
            ItemGroupMetadataBean bn_mdata = null;
            ItemGroupMetadataBean bn_new_mdata = null;
            while (cur_counter < cur_items.size() || new_counter < new_items.size()) {
                if (cur_counter < cur_items.size()) {
                    cur_element = (ItemBean)cur_items.get(cur_counter);
                    bn_mdata = (ItemGroupMetadataBean)hash_item_form_mdata.get(new Integer(cur_element.getId()));
                }
                if (new_counter < new_items.size()) {
                    new_element = (ItemBean)new_items.get(new_counter);
                    bn_new_mdata = (ItemGroupMetadataBean)hash_new_item_form_mdata.get(new Integer(new_element.getId()));
                }
                if (cur_counter < cur_items.size() && new_counter < new_items.size() && new_element.getId() == cur_element.getId()) {
                    this.buildRecord(cur_element, new_element, bn_mdata, bn_new_mdata, rows);
                    ++cur_counter;
                    ++new_counter;
                    continue;
                }
                if (cur_counter < cur_items.size() && (new_counter >= new_items.size() || new_element.getId() > cur_element.getId())) {
                    this.buildRecord(cur_element, null, bn_mdata, null, rows);
                    ++cur_counter;
                    continue;
                }
                if (new_counter >= new_items.size() || cur_counter < cur_items.size() && new_element.getId() >= cur_element.getId()) continue;
                this.buildRecord(null, new_element, null, bn_new_mdata, rows);
                ++new_counter;
            }
        }
        catch (Exception e) {
            this.logger.error(cur_counter + " " + new_counter);
            pageMessages.add(this.resword.getString("confirm_crf_version_em_dataextraction"));
        }
        request.setAttribute("pageMessages", (Object)pageMessages);
        gridMap.addAttribute("rows", rows);
        return gridMap;
    }

    private void buildRecord(ItemBean cur_element, ItemBean new_element, ItemGroupMetadataBean cur_bean_mdata, ItemGroupMetadataBean new_bean_mdata, ArrayList<String[]> rows) {
        String[] row = new String[8];
        int cycle_count = 0;
        if (cur_element == null && new_element != null) {
            if (new_element.getItemDataElements() == null || new_element.getItemDataElements().size() < 1) {
                row[7] = "";
                row[3] = "";
                row[2] = "";
                row[1] = "";
                row[0] = "";
                row[4] = new_bean_mdata.isRepeatingGroup() ? new_element.getName() + "(1)" : new_element.getName();
                row[5] = new_element.getOid();
                row[6] = String.valueOf(new_element.getId());
                rows.add(row);
                return;
            }
            for (ItemDataBean data_item : new_element.getItemDataElements()) {
                row = new String[8];
                row[7] = "";
                row[3] = "";
                row[2] = "";
                row[1] = "";
                row[0] = "";
                row[4] = new_bean_mdata.isRepeatingGroup() ? new_element.getName() + "(" + data_item.getOrdinal() + ")" : new_element.getName();
                row[5] = new_element.getOid();
                row[6] = String.valueOf(new_element.getId());
                row[7] = data_item.getValue();
                rows.add(row);
            }
            return;
        }
        if (cur_element != null && new_element == null) {
            if (cur_element.getItemDataElements() == null || cur_element.getItemDataElements().size() < 1) {
                row[0] = cur_bean_mdata.isRepeatingGroup() ? cur_element.getName() + "(1)" : cur_element.getName();
                row[1] = cur_element.getOid();
                row[2] = String.valueOf(cur_element.getId());
                row[3] = "";
                row[5] = "";
                row[7] = "";
                row[6] = "";
                row[4] = "";
                rows.add(row);
            } else {
                for (ItemDataBean data_item : cur_element.getItemDataElements()) {
                    row = new String[8];
                    row[0] = cur_bean_mdata.isRepeatingGroup() ? cur_element.getName() + " (" + data_item.getOrdinal() + ")" : cur_element.getName();
                    row[1] = cur_element.getOid();
                    row[2] = String.valueOf(cur_element.getId());
                    row[3] = data_item.getValue();
                    row[5] = "";
                    row[7] = "";
                    row[6] = "";
                    row[4] = "";
                    rows.add(row);
                    if (++cycle_count <= 0 || cur_bean_mdata.isRepeatingGroup()) continue;
                    break;
                }
            }
            return;
        }
        if (cur_element != null && new_element != null) {
            if (cur_element.getItemDataElements() == null) {
                row[4] = new_bean_mdata.isRepeatingGroup() ? new_element.getName() + "(1)" : new_element.getName();
                row[5] = new_element.getOid();
                row[6] = String.valueOf(new_element.getId());
                row[0] = cur_bean_mdata.isRepeatingGroup() ? cur_element.getName() + "(1)" : cur_element.getName();
                row[1] = cur_element.getOid();
                row[2] = String.valueOf(cur_element.getId());
                row[7] = "";
                row[3] = "";
                rows.add(row);
                return;
            }
            for (ItemDataBean data_item : cur_element.getItemDataElements()) {
                row = new String[8];
                if (!cur_bean_mdata.isRepeatingGroup() && cycle_count > 0) {
                    row[3] = "";
                    row[2] = "";
                    row[1] = "";
                    row[0] = "";
                } else {
                    row[0] = cur_bean_mdata.isRepeatingGroup() ? cur_element.getName() + " (" + data_item.getOrdinal() + ")" : cur_element.getName();
                    row[1] = cur_element.getOid();
                    row[2] = String.valueOf(cur_element.getId());
                    row[3] = data_item.getValue();
                }
                if (new_bean_mdata.isRepeatingGroup()) {
                    if (!cur_bean_mdata.isRepeatingGroup()) {
                        row[4] = cur_element.getName() + " (" + data_item.getOrdinal() + ")";
                    }
                    if (cur_bean_mdata.isRepeatingGroup()) {
                        row[4] = row[0];
                    }
                    row[5] = new_element.getOid();
                    row[6] = String.valueOf(new_element.getId());
                    row[7] = data_item.getValue();
                } else if (cycle_count == 0) {
                    row[4] = row[0];
                    row[5] = new_element.getOid();
                    row[6] = String.valueOf(new_element.getId());
                    row[7] = data_item.getValue();
                } else {
                    row[7] = "";
                    row[6] = "";
                    row[5] = "";
                    row[4] = "";
                }
                ++cycle_count;
                if (row[0].equals("") && row[4].equals("")) continue;
                rows.add(row);
            }
            return;
        }
    }

    @RequestMapping(value={"/managestudy/changeCRFVersion"})
    public ModelMap changeCRFVersionAction(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="crfId") int crfId, @RequestParam(value="crfName") String crfName, @RequestParam(value="crfversionId") int crfVersionId, @RequestParam(value="crfVersionName") String crfVersionName, @RequestParam(value="studySubjectLabel") String studySubjectLabel, @RequestParam(value="studySubjectId") int studySubjectId, @RequestParam(value="eventCRFId") int eventCRFId, @RequestParam(value="eventDefinitionCRFId") int eventDefinitionCRFId, @RequestParam(value="newCRFVersionId", required=true) int newCRFVersionId) {
        if (!this.mayProceed(request) && this.redirect(request, response, "/MainMenu?message=authentication_failed") == null) {
            return null;
        }
        ArrayList pageMessages = this.initPageMessages(request);
        this.setupResource(request);
        try {
            EventCRFDAO event_crf_dao = new EventCRFDAO(this.dataSource);
            StudyEventDAO sedao = new StudyEventDAO(this.dataSource);
            EventCRFBean ev_bean = (EventCRFBean)event_crf_dao.findByPK(eventCRFId);
            StudyEventBean st_event_bean = (StudyEventBean)sedao.findByPK(ev_bean.getStudyEventId());
            Connection con = this.dataSource.getConnection();
            con.setAutoCommit(false);
            event_crf_dao.updateCRFVersionID(eventCRFId, newCRFVersionId, this.getCurrentUser(request).getId(), con);
            String status_before_update = null;
            SubjectEventStatus eventStatus = null;
            Status subjectStatus = null;
            AuditDAO auditDao = new AuditDAO(this.dataSource);
            StudySubjectDAO studySubDao = new StudySubjectDAO(this.dataSource);
            StudySubjectBean studySubBean = (StudySubjectBean)studySubDao.findByPK(st_event_bean.getStudySubjectId());
            if (studySubBean.getStatus().isSigned()) {
                status_before_update = auditDao.findLastStatus("study_subject", studySubBean.getId(), "8");
                if (status_before_update != null && status_before_update.length() == 1) {
                    int subject_status = Integer.parseInt(status_before_update);
                    subjectStatus = Status.get((int)subject_status);
                    studySubBean.setStatus(subjectStatus);
                }
                studySubBean.setUpdater(this.getCurrentUser(request));
                studySubDao.update((EntityBean)studySubBean, con);
            }
            st_event_bean.setUpdater(this.getCurrentUser(request));
            st_event_bean.setUpdatedDate(new Date());
            status_before_update = auditDao.findLastStatus("study_event", st_event_bean.getId(), "8");
            if (status_before_update != null && status_before_update.length() == 1) {
                int status = Integer.parseInt(status_before_update);
                eventStatus = SubjectEventStatus.get((int)status);
                st_event_bean.setSubjectEventStatus(eventStatus);
            }
            sedao.update((EntityBean)st_event_bean, con);
            con.commit();
            con.setAutoCommit(true);
            con.close();
            pageMessages.add(this.resword.getString("confirm_crf_version_ms"));
            String msg = this.resword.getString("confirm_crf_version_ms");
            this.redirect(request, response, "/ViewStudySubject?isFromCRFVersionChange=" + msg + "&id=" + studySubjectId);
        }
        catch (Exception e) {
            pageMessages.add(this.resword.getString("error_message_cannot_update_crf_version"));
        }
        return null;
    }

    @ExceptionHandler(value={HttpSessionRequiredException.class})
    public String handleSessionRequiredException(HttpSessionRequiredException ex, HttpServletRequest request) {
        return "redirect:/MainMenu";
    }

    @ExceptionHandler(value={NullPointerException.class})
    public String handleNullPointerException(NullPointerException ex, HttpServletRequest request, HttpServletResponse response) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (currentStudy == null) {
            return "redirect:/MainMenu";
        }
        throw ex;
    }

    private void setUpSidebar(HttpServletRequest request) {
        if (this.sidebarInit.getAlertsBoxSetup() == SidebarEnumConstants.OPENALERTS) {
            request.setAttribute("alertsBoxSetup", (Object)true);
        }
        if (this.sidebarInit.getInfoBoxSetup() == SidebarEnumConstants.OPENINFO) {
            request.setAttribute("infoBoxSetup", (Object)true);
        }
        if (this.sidebarInit.getInstructionsBoxSetup() == SidebarEnumConstants.OPENINSTRUCTIONS) {
            request.setAttribute("instructionsBoxSetup", (Object)true);
        }
        if (this.sidebarInit.getEnableIconsBoxSetup() == SidebarEnumConstants.DISABLEICONS) {
            request.setAttribute("enableIconsBoxSetup", (Object)false);
        }
    }

    private boolean mayProceed(HttpServletRequest request) {
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        Role r = currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return true;
        }
        ArrayList pageMessages = this.initPageMessages(request);
        pageMessages.add(this.respage.getString("no_have_correct_privilege_current_study") + this.respage.getString("change_study_contact_sysadmin"));
        return false;
    }

    private UserAccountBean getCurrentUser(HttpServletRequest request) {
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        return ub;
    }

    private Object redirect(HttpServletRequest request, HttpServletResponse response, String location) {
        try {
            response.sendRedirect(request.getContextPath() + location);
        }
        catch (Exception e) {
            this.logger.error("Error while redirecting the request: ", (Throwable)e);
        }
        return null;
    }

    private void resetPanel(HttpServletRequest request) {
        StudyInfoPanel panel = new StudyInfoPanel();
        panel.reset();
        panel.setIconInfoShown(false);
        request.getSession().setAttribute("panel", (Object)panel);
    }

    private void setupResource(HttpServletRequest request) {
        Locale locale = request.getLocale();
        ResourceBundleProvider.updateLocale((Locale)locale);
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
    }

    private String formatDate(Date date) {
        String dateFormat = this.resformat.getString("date_format_string");
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        String s = formatter.format(date);
        return s;
    }

    private ArrayList<String> initPageMessages(HttpServletRequest request) {
        ArrayList<String> pageMessages = (ArrayList<String>)request.getAttribute("pageMessages");
        if (pageMessages == null) {
            pageMessages = new ArrayList<String>();
        }
        request.setAttribute("pageMessages", pageMessages);
        return pageMessages;
    }
}

