/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.extract.ExtractPropertyBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.controller.SidebarEnumConstants;
import org.akaza.openclinica.controller.SidebarInit;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.job.XsltStatefulJob;
import org.akaza.openclinica.service.extract.ExtractUtils;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.web.SQLInitServlet;
import org.apache.commons.dbcp.BasicDataSource;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="extractController")
@RequestMapping(value={"/extract"})
public class ExtractController {
    @Autowired
    @Qualifier(value="sidebarInit")
    private SidebarInit sidebarInit;
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    private DatasetDAO datasetDao;
    @Autowired
    private Scheduler scheduler;
    public static String TRIGGER_GROUP_NAME = "XsltTriggers";
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @RequestMapping(method={RequestMethod.GET})
    public ModelMap processSubmit(@RequestParam(value="id") String id, @RequestParam(value="datasetId") String datasetId, HttpServletRequest request, HttpServletResponse response) {
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Error in redirecting the response: ", (Throwable)e);
            }
            return null;
        }
        ModelMap map = new ModelMap();
        ResourceBundleProvider.updateLocale((Locale)LocaleResolver.getLocale((HttpServletRequest)request));
        this.logger.debug("found both id " + id + " and dataset " + datasetId);
        ExtractUtils extractUtils = new ExtractUtils();
        this.datasetDao = new DatasetDAO((DataSource)this.dataSource);
        UserAccountBean userBean = (UserAccountBean)request.getSession().getAttribute("userBean");
        CoreResources cr = new CoreResources();
        ExtractPropertyBean epBean = cr.findExtractPropertyBeanById(new Integer(id).intValue(), datasetId);
        DatasetBean dsBean = (DatasetBean)this.datasetDao.findByPK(new Integer(datasetId).intValue());
        String[] files = epBean.getFileName();
        int fileSize = files.length;
        int cnt = 0;
        JobDetailFactoryBean jobDetailBean = new JobDetailFactoryBean();
        SimpleTrigger simpleTrigger = null;
        dsBean.setName(dsBean.getName().replaceAll(" ", "_"));
        String[] exportFiles = epBean.getExportFileName();
        String pattern = "yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "HHmmssSSS" + File.separator;
        SimpleDateFormat sdfDir = new SimpleDateFormat(pattern);
        String[] temp = new String[exportFiles.length];
        for (int i = 0; i < exportFiles.length; ++i) {
            temp[i] = this.resolveVars(exportFiles[i], dsBean, sdfDir, SQLInitServlet.getField((String)"filePath"), extractUtils);
        }
        epBean.setDoNotDelFiles(temp);
        epBean.setExportFileName(temp);
        XsltTriggerService xsltService = new XsltTriggerService();
        String generalFileDir = SQLInitServlet.getField((String)"filePath");
        generalFileDir = generalFileDir + "datasets" + File.separator + dsBean.getId() + File.separator + sdfDir.format(new Date());
        String exportFileName = epBean.getExportFileName()[cnt];
        this.logger.debug("found odm xml file path " + generalFileDir);
        String xsltPath = SQLInitServlet.getField((String)"filePath") + "xslt" + File.separator + files[cnt];
        String endFilePath = epBean.getFileLocation();
        endFilePath = this.getEndFilePath(endFilePath, dsBean, sdfDir, SQLInitServlet.getField((String)"filePath"), extractUtils);
        if (epBean.getPostProcExportName() != null) {
            String preProcExportPathName = this.resolveVars(epBean.getPostProcExportName(), dsBean, sdfDir, SQLInitServlet.getField((String)"filePath"), extractUtils);
            epBean.setPostProcExportName(preProcExportPathName);
        }
        if (epBean.getPostProcLocation() != null) {
            String prePocLoc = this.getEndFilePath(epBean.getPostProcLocation(), dsBean, sdfDir, SQLInitServlet.getField((String)"filePath"), extractUtils);
            epBean.setPostProcLocation(prePocLoc);
        }
        this.setAllProps(epBean, dsBean, sdfDir, extractUtils);
        this.logger.debug("found xslt file name " + xsltPath);
        simpleTrigger = xsltService.generateXsltTrigger(xsltPath, generalFileDir, endFilePath + File.separator, exportFileName, dsBean.getId(), epBean, userBean, LocaleResolver.getLocale((HttpServletRequest)request).getLanguage(), cnt, SQLInitServlet.getField((String)"filePath") + "xslt", TRIGGER_GROUP_NAME);
        ++cnt;
        jobDetailBean = new JobDetailFactoryBean();
        jobDetailBean.setGroup(TRIGGER_GROUP_NAME);
        jobDetailBean.setName(simpleTrigger.getKey().getName() + System.currentTimeMillis());
        jobDetailBean.setJobClass(XsltStatefulJob.class);
        jobDetailBean.setJobDataMap(simpleTrigger.getJobDataMap());
        jobDetailBean.setDurability(true);
        jobDetailBean.afterPropertiesSet();
        try {
            Date dateStart = this.scheduler.scheduleJob(jobDetailBean.getObject(), (Trigger)simpleTrigger);
            this.logger.debug("== found job date: " + dateStart.toString());
        }
        catch (SchedulerException se) {
            this.logger.error("Error while accessing job date: ", (Throwable)se);
        }
        request.setAttribute("datasetId", (Object)datasetId);
        if (jobDetailBean != null) {
            request.getSession().setAttribute("jobName", (Object)jobDetailBean.getObject().getKey().getName());
        }
        if (simpleTrigger != null) {
            request.getSession().setAttribute("groupName", (Object)TRIGGER_GROUP_NAME);
        }
        request.getSession().setAttribute("datasetId", (Object)new Integer(dsBean.getId()));
        return map;
    }

    @Deprecated
    private ExtractPropertyBean setAllProps(ExtractPropertyBean epBean, DatasetBean dsBean, SimpleDateFormat sdfDir) {
        return this.setAllProps(epBean, dsBean, sdfDir, new ExtractUtils());
    }

    private ExtractPropertyBean setAllProps(ExtractPropertyBean epBean, DatasetBean dsBean, SimpleDateFormat sdfDir, ExtractUtils extractUtils) {
        return extractUtils.setAllProps(epBean, dsBean, sdfDir, SQLInitServlet.getField((String)"filePath"));
    }

    private String getEndFilePath(String endFilePath, DatasetBean dsBean, SimpleDateFormat sdfDir, String filePath, ExtractUtils extractUtils) {
        return extractUtils.getEndFilePath(endFilePath, dsBean, sdfDir, filePath);
    }

    @Deprecated
    private String resolveVars(String endFilePath, DatasetBean dsBean, SimpleDateFormat sdfDir) {
        return this.resolveVars(endFilePath, dsBean, sdfDir, SQLInitServlet.getField((String)"filePath"), new ExtractUtils());
    }

    @Deprecated
    private String resolveVars(String endFilePath, DatasetBean dsBean, SimpleDateFormat sdfDir, String filePath) {
        return this.resolveVars(endFilePath, dsBean, sdfDir, filePath, new ExtractUtils());
    }

    private String resolveVars(String endFilePath, DatasetBean dsBean, SimpleDateFormat sdfDir, String filePath, ExtractUtils extractUtils) {
        return extractUtils.resolveVars(endFilePath, dsBean, sdfDir, filePath);
    }

    private void setUpSidebar(HttpServletRequest request) {
        if (this.sidebarInit.getAlertsBoxSetup() == SidebarEnumConstants.OPENALERTS) {
            request.setAttribute("alertsBoxSetup", (Object)true);
        }
        if (this.sidebarInit.getInfoBoxSetup() == SidebarEnumConstants.OPENINFO) {
            request.setAttribute("infoBoxSetup", (Object)true);
        }
        if (this.sidebarInit.getInstructionsBoxSetup() == SidebarEnumConstants.OPENINSTRUCTIONS) {
            request.setAttribute("instructionsBoxSetup", (Object)true);
        }
        if (this.sidebarInit.getEnableIconsBoxSetup() != SidebarEnumConstants.DISABLEICONS) {
            request.setAttribute("enableIconsBoxSetup", (Object)true);
        }
    }

    public SidebarInit getSidebarInit() {
        return this.sidebarInit;
    }

    public void setSidebarInit(SidebarInit sidebarInit) {
        this.sidebarInit = sidebarInit;
    }

    private String resolveExportFilePath(String epBeanFileName) {
        if (epBeanFileName.contains("$datetime")) {
            String dateTimeFilePattern = "yyyy-MM-dd-HHmmssSSS";
            SimpleDateFormat sdfDir = new SimpleDateFormat(dateTimeFilePattern);
            epBeanFileName = epBeanFileName.replace("$datetime", sdfDir.format(new Date()));
        } else if (epBeanFileName.contains("$date")) {
            String dateFilePattern = "yyyy-MM-dd";
            SimpleDateFormat sdfDir = new SimpleDateFormat(dateFilePattern);
            epBeanFileName = epBeanFileName.replace("$date", sdfDir.format(new Date()));
        }
        return epBeanFileName;
    }

    private boolean mayProceed(HttpServletRequest request) {
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        Role r = currentRole.getRole();
        return r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.MONITOR) || currentRole.getRole().equals((Term)Role.INVESTIGATOR);
    }
}

