/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.ErrorObject;
import org.akaza.openclinica.bean.login.EventDefinitionDTO;
import org.akaza.openclinica.bean.login.ResponseSuccessEventDefDTO;
import org.akaza.openclinica.bean.login.ResponseSuccessSiteDTO;
import org.akaza.openclinica.bean.login.ResponseSuccessStudyDTO;
import org.akaza.openclinica.bean.login.SiteDTO;
import org.akaza.openclinica.bean.login.StudyDTO;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.login.UserRole;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/auth/api/v1/studies"})
public class StudyController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    public static ResourceBundle resadmin;
    public static ResourceBundle resaudit;
    public static ResourceBundle resexception;
    public static ResourceBundle resformat;
    public static ResourceBundle respage;
    public static ResourceBundle resterm;
    public static ResourceBundle restext;
    public static ResourceBundle resword;
    public static ResourceBundle resworkflow;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    UserAccountDAO udao;
    StudyDAO sdao;
    StudyEventDefinitionDAO seddao;

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createNewStudy(HttpServletRequest request, @RequestBody HashMap<String, Object> map) throws Exception {
        ErrorObject errorOBject;
        UserAccountBean ownerUserAccount;
        ErrorObject errorOBject2;
        ErrorObject errorOBject3;
        ErrorObject errorOBject4;
        ArrayList<ErrorObject> errorObjects = new ArrayList<ErrorObject>();
        StudyBean studyBean = null;
        this.logger.debug("I'm in Create Study");
        ResponseEntity response = null;
        String validation_failed_message = "VALIDATION FAILED";
        String validation_passed_message = "SUCCESS";
        String uniqueProtocolID = (String)map.get("uniqueProtocolID");
        String name = (String)map.get("briefTitle");
        String principalInvestigator = (String)map.get("principalInvestigator");
        String briefSummary = (String)map.get("briefSummary");
        String sponsor = (String)map.get("sponsor");
        String protocolType = (String)map.get("protocolType");
        String startDate = (String)map.get("startDate");
        String expectedTotalEnrollment = (String)map.get("expectedTotalEnrollment");
        String status = (String)map.get("status");
        ArrayList assignUserRoles = (ArrayList)map.get("assignUserRoles");
        ArrayList<UserRole> userList = new ArrayList<UserRole>();
        if (assignUserRoles != null) {
            for (Object userRole : assignUserRoles) {
                UserRole uRole = new UserRole();
                uRole.setUsername((String)((HashMap)userRole).get("username"));
                uRole.setRole((String)((HashMap)userRole).get("role"));
                this.udao = new UserAccountDAO((DataSource)this.dataSource);
                UserAccountBean assignedUserBean = (UserAccountBean)this.udao.findByUserName(uRole.getUsername());
                if (assignedUserBean == null || !assignedUserBean.isActive()) {
                    errorOBject4 = this.createErrorObject("Study Object", "The Assigned Username " + uRole.getUsername() + " is not a Valid User", "Assigned User");
                    errorObjects.add(errorOBject4);
                }
                ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
                if (this.getStudyRole(uRole.getRole(), resterm) == null) {
                    errorOBject3 = this.createErrorObject("Study Object", "Assigned Role for " + uRole.getUsername() + " is not a Valid Study Role", "Assigned Role");
                    errorObjects.add(errorOBject3);
                }
                userList.add(uRole);
            }
        }
        StudyDTO studyDTO = this.buildStudyDTO(uniqueProtocolID, name, briefSummary, principalInvestigator, sponsor, expectedTotalEnrollment, protocolType, status, startDate, userList);
        if (uniqueProtocolID == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "UniqueProtocolID");
            errorObjects.add(errorOBject2);
        } else {
            uniqueProtocolID = uniqueProtocolID.trim();
        }
        if (name == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "BriefTitle");
            errorObjects.add(errorOBject2);
        } else {
            name = name.trim();
        }
        if (principalInvestigator == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "PrincipalInvestigator");
            errorObjects.add(errorOBject2);
        } else {
            principalInvestigator = principalInvestigator.trim();
        }
        if (briefSummary == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "BriefSummary");
            errorObjects.add(errorOBject2);
        } else {
            briefSummary = briefSummary.trim();
        }
        if (sponsor == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "Sponsor");
            errorObjects.add(errorOBject2);
        } else {
            sponsor = sponsor.trim();
        }
        if (protocolType == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "ProtocolType");
            errorObjects.add(errorOBject2);
        } else {
            protocolType = protocolType.trim();
        }
        if (startDate == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "StartDate");
            errorObjects.add(errorOBject2);
        } else {
            startDate = startDate.trim();
        }
        if (expectedTotalEnrollment == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "ExpectedTotalEnrollment");
            errorObjects.add(errorOBject2);
        } else {
            expectedTotalEnrollment = expectedTotalEnrollment.trim();
        }
        if (status == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "Status");
            errorObjects.add(errorOBject2);
        } else {
            status = status.trim();
        }
        if (assignUserRoles == null) {
            errorOBject2 = this.createErrorObject("Study Object", "Missing Field", "AssignUserRoles");
            errorObjects.add(errorOBject2);
        }
        if (!(status == null || status.equalsIgnoreCase("available") || status.equalsIgnoreCase("design") || status.equals(""))) {
            errorOBject2 = this.createErrorObject("Study Object", "Status Field Should have 'Available' or 'Design' Status only, If left empty , will default to 'Design' Mode", "Status");
            errorObjects.add(errorOBject2);
        }
        request.setAttribute("uniqueProId", (Object)uniqueProtocolID);
        request.setAttribute("name", (Object)name);
        request.setAttribute("prinInvestigator", (Object)principalInvestigator);
        request.setAttribute("description", (Object)briefSummary);
        request.setAttribute("sponsor", (Object)sponsor);
        request.setAttribute("startDate", (Object)startDate);
        request.setAttribute("expectedTotalEnrollment", (Object)expectedTotalEnrollment);
        request.setAttribute("status", (Object)status);
        String format = "yyyy-MM-dd";
        SimpleDateFormat formatter = null;
        Date formattedDate = null;
        if (startDate != "" && startDate != null) {
            try {
                formatter = new SimpleDateFormat(format);
                formattedDate = formatter.parse(startDate);
            }
            catch (ParseException e) {
                errorOBject3 = this.createErrorObject("Study Object", "The StartDate format is not a valid 'yyyy-MM-dd' format", "StartDate");
                errorObjects.add(errorOBject3);
            }
            if (formattedDate != null && !startDate.equals(formatter.format(formattedDate))) {
                errorOBject4 = this.createErrorObject("Study Object", "The StartDate format is not a valid 'yyyy-MM-dd' format", "StartDate");
                errorObjects.add(errorOBject4);
            }
        }
        if ((ownerUserAccount = this.getStudyOwnerAccount(request)) == null) {
            errorOBject3 = this.createErrorObject("Study Object", "The Owner User Account is not Valid Account or Does not have Admin user type", "Owner Account");
            errorObjects.add(errorOBject3);
        }
        Validator v0 = new Validator(request);
        v0.addValidation("name", 1);
        HashMap vError0 = v0.validate();
        if (!vError0.isEmpty()) {
            ErrorObject errorOBject5 = this.createErrorObject("Study Object", "This field cannot be blank.", "BriefTitle");
            errorObjects.add(errorOBject5);
        }
        Validator v1 = new Validator(request);
        v1.addValidation("uniqueProId", 1);
        HashMap vError1 = v1.validate();
        if (!vError1.isEmpty()) {
            ErrorObject errorOBject6 = this.createErrorObject("Study Object", "This field cannot be blank.", "UniqueProtocolId");
            errorObjects.add(errorOBject6);
        }
        Validator v2 = new Validator(request);
        v2.addValidation("description", 1);
        HashMap vError2 = v2.validate();
        if (!vError2.isEmpty()) {
            ErrorObject errorOBject7 = this.createErrorObject("Study Object", "This field cannot be blank.", "BriefSummary");
            errorObjects.add(errorOBject7);
        }
        Validator v3 = new Validator(request);
        v3.addValidation("prinInvestigator", 1);
        HashMap vError3 = v3.validate();
        if (!vError3.isEmpty()) {
            ErrorObject errorOBject8 = this.createErrorObject("Study Object", "This field cannot be blank.", "PrincipleInvestigator");
            errorObjects.add(errorOBject8);
        }
        Validator v4 = new Validator(request);
        v4.addValidation("sponsor", 1);
        HashMap vError4 = v4.validate();
        if (!vError4.isEmpty()) {
            ErrorObject errorOBject9 = this.createErrorObject("Study Object", "This field cannot be blank.", "Sponsor");
            errorObjects.add(errorOBject9);
        }
        Validator v5 = new Validator(request);
        v5.addValidation("startDate", 1);
        HashMap vError5 = v5.validate();
        if (!vError5.isEmpty()) {
            ErrorObject errorOBject10 = this.createErrorObject("Study Object", "This field cannot be blank.", "StartDate");
            errorObjects.add(errorOBject10);
        }
        Validator v6 = new Validator(request);
        HashMap vError6 = v6.validate();
        if (uniqueProtocolID != null) {
            this.validateUniqueProId(request, vError6);
        }
        if (!vError6.isEmpty()) {
            ErrorObject errorOBject11 = this.createErrorObject("Study Object", "Unique Protocol Id exist in the System", "UniqueProtocolId");
            errorObjects.add(errorOBject11);
        }
        Validator v7 = new Validator(request);
        v7.addValidation("expectedTotalEnrollment", 1);
        HashMap vError7 = v7.validate();
        if (!vError7.isEmpty()) {
            errorOBject = this.createErrorObject("Study Object", "This field cannot be blank.", "ExpectedTotalEnrollment");
            errorObjects.add(errorOBject);
        }
        if (protocolType != null && !this.verifyProtocolTypeExist(protocolType).booleanValue()) {
            errorOBject = this.createErrorObject("Study Object", "Protocol Type is not Valid", "ProtocolType");
            errorObjects.add(errorOBject);
        }
        studyDTO.setErrors(errorObjects);
        if (errorObjects != null && errorObjects.size() != 0) {
            studyDTO.setMessage(validation_failed_message);
            response = new ResponseEntity((Object)studyDTO, HttpStatus.BAD_REQUEST);
        } else {
            studyBean = this.buildStudyBean(uniqueProtocolID, name, briefSummary, principalInvestigator, sponsor, Integer.valueOf(expectedTotalEnrollment).intValue(), protocolType, status, formattedDate, ownerUserAccount);
            StudyBean sBean = this.createStudy(studyBean, ownerUserAccount);
            studyDTO.setStudyOid(sBean.getOid());
            studyDTO.setMessage(validation_passed_message);
            StudyUserRoleBean sub = new StudyUserRoleBean();
            sub.setRole(Role.COORDINATOR);
            sub.setStudyId(sBean.getId());
            sub.setStatus(Status.AVAILABLE);
            sub.setOwner(ownerUserAccount);
            StudyUserRoleBean surb = this.createRole(ownerUserAccount, sub);
            ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
            for (UserRole userRole : userList) {
                sub = new StudyUserRoleBean();
                sub.setRole(this.getStudyRole(userRole.getRole(), resterm));
                sub.setStudyId(sBean.getId());
                sub.setStatus(Status.AVAILABLE);
                sub.setOwner(ownerUserAccount);
                this.udao = new UserAccountDAO((DataSource)this.dataSource);
                UserAccountBean assignedUserBean = (UserAccountBean)this.udao.findByUserName(userRole.getUsername());
                surb = this.createRole(assignedUserBean, sub);
            }
            ResponseSuccessStudyDTO responseSuccess = new ResponseSuccessStudyDTO();
            responseSuccess.setMessage(studyDTO.getMessage());
            responseSuccess.setStudyOid(studyDTO.getStudyOid());
            responseSuccess.setUniqueProtocolID(studyDTO.getUniqueProtocolID());
            response = new ResponseEntity((Object)responseSuccess, HttpStatus.OK);
        }
        return response;
    }

    @RequestMapping(value={"/{uniqueProtocolID}/sites"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createNewSites(HttpServletRequest request, @RequestBody HashMap<String, Object> map, @PathVariable(value="uniqueProtocolID") String uniqueProtocolID) throws Exception {
        ErrorObject errorOBject;
        StudyBean parentStudy;
        ErrorObject errorOBject2;
        ErrorObject errorOBject3;
        ErrorObject errorOBject4;
        this.logger.debug("I'm in Create Sites ");
        ArrayList<ErrorObject> errorObjects = new ArrayList<ErrorObject>();
        StudyBean siteBean = null;
        ResponseEntity response = null;
        String validation_failed_message = "VALIDATION FAILED";
        String validation_passed_message = "SUCCESS";
        String name = (String)map.get("briefTitle");
        String principalInvestigator = (String)map.get("principalInvestigator");
        String uniqueSiteProtocolID = (String)map.get("uniqueProtocolID");
        String expectedTotalEnrollment = (String)map.get("expectedTotalEnrollment");
        String startDate = (String)map.get("startDate");
        String protocolDateVerification = (String)map.get("protocolDateVerification");
        String secondaryProId = (String)map.get("secondaryProtocolID");
        ArrayList assignUserRoles = (ArrayList)map.get("assignUserRoles");
        ArrayList<UserRole> userList = new ArrayList<UserRole>();
        if (assignUserRoles != null) {
            for (Object userRole : assignUserRoles) {
                UserRole uRole = new UserRole();
                uRole.setUsername((String)((HashMap)userRole).get("username"));
                uRole.setRole((String)((HashMap)userRole).get("role"));
                this.udao = new UserAccountDAO((DataSource)this.dataSource);
                UserAccountBean assignedUserBean = (UserAccountBean)this.udao.findByUserName(uRole.getUsername());
                if (assignedUserBean == null || !assignedUserBean.isActive()) {
                    ErrorObject errorOBject5 = this.createErrorObject("Study Object", "The Assigned Username " + uRole.getUsername() + " is not a Valid User", "Assigned User");
                    errorObjects.add(errorOBject5);
                }
                ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
                if (this.getSiteRole(uRole.getRole(), resterm) == null) {
                    errorOBject4 = this.createErrorObject("Study Object", "Assigned Role for " + uRole.getUsername() + " is not a Valid Site Role", "Assigned Role");
                    errorObjects.add(errorOBject4);
                }
                userList.add(uRole);
            }
        }
        SiteDTO siteDTO = this.buildSiteDTO(uniqueSiteProtocolID, name, principalInvestigator, expectedTotalEnrollment, startDate, protocolDateVerification, secondaryProId, userList);
        if (uniqueSiteProtocolID == null) {
            errorOBject3 = this.createErrorObject("Site Object", "Missing Field", "UniqueProtocolID");
            errorObjects.add(errorOBject3);
        } else {
            uniqueSiteProtocolID = uniqueSiteProtocolID.trim();
        }
        if (name == null) {
            errorOBject3 = this.createErrorObject("Site Object", "Missing Field", "BriefTitle");
            errorObjects.add(errorOBject3);
        } else {
            name = name.trim();
        }
        if (principalInvestigator == null) {
            errorOBject3 = this.createErrorObject("Site Object", "Missing Field", "PrincipalInvestigator");
            errorObjects.add(errorOBject3);
        } else {
            principalInvestigator = principalInvestigator.trim();
        }
        if (startDate == null) {
            errorOBject3 = this.createErrorObject("Site Object", "Missing Field", "StartDate");
            errorObjects.add(errorOBject3);
        } else {
            startDate = startDate.trim();
        }
        if (protocolDateVerification == null) {
            errorOBject3 = this.createErrorObject("Site Object", "Missing Field", "ProtocolDateVerification");
            errorObjects.add(errorOBject3);
        } else {
            protocolDateVerification = protocolDateVerification.trim();
        }
        if (expectedTotalEnrollment == null) {
            errorOBject3 = this.createErrorObject("Site Object", "Missing Field", "ExpectedTotalEnrollment");
            errorObjects.add(errorOBject3);
        } else {
            expectedTotalEnrollment = expectedTotalEnrollment.trim();
        }
        if (secondaryProId != null) {
            secondaryProId = secondaryProId.trim();
        }
        if (assignUserRoles == null) {
            errorOBject3 = this.createErrorObject("Study Object", "Missing Field", "AssignUserRoles");
            errorObjects.add(errorOBject3);
        }
        request.setAttribute("uniqueProId", (Object)uniqueSiteProtocolID);
        request.setAttribute("name", (Object)name);
        request.setAttribute("prinInvestigator", (Object)principalInvestigator);
        request.setAttribute("expectedTotalEnrollment", (Object)expectedTotalEnrollment);
        request.setAttribute("startDate", (Object)startDate);
        request.setAttribute("protocolDateVerification", (Object)protocolDateVerification);
        request.setAttribute("secondProId", (Object)secondaryProId);
        String format = "yyyy-MM-dd";
        SimpleDateFormat formatter = null;
        Date formattedStartDate = null;
        Date formattedProtocolDate = null;
        if (startDate != "" && startDate != null) {
            try {
                formatter = new SimpleDateFormat(format);
                formattedStartDate = formatter.parse(startDate);
            }
            catch (ParseException e) {
                errorOBject2 = this.createErrorObject("Site Object", "The StartDate format is not a valid 'yyyy-MM-dd' format", "StartDate");
                errorObjects.add(errorOBject2);
            }
            if (formattedStartDate != null && !startDate.equals(formatter.format(formattedStartDate))) {
                errorOBject4 = this.createErrorObject("Site Object", "The StartDate format is not a valid 'yyyy-MM-dd' format", "StartDate");
                errorObjects.add(errorOBject4);
            }
        }
        if (protocolDateVerification != "" && protocolDateVerification != null) {
            try {
                formatter = new SimpleDateFormat(format);
                formattedProtocolDate = formatter.parse(protocolDateVerification);
            }
            catch (ParseException e) {
                errorOBject2 = this.createErrorObject("Site Object", "The Protocol Verification Date format is not a valid 'yyyy-MM-dd' format", "ProtocolDateVerification");
                errorObjects.add(errorOBject2);
            }
            if (formattedProtocolDate != null && !protocolDateVerification.equals(formatter.format(formattedProtocolDate))) {
                errorOBject4 = this.createErrorObject("Site Object", "The Protocol Verification Date format is not a valid 'yyyy-MM-dd' format", "ProtocolDateVerification");
                errorObjects.add(errorOBject4);
            }
        }
        if ((parentStudy = this.getStudyByUniqId(uniqueProtocolID)) == null) {
            errorOBject2 = this.createErrorObject("Study Object", "The Study Protocol Id provided in the URL is not a valid Protocol Id", "Unique Study Protocol Id");
            errorObjects.add(errorOBject2);
        } else if (parentStudy.getParentStudyId() != 0) {
            errorOBject2 = this.createErrorObject("Study Object", "The Study Protocol Id provided in the URL is not a valid Study Protocol Id", "Unique Study Protocol Id");
            errorObjects.add(errorOBject2);
        }
        UserAccountBean ownerUserAccount = null;
        if (parentStudy != null && (ownerUserAccount = this.getSiteOwnerAccount(request, parentStudy)) == null) {
            ErrorObject errorOBject6 = this.createErrorObject("Site Object", "The Owner User Account is not Valid Account or Does not have rights to Create Sites", "Owner Account");
            errorObjects.add(errorOBject6);
        }
        Validator v1 = new Validator(request);
        v1.addValidation("uniqueProId", 1);
        HashMap vError1 = v1.validate();
        if (!vError1.isEmpty()) {
            ErrorObject errorOBject7 = this.createErrorObject("Site Object", "This field cannot be blank.", "UniqueProtocolId");
            errorObjects.add(errorOBject7);
        }
        Validator v2 = new Validator(request);
        v2.addValidation("name", 1);
        HashMap vError2 = v2.validate();
        if (!vError2.isEmpty()) {
            ErrorObject errorOBject8 = this.createErrorObject("Site Object", "This field cannot be blank.", "BriefTitle");
            errorObjects.add(errorOBject8);
        }
        Validator v3 = new Validator(request);
        v3.addValidation("prinInvestigator", 1);
        HashMap vError3 = v3.validate();
        if (!vError3.isEmpty()) {
            ErrorObject errorOBject9 = this.createErrorObject("Site Object", "This field cannot be blank.", "PrincipleInvestigator");
            errorObjects.add(errorOBject9);
        }
        Validator v6 = new Validator(request);
        HashMap vError6 = v6.validate();
        if (uniqueProtocolID != null) {
            this.validateUniqueProId(request, vError6);
        }
        if (!vError6.isEmpty()) {
            ErrorObject errorOBject10 = this.createErrorObject("Site Object", "Unique Protocol Id exist in the System", "UniqueProtocolId");
            errorObjects.add(errorOBject10);
        }
        Validator v7 = new Validator(request);
        v7.addValidation("expectedTotalEnrollment", 1);
        HashMap vError7 = v7.validate();
        if (!vError7.isEmpty()) {
            errorOBject = this.createErrorObject("Site Object", "This field cannot be blank.", "ExpectedTotalEnrollment");
            errorObjects.add(errorOBject);
        }
        if (request.getAttribute("name") != null && ((String)request.getAttribute("name")).length() > 100) {
            errorOBject = this.createErrorObject("Site Object", "BriefTitle Length exceeds the max length 100", "BriefTitle");
            errorObjects.add(errorOBject);
        }
        if (request.getAttribute("uniqueProId") != null && ((String)request.getAttribute("uniqueProId")).length() > 30) {
            errorOBject = this.createErrorObject("Site Object", "UniqueProtocolId Length exceeds the max length 30", "UniqueProtocolId");
            errorObjects.add(errorOBject);
        }
        if (request.getAttribute("prinInvestigator") != null && ((String)request.getAttribute("prinInvestigator")).length() > 255) {
            errorOBject = this.createErrorObject("Site Object", "PrincipleInvestigator Length exceeds the max length 255", "PrincipleInvestigator");
            errorObjects.add(errorOBject);
        }
        if (request.getAttribute("expectedTotalEnrollment") != null && Integer.valueOf((String)request.getAttribute("expectedTotalEnrollment")) <= 0) {
            errorOBject = this.createErrorObject("Site Object", "ExpectedTotalEnrollment Length can't be negative", "ExpectedTotalEnrollment");
            errorObjects.add(errorOBject);
        }
        siteDTO.setErrors(errorObjects);
        if (errorObjects != null && errorObjects.size() != 0) {
            siteDTO.setMessage(validation_failed_message);
            response = new ResponseEntity((Object)siteDTO, HttpStatus.BAD_REQUEST);
        } else {
            siteBean = this.buildSiteBean(uniqueSiteProtocolID, name, principalInvestigator, Integer.valueOf(expectedTotalEnrollment).intValue(), formattedStartDate, formattedProtocolDate, secondaryProId, ownerUserAccount, parentStudy.getId());
            StudyBean sBean = this.createStudy(siteBean, ownerUserAccount);
            siteDTO.setSiteOid(sBean.getOid());
            siteDTO.setMessage(validation_passed_message);
            ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
            StudyUserRoleBean sub = null;
            for (UserRole userRole : userList) {
                sub = new StudyUserRoleBean();
                sub.setRole(this.getSiteRole(userRole.getRole(), resterm));
                sub.setStudyId(sBean.getId());
                sub.setStatus(Status.AVAILABLE);
                sub.setOwner(ownerUserAccount);
                this.udao = new UserAccountDAO((DataSource)this.dataSource);
                UserAccountBean assignedUserBean = (UserAccountBean)this.udao.findByUserName(userRole.getUsername());
                StudyUserRoleBean studyUserRoleBean = this.createRole(assignedUserBean, sub);
            }
            ResponseSuccessSiteDTO responseSuccess = new ResponseSuccessSiteDTO();
            responseSuccess.setMessage(siteDTO.getMessage());
            responseSuccess.setSiteOid(siteDTO.getSiteOid());
            responseSuccess.setUniqueSiteProtocolID(siteDTO.getUniqueSiteProtocolID());
            response = new ResponseEntity((Object)responseSuccess, HttpStatus.OK);
        }
        return response;
    }

    @RequestMapping(value={"/{uniqueProtocolID}/eventdefinitions"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createEventDefinition(HttpServletRequest request, @RequestBody HashMap<String, Object> map, @PathVariable(value="uniqueProtocolID") String uniqueProtocolID) throws Exception {
        ErrorObject errorOBject;
        ErrorObject errorOBject2;
        ErrorObject errorOBject3;
        this.logger.debug("I'm in Create Event Definition ");
        ArrayList<ErrorObject> errorObjects = new ArrayList<ErrorObject>();
        StudyEventDefinitionBean eventBean = null;
        ResponseEntity response = null;
        String validation_failed_message = "VALIDATION FAILED";
        String validation_passed_message = "SUCCESS";
        String name = (String)map.get("name");
        String description = (String)map.get("description");
        String category = (String)map.get("category");
        String type = (String)map.get("type");
        String repeating = (String)map.get("repeating");
        EventDefinitionDTO eventDefinitionDTO = this.buildEventDefnDTO(name, description, category, repeating, type);
        if (name == null) {
            errorOBject3 = this.createErrorObject("Event Definition Object", "Missing Field", "Name");
            errorObjects.add(errorOBject3);
        } else {
            name = name.trim();
        }
        if (description == null) {
            errorOBject3 = this.createErrorObject("Event Definition Object", "Missing Field", "Description");
            errorObjects.add(errorOBject3);
        } else {
            description = description.trim();
        }
        if (category == null) {
            errorOBject3 = this.createErrorObject("Event Definition Object", "Missing Field", "Category");
            errorObjects.add(errorOBject3);
        } else {
            category = category.trim();
        }
        if (type == null) {
            errorOBject3 = this.createErrorObject("Event Definition Object", "Missing Field", "Type");
            errorObjects.add(errorOBject3);
        } else {
            type = type.trim();
        }
        if (repeating == null) {
            errorOBject3 = this.createErrorObject("Event Definition Object", "Missing Field", "Repeating");
            errorObjects.add(errorOBject3);
        } else {
            repeating = repeating.trim();
        }
        if (repeating != null && !repeating.equalsIgnoreCase("true") && !repeating.equalsIgnoreCase("false")) {
            errorOBject3 = this.createErrorObject("Event Definition Object", "Repeating Field should be Either 'True' or 'False'", "Repeating");
            errorObjects.add(errorOBject3);
        }
        if (!(type == null || type.equalsIgnoreCase("scheduled") || type.equalsIgnoreCase("unscheduled") || type.equalsIgnoreCase("common"))) {
            errorOBject3 = this.createErrorObject("Event Definition Object", "Type Field should be Either 'Scheduled' , 'UnScheduled' or 'Common'", "Type");
            errorObjects.add(errorOBject3);
        }
        request.setAttribute("name", (Object)name);
        request.setAttribute("description", (Object)description);
        request.setAttribute("category", (Object)category);
        request.setAttribute("type", (Object)type);
        request.setAttribute("repeating", (Object)repeating);
        StudyBean parentStudy = this.getStudyByUniqId(uniqueProtocolID);
        if (parentStudy == null) {
            errorOBject2 = this.createErrorObject("Event Definition Object", "The Study Protocol Id provided in the URL is not a valid Protocol Id", "Unique Study Protocol Id");
            errorObjects.add(errorOBject2);
        } else if (parentStudy.getParentStudyId() != 0) {
            errorOBject2 = this.createErrorObject("Event Definition Object", "The Study Protocol Id provided in the URL is not a valid Study Protocol Id", "Unique Study Protocol Id");
            errorObjects.add(errorOBject2);
        }
        UserAccountBean ownerUserAccount = this.getStudyOwnerAccount(request);
        if (ownerUserAccount == null) {
            ErrorObject errorOBject4 = this.createErrorObject("Study Object", "The Owner User Account is not Valid Account or Does not have Admin user type", "Owner Account");
            errorObjects.add(errorOBject4);
        }
        Validator v1 = new Validator(request);
        v1.addValidation("name", 1);
        HashMap vError1 = v1.validate();
        if (!vError1.isEmpty()) {
            ErrorObject errorOBject5 = this.createErrorObject("Event Definition Object", "This field cannot be blank.", "Name");
            errorObjects.add(errorOBject5);
        }
        if (name != null) {
            Validator v2 = new Validator(request);
            v2.addValidation("name", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
            HashMap vError2 = v2.validate();
            if (!vError2.isEmpty()) {
                errorOBject = this.createErrorObject("Event Definition Object", "The Length Should not exceed 2000.", "Name");
                errorObjects.add(errorOBject);
            }
        }
        if (description != null) {
            Validator v3 = new Validator(request);
            v3.addValidation("description", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
            HashMap vError3 = v3.validate();
            if (!vError3.isEmpty()) {
                errorOBject = this.createErrorObject("Event Definition Object", "The Length Should not exceed 2000.", "Description");
                errorObjects.add(errorOBject);
            }
        }
        if (category != null) {
            Validator v4 = new Validator(request);
            v4.addValidation("category", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
            HashMap vError4 = v4.validate();
            if (!vError4.isEmpty()) {
                errorOBject = this.createErrorObject("Event Definition Object", "The Length Should not exceed 2000.", "Category");
                errorObjects.add(errorOBject);
            }
        }
        Validator v5 = new Validator(request);
        v5.addValidation("repeating", 1);
        HashMap vError5 = v5.validate();
        if (!vError5.isEmpty()) {
            errorOBject = this.createErrorObject("Event Definition Object", "This field cannot be blank.", "Repeating");
            errorObjects.add(errorOBject);
        }
        Validator v6 = new Validator(request);
        v6.addValidation("type", 1);
        HashMap vError6 = v6.validate();
        if (!vError6.isEmpty()) {
            ErrorObject errorOBject6 = this.createErrorObject("Event Definition Object", "This field cannot be blank.", "Type");
            errorObjects.add(errorOBject6);
        }
        eventDefinitionDTO.setErrors(errorObjects);
        if (errorObjects != null && errorObjects.size() != 0) {
            eventDefinitionDTO.setMessage(validation_failed_message);
            response = new ResponseEntity((Object)eventDefinitionDTO, HttpStatus.BAD_REQUEST);
        } else {
            eventBean = this.buildEventDefBean(name, description, category, type, repeating, ownerUserAccount, parentStudy);
            StudyEventDefinitionBean sedBean = this.createEventDefn(eventBean, ownerUserAccount);
            eventDefinitionDTO.setEventDefOid(sedBean.getOid());
            eventDefinitionDTO.setMessage(validation_passed_message);
        }
        ResponseSuccessEventDefDTO responseSuccess = new ResponseSuccessEventDefDTO();
        responseSuccess.setMessage(eventDefinitionDTO.getMessage());
        responseSuccess.setEventDefOid(eventDefinitionDTO.getEventDefOid());
        responseSuccess.setName(eventDefinitionDTO.getName());
        response = new ResponseEntity((Object)responseSuccess, HttpStatus.OK);
        return response;
    }

    public Boolean verifyProtocolTypeExist(String protocolType) {
        ResourceBundle resadmin = ResourceBundleProvider.getAdminBundle();
        if (!protocolType.equals(resadmin.getString("interventional")) && !protocolType.equals(resadmin.getString("observational"))) {
            this.logger.info("Study Protocol Type not supported");
            return false;
        }
        return true;
    }

    public StudyEventDefinitionBean buildEventDefBean(String name, String description, String category, String type, String repeating, UserAccountBean owner, StudyBean parentStudy) {
        StudyEventDefinitionBean sed = new StudyEventDefinitionBean();
        this.seddao = new StudyEventDefinitionDAO((DataSource)this.dataSource);
        ArrayList defs = this.seddao.findAllByStudy(parentStudy);
        if (defs == null || defs.isEmpty()) {
            sed.setOrdinal(1);
        } else {
            int lastCount = defs.size() - 1;
            StudyEventDefinitionBean last = (StudyEventDefinitionBean)defs.get(lastCount);
            sed.setOrdinal(last.getOrdinal() + 1);
        }
        sed.setName(name);
        sed.setCategory(category);
        sed.setType(type.toLowerCase());
        sed.setDescription(description);
        sed.setRepeating(Boolean.valueOf(repeating).booleanValue());
        sed.setStudyId(parentStudy.getId());
        sed.setOwner(owner);
        sed.setStatus(Status.AVAILABLE);
        return sed;
    }

    public StudyBean buildSiteBean(String uniqueSiteProtocolId, String name, String principalInvestigator, int expectedTotalEnrollment, Date startDate, Date protocolDateVerification, String secondaryProId, UserAccountBean owner, int parentStudyId) {
        StudyBean study = new StudyBean();
        ResourceBundle resadmin = ResourceBundleProvider.getAdminBundle();
        study.setDatePlannedStart(startDate);
        study.setProtocolDateVerification(protocolDateVerification);
        study.setSecondaryIdentifier(secondaryProId);
        study.setIdentifier(uniqueSiteProtocolId);
        study.setName(name);
        study.setPrincipalInvestigator(principalInvestigator);
        study.setExpectedTotalEnrollment(expectedTotalEnrollment);
        study.setParentStudyId(parentStudyId);
        study.setOwner(owner);
        study.setStatus(Status.AVAILABLE);
        return study;
    }

    public StudyBean createStudy(StudyBean studyBean, UserAccountBean owner) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean sBean = (StudyBean)this.sdao.create((EntityBean)studyBean);
        sBean = (StudyBean)this.sdao.findByPK(sBean.getId());
        return sBean;
    }

    public StudyEventDefinitionBean createEventDefn(StudyEventDefinitionBean sedBean, UserAccountBean owner) {
        this.seddao = new StudyEventDefinitionDAO((DataSource)this.dataSource);
        StudyEventDefinitionBean sdBean = (StudyEventDefinitionBean)this.seddao.create((EntityBean)sedBean);
        sdBean = (StudyEventDefinitionBean)this.seddao.findByPK(sdBean.getId());
        return sdBean;
    }

    public StudyUserRoleBean createRole(UserAccountBean ownerUserAccount, StudyUserRoleBean sub) {
        this.udao = new UserAccountDAO((DataSource)this.dataSource);
        StudyUserRoleBean studyUserRoleBean = this.udao.createStudyUserRole(ownerUserAccount, sub);
        return studyUserRoleBean;
    }

    public StudyUserRoleBean createUserRole(UserAccountBean ownerUserAccount, StudyBean study) {
        this.udao = new UserAccountDAO((DataSource)this.dataSource);
        StudyUserRoleBean surBean = this.udao.findRoleByUserNameAndStudyId(ownerUserAccount.getName(), study.getId());
        return surBean;
    }

    public StudyBean updateStudy(StudyBean studyBean, UserAccountBean owner) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean sBean = (StudyBean)this.sdao.update((EntityBean)studyBean);
        return sBean;
    }

    public void addValidationToDefinitionFields(Validator v) {
        v.addValidation("name", 1);
        v.addValidation("name", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        v.addValidation("description", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
        v.addValidation("category", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
    }

    private UserAccountBean getUserAccount(String userName) {
        this.udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean userAccountBean = (UserAccountBean)this.udao.findByUserName(userName);
        return userAccountBean;
    }

    private StudyBean getStudyByUniqId(String uniqueId) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByUniqueIdentifier(uniqueId);
        return studyBean;
    }

    public void validateUniqueProId(HttpServletRequest request, HashMap errors) {
        StudyDAO studyDAO = new StudyDAO((DataSource)this.dataSource);
        ArrayList allStudies = (ArrayList)studyDAO.findAll();
        for (StudyBean thisBean : allStudies) {
            if (request.getAttribute("uniqueProId") == null || !request.getAttribute("uniqueProId").equals(thisBean.getIdentifier())) continue;
            ResourceBundle resexception = ResourceBundleProvider.getExceptionsBundle();
            Validator.addError((HashMap)errors, (String)"uniqueProId", (String)resexception.getString("unique_protocol_id_existed"));
            break;
        }
    }

    public UserAccountBean getStudyOwnerAccount(HttpServletRequest request) {
        UserAccountBean ownerUserAccount = (UserAccountBean)request.getSession().getAttribute("userBean");
        if (!ownerUserAccount.isTechAdmin() && !ownerUserAccount.isSysAdmin()) {
            this.logger.info("The Owner User Account is not Valid Account or Does not have Admin user type");
            return null;
        }
        return ownerUserAccount;
    }

    public UserAccountBean getSiteOwnerAccount(HttpServletRequest request, StudyBean study) {
        UserAccountBean ownerUserAccount = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyUserRoleBean currentRole = this.createUserRole(ownerUserAccount, study);
        if (currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return ownerUserAccount;
        }
        return null;
    }

    public StudyDTO buildStudyDTO(String uniqueProtocolID, String name, String briefSummary, String principalInvestigator, String sponsor, String expectedTotalEnrollment, String protocolType, String status, String startDate, ArrayList<UserRole> userList) {
        if (status != null && status.equals("")) {
            status = "design";
        }
        StudyDTO studyDTO = new StudyDTO();
        studyDTO.setUniqueProtocolID(uniqueProtocolID);
        studyDTO.setBriefTitle(name);
        studyDTO.setPrincipalInvestigator(principalInvestigator);
        studyDTO.setBriefSummary(briefSummary);
        studyDTO.setSponsor(sponsor);
        studyDTO.setProtocolType(protocolType);
        studyDTO.setStatus(status);
        studyDTO.setExpectedTotalEnrollment(expectedTotalEnrollment);
        studyDTO.setStartDate(startDate);
        studyDTO.setAssignUserRoles(userList);
        return studyDTO;
    }

    public SiteDTO buildSiteDTO(String uniqueSiteProtocolID, String name, String principalInvestigator, String expectedTotalEnrollment, String startDate, String protocolDateVerification, String secondaryProId, ArrayList<UserRole> userList) {
        SiteDTO siteDTO = new SiteDTO();
        siteDTO.setUniqueSiteProtocolID(uniqueSiteProtocolID);
        siteDTO.setBriefTitle(name);
        siteDTO.setPrincipalInvestigator(principalInvestigator);
        siteDTO.setExpectedTotalEnrollment(expectedTotalEnrollment);
        siteDTO.setStartDate(startDate);
        siteDTO.setSecondaryProId(secondaryProId);
        siteDTO.setProtocolDateVerification(protocolDateVerification);
        siteDTO.setAssignUserRoles(userList);
        return siteDTO;
    }

    public EventDefinitionDTO buildEventDefnDTO(String name, String description, String category, String repeating, String type) {
        EventDefinitionDTO eventDefinitionDTO = new EventDefinitionDTO();
        eventDefinitionDTO.setName(name);
        eventDefinitionDTO.setDescription(description);
        eventDefinitionDTO.setCategory(category);
        eventDefinitionDTO.setType(type);
        eventDefinitionDTO.setRepeating(repeating);
        return eventDefinitionDTO;
    }

    public StudyBean buildStudyBean(String uniqueProtocolId, String name, String briefSummary, String principalInvestigator, String sponsor, int expectedTotalEnrollment, String protocolType, String status, Date startDate, UserAccountBean owner) {
        StudyBean study = new StudyBean();
        ResourceBundle resadmin = ResourceBundleProvider.getAdminBundle();
        if (protocolType.equals(resadmin.getString("interventional"))) {
            study.setProtocolType("interventional");
        } else if (protocolType.equals(resadmin.getString("observational"))) {
            study.setProtocolType("observational");
        }
        ResourceBundle resword = ResourceBundleProvider.getWordsBundle();
        if (resword.getString("available").equalsIgnoreCase(status)) {
            study.setStatus(Status.AVAILABLE);
        } else if (resword.getString("design").equalsIgnoreCase(status) || status.equals("")) {
            study.setStatus(Status.PENDING);
        }
        study.setIdentifier(uniqueProtocolId);
        study.setName(name);
        study.setPrincipalInvestigator(principalInvestigator);
        study.setSummary(briefSummary);
        study.setSponsor(sponsor);
        study.setExpectedTotalEnrollment(expectedTotalEnrollment);
        study.setDatePlannedStart(startDate);
        study.setOwner(owner);
        return study;
    }

    public ErrorObject createErrorObject(String resource, String code, String field) {
        ErrorObject errorOBject = new ErrorObject();
        errorOBject.setResource(resource);
        errorOBject.setCode(code);
        errorOBject.setField(field);
        return errorOBject;
    }

    public Role getStudyRole(String roleName, ResourceBundle resterm) {
        if (roleName.equalsIgnoreCase(resterm.getString("Study_Director").trim())) {
            return Role.STUDYDIRECTOR;
        }
        if (roleName.equalsIgnoreCase(resterm.getString("Study_Coordinator").trim())) {
            return Role.COORDINATOR;
        }
        if (roleName.equalsIgnoreCase(resterm.getString("Investigator").trim())) {
            return Role.INVESTIGATOR;
        }
        if (roleName.equalsIgnoreCase(resterm.getString("Data_Entry_Person").trim())) {
            return Role.RESEARCHASSISTANT;
        }
        if (roleName.equalsIgnoreCase(resterm.getString("Monitor").trim())) {
            return Role.MONITOR;
        }
        return null;
    }

    public Role getSiteRole(String roleName, ResourceBundle resterm) {
        if (roleName.equalsIgnoreCase(resterm.getString("site_investigator").trim())) {
            return Role.INVESTIGATOR;
        }
        if (roleName.equalsIgnoreCase(resterm.getString("site_Data_Entry_Person").trim())) {
            return Role.RESEARCHASSISTANT;
        }
        if (roleName.equalsIgnoreCase(resterm.getString("site_monitor").trim())) {
            return Role.MONITOR;
        }
        if (roleName.equalsIgnoreCase(resterm.getString("site_Data_Entry_Person2").trim())) {
            return Role.RESEARCHASSISTANT2;
        }
        return null;
    }
}

