/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.helper;

import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.view.StudyInfoPanel;

public class SetUpStudyRole {
    private DataSource dataSource;
    public static final String STUDY_INFO_PANEL = "panel";

    public SetUpStudyRole(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUp(HttpSession httpSession, UserAccountBean userAccountBean) {
        ArrayList roles;
        StudyUserRoleBean currentRole = new StudyUserRoleBean();
        StudyBean currentStudy = new StudyBean();
        StudyInfoPanel panel = new StudyInfoPanel();
        StudyDAO sdao = new StudyDAO(this.dataSource);
        if (userAccountBean.getId() > 0 && userAccountBean.getActiveStudyId() > 0) {
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.dataSource);
            currentStudy = (StudyBean)sdao.findByPK(userAccountBean.getActiveStudyId());
            ArrayList studyParameters = spvdao.findParamConfigByStudy(currentStudy);
            currentStudy.setStudyParameters(studyParameters);
            StudyConfigService scs = new StudyConfigService(this.dataSource);
            if (currentStudy.getParentStudyId() <= 0) {
                scs.setParametersForStudy(currentStudy);
            } else {
                currentStudy.setParentStudyName(((StudyBean)sdao.findByPK(currentStudy.getParentStudyId())).getName());
                scs.setParametersForSite(currentStudy);
            }
            panel.reset();
            httpSession.setAttribute(STUDY_INFO_PANEL, (Object)panel);
        } else {
            currentStudy = new StudyBean();
        }
        httpSession.setAttribute("study", (Object)currentStudy);
        if (currentStudy.getParentStudyId() > 0) {
            currentStudy.setParentStudyName(((StudyBean)sdao.findByPK(currentStudy.getParentStudyId())).getName());
        }
        if (currentStudy.getParentStudyId() > 0) {
            roles = Role.toArrayList();
            for (Role role : roles) {
                switch (role.getId()) {
                    case 2: {
                        role.setDescription("site_Study_Coordinator");
                        break;
                    }
                    case 3: {
                        role.setDescription("site_Study_Director");
                        break;
                    }
                    case 4: {
                        role.setDescription("site_investigator");
                        break;
                    }
                    case 5: {
                        role.setDescription("site_Data_Entry_Person");
                        break;
                    }
                    case 6: {
                        role.setDescription("site_monitor");
                        break;
                    }
                    case 7: {
                        role.setDescription("site_Data_Entry_Person2");
                        break;
                    }
                }
            }
        } else {
            roles = Role.toArrayList();
            for (Role role : roles) {
                switch (role.getId()) {
                    case 2: {
                        role.setDescription("Study_Coordinator");
                        break;
                    }
                    case 3: {
                        role.setDescription("Study_Director");
                        break;
                    }
                    case 4: {
                        role.setDescription("investigator");
                        break;
                    }
                    case 5: {
                        role.setDescription("Data_Entry_Person");
                        break;
                    }
                    case 6: {
                        role.setDescription("monitor");
                        break;
                    }
                }
            }
        }
        if (currentRole.getId() <= 0) {
            if (userAccountBean.getId() > 0 && currentStudy.getId() > 0 && !currentStudy.getStatus().getName().equals("removed")) {
                currentRole = userAccountBean.getRoleByStudy(currentStudy.getId());
                if (currentStudy.getParentStudyId() > 0) {
                    StudyUserRoleBean roleInParent = userAccountBean.getRoleByStudy(currentStudy.getParentStudyId());
                    currentRole.setRole(Role.max((Role)currentRole.getRole(), (Role)roleInParent.getRole()));
                }
            } else {
                currentRole = new StudyUserRoleBean();
            }
            httpSession.setAttribute("userRole", (Object)currentRole);
        } else if (currentRole.getId() > 0 && (currentStudy.getStatus().equals((Term)Status.DELETED) || currentStudy.getStatus().equals((Term)Status.AUTO_DELETED))) {
            currentRole.setRole(Role.INVALID);
            currentRole.setStatus(Status.DELETED);
            httpSession.setAttribute("userRole", (Object)currentRole);
        }
    }
}

