/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.helper;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.controller.helper.SetUpStudyRole;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SetUpUserInterceptor
extends HandlerInterceptorAdapter {
    public static final String USER_BEAN_NAME = "userBean";
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        boolean userBeanIsInvalid;
        Locale locale = (Locale)ResourceBundleProvider.localeMap.get(Thread.currentThread());
        if (locale == null) {
            ResourceBundleProvider.updateLocale((Locale)LocaleResolver.getLocale((HttpServletRequest)httpServletRequest));
        }
        HttpSession currentSession = httpServletRequest.getSession();
        UserAccountBean userBean = (UserAccountBean)currentSession.getAttribute(USER_BEAN_NAME);
        String userName = "";
        UserAccountDAO userAccountDAO = new UserAccountDAO(this.dataSource);
        if (userBean == null && !(userBeanIsInvalid = "".equalsIgnoreCase(userName = httpServletRequest.getRemoteUser()))) {
            userBean = (UserAccountBean)userAccountDAO.findByUserName(userName);
            boolean bl = userBeanIsInvalid = userBean == null;
            if (!userBeanIsInvalid) {
                currentSession.setAttribute(USER_BEAN_NAME, (Object)userBean);
            }
        }
        if (userBean == null) {
            userBean = new UserAccountBean();
            userBean.setName("unknown");
            currentSession.setAttribute(USER_BEAN_NAME, (Object)userBean);
        }
        userBean = userBean.getId() > 0 ? (UserAccountBean)userAccountDAO.findByPK(userBean.getId()) : userBean;
        SetUpStudyRole setupStudy = new SetUpStudyRole(this.dataSource);
        setupStudy.setUp(currentSession, userBean);
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

