/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.user;

import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.service.user.LdapUserService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LdapUserController {
    private static final String PAGE_LIST_LDAP_USERS = "listLdapUsers";
    @Autowired
    private LdapUserService ldapUserService;
    @Autowired
    private UserAccountDAO userAccountDao;

    @RequestMapping(value={"/listLdapUsers"})
    public String listLdapUsers(HttpServletRequest req, @RequestParam(value="filter", required=false) String filter) {
        if (!StringUtils.isEmpty((String)filter)) {
            Collection existingAccounts = this.userAccountDao.findAll();
            HashSet<String> existingUsernames = new HashSet<String>(existingAccounts.size());
            for (UserAccountBean existingAccount : existingAccounts) {
                existingUsernames.add(existingAccount.getName());
            }
            req.setAttribute("memberList", (Object)this.ldapUserService.listNewUsers(filter, existingUsernames));
        }
        return PAGE_LIST_LDAP_USERS;
    }

    @RequestMapping(value={"/selectLdapUser"})
    public String selectLdapUser(HttpServletRequest req, @RequestParam(value="dn", required=false) String dn) {
        if (!StringUtils.isEmpty((String)dn)) {
            req.getSession().setAttribute("ldapUser", (Object)this.ldapUserService.loadUser(dn));
        }
        return "redirect:/CreateUserAccount";
    }
}

