/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.display;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.view.form.FormBeanUtil;
import org.akaza.openclinica.view.form.ViewPersistanceHandler;

public class DisplaySectionBeanHandler {
    private boolean hasStoredData = false;
    private int crfVersionId;
    private int eventCRFId;
    private List<DisplaySectionBean> displaySectionBeans;
    private ServletContext context;
    private DataSource dataSource;

    public DisplaySectionBeanHandler(boolean dataEntry) {
        this.hasStoredData = dataEntry;
    }

    public DisplaySectionBeanHandler(boolean dataEntry, DataSource dataSource, ServletContext context) {
        this(dataEntry);
        if (dataSource != null) {
            this.setDataSource(dataSource);
        }
        if (context != null) {
            this.context = context;
        }
    }

    public int getCrfVersionId() {
        return this.crfVersionId;
    }

    public void setCrfVersionId(int crfVersionId) {
        this.crfVersionId = crfVersionId;
    }

    public int getEventCRFId() {
        return this.eventCRFId;
    }

    public void setEventCRFId(int eventCRFId) {
        this.eventCRFId = eventCRFId;
    }

    public List<DisplaySectionBean> getDisplaySectionBeans() {
        if (this.displaySectionBeans == null) {
            this.displaySectionBeans = new ArrayList();
            FormBeanUtil formBeanUtil = new FormBeanUtil();
            if (this.hasStoredData) {
                ViewPersistanceHandler viewPersistanceHandler = new ViewPersistanceHandler();
            }
            if (this.crfVersionId == 0) {
                return this.displaySectionBeans;
            }
            SectionDAO sectionDao = new SectionDAO(this.dataSource);
            ArrayList allCrfSections = (ArrayList)sectionDao.findByVersionId(this.crfVersionId);
            EventDefinitionCRFBean eventDefBean = null;
            EventCRFBean eventCRFBean = new EventCRFBean();
            if (this.eventCRFId > 0) {
                EventCRFDAO ecdao = new EventCRFDAO(this.dataSource);
                eventCRFBean = (EventCRFBean)ecdao.findByPK(this.eventCRFId);
                StudyEventDAO sedao = new StudyEventDAO(this.dataSource);
                StudyEventBean studyEvent = (StudyEventBean)sedao.findByPK(eventCRFBean.getStudyEventId());
                EventDefinitionCRFDAO eventDefinitionCRFDAO = new EventDefinitionCRFDAO(this.dataSource);
                StudyDAO sdao = new StudyDAO(this.dataSource);
                StudyBean study = sdao.findByStudySubjectId(eventCRFBean.getStudySubjectId());
                eventDefBean = eventDefinitionCRFDAO.findByStudyEventIdAndCRFVersionId(study, studyEvent.getId(), this.crfVersionId);
            }
            eventDefBean = eventDefBean == null ? new EventDefinitionCRFBean() : eventDefBean;
            for (SectionBean sectionBean : allCrfSections) {
                DisplaySectionBean displaySectionBean = formBeanUtil.createDisplaySectionBWithFormGroupsForPrint(sectionBean.getId(), this.crfVersionId, this.dataSource, eventDefBean.getId(), eventCRFBean, this.context);
                this.displaySectionBeans.add(displaySectionBean);
            }
        }
        return this.displaySectionBeans;
    }

    public void setDisplaySectionBeans(List<DisplaySectionBean> displaySectionBeans) {
        this.displaySectionBeans = displaySectionBeans;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

