/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.job;

import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.TriggerBean;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.extract.ExtractBean;
import org.akaza.openclinica.bean.extract.SPSSReportBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.OpenClinicaMailSender;
import org.akaza.openclinica.dao.admin.AuditEventDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.extract.GenerateExtractFileService;
import org.akaza.openclinica.web.SQLInitServlet;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ExampleSpringJob
extends QuartzJobBean {
    private String message;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String PERIOD = "periodToRun";
    public static final String TAB = "tab";
    public static final String CDISC = "cdisc";
    public static final String CDISC12 = "cdisc12";
    public static final String CDISC13 = "cdisc13";
    public static final String CDISC13OC = "cdisc13oc";
    public static final String SPSS = "spss";
    public static final String DATASET_ID = "dsId";
    public static final String EMAIL = "contactEmail";
    public static final String USER_ID = "user_id";
    public static final String STUDY_NAME = "study_name";
    public static final String STUDY_ID = "studyId";
    public static final String LOCALE = "locale";
    private static final String DATASET_DIR = SQLInitServlet.getField((String)"filePath") + "datasets" + File.separator;
    private OpenClinicaMailSender mailSender;
    private DataSource dataSource;
    private GenerateExtractFileService generateFileService;
    private UserAccountBean userBean;
    private JobDetailFactoryBean jobDetailBean;
    private CoreResources coreResources;
    private RuleSetRuleDao ruleSetRuleDao;

    public void setMessage(String message) {
        this.message = message;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        block16: {
            Locale locale = new Locale("en-US");
            ResourceBundleProvider.updateLocale((Locale)locale);
            ResourceBundle pageMessages = ResourceBundleProvider.getPageMessagesBundle();
            JobDataMap dataMap = context.getMergedJobDataMap();
            SimpleTrigger trigger = (SimpleTrigger)context.getTrigger();
            try {
                String cdisc13oc;
                String cdisc13;
                ApplicationContext appContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
                CoreResources cfr_ignored_0 = (CoreResources)appContext.getBean("coreResources");
                String studySubjectNumber = CoreResources.getField((String)"extract.number");
                this.coreResources = (CoreResources)appContext.getBean("coreResources");
                this.ruleSetRuleDao = (RuleSetRuleDao)appContext.getBean("ruleSetRuleDao");
                this.dataSource = (DataSource)appContext.getBean("dataSource");
                this.mailSender = (OpenClinicaMailSender)appContext.getBean("openClinicaMailSender");
                AuditEventDAO auditEventDAO = new AuditEventDAO(this.dataSource);
                String alertEmail = dataMap.getString(EMAIL);
                String localeStr = dataMap.getString(LOCALE);
                if (localeStr != null) {
                    locale = new Locale(localeStr);
                    ResourceBundleProvider.updateLocale((Locale)locale);
                    pageMessages = ResourceBundleProvider.getPageMessagesBundle();
                }
                int dsId = dataMap.getInt(DATASET_ID);
                String tab = dataMap.getString(TAB);
                String cdisc = dataMap.getString(CDISC);
                String cdisc12 = dataMap.getString(CDISC12);
                if (cdisc12 == null) {
                    cdisc12 = "0";
                }
                if ((cdisc13 = dataMap.getString(CDISC13)) == null) {
                    cdisc13 = "0";
                }
                if ((cdisc13oc = dataMap.getString(CDISC13OC)) == null) {
                    cdisc13oc = "0";
                }
                String spss = dataMap.getString(SPSS);
                int userId = dataMap.getInt(USER_ID);
                int studyId = dataMap.getInt(STUDY_ID);
                this.logger.debug("-- found the job: " + dsId + " dataset id");
                HashMap fileName = new HashMap();
                if (dsId > 0) {
                    String odmVersion;
                    DatasetDAO dsdao = new DatasetDAO(this.dataSource);
                    DatasetBean datasetBean = (DatasetBean)dsdao.findByPK(dsId);
                    StudyDAO studyDao = new StudyDAO(this.dataSource);
                    UserAccountDAO userAccountDAO = new UserAccountDAO(this.dataSource);
                    String generalFileDir = "";
                    String generalFileDirCopy = "";
                    String exportFilePath = SQLInitServlet.getField((String)"exportFilePath");
                    String pattern = "yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "HHmmssSSS" + File.separator;
                    SimpleDateFormat sdfDir = new SimpleDateFormat(pattern);
                    generalFileDir = DATASET_DIR + datasetBean.getId() + File.separator + sdfDir.format(new Date());
                    if (!"".equals(exportFilePath)) {
                        generalFileDirCopy = SQLInitServlet.getField((String)"filePath") + exportFilePath + File.separator;
                    }
                    long sysTimeBegin = System.currentTimeMillis();
                    this.userBean = (UserAccountBean)userAccountDAO.findByPK(userId);
                    this.generateFileService = new GenerateExtractFileService(this.dataSource, this.coreResources, this.ruleSetRuleDao);
                    StudyBean activeStudy = (StudyBean)studyDao.findByPK(studyId);
                    StudyBean parentStudy = new StudyBean();
                    this.logger.debug("active study: " + studyId + " parent study: " + activeStudy.getParentStudyId());
                    parentStudy = activeStudy.getParentStudyId() > 0 ? (StudyBean)studyDao.findByPK(activeStudy.getParentStudyId()) : activeStudy;
                    this.logger.debug("-- found extract bean ");
                    ExtractBean eb = this.generateFileService.generateExtractBean(datasetBean, activeStudy, parentStudy);
                    MessageFormat mf = new MessageFormat("");
                    StringBuffer message = new StringBuffer();
                    StringBuffer auditMessage = new StringBuffer();
                    message.append("<p>" + pageMessages.getString("email_header_1") + " " + EmailEngine.getAdminEmail() + " " + pageMessages.getString("email_header_2") + " Job Execution " + pageMessages.getString("email_header_3") + "</p>");
                    message.append("<P>Dataset: " + datasetBean.getName() + "</P>");
                    message.append("<P>Study: " + activeStudy.getName() + "</P>");
                    message.append("<p>" + pageMessages.getString("html_email_body_1") + datasetBean.getName() + pageMessages.getString("html_email_body_2") + SQLInitServlet.getField((String)"sysURL") + pageMessages.getString("html_email_body_3") + "</p>");
                    if ("1".equals(tab)) {
                        this.logger.debug("-- gen tab file 01");
                        fileName = this.generateFileService.createTabFile(eb, sysTimeBegin, generalFileDir, datasetBean, activeStudy.getId(), parentStudy.getId(), generalFileDirCopy, this.userBean);
                        message.append("<p>" + pageMessages.getString("html_email_body_4") + " " + this.getFileNameStr(fileName) + pageMessages.getString("html_email_body_4_5") + SQLInitServlet.getField((String)"sysURL.base") + "AccessFile?fileId=" + this.getFileIdInt(fileName) + pageMessages.getString("html_email_body_3") + "</p>");
                        auditMessage.append(pageMessages.getString("you_can_access_tab_delimited") + this.getFileIdInt(fileName) + pageMessages.getString("access_end"));
                    }
                    if ("1".equals(cdisc)) {
                        odmVersion = "oc1.2";
                        fileName = this.generateFileService.createODMFile(odmVersion, sysTimeBegin, generalFileDir, datasetBean, activeStudy, generalFileDirCopy, eb, Integer.valueOf(activeStudy.getId()), Integer.valueOf(parentStudy.getId()), studySubjectNumber, true, true, true, null, this.userBean);
                        this.logger.debug("-- gen odm file");
                        message.append("<p>" + pageMessages.getString("html_email_body_4") + " " + this.getFileNameStr(fileName) + pageMessages.getString("html_email_body_4_5") + SQLInitServlet.getField((String)"sysURL.base") + "AccessFile?fileId=" + this.getFileIdInt(fileName) + pageMessages.getString("html_email_body_3") + "</p>");
                        auditMessage.append(pageMessages.getString("you_can_access_odm_12") + this.getFileIdInt(fileName) + pageMessages.getString("access_end"));
                    }
                    if ("1".equals(cdisc12)) {
                        odmVersion = "1.2";
                        fileName = this.generateFileService.createODMFile(odmVersion, sysTimeBegin, generalFileDir, datasetBean, activeStudy, generalFileDirCopy, eb, Integer.valueOf(activeStudy.getId()), Integer.valueOf(parentStudy.getId()), studySubjectNumber, true, true, true, null, this.userBean);
                        this.logger.debug("-- gen odm file 1.2 default");
                        message.append("<p>" + pageMessages.getString("html_email_body_4") + " " + this.getFileNameStr(fileName) + pageMessages.getString("html_email_body_4_5") + SQLInitServlet.getField((String)"sysURL.base") + "AccessFile?fileId=" + this.getFileIdInt(fileName) + pageMessages.getString("html_email_body_3") + "</p>");
                        auditMessage.append(pageMessages.getString("you_can_access_odm_12_xml") + this.getFileIdInt(fileName) + pageMessages.getString("access_end"));
                    }
                    if ("1".equals(cdisc13)) {
                        odmVersion = "1.3";
                        fileName = this.generateFileService.createODMFile(odmVersion, sysTimeBegin, generalFileDir, datasetBean, activeStudy, generalFileDirCopy, eb, Integer.valueOf(activeStudy.getId()), Integer.valueOf(parentStudy.getId()), studySubjectNumber, true, true, true, null, this.userBean);
                        this.logger.debug("-- gen odm file 1.3");
                        message.append("<p>" + pageMessages.getString("html_email_body_4") + " " + this.getFileNameStr(fileName) + pageMessages.getString("html_email_body_4_5") + SQLInitServlet.getField((String)"sysURL.base") + "AccessFile?fileId=" + this.getFileIdInt(fileName) + pageMessages.getString("html_email_body_3") + "</p>");
                        auditMessage.append(pageMessages.getString("you_can_access_odm_13") + this.getFileIdInt(fileName) + pageMessages.getString("access_end"));
                    }
                    if ("1".equals(cdisc13oc)) {
                        odmVersion = "oc1.3";
                        fileName = this.generateFileService.createODMFile(odmVersion, sysTimeBegin, generalFileDir, datasetBean, activeStudy, generalFileDirCopy, eb, Integer.valueOf(activeStudy.getId()), Integer.valueOf(parentStudy.getId()), studySubjectNumber, true, true, true, null, this.userBean);
                        this.logger.debug("-- gen odm file 1.3 oc");
                        message.append("<p>" + pageMessages.getString("html_email_body_4") + " " + this.getFileNameStr(fileName) + pageMessages.getString("html_email_body_4_5") + SQLInitServlet.getField((String)"sysURL.base") + "AccessFile?fileId=" + this.getFileIdInt(fileName) + pageMessages.getString("html_email_body_3") + "</p>");
                        auditMessage.append(pageMessages.getString("you_can_access_odm_13_xml") + this.getFileIdInt(fileName) + pageMessages.getString("access_end"));
                    }
                    if ("1".equals(spss)) {
                        SPSSReportBean answer = new SPSSReportBean();
                        fileName = this.generateFileService.createSPSSFile(datasetBean, eb, activeStudy, parentStudy, sysTimeBegin, generalFileDir, answer, generalFileDirCopy, this.userBean);
                        this.logger.debug("-- gen spss file");
                        message.append("<p>" + pageMessages.getString("html_email_body_4") + " " + this.getFileNameStr(fileName) + pageMessages.getString("html_email_body_4_5") + SQLInitServlet.getField((String)"sysURL.base") + "AccessFile?fileId=" + this.getFileIdInt(fileName) + pageMessages.getString("html_email_body_3") + "</p>");
                        auditMessage.append(pageMessages.getString("you_can_access_spss") + this.getFileIdInt(fileName) + pageMessages.getString("access_end"));
                    }
                    message.append("<p>" + pageMessages.getString("html_email_body_5") + "</P><P>" + pageMessages.getString("email_footer"));
                    try {
                        this.mailSender.sendEmail(alertEmail.trim(), pageMessages.getString("job_ran_for") + " " + datasetBean.getName(), message.toString(), Boolean.valueOf(true));
                    }
                    catch (OpenClinicaSystemException answer) {
                        // empty catch block
                    }
                    TriggerBean triggerBean = new TriggerBean();
                    triggerBean.setDataset(datasetBean);
                    triggerBean.setUserAccount(this.userBean);
                    triggerBean.setFullName(trigger.getKey().getName());
                    auditEventDAO.createRowForExtractDataJobSuccess(triggerBean, auditMessage.toString());
                    break block16;
                }
                TriggerBean triggerBean = new TriggerBean();
                triggerBean.setUserAccount(this.userBean);
                triggerBean.setFullName(trigger.getKey().getName());
                auditEventDAO.createRowForExtractDataJobFailure(triggerBean);
            }
            catch (Exception e) {
                this.logger.debug("-- found exception: ", (Throwable)e);
            }
        }
    }

    private String getFileNameStr(HashMap fileName) {
        String fileNameStr = "";
        for (Map.Entry entry : fileName.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            fileNameStr = (String)key;
            Integer n = (Integer)value;
        }
        return fileNameStr;
    }

    private int getFileIdInt(HashMap fileName) {
        Integer fileID = new Integer(0);
        for (Map.Entry entry : fileName.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            fileID = (Integer)value;
        }
        return fileID;
    }

    private DataSource getDataSource(Scheduler scheduler) {
        try {
            ApplicationContext context = (ApplicationContext)scheduler.getContext().get((Object)"applicationContext");
            this.dataSource = this.dataSource != null ? this.dataSource : (DataSource)context.getBean("dataSource");
        }
        catch (Exception e) {
            this.logger.error("Error while accessing application context: ", (Throwable)e);
        }
        return this.dataSource;
    }
}

