/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.job;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.TriggerBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.rule.XmlSchemaValidationHelper;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemBeanWrapper;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ODMContainer;
import org.akaza.openclinica.bean.submit.crfdata.SubjectDataBean;
import org.akaza.openclinica.bean.submit.crfdata.SummaryStatsBean;
import org.akaza.openclinica.control.submit.ImportCRFInfoContainer;
import org.akaza.openclinica.core.OpenClinicaMailSender;
import org.akaza.openclinica.dao.admin.AuditEventDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.logic.rulerunner.ExecutionMode;
import org.akaza.openclinica.logic.rulerunner.ImportDataRuleRunnerContainer;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.crfdata.ImportCRFDataService;
import org.akaza.openclinica.web.job.CrfBusinessLogicHelper;
import org.akaza.openclinica.web.job.TriggerService;
import org.apache.commons.lang.StringUtils;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImportSpringJob
extends QuartzJobBean {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    XmlSchemaValidationHelper schemaValidator = new XmlSchemaValidationHelper();
    public static final String DIR_PATH = "scheduled_data_import";
    ResourceBundle respage;
    ResourceBundle resword;
    Locale locale;
    public static final String DIRECTORY = "filePathDir";
    public static final String EMAIL = "contactEmail";
    public static final String USER_ID = "user_id";
    public static final String STUDY_NAME = "study_name";
    public static final String STUDY_OID = "study_oid";
    public static final String DEST_DIR = "Event_CRF_Data";
    private static final String IMPORT_DIR = SQLInitServlet.getField((String)"filePath") + "scheduled_data_import" + File.separator;
    public static final String IMPORT_DIR_2 = SQLInitServlet.getField((String)"filePath") + "Event_CRF_Data" + File.separator;
    private DataSource dataSource;
    private OpenClinicaMailSender mailSender;
    private ImportCRFDataService dataService;
    private ItemDataDAO itemDataDao;
    private EventCRFDAO eventCrfDao;
    private AuditEventDAO auditEventDAO;
    private TriggerService triggerService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            ApplicationContext appContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
            TransactionTemplate transactionTemplate = (TransactionTemplate)appContext.getBean("sharedTransactionTemplate");
            transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (SchedulerException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    protected void executeInternalInTransaction(JobExecutionContext context) {
        block15: {
            this.locale = new Locale("en-US");
            ResourceBundleProvider.updateLocale((Locale)this.locale);
            this.respage = ResourceBundleProvider.getPageMessagesBundle();
            this.resword = ResourceBundleProvider.getWordsBundle();
            this.triggerService = new TriggerService();
            JobDataMap dataMap = context.getMergedJobDataMap();
            SimpleTrigger trigger = (SimpleTrigger)context.getTrigger();
            TriggerBean triggerBean = new TriggerBean();
            triggerBean.setFullName(trigger.getKey().getName());
            String contactEmail = dataMap.getString("contactEmail");
            this.logger.debug("=== starting to run trigger " + trigger.getKey().getName() + " ===");
            try {
                File destDirectory;
                ApplicationContext appContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
                this.dataSource = (DataSource)appContext.getBean("dataSource");
                this.mailSender = (OpenClinicaMailSender)appContext.getBean("openClinicaMailSender");
                RuleSetServiceInterface ruleSetService = (RuleSetServiceInterface)appContext.getBean("ruleSetService");
                this.itemDataDao = new ItemDataDAO(this.dataSource);
                this.eventCrfDao = new EventCRFDAO(this.dataSource);
                this.auditEventDAO = new AuditEventDAO(this.dataSource);
                int userId = dataMap.getInt("user_id");
                UserAccountDAO userAccountDAO = new UserAccountDAO(this.dataSource);
                UserAccountBean ub = (UserAccountBean)userAccountDAO.findByPK(userId);
                triggerBean.setUserAccount(ub);
                String directory = dataMap.getString("filePathDir");
                String studyName = dataMap.getString("study_name");
                String studyOid = dataMap.getString("study_oid");
                String localeStr = dataMap.getString("locale");
                if (localeStr != null) {
                    this.locale = new Locale(localeStr);
                    ResourceBundleProvider.updateLocale((Locale)this.locale);
                    this.respage = ResourceBundleProvider.getPageMessagesBundle();
                    this.resword = ResourceBundleProvider.getWordsBundle();
                }
                StudyDAO studyDAO = new StudyDAO(this.dataSource);
                StudyBean studyBean = studyOid != null ? studyDAO.findByOid(studyOid) : (StudyBean)studyDAO.findByName(studyName);
                File fileDirectory = new File(SQLInitServlet.getField((String)"filePath") + "scheduled_data_import" + File.separator);
                if (!"".equals(directory)) {
                    fileDirectory = new File(SQLInitServlet.getField((String)"filePath") + "scheduled_data_import" + File.separator + directory + File.separator);
                }
                if (!fileDirectory.isDirectory()) {
                    fileDirectory.mkdirs();
                }
                if (!(destDirectory = new File(SQLInitServlet.getField((String)"filePath") + "Event_CRF_Data" + File.separator)).isDirectory()) {
                    destDirectory.mkdirs();
                }
                String[] files = fileDirectory.list();
                this.logger.debug("found " + files.length + " files under directory " + SQLInitServlet.getField((String)"filePath") + "scheduled_data_import" + File.separator + directory);
                File[] target = new File[files.length];
                File[] destination = new File[files.length];
                for (int i = 0; i < files.length; ++i) {
                    if (new File(fileDirectory + File.separator + files[i]).isDirectory()) continue;
                    File f = new File(fileDirectory + File.separator + files[i]);
                    if (f == null || f.getName() == null) {
                        this.logger.debug("found a null file");
                        continue;
                    }
                    if (f.getName().indexOf(".xml") < 0 && f.getName().indexOf(".XML") < 0) {
                        this.logger.debug("does not seem to be an xml file");
                        continue;
                    }
                    this.logger.debug("adding: " + f.getName());
                    target[i] = f;
                    destination[i] = new File(SQLInitServlet.getField((String)"filePath") + "Event_CRF_Data" + File.separator + files[i]);
                }
                if (target.length > 0 && destination.length > 0) {
                    this.cutAndPaste(target, destination);
                    destination = this.removeNullElements(destination);
                    ArrayList auditMessages = this.processData(destination, this.dataSource, this.respage, this.resword, ub, studyBean, destDirectory, triggerBean, ruleSetService);
                    this.auditEventDAO.createRowForExtractDataJobSuccess(triggerBean, (String)auditMessages.get(1));
                    try {
                        if (contactEmail != null && !"".equals(contactEmail)) {
                            this.mailSender.sendEmail(contactEmail, this.respage.getString("job_ran_for") + " " + triggerBean.getFullName(), this.generateMsg((String)auditMessages.get(0), contactEmail), Boolean.valueOf(true));
                            this.logger.debug("email body: " + (String)auditMessages.get(1));
                        }
                        break block15;
                    }
                    catch (OpenClinicaSystemException e) {
                        this.logger.error("Error in mailSender {}", (Object)e.getMessage(), (Object)e);
                    }
                    break block15;
                }
                this.logger.debug("no real files found");
                this.auditEventDAO.createRowForExtractDataJobSuccess(triggerBean, this.respage.getString("job_ran_but_no_files"));
            }
            catch (Exception e) {
                this.logger.error("found a fail exception: {}", (Object)e.getMessage(), (Object)e);
                this.auditEventDAO.createRowForExtractDataJobFailure(triggerBean, e.getMessage());
                try {
                    this.mailSender.sendEmail(contactEmail, this.respage.getString("job_failure_for") + " " + triggerBean.getFullName(), e.getMessage(), Boolean.valueOf(true));
                }
                catch (OpenClinicaSystemException ose) {
                    this.logger.error("Error in mailSender {}", (Object)ose.getMessage(), (Object)ose);
                }
            }
        }
    }

    private ImportCRFDataService getImportCRFDataService(DataSource dataSource) {
        this.dataService = this.dataService != null ? this.dataService : new ImportCRFDataService(dataSource, this.locale);
        return this.dataService;
    }

    private String generateMsg(String msg, String contactEmail) {
        String returnMe = this.respage.getString("html_email_header_1") + " " + contactEmail + this.respage.getString("your_job_ran_success_html") + "  " + this.respage.getString("please_review_the_data_html") + msg;
        return returnMe;
    }

    private ArrayList<String> processData(File[] dest, DataSource dataSource, ResourceBundle respage, ResourceBundle resword, UserAccountBean ub, StudyBean studyBean, File destDirectory, TriggerBean triggerBean, RuleSetServiceInterface ruleSetService) throws Exception {
        StringBuffer msg = new StringBuffer();
        StringBuffer auditMsg = new StringBuffer();
        Mapping myMap = new Mapping();
        String propertiesPath = CoreResources.PROPERTIES_DIR;
        new File(propertiesPath + File.separator + "ODM1-3-0.xsd");
        File xsdFile2 = new File(propertiesPath + File.separator + "ODM1-2-1.xsd");
        String ODM_MAPPING_DIR_path = CoreResources.ODM_MAPPING_DIR;
        myMap.loadMapping(ODM_MAPPING_DIR_path + File.separator + "cd_odm_mapping.xml");
        Unmarshaller um1 = new Unmarshaller(myMap);
        ODMContainer odmContainer = new ODMContainer();
        for (File f : dest) {
            boolean fail = false;
            String regex = "\\s+";
            String replacement = "_";
            String pattern = "yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "HHmmssSSS" + File.separator;
            SimpleDateFormat sdfDir = new SimpleDateFormat(pattern);
            String generalFileDir = sdfDir.format(new Date());
            File logDestDirectory = new File(destDirectory + File.separator + generalFileDir + f.getName().replaceAll(regex, replacement) + ".log.txt");
            if (!logDestDirectory.isDirectory()) {
                this.logger.debug("creating new dir: " + logDestDirectory.getAbsolutePath());
                logDestDirectory.mkdirs();
            }
            File newFile = new File(logDestDirectory, "log.txt");
            BufferedWriter out = new BufferedWriter(new FileWriter(newFile));
            if (f != null) {
                String firstLine = "<P>" + f.getName() + ": ";
                msg.append(firstLine);
                out.write(firstLine);
                auditMsg.append(firstLine);
            } else {
                msg.append("<P>" + respage.getString("unreadable_file") + ": ");
                out.write("<P>" + respage.getString("unreadable_file") + ": ");
                auditMsg.append("<P>" + respage.getString("unreadable_file") + ": ");
            }
            try {
                odmContainer = (ODMContainer)um1.unmarshal((Reader)new FileReader(f));
                this.logger.debug("Found crf data container for study oid: " + odmContainer.getCrfDataPostImportContainer().getStudyOID());
                this.logger.debug("found length of subject list: " + odmContainer.getCrfDataPostImportContainer().getSubjectData().size());
            }
            catch (Exception me1) {
                try {
                    this.schemaValidator.validateAgainstSchema(f, xsdFile2);
                    odmContainer = (ODMContainer)um1.unmarshal((Reader)new FileReader(f));
                }
                catch (Exception me2) {
                    MessageFormat mf = new MessageFormat("");
                    mf.applyPattern(respage.getString("your_xml_is_not_well_formed"));
                    Object[] arguments = new Object[]{me1.getMessage()};
                    msg.append(mf.format(arguments) + "<br/>");
                    auditMsg.append(mf.format(arguments) + "<br/>");
                    this.logger.error("found an error with XML: " + msg.toString());
                    continue;
                }
            }
            List errors = this.getImportCRFDataService(dataSource).validateStudyMetadata(odmContainer, studyBean.getId());
            if (errors != null) {
                if (errors.size() > 0) {
                    out.write("<P>Errors:<br/>");
                    for (String error : errors) {
                        out.write(error + "<br/>");
                    }
                    out.write("</P>");
                    MessageFormat mf = new MessageFormat("");
                    mf.applyPattern(respage.getString("your_xml_in_the_file"));
                    Object[] arguments = new Object[]{f.getName(), errors.size()};
                    auditMsg.append(mf.format(arguments) + "<br/>");
                    msg.append(mf.format(arguments) + "<br/>");
                    auditMsg.append("You can see the log file <a href='" + SQLInitServlet.getField((String)"sysURL.base") + "ViewLogMessage?n=" + generalFileDir + f.getName() + "&tn=" + triggerBean.getName() + "&gn=1'>here</a>.<br/>");
                    msg.append("You can see the log file <a href='" + SQLInitServlet.getField((String)"sysURL.base") + "ViewLogMessage?n=" + generalFileDir + f.getName() + "&tn=" + triggerBean.getName() + "&gn=1'>here</a>.<br/>");
                    out.close();
                    continue;
                }
                msg.append(respage.getString("passed_study_check") + "<br/>");
                msg.append(respage.getString("passed_oid_metadata_check") + "<br/>");
                auditMsg.append(respage.getString("passed_study_check") + "<br/>");
                auditMsg.append(respage.getString("passed_oid_metadata_check") + "<br/>");
            }
            ImportCRFInfoContainer importCrfInfo = new ImportCRFInfoContainer(odmContainer, dataSource);
            List eventCRFBeans = this.getImportCRFDataService(dataSource).fetchEventCRFBeans(odmContainer, ub);
            ArrayList<Integer> permittedEventCRFIds = new ArrayList<Integer>();
            Boolean eventCRFStatusesValid = this.getImportCRFDataService(dataSource).eventCRFStatusesValid(odmContainer, ub);
            ArrayList displayItemBeanWrappers = new ArrayList();
            HashMap totalValidationErrors = new HashMap();
            HashMap hardValidationErrors = new HashMap();
            HashMap importedCRFStatuses = this.getImportCRFDataService(dataSource).fetchEventCRFStatuses(odmContainer);
            if (eventCRFBeans == null) {
                fail = true;
                msg.append(respage.getString("no_event_status_matching"));
                out.write(respage.getString("no_event_status_matching"));
                out.close();
                continue;
            }
            if (!eventCRFBeans.isEmpty()) {
                this.logger.debug("found a list of eventCRFBeans: " + eventCRFBeans.toString());
                for (EventCRFBean eventCRFBean : eventCRFBeans) {
                    DataEntryStage dataEntryStage = eventCRFBean.getStage();
                    Status eventCRFStatus = eventCRFBean.getStatus();
                    this.logger.debug("Event CRF Bean: id " + eventCRFBean.getId() + ", data entry stage " + dataEntryStage.getName() + ", status " + eventCRFStatus.getName());
                    if (eventCRFStatus.equals((Term)Status.AVAILABLE) || dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) || dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) || dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
                        permittedEventCRFIds.add(new Integer(eventCRFBean.getId()));
                        continue;
                    }
                    MessageFormat mf = new MessageFormat("");
                    mf.applyPattern(respage.getString("your_listed_crf_in_the_file"));
                    Object[] arguments = new Object[]{f.getName()};
                    msg.append(mf.format(arguments) + "<br/>");
                    auditMsg.append(mf.format(arguments) + "<br/>");
                    out.write(mf.format(arguments) + "<br/>");
                    out.close();
                }
                if (eventCRFBeans.size() >= permittedEventCRFIds.size()) {
                    msg.append(respage.getString("passed_event_crf_status_check") + "<br/>");
                    auditMsg.append(respage.getString("passed_event_crf_status_check") + "<br/>");
                } else {
                    fail = true;
                    msg.append(respage.getString("the_event_crf_not_correct_status") + "<br/>");
                    auditMsg.append(respage.getString("the_event_crf_not_correct_status") + "<br/>");
                }
                MockHttpServletRequest request = new MockHttpServletRequest();
                request.addPreferredLocale(this.locale);
                try {
                    List tempDisplayItemBeanWrappers = new ArrayList();
                    tempDisplayItemBeanWrappers = this.getImportCRFDataService(dataSource).lookupValidationErrors((HttpServletRequest)request, odmContainer, ub, totalValidationErrors, hardValidationErrors, permittedEventCRFIds);
                    this.logger.debug("size of total validation errors: " + totalValidationErrors.size());
                    displayItemBeanWrappers.addAll(tempDisplayItemBeanWrappers);
                }
                catch (NullPointerException npe1) {
                    fail = true;
                    this.logger.debug("threw a NPE after calling lookup validation errors", (Throwable)npe1);
                    msg.append(respage.getString("an_error_was_thrown_while_validation_errors") + "<br/>");
                    auditMsg.append(respage.getString("an_error_was_thrown_while_validation_errors") + "<br/>");
                    out.write(respage.getString("an_error_was_thrown_while_validation_errors") + "<br/>");
                    this.logger.debug("=== threw the null pointer, import ===");
                }
                catch (OpenClinicaException oce1) {
                    fail = true;
                    this.logger.error("threw an OCE after calling lookup validation errors " + oce1.getOpenClinicaMessage());
                    msg.append(oce1.getOpenClinicaMessage() + "<br/>");
                    out.write(oce1.getOpenClinicaMessage() + "<br/>");
                }
            } else {
                if (!eventCRFStatusesValid.booleanValue()) {
                    fail = true;
                    msg.append(respage.getString("the_event_crf_not_correct_status"));
                    out.write(respage.getString("the_event_crf_not_correct_status"));
                    out.close();
                    continue;
                }
                msg.append(respage.getString("no_event_crfs_matching_the_xml_metadata") + "<br/>");
                out.write(respage.getString("no_event_crfs_matching_the_xml_metadata") + "<br/>");
                out.close();
                continue;
            }
            ArrayList subjectData = odmContainer.getCrfDataPostImportContainer().getSubjectData();
            if (!hardValidationErrors.isEmpty()) {
                String messageHardVals = this.triggerService.generateHardValidationErrorMessage(subjectData, hardValidationErrors, false);
                out.write(messageHardVals);
                msg.append(respage.getString("file_generated_hard_validation_error"));
                fail = true;
            } else {
                if (!totalValidationErrors.isEmpty()) {
                    String totalValErrors = this.triggerService.generateHardValidationErrorMessage(subjectData, totalValidationErrors, false);
                    out.write(totalValErrors);
                }
                String validMsgs = this.triggerService.generateValidMessage(subjectData, totalValidationErrors);
                out.write(validMsgs);
            }
            out.close();
            if (fail) {
                MessageFormat mf = new MessageFormat("");
                mf.applyPattern(respage.getString("problems_encountered_with_file"));
                Object[] arguments = new Object[]{f.getName(), msg.toString()};
                msg = new StringBuffer(mf.format(arguments) + "<br/>");
                out.close();
                auditMsg.append("You can see the log file <a href='" + SQLInitServlet.getField((String)"sysURL.base") + "ViewLogMessage?n=" + generalFileDir + f.getName() + "&tn=" + triggerBean.getName() + "&gn=1'>here</a>.<br/>");
                msg.append("You can see the log file <a href='" + SQLInitServlet.getField((String)"sysURL.base") + "ViewLogMessage?n=" + generalFileDir + f.getName() + "&tn=" + triggerBean.getName() + "&gn=1'>here</a>.<br/>");
                continue;
            }
            msg.append(respage.getString("passing_crf_edit_checks") + "<br/>");
            auditMsg.append(respage.getString("passing_crf_edit_checks") + "<br/>");
            this.logger.debug("found total validation errors: " + totalValidationErrors.size());
            SummaryStatsBean ssBean = this.getImportCRFDataService(dataSource).generateSummaryStatsBean(odmContainer, displayItemBeanWrappers, importCrfInfo);
            msg.append(this.triggerService.generateSummaryStatsMessage(ssBean, respage) + "<br/>");
            msg.append(this.triggerService.generateSkippedCRFMessage(importCrfInfo, resword) + "<br/>");
            List containers = this.ruleRunSetup(dataSource, studyBean, ub, ruleSetService, odmContainer);
            CrfBusinessLogicHelper crfBusinessLogicHelper = new CrfBusinessLogicHelper(dataSource);
            for (DisplayItemBeanWrapper wrapper : displayItemBeanWrappers) {
                boolean resetSDV = false;
                int eventCrfBeanId = -1;
                EventCRFBean eventCrfBean = new EventCRFBean();
                this.logger.debug("right before we check to make sure it is savable: " + wrapper.isSavable());
                if (!wrapper.isSavable()) continue;
                ArrayList<Integer> eventCrfInts = new ArrayList<Integer>();
                this.logger.debug("wrapper problems found : " + wrapper.getValidationErrors().toString());
                this.itemDataDao.setFormatDates(false);
                for (DisplayItemBean displayItemBean : wrapper.getDisplayItemBeans()) {
                    eventCrfBeanId = displayItemBean.getData().getEventCRFId();
                    eventCrfBean = (EventCRFBean)this.eventCrfDao.findByPK(eventCrfBeanId);
                    this.logger.debug("found value here: " + displayItemBean.getData().getValue());
                    this.logger.debug("found status here: " + eventCrfBean.getStatus().getName());
                    ItemDataBean itemDataBean = new ItemDataBean();
                    itemDataBean = this.itemDataDao.findByItemIdAndEventCRFIdAndOrdinal(displayItemBean.getItem().getId(), eventCrfBean.getId(), displayItemBean.getData().getOrdinal());
                    if (wrapper.isOverwrite() && itemDataBean.getStatus() != null) {
                        this.logger.debug("just tried to find item data bean on item name " + displayItemBean.getItem().getName());
                        if (!itemDataBean.getValue().equals(displayItemBean.getData().getValue())) {
                            resetSDV = true;
                        }
                        itemDataBean.setUpdatedDate(new Date());
                        itemDataBean.setUpdater(ub);
                        itemDataBean.setValue(displayItemBean.getData().getValue());
                        this.itemDataDao.update((EntityBean)itemDataBean);
                        this.logger.debug("updated: " + itemDataBean.getItemId());
                        displayItemBean.getData().setId(itemDataBean.getId());
                    } else {
                        resetSDV = true;
                        this.itemDataDao.create((EntityBean)displayItemBean.getData());
                        this.logger.debug("created: " + displayItemBean.getData().getItemId());
                        ItemDataBean itemDataBean2 = this.itemDataDao.findByItemIdAndEventCRFIdAndOrdinal(displayItemBean.getItem().getId(), eventCrfBean.getId(), displayItemBean.getData().getOrdinal());
                        this.logger.debug("found: id " + itemDataBean2.getId() + " name " + itemDataBean2.getName());
                        displayItemBean.getData().setId(itemDataBean2.getId());
                    }
                    ItemDAO idao = new ItemDAO(dataSource);
                    ItemBean ibean = (ItemBean)idao.findByPK(displayItemBean.getData().getItemId());
                    this.logger.debug("*** checking for validation errors: " + ibean.getName());
                    String itemOid = displayItemBean.getItem().getOid() + "_" + wrapper.getStudyEventRepeatKey() + "_" + displayItemBean.getData().getOrdinal() + "_" + wrapper.getStudySubjectOid();
                    if (wrapper.getValidationErrors().containsKey(itemOid)) {
                        ArrayList messageList = (ArrayList)wrapper.getValidationErrors().get(itemOid);
                        for (int iter = 0; iter < messageList.size(); ++iter) {
                            String message = (String)messageList.get(iter);
                            DiscrepancyNoteBean parentDn = ImportSpringJob.createDiscrepancyNote((ItemBean)ibean, (String)message, (EventCRFBean)eventCrfBean, (DisplayItemBean)displayItemBean, null, (UserAccountBean)ub, (DataSource)dataSource, (StudyBean)studyBean);
                            ImportSpringJob.createDiscrepancyNote((ItemBean)ibean, (String)message, (EventCRFBean)eventCrfBean, (DisplayItemBean)displayItemBean, (Integer)parentDn.getId(), (UserAccountBean)ub, (DataSource)dataSource, (StudyBean)studyBean);
                            this.logger.debug("*** created disc note with message: " + message);
                        }
                    }
                    if (eventCrfInts.contains(new Integer(eventCrfBean.getId()))) continue;
                    String eventCRFStatus = (String)importedCRFStatuses.get(new Integer(eventCrfBean.getId()));
                    if (eventCRFStatus != null && eventCRFStatus.equals(DataEntryStage.INITIAL_DATA_ENTRY.getName()) && eventCrfBean.getStatus().isAvailable()) {
                        crfBusinessLogicHelper.markCRFStarted(eventCrfBean, ub);
                    } else {
                        crfBusinessLogicHelper.markCRFComplete(eventCrfBean, ub);
                    }
                    this.logger.debug("*** just updated event crf bean: " + eventCrfBean.getId());
                    eventCrfInts.add(new Integer(eventCrfBean.getId()));
                }
                this.itemDataDao.setFormatDates(true);
                if (eventCrfBean == null || !resetSDV) continue;
                this.eventCrfDao.setSDVStatus(false, ub.getId(), eventCrfBean.getId());
            }
            msg.append(respage.getString("data_has_been_successfully_import") + "<br/>");
            auditMsg.append(respage.getString("data_has_been_successfully_import") + "<br/>");
            String linkMessage = respage.getString("you_can_review_the_data") + SQLInitServlet.getField((String)"sysURL.base") + respage.getString("you_can_review_the_data_2") + SQLInitServlet.getField((String)"sysURL.base") + respage.getString("you_can_review_the_data_3") + generalFileDir + f.getName() + "&tn=" + triggerBean.getFullName() + "&gn=1" + respage.getString("you_can_review_the_data_4") + "<br/>";
            msg.append(linkMessage);
            auditMsg.append(linkMessage);
            auditMsg.append(this.runRules(studyBean, ub, containers, ruleSetService, ExecutionMode.SAVE));
        }
        ArrayList<String> retList = new ArrayList<String>();
        retList.add(msg.toString());
        retList.add(auditMsg.toString());
        return retList;
    }

    public static DiscrepancyNoteBean createDiscrepancyNote(ItemBean itemBean, String message, EventCRFBean eventCrfBean, DisplayItemBean displayItemBean, Integer parentId, UserAccountBean uab, DataSource ds, StudyBean study) {
        DiscrepancyNoteBean note = new DiscrepancyNoteBean();
        StudySubjectDAO ssdao = new StudySubjectDAO(ds);
        note.setDescription(message);
        note.setDetailedNotes("Failed Validation Check");
        note.setOwner(uab);
        note.setCreatedDate(new Date());
        note.setResolutionStatusId(ResolutionStatus.OPEN.getId());
        note.setDiscrepancyNoteTypeId(DiscrepancyNoteType.FAILEDVAL.getId());
        if (parentId != null) {
            note.setParentDnId(parentId.intValue());
        }
        note.setField(itemBean.getName());
        note.setStudyId(study.getId());
        note.setEntityName(itemBean.getName());
        note.setEntityType("itemData");
        note.setEntityValue(displayItemBean.getData().getValue());
        note.setEventName(eventCrfBean.getName());
        note.setEventStart(eventCrfBean.getCreatedDate());
        note.setCrfName(displayItemBean.getEventDefinitionCRF().getCrfName());
        StudySubjectBean ss = (StudySubjectBean)ssdao.findByPK(eventCrfBean.getStudySubjectId());
        note.setSubjectName(ss.getName());
        note.setEntityId(displayItemBean.getData().getId());
        note.setColumn("value");
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(ds);
        note = (DiscrepancyNoteBean)dndao.create((EntityBean)note);
        dndao.createMapping(note);
        return note;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutAndPaste(File[] tar, File[] dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        int fle_count = -1;
        for (File cur_file : tar) {
            if (cur_file == null) {
                ++fle_count;
                continue;
            }
            try {
                in = new FileInputStream(cur_file);
                out = new FileOutputStream(dest[++fle_count]);
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                ((InputStream)in).close();
                out.close();
                cur_file.delete();
            }
            catch (NullPointerException npe) {
                this.logger.debug("found Npe: " + npe.getMessage());
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    @Transactional
    private List<ImportDataRuleRunnerContainer> ruleRunSetup(DataSource dataSource, StudyBean studyBean, UserAccountBean userBean, RuleSetServiceInterface ruleSetService, ODMContainer odmContainer) {
        ArrayList<ImportDataRuleRunnerContainer> containers = new ArrayList<ImportDataRuleRunnerContainer>();
        if (odmContainer != null) {
            ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
            if (ruleSetService.getCountByStudy(studyBean) > 0) {
                for (SubjectDataBean subjectDataBean : subjectDataBeans) {
                    ImportDataRuleRunnerContainer container = new ImportDataRuleRunnerContainer();
                    container.initRuleSetsAndTargets(dataSource, studyBean, subjectDataBean, ruleSetService);
                    if (!container.getShouldRunRules().booleanValue()) continue;
                    containers.add(container);
                }
                if (containers != null && !containers.isEmpty()) {
                    ruleSetService.runRulesInImportData(containers, studyBean, userBean, ExecutionMode.DRY_RUN);
                }
            }
        }
        return containers;
    }

    @Transactional
    private StringBuffer runRules(StudyBean studyBean, UserAccountBean userBean, List<ImportDataRuleRunnerContainer> containers, RuleSetServiceInterface ruleSetService, ExecutionMode executionMode) {
        StringBuffer messages = new StringBuffer();
        if (containers != null && !containers.isEmpty()) {
            HashMap summary = ruleSetService.runRulesInImportData(containers, studyBean, userBean, executionMode);
            messages = this.extractRuleActionWarnings(summary);
        }
        return messages;
    }

    private StringBuffer extractRuleActionWarnings(HashMap<String, ArrayList<String>> summaryMap) {
        StringBuffer messages = new StringBuffer();
        if (summaryMap != null && !summaryMap.isEmpty()) {
            for (String key : summaryMap.keySet()) {
                messages.append(key);
                messages.append(" : ");
                messages.append(StringUtils.join((Collection)summaryMap.get(key), (String)", "));
            }
        }
        return messages;
    }

    private File[] removeNullElements(File[] source) {
        ArrayList<File> list = new ArrayList<File>();
        for (File f : source) {
            if (f == null) continue;
            list.add(f);
        }
        return list.toArray(new File[list.size()]);
    }
}

