/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.pform;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.controller.openrosa.OpenRosaSubmissionController;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.CrfVersionMediaDao;
import org.akaza.openclinica.dao.hibernate.RuleActionPropertyDao;
import org.akaza.openclinica.dao.hibernate.SCDItemMetadataDao;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.datamap.CrfVersionMedia;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.web.pform.OpenRosaServices;
import org.akaza.openclinica.web.pform.OpenRosaXmlGenerator;
import org.akaza.openclinica.web.pform.PFormCache;
import org.akaza.openclinica.web.pform.formlist.XForm;
import org.akaza.openclinica.web.pform.formlist.XFormList;
import org.akaza.openclinica.web.pform.manifest.Manifest;
import org.akaza.openclinica.web.pform.manifest.MediaFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestHeader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

@Path(value="/openrosa")
@Component
public class OpenRosaServices {
    public static final String INPUT_USER_SOURCE = "userSource";
    public static final String INPUT_FIRST_NAME = "Participant";
    public static final String INPUT_LAST_NAME = "User";
    public static final String INPUT_EMAIL = "email";
    public static final String INPUT_INSTITUTION = "PFORM";
    public static final String INPUT_STUDY = "activeStudy";
    public static final String INPUT_ROLE = "role";
    public static final String INPUT_TYPE = "type";
    public static final String INPUT_DISPLAY_PWD = "displayPwd";
    public static final String INPUT_RUN_WEBSERVICES = "runWebServices";
    public static final String USER_ACCOUNT_NOTIFICATION = "notifyPassword";
    public static final String FORM_CONTEXT = "ecid";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenRosaServices.class);
    private DataSource dataSource;
    private CoreResources coreResources;
    private OpenRosaSubmissionController openRosaSubmissionController;
    private RuleActionPropertyDao ruleActionPropertyDao;
    private SCDItemMetadataDao scdItemMetadataDao;
    ParticipantPortalRegistrar participantPortalRegistrar;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    StudyDAO sdao;
    StudySubjectDAO studySubjectDao;

    @GET
    @Path(value="/{studyOID}/formList")
    @Produces(value={"text/xml"})
    public String getFormList(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="studyOID") String studyOID, @QueryParam(value="formID") String crfOID, @RequestHeader(value="Authorization") String authorization, @Context ServletContext context) throws Exception {
        if (!this.mayProceedPreview(studyOID)) {
            return null;
        }
        StudyDAO sdao = new StudyDAO(this.getDataSource());
        StudyBean study = sdao.findByOid(studyOID);
        CRFDAO cdao = new CRFDAO(this.getDataSource());
        Collection crfs = cdao.findAll();
        CRFVersionDAO cVersionDao = new CRFVersionDAO(this.getDataSource());
        Collection crfVersions = cVersionDao.findAll();
        CrfVersionMediaDao mediaDao = (CrfVersionMediaDao)SpringServletAccess.getApplicationContext((ServletContext)context).getBean("crfVersionMediaDao");
        try {
            XFormList formList = new XFormList();
            for (CRFBean crf : crfs) {
                for (CRFVersionBean version : crfVersions) {
                    if (version.getCrfId() != crf.getId()) continue;
                    XForm form = new XForm(crf, version);
                    if (version.getXformName() != null) {
                        form.setHash(DigestUtils.md5Hex((String)version.getXform()));
                    } else {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(new Date());
                        form.setHash(DigestUtils.md5Hex((String)String.valueOf(cal.getTimeInMillis())));
                    }
                    String urlBase = this.getCoreResources().getDataInfo().getProperty("sysURL").split("/MainMenu")[0];
                    form.setDownloadURL(urlBase + "/rest2/openrosa/" + studyOID + "/formXml?formId=" + version.getOid());
                    ArrayList mediaList = mediaDao.findByCrfVersionId(version.getId());
                    if (mediaList != null && mediaList.size() > 0) {
                        form.setManifestURL(urlBase + "/rest2/openrosa/" + studyOID + "/manifest?formId=" + version.getOid());
                    }
                    formList.add(form);
                }
            }
            XMLContext xmlContext = new XMLContext();
            Mapping mapping = xmlContext.createMapping();
            mapping.loadMapping(this.getCoreResources().getURL("openRosaFormListMapping.xml"));
            xmlContext.addMapping(mapping);
            Marshaller marshaller = xmlContext.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.setWriter((Writer)writer);
            marshaller.marshal((Object)formList);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            Date currentDate = new Date();
            cal.setTime(currentDate);
            SimpleDateFormat format = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss zz");
            format.setCalendar(cal);
            response.setHeader("Content-Type", "text/xml; charset=UTF-8");
            response.setHeader("Date", format.format(currentDate));
            response.setHeader("X-OpenRosa-Version", "1.0");
            return writer.toString();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            return "<Error>" + e.getMessage() + "</Error>";
        }
    }

    @GET
    @Path(value="/{studyOID}/manifest")
    @Produces(value={"text/xml"})
    public String getManifest(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="studyOID") String studyOID, @QueryParam(value="formId") String crfOID, @RequestHeader(value="Authorization") String authorization, @Context ServletContext context) throws Exception {
        if (!this.mayProceedPreview(studyOID)) {
            return null;
        }
        CRFVersionDAO cVersionDao = new CRFVersionDAO(this.getDataSource());
        CrfVersionMediaDao mediaDao = (CrfVersionMediaDao)SpringServletAccess.getApplicationContext((ServletContext)context).getBean("crfVersionMediaDao");
        CRFVersionBean crfVersion = cVersionDao.findByOid(crfOID);
        ArrayList mediaFiles = new ArrayList();
        Manifest manifest = new Manifest();
        ArrayList mediaList = mediaDao.findByCrfVersionId(crfVersion.getId());
        if (mediaList != null && mediaList.size() > 0) {
            for (CrfVersionMedia media : mediaList) {
                String urlBase = this.getCoreResources().getDataInfo().getProperty("sysURL").split("/MainMenu")[0];
                MediaFile mediaFile = new MediaFile();
                mediaFile.setFilename(media.getName());
                File image = new File(media.getPath() + media.getName());
                mediaFile.setHash(DigestUtils.md5Hex((String)media.getName()) + Double.toString(image.length()));
                mediaFile.setDownloadUrl(urlBase + "/rest2/openrosa/" + studyOID + "/downloadMedia?crfVersionMediaId=" + media.getCrfVersionMediaId());
                manifest.add(mediaFile);
            }
        }
        try {
            XMLContext xmlContext = new XMLContext();
            Mapping mapping = xmlContext.createMapping();
            mapping.loadMapping(this.getCoreResources().getURL("openRosaManifestMapping.xml"));
            xmlContext.addMapping(mapping);
            Marshaller marshaller = xmlContext.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.setWriter((Writer)writer);
            marshaller.marshal((Object)manifest);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            Date currentDate = new Date();
            cal.setTime(currentDate);
            SimpleDateFormat format = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss zz");
            format.setCalendar(cal);
            response.setHeader("Content-Type", "text/xml; charset=UTF-8");
            response.setHeader("Date", format.format(currentDate));
            response.setHeader("X-OpenRosa-Version", "1.0");
            return writer.toString();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            return "<Error>" + e.getMessage() + "</Error>";
        }
    }

    @GET
    @Path(value="/{studyOID}/formXml")
    @Produces(value={"application/xml"})
    public String getFormXml(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="studyOID") String studyOID, @QueryParam(value="formID") String crfOID, @RequestHeader(value="Authorization") String authorization) throws Exception {
        if (!this.mayProceedPreview(studyOID)) {
            return null;
        }
        String xform = null;
        String formId = request.getParameter("formId");
        if (formId == null) {
            return "<error>formID is null :(</error>";
        }
        try {
            CRFVersionDAO versionDAO = new CRFVersionDAO(this.dataSource);
            CRFVersionBean crfVersion = versionDAO.findByOid(formId);
            if (crfVersion.getXform() != null && !crfVersion.getXform().equals("")) {
                xform = this.updateRepeatGroupsWithOrdinal(crfVersion.getXform());
            } else {
                OpenRosaXmlGenerator generator = new OpenRosaXmlGenerator(this.coreResources, this.dataSource, this.ruleActionPropertyDao);
                xform = generator.buildForm(formId);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(ExceptionUtils.getStackTrace((Throwable)e));
            LOGGER.error(e.getMessage());
            LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            return "<error>" + e.getMessage() + "</error>";
        }
        response.setHeader("Content-Type", "text/xml; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + crfOID + ".xml\";");
        response.setContentType("text/xml; charset=utf-8");
        return xform;
    }

    @GET
    @Path(value="/{studyOID}/downloadMedia")
    public Response getMediaFile(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="studyOID") String studyOID, @QueryParam(value="crfVersionMediaId") String crfVersionMediaId, @RequestHeader(value="Authorization") String authorization, @Context ServletContext context) throws Exception {
        if (!this.mayProceedPreview(studyOID)) {
            return null;
        }
        CrfVersionMediaDao mediaDao = (CrfVersionMediaDao)SpringServletAccess.getApplicationContext((ServletContext)context).getBean("crfVersionMediaDao");
        CrfVersionMedia media = (CrfVersionMedia)mediaDao.findById(Integer.valueOf(crfVersionMediaId));
        File image = new File(media.getPath() + media.getName());
        FileInputStream fis = new FileInputStream(image);
        MediaStreamingOutput stream = new MediaStreamingOutput(this, (InputStream)fis);
        Response.ResponseBuilder builder = Response.ok((Object)stream);
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(media.getPath() + media.getName());
        if (type != null && !type.isEmpty()) {
            builder = builder.header("Content-Type", (Object)type);
        }
        return builder.build();
    }

    @POST
    @Path(value="/{studyOID}/submission")
    @Produces(value={"application/xml"})
    public Response doSubmission(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @PathParam(value="studyOID") String studyOID, @QueryParam(value="ecid") String context) {
        Response.ResponseBuilder builder = Response.noContent();
        ResponseEntity responseEntity = this.openRosaSubmissionController.doSubmission(request, response, studyOID, context);
        if (responseEntity == null) {
            LOGGER.debug("Null response from OpenRosaSubmissionController.");
            return builder.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        if (responseEntity.getStatusCode().equals((Object)HttpStatus.CREATED)) {
            LOGGER.debug("Successful OpenRosa submission");
            builder.entity((Object)"<OpenRosaResponse xmlns=\"http://openrosa.org/http/response\"><message>success</message></OpenRosaResponse>");
            return builder.status(Response.Status.CREATED).build();
        }
        if (responseEntity.getStatusCode().equals((Object)HttpStatus.NOT_ACCEPTABLE)) {
            LOGGER.debug("Failed OpenRosa submission");
            return builder.status(Response.Status.NOT_ACCEPTABLE).build();
        }
        LOGGER.debug("Failed OpenRosa submission with unhandled error");
        return builder.status(Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @HEAD
    @Path(value="/{studyOID}/submission")
    @Produces(value={"application/xml"})
    public Response doSubmissionHead(@PathParam(value="studyOID") String studyOID) {
        Response.ResponseBuilder builder = Response.noContent();
        String maxSubmissionSize = CoreResources.getField((String)"pformMaxSubmissionSize");
        int maxSubmissionSizeInt = -1;
        try {
            maxSubmissionSizeInt = Integer.valueOf(maxSubmissionSize);
        }
        catch (Exception e) {
            this.logger.error("Unable to parse pformMaxSubmissionSize as an integer.");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date currentDate = new Date();
        cal.setTime(currentDate);
        SimpleDateFormat format = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss zz");
        format.setCalendar(cal);
        builder = builder.header("Date", (Object)format.format(currentDate));
        builder = builder.header("X-OpenRosa-Version", (Object)"1.0");
        if (maxSubmissionSizeInt < 1) {
            this.logger.error("pformMaxSubmissionSize does not contain an integer value greater than 0.");
            return builder.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        builder = builder.header("X-OpenRosa-Accept-Content-Length", (Object)maxSubmissionSizeInt);
        return builder.status(Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/{studyOID}/getSchedule")
    @Produces(value={"application/xml"})
    public String getSchedule(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext context, @PathParam(value="studyOID") String studyOID, @RequestHeader(value="Authorization") String authorization) throws Exception {
        StudySubjectDAO ssdao = new StudySubjectDAO(this.dataSource);
        String ssoid = request.getParameter("studySubjectOID");
        StudySubjectBean ssBean = ssdao.findByOid(ssoid);
        if (!this.mayProceedSubmission(studyOID, ssBean)) {
            return null;
        }
        HashMap urlCache = (HashMap)context.getAttribute("pformURLCache");
        context.getAttribute("subjectContextCache");
        if (ssoid == null) {
            return "<error>studySubjectOID is null :(</error>";
        }
        try {
            StudyEventDAO eventDAO = new StudyEventDAO(this.getDataSource());
            StudyEventBean nextEvent = (StudyEventBean)eventDAO.getNextScheduledEvent(ssoid);
            CRFVersionDAO versionDAO = new CRFVersionDAO(this.getDataSource());
            ArrayList crfs = versionDAO.findDefCRFVersionsByStudyEvent(nextEvent.getStudyEventDefinitionId());
            PFormCache cache = PFormCache.getInstance((ServletContext)context);
            for (CRFVersionBean crfVersion : crfs) {
                String enketoURL = cache.getPFormURL(studyOID, crfVersion.getOid());
                String string = cache.putSubjectContext(ssoid, String.valueOf(nextEvent.getStudyEventDefinitionId()), String.valueOf(nextEvent.getSampleOrdinal()), crfVersion.getOid());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
            LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            return "<error>" + e.getMessage() + "</error>";
        }
        response.setHeader("Content-Type", "text/xml; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"schedule.xml\";");
        response.setContentType("text/xml; charset=utf-8");
        return "<result>success</result>";
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public CoreResources getCoreResources() {
        return this.coreResources;
    }

    public void setCoreResources(CoreResources coreResources) {
        this.coreResources = coreResources;
    }

    public OpenRosaSubmissionController getOpenRosaSubmissionController() {
        return this.openRosaSubmissionController;
    }

    public void setOpenRosaSubmissionController(OpenRosaSubmissionController openRosaSubmissionController) {
        this.openRosaSubmissionController = openRosaSubmissionController;
    }

    public RuleActionPropertyDao getRuleActionPropertyDao() {
        return this.ruleActionPropertyDao;
    }

    public void setRuleActionPropertyDao(RuleActionPropertyDao ruleActionPropertyDao) {
        this.ruleActionPropertyDao = ruleActionPropertyDao;
    }

    public SCDItemMetadataDao getScdItemMetadataDao() {
        return this.scdItemMetadataDao;
    }

    public void setScdItemMetadataDao(SCDItemMetadataDao scdItemMetadataDao) {
        this.scdItemMetadataDao = scdItemMetadataDao;
    }

    private StudyBean getStudy(String oid) {
        this.sdao = new StudyDAO(this.dataSource);
        StudyBean studyBean = this.sdao.findByOid(oid);
        return studyBean;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = (StudyBean)this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private String updateRepeatGroupsWithOrdinal(String xform) throws Exception {
        NamedNodeMap attribs = this.fetchXformAttributes(xform);
        ByteArrayInputStream is = new ByteArrayInputStream(xform.getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        Document doc = factory.newDocumentBuilder().parse(is);
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = null;
        expr = xpath.compile("/html/body/group/repeat");
        NodeList repeatNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        for (int k = 0; k < repeatNodes.getLength(); ++k) {
            Element groupElement = (Element)repeatNodes.item(k).getParentNode();
            String groupRef = groupElement.getAttribute("ref");
            expr = xpath.compile("/html/head/model/instance[1]" + groupRef);
            Element group = (Element)expr.evaluate(doc, XPathConstants.NODE);
            Element ordinal = doc.createElement("OC.REPEAT_ORDINAL");
            group.appendChild(ordinal);
        }
        TransformerFactory transformFactory = TransformerFactory.newInstance();
        Transformer transformer = transformFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("method", "xml");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        String modifiedXform = writer.toString();
        modifiedXform = this.applyXformAttributes(modifiedXform, attribs);
        System.out.println("Finalized xform source: " + modifiedXform);
        return modifiedXform;
    }

    private String applyXformAttributes(String xform, NamedNodeMap attribs) throws Exception {
        String defaultNamespace = null;
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attrib = (Attr)attribs.item(i);
            if (!attrib.getName().equals("xmlns")) continue;
            defaultNamespace = attrib.getValue();
        }
        String[] xformArray = xform.split("html", 2);
        String modifiedXform = xformArray[0] + "html xmlns=\"" + defaultNamespace + "\" " + xformArray[1];
        return modifiedXform;
    }

    private NamedNodeMap fetchXformAttributes(String xform) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xform.getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(is);
        Element html = doc.getDocumentElement();
        NamedNodeMap attribs = html.getAttributes();
        return attribs;
    }

    private boolean mayProceedSubmission(String studyOid, StudySubjectBean ssBean) throws Exception {
        boolean accessPermission = false;
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(studyOid).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus + "  studySubjectStatus: " + ssBean.getStatus().getName());
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE") && ssBean.getStatus() == Status.AVAILABLE) {
            accessPermission = true;
        }
        return accessPermission;
    }

    private boolean mayProceedPreview(String studyOid) throws Exception {
        boolean accessPermission = false;
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(studyOid).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus);
        if (participateStatus.equalsIgnoreCase("enabled") && (studyStatus.equalsIgnoreCase("available") || studyStatus.equalsIgnoreCase("pending") || studyStatus.equalsIgnoreCase("frozen") || studyStatus.equalsIgnoreCase("locked")) && (pManageStatus.equalsIgnoreCase("ACTIVE") || pManageStatus.equalsIgnoreCase("PENDING") || pManageStatus.equalsIgnoreCase("INACTIVE"))) {
            accessPermission = true;
        }
        return accessPermission;
    }
}

