/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.table.scheduledjobs;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.dao.ScheduledJobSort;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.web.table.scheduledjobs.ScheduledJobTableFactory;
import org.akaza.openclinica.web.table.scheduledjobs.ScheduledJobs;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.View;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.component.HtmlTable;
import org.jmesa.web.WebContext;

public class ScheduledJobTableFactory
extends AbstractTableFactory {
    private ResourceBundle resword;
    private int studyId;
    private String contextPath;

    protected String getTableName() {
        return "scheduledJobs";
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade) {
        tableFacade.setView((View)new ScheduledJobView(this, this.getLocale()));
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"datasetId", "fireTime", "exportFileName", "jobStatus", "action"});
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        Row row = tableFacade.getTable().getRow();
        String[] allTitles = new String[]{"DataSet Name", "Fire Time", "Export File", "Job Status", "Actions"};
        SDVUtil sdvUtil = new SDVUtil();
        sdvUtil.setTitles(allTitles, (HtmlTable)tableFacade.getTable());
        sdvUtil.setHtmlCellEditors(tableFacade, new String[]{"action"}, false);
        this.configureColumn(row.getColumn("action"), "Actions", (CellEditor)sdvUtil.getCellEditorNoEscapes(), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public TableFacade createTable(HttpServletRequest request, HttpServletResponse response) {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        TableFacade tableFacade = this.getTableFacadeImpl(request, response);
        tableFacade.setStateAttr("restore");
        int maxJobs = (Integer)request.getAttribute("totalJobs");
        tableFacade.setTotalRows(maxJobs);
        Limit limit = tableFacade.getLimit();
        List jobs = (List)request.getAttribute("jobs");
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        tableFacade.setItems((Collection)jobs);
        this.configureTableFacade(response, tableFacade);
        if (!tableFacade.getLimit().isExported()) {
            this.configureColumns(tableFacade, this.locale);
            tableFacade.setMaxRowsIncrements(this.getMaxRowIncrements());
            this.configureTableFacadePostColumnConfiguration(tableFacade);
            this.configureTableFacadeCustomView(tableFacade);
            this.configureUnexportedTable(tableFacade, this.locale);
        } else {
            this.configureExportColumns(tableFacade, this.locale);
        }
        return tableFacade;
    }

    public void setDataAndLimitVariables(TableFacade tableFacade, List<ScheduledJobs> jobs) {
        Limit limit = tableFacade.getLimit();
        WebContext context = tableFacade.getWebContext();
        if (context != null) {
            this.studyId = Integer.parseInt(context.getParameter("studyId"));
            this.contextPath = context.getContextPath();
        }
        ScheduledJobSort scheduledJobSort = this.getScheduledJobSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        Collection items = this.getFilteredItems(jobs, scheduledJobSort, rowStart, rowEnd);
    }

    private Collection<ScheduledJobs> getFilteredItems(List<ScheduledJobs> jobs, ScheduledJobSort scheduledJobSort, int rowStart, int rowEnd) {
        return null;
    }

    protected ScheduledJobSort getScheduledJobSort(Limit limit) {
        ScheduledJobSort scheduledJobSort = new ScheduledJobSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            scheduledJobSort.addSort(property, order);
        }
        return scheduledJobSort;
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
    }
}

