/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.admin.NewCRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.rule.FileUploadHelper;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.admin.SpreadSheetTableClassic;
import org.akaza.openclinica.control.admin.SpreadSheetTableRepeating;
import org.akaza.openclinica.control.admin.SpreadsheetPreview;
import org.akaza.openclinica.control.admin.SpreadsheetPreviewNw;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.MeasurementUnitDao;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.exception.CRFReadingException;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class CreateCRFVersionServlet
extends SecureController {
    private static final long serialVersionUID = 2414948228788037586L;
    Locale locale;
    FileUploadHelper uploadHelper = new FileUploadHelper();

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processRequest() throws Exception {
        this.resetPanel();
        this.panel.setStudyInfoShown(true);
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO vdao = new CRFVersionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.session.setAttribute("module", (Object)module);
        this.request.setAttribute("xformEnabled", (Object)CoreResources.getField((String)"xform.enabled"));
        String action = this.request.getParameter("action");
        CRFVersionBean version = (CRFVersionBean)this.session.getAttribute("version");
        if (action == null || action.trim().isEmpty()) {
            logger.debug("action is blank");
            this.request.setAttribute("version", (Object)version);
            this.forwardPage(Page.CREATE_CRF_VERSION);
            return;
        }
        if ("confirm".equalsIgnoreCase(action)) {
            String dir = SQLInitServlet.getField((String)"filePath");
            if (!new File(dir).exists()) {
                logger.debug("The filePath in datainfo.properties is invalid " + dir);
                this.addPageMessage(resword.getString("the_filepath_you_defined"));
                this.forwardPage(Page.CREATE_CRF_VERSION);
                return;
            }
            String theDir = dir + "crf" + File.separator + "original" + File.separator;
            if (!new File(theDir).isDirectory()) {
                new File(theDir).mkdirs();
                logger.debug("Made the directory " + theDir);
            }
            String tempFile = "";
            try {
                tempFile = this.uploadFile(theDir, version);
            }
            catch (CRFReadingException crfException) {
                Validator.addError((HashMap)this.errors, (String)"excel_file", (String)crfException.getMessage());
                this.request.setAttribute("formMessages", (Object)this.errors);
                this.forwardPage(Page.CREATE_CRF_VERSION);
                return;
            }
            catch (Exception e) {
                logger.error("*** Found exception during file upload***", (Throwable)e);
            }
            this.session.setAttribute("tempFileName", (Object)tempFile);
            if (this.errors.isEmpty()) {
                String s = ((NewCRFBean)this.session.getAttribute("nib")).getVersionName();
                if (s.length() > 255) {
                    Validator.addError((HashMap)this.errors, (String)"excel_file", (String)resword.getString("the_version_CRF_version_more_than_255"));
                } else if (s.length() <= 0) {
                    Validator.addError((HashMap)this.errors, (String)"excel_file", (String)resword.getString("the_VERSION_column_was_blank"));
                }
                version.setName(s);
                if (version.getCrfId() == 0) {
                    version.setCrfId(fp.getInt("crfId"));
                }
                this.session.setAttribute("version", (Object)version);
            }
            if (!this.errors.isEmpty()) {
                logger.debug("has validation errors ");
                this.request.setAttribute("formMessages", (Object)this.errors);
                this.forwardPage(Page.CREATE_CRF_VERSION);
                return;
            }
            CRFBean crf = cdao.findByPK(version.getCrfId());
            ArrayList versions = vdao.findAllByCRF(crf.getId());
            for (int i = 0; i < versions.size(); ++i) {
                CRFVersionBean version1 = (CRFVersionBean)versions.get(i);
                if (!version.getName().equals(version1.getName())) continue;
                logger.debug("Version already exists; owner or not:" + this.ub.getId() + "," + version1.getOwnerId());
                if (this.ub.getId() != version1.getOwnerId()) {
                    this.addPageMessage(respage.getString("CRF_version_try_upload_exists_database") + version1.getOwner().getName() + respage.getString("please_contact_owner_to_delete"));
                    this.forwardPage(Page.CREATE_CRF_VERSION);
                    return;
                }
                ArrayList definitions = edao.findByDefaultVersion(version1.getId());
                if (!definitions.isEmpty()) {
                    this.request.setAttribute("definitions", (Object)definitions);
                    this.forwardPage(Page.REMOVE_CRF_VERSION_DEF);
                    return;
                }
                int previousVersionId = version1.getId();
                version.setId(previousVersionId);
                this.session.setAttribute("version", (Object)version);
                this.session.setAttribute("previousVersionId", (Object)new Integer(previousVersionId));
                this.forwardPage(Page.REMOVE_CRF_VERSION_CONFIRM);
                return;
            }
            logger.debug("didn't find same version in the DB,let user upload the excel file.");
            ArrayList excelErr = ClassCastHelper.asArrayList((Object)this.session.getAttribute("excelErrors"), String.class);
            logger.debug("excelErr.isEmpty()=" + excelErr.isEmpty());
            if (excelErr != null && excelErr.isEmpty()) {
                this.addPageMessage(resword.getString("congratulations_your_spreadsheet_no_errors"));
                this.forwardPage(Page.VIEW_SECTION_DATA_ENTRY_PREVIEW);
                return;
            } else {
                logger.debug("OpenClinicaException thrown, forwarding to CREATE_CRF_VERSION_CONFIRM.");
                this.forwardPage(Page.CREATE_CRF_VERSION_CONFIRM);
            }
            return;
        }
        if ("confirmsql".equalsIgnoreCase(action)) {
            NewCRFBean nib = (NewCRFBean)this.session.getAttribute("nib");
            if (nib != null && nib.getItemQueries() != null) {
                this.request.setAttribute("openQueries", (Object)nib.getItemQueries());
            } else {
                this.request.setAttribute("openQueries", new HashMap());
            }
            boolean canDelete = false;
            Boolean deletePreviousVersion = (Boolean)this.session.getAttribute("deletePreviousVersion");
            Integer previousVersionId = (Integer)this.session.getAttribute("previousVersionId");
            if (deletePreviousVersion != null && deletePreviousVersion.equals(Boolean.TRUE) && previousVersionId != null && previousVersionId > 0) {
                logger.debug("Need to delete previous version");
                canDelete = this.canDeleteVersion(previousVersionId.intValue());
                if (!canDelete) {
                    logger.debug("but cannot delete previous version");
                    if (this.session.getAttribute("itemsHaveData") == null && this.session.getAttribute("eventsForVersion") == null) {
                        this.addPageMessage(respage.getString("you_are_not_owner_some_items_cannot_delete"));
                    }
                    if (this.session.getAttribute("itemsHaveData") == null) {
                        this.session.setAttribute("itemsHaveData", new ArrayList());
                    }
                    if (this.session.getAttribute("eventsForVersion") == null) {
                        this.session.setAttribute("eventsForVersion", new ArrayList());
                    }
                    this.forwardPage(Page.CREATE_CRF_VERSION_NODELETE);
                    return;
                }
                ArrayList nonSharedItems = vdao.findNotSharedItemsByVersion(previousVersionId.intValue());
                HashMap item_table_statements = new HashMap();
                ArrayList<String> temp = new ArrayList<String>(nonSharedItems.size());
                for (ItemBean item : nonSharedItems) {
                    temp.add(item.getName());
                    item_table_statements.put(item.getName(), nib.getBackupItemQueries().get(item.getName()));
                }
                for (String item_name : nib.getItemQueries().keySet()) {
                    if (temp.contains(item_name)) continue;
                    item_table_statements.put(item_name, nib.getItemQueries().get(item_name));
                }
                if (!nonSharedItems.isEmpty()) {
                    this.request.setAttribute("openQueries", item_table_statements);
                }
                nib.setItemQueries(item_table_statements);
                this.session.setAttribute("nib", (Object)nib);
            }
            logger.debug("commit sql");
            NewCRFBean nib1 = (NewCRFBean)this.session.getAttribute("nib");
            if (nib1 != null) {
                try {
                    Integer cfvID;
                    if (canDelete) {
                        nib1.deleteInsertToDB();
                    } else {
                        nib1.insertToDB();
                    }
                    this.request.setAttribute("queries", (Object)nib1.getQueries());
                    CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
                    ArrayList crfvbeans = new ArrayList();
                    logger.debug("CRF-ID [" + version.getCrfId() + "]");
                    int crfVersionId = 0;
                    if (version.getCrfId() != 0) {
                        crfvbeans = cvdao.findAllByCRFId(version.getCrfId());
                        CRFVersionBean lastCvbean = (CRFVersionBean)crfvbeans.get(crfvbeans.size() - 1);
                        crfVersionId = lastCvbean.getId();
                        for (CRFVersionBean cvbean : crfvbeans) {
                            if (crfVersionId >= cvbean.getId()) continue;
                            crfVersionId = cvbean.getId();
                        }
                    }
                    if ((cfvID = new Integer(crfVersionId)) == 0) {
                        cfvID = cvdao.findCRFVersionId(nib1.getCrfId(), nib1.getVersionName());
                    }
                    CRFVersionBean finalVersion = cvdao.findByPK(cfvID.intValue());
                    version.setCrfId(nib1.getCrfId());
                    version.setOid(finalVersion.getOid());
                    CRFBean crfBean = cdao.findByPK(version.getCrfId());
                    crfBean.setUpdatedDate(version.getCreatedDate());
                    crfBean.setUpdater(this.ub);
                    cdao.update(crfBean);
                    this.request.setAttribute("crfVersionId", (Object)cfvID);
                    this.session.removeAttribute("version");
                    this.session.removeAttribute("eventsForVersion");
                    this.session.removeAttribute("itemsHaveData");
                    this.session.removeAttribute("nib");
                    this.session.removeAttribute("deletePreviousVersion");
                    this.session.removeAttribute("previousVersionId");
                    String tempFile = (String)this.session.getAttribute("tempFileName");
                    if (tempFile != null) {
                        logger.debug("*** ^^^ *** saving new version spreadsheet" + tempFile);
                        try {
                            String dir = SQLInitServlet.getField((String)"filePath");
                            File f = new File(dir + "crf" + File.separator + "original" + File.separator + tempFile);
                            String finalDir = dir + "crf" + File.separator + "new" + File.separator;
                            if (!new File(finalDir).isDirectory()) {
                                logger.debug("need to create folder for excel files" + finalDir);
                                new File(finalDir).mkdirs();
                            }
                            String newFile = version.getCrfId() + version.getOid() + ".xls";
                            logger.debug("*** ^^^ *** new file: " + newFile);
                            File nf = new File(finalDir + newFile);
                            logger.debug("copying old file " + f.getName() + " to new file " + nf.getName());
                            this.copy(f, nf);
                        }
                        catch (IOException ie) {
                            logger.debug("==============");
                            this.addPageMessage(respage.getString("CRF_version_spreadsheet_could_not_saved_contact"));
                        }
                    }
                    this.session.removeAttribute("tempFileName");
                    this.session.removeAttribute("module");
                    this.session.removeAttribute("excelErrors");
                    this.session.removeAttribute("htmlTab");
                    this.forwardPage(Page.CREATE_CRF_VERSION_DONE);
                    return;
                }
                catch (OpenClinicaException pe) {
                    logger.debug("--------------");
                    this.session.setAttribute("excelErrors", (Object)nib1.getErrors());
                    this.forwardPage(Page.CREATE_CRF_VERSION_ERROR);
                }
                return;
            }
            this.forwardPage(Page.CREATE_CRF_VERSION);
            return;
        }
        if (!"delete".equalsIgnoreCase(action)) return;
        logger.debug("user wants to delete previous version");
        ArrayList excelErr = ClassCastHelper.asArrayList((Object)this.session.getAttribute("excelErrors"), String.class);
        logger.debug("for overwrite CRF version, excelErr.isEmpty()=" + excelErr.isEmpty());
        if (excelErr != null && excelErr.isEmpty()) {
            this.addPageMessage(resword.getString("congratulations_your_spreadsheet_no_errors"));
            this.session.setAttribute("deletePreviousVersion", (Object)Boolean.TRUE);
            this.forwardPage(Page.VIEW_SECTION_DATA_ENTRY_PREVIEW);
            return;
        } else {
            this.session.setAttribute("deletePreviousVersion", (Object)Boolean.FALSE);
            logger.debug("OpenClinicaException thrown, forwarding to CREATE_CRF_VERSION_CONFIRM.");
            this.forwardPage(Page.CREATE_CRF_VERSION_CONFIRM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String theDir, CRFVersionBean version) throws Exception {
        List theFiles = this.uploadHelper.returnFiles(this.request, this.context, theDir);
        this.errors.remove("excel_file");
        String tempFile = null;
        for (File f : theFiles) {
            if (f == null || f.getName() == null) {
                logger.debug("file is empty.");
                Validator.addError((HashMap)this.errors, (String)"excel_file", (String)resword.getString("you_have_to_provide_spreadsheet"));
                this.session.setAttribute("version", (Object)version);
                return tempFile;
            }
            if (f.getName().indexOf(".xls") < 0 && f.getName().indexOf(".XLS") < 0) {
                logger.debug("file name:" + f.getName());
                Validator.addError((HashMap)this.errors, (String)"excel_file", (String)respage.getString("file_you_uploaded_not_seem_excel_spreadsheet"));
                this.session.setAttribute("version", (Object)version);
                return tempFile;
            }
            logger.debug("file name:" + f.getName());
            tempFile = f.getName();
            FileInputStream inStream = null;
            FileInputStream inStreamClassic = null;
            SpreadSheetTableRepeating htab = null;
            SpreadSheetTableClassic sstc = null;
            NewCRFBean nib = null;
            try {
                ItemBean ib;
                inStream = new FileInputStream(theDir + tempFile);
                htab = new SpreadSheetTableRepeating(inStream, this.ub, version.getName(), this.locale, this.currentStudy.getId());
                htab.setMeasurementUnitDao((MeasurementUnitDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("measurementUnitDao"));
                if (!htab.isRepeating()) {
                    inStreamClassic = new FileInputStream(theDir + tempFile);
                    sstc = new SpreadSheetTableClassic(inStreamClassic, this.ub, version.getName(), this.locale, this.currentStudy.getId());
                    sstc.setMeasurementUnitDao((MeasurementUnitDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("measurementUnitDao"));
                }
                if (htab.isRepeating()) {
                    htab.setCrfId(version.getCrfId());
                    this.session.setAttribute("new_table", (Object)"y");
                } else {
                    sstc.setCrfId(version.getCrfId());
                }
                nib = htab.isRepeating() ? htab.toNewCRF(this.sm.getDataSource(), respage) : sstc.toNewCRF(this.sm.getDataSource(), respage);
                HSSFWorkbook workbook = null;
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(theDir + tempFile);
                    workbook = new HSSFWorkbook((InputStream)inputStream);
                    Object preview = htab.isRepeating() ? new SpreadsheetPreviewNw() : new SpreadsheetPreview();
                    this.session.setAttribute("preview_crf", (Object)preview.createCrfMetaObject(workbook));
                }
                catch (Exception exc) {
                    String message = resword.getString("the_application_encountered_a_problem_uploading_CRF");
                    logger.debug("{} : {}", new Object[]{message, exc.getMessage(), exc});
                    this.addPageMessage(message);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException exc) {}
                    }
                }
                ArrayList ibs = this.isItemSame(nib.getItems(), version);
                if (!ibs.isEmpty()) {
                    ArrayList<String> warnings = new ArrayList<String>();
                    warnings.add(resexception.getString("you_may_not_modify_items"));
                    for (int i = 0; i < ibs.size(); ++i) {
                        ItemBean ib2 = (ItemBean)ibs.get(i);
                        if (ib2.getOwner().getId() == this.ub.getId()) {
                            warnings.add(resword.getString("the_item") + " '" + ib2.getName() + "' " + resexception.getString("in_your_spreadsheet_already_exists") + ib2.getDescription() + "), DATA_TYPE(" + ib2.getDataType().getName() + "), UNITS(" + ib2.getUnits() + "), " + resword.getString("and_or") + " PHI_STATUS(" + ib2.isPhiStatus() + "). UNITS " + resword.getString("and") + " DATA_TYPE(PDATE to DATE) " + resexception.getString("will_not_be_changed_if") + " PHI, DESCRIPTION, DATA_TYPE from PDATE to DATE " + resexception.getString("will_be_changed_if_you_continue"));
                        } else {
                            warnings.add(resword.getString("the_item") + " '" + ib2.getName() + "' " + resexception.getString("in_your_spreadsheet_already_exists") + ib2.getDescription() + "), DATA_TYPE(" + ib2.getDataType().getName() + "), UNITS(" + ib2.getUnits() + "), " + resword.getString("and_or") + " PHI_STATUS(" + ib2.isPhiStatus() + "). " + resexception.getString("these_field_cannot_be_modified_because_not_owner"));
                        }
                        this.request.setAttribute("warnings", warnings);
                    }
                }
                if ((ib = this.isResponseValid(nib.getItems(), version)) != null) {
                    nib.getErrors().add(resword.getString("the_item") + ": " + ib.getName() + " " + resexception.getString("in_your_spreadsheet_already_exits_in_DB"));
                }
            }
            catch (IOException io) {
                logger.warn("Opening up the Excel file caused an error. the error message is: " + io.getMessage());
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inStreamClassic != null) {
                    try {
                        inStreamClassic.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.session.setAttribute("excelErrors", (Object)nib.getErrors());
            this.session.setAttribute("htmlTable", (Object)nib.getHtmlTable());
            this.session.setAttribute("nib", nib);
        }
        return tempFile;
    }

    private boolean canDeleteVersion(int previousVersionId) {
        CRFVersionDAO cdao = new CRFVersionDAO(this.sm.getDataSource());
        ArrayList items = null;
        ArrayList<ItemBean> itemsHaveData = new ArrayList<ItemBean>();
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        ArrayList events = ecdao.findAllByCRFVersion(previousVersionId);
        if (!events.isEmpty()) {
            this.session.setAttribute("eventsForVersion", (Object)events);
            return false;
        }
        items = cdao.findNotSharedItemsByVersion(previousVersionId);
        for (int i = 0; i < items.size(); ++i) {
            ItemBean item = (ItemBean)items.get(i);
            if (this.ub.getId() != item.getOwner().getId()) {
                logger.debug("not owner" + item.getOwner().getId() + "<>" + this.ub.getId());
                return false;
            }
            if (!cdao.hasItemData(item.getId())) continue;
            itemsHaveData.add(item);
            logger.debug("item has data");
            this.session.setAttribute("itemsHaveData", itemsHaveData);
            return false;
        }
        NewCRFBean nib = (NewCRFBean)this.session.getAttribute("nib");
        nib.setDeleteQueries(cdao.generateDeleteQueries(previousVersionId, items));
        this.session.setAttribute("nib", (Object)nib);
        return true;
    }

    private ArrayList<ItemBean> isItemSame(HashMap<String, ItemBean> items, CRFVersionBean version) {
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        ArrayList<ItemBean> diffItems = new ArrayList<ItemBean>();
        for (String name : items.keySet()) {
            ItemBean newItem = idao.findByNameAndCRFId(name, version.getCrfId());
            ItemBean item = items.get(name);
            if (newItem.getId() <= 0 || item.getUnits().equalsIgnoreCase(newItem.getUnits()) && item.isPhiStatus() == newItem.isPhiStatus() && item.getDataType().getId() == newItem.getDataType().getId() && item.getDescription().equalsIgnoreCase(newItem.getDescription())) continue;
            logger.debug("found two items with same name but different units/phi/datatype/description");
            diffItems.add(newItem);
        }
        return diffItems;
    }

    private ItemBean isResponseValid(HashMap<String, ItemBean> items, CRFVersionBean version) {
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        ItemFormMetadataDAO metadao = new ItemFormMetadataDAO(this.sm.getDataSource());
        Set<String> names = items.keySet();
        for (String name : names) {
            ItemBean oldItem = idao.findByNameAndCRFId(name, version.getCrfId());
            ItemBean item = items.get(name);
            if (oldItem.getId() <= 0) continue;
            ArrayList metas = metadao.findAllByItemId(oldItem.getId());
            for (int i = 0; i < metas.size(); ++i) {
                ItemFormMetadataBean ifmb = (ItemFormMetadataBean)metas.get(i);
                ResponseSetBean rsb = ifmb.getResponseSet();
                if (this.hasDifferentOption(rsb, item.getItemMeta().getResponseSet()) == null) continue;
                return item;
            }
        }
        return null;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public ResponseOptionBean hasDifferentOption(ResponseSetBean oldRes, ResponseSetBean newRes) {
        ArrayList oldOptions = oldRes.getOptions();
        ArrayList newOptions = newRes.getOptions();
        if (oldOptions.size() != newOptions.size()) {
            return null;
        }
        for (int i = 0; i < oldOptions.size(); ++i) {
            ResponseOptionBean rob = (ResponseOptionBean)oldOptions.get(i);
            String text = rob.getText();
            String value = rob.getValue();
            ResponseOptionBean rob1 = (ResponseOptionBean)newOptions.get(i);
            String text1 = this.restoreQuotes(rob1.getText());
            String value1 = this.restoreQuotes(rob1.getValue());
            if ((text1 == null || text1.trim().isEmpty()) && (value1 == null || value1.trim().isEmpty())) continue;
            if (text1.equalsIgnoreCase(text) && !value1.equals(value)) {
                logger.debug("different response value:" + value1 + "|" + value);
                return rob;
            }
            if (text1.equalsIgnoreCase(text) || !value1.equals(value)) continue;
            logger.debug("different response text:" + text1 + "|" + text);
            return rob;
        }
        return null;
    }

    public void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public String restoreQuotes(String subj) {
        if (subj == null) {
            return null;
        }
        String returnme = "";
        String[] subjarray = subj.split("''");
        if (subjarray.length == 1) {
            returnme = subjarray[0];
        } else {
            for (int i = 0; i < subjarray.length - 1; ++i) {
                returnme = returnme + subjarray[i];
                returnme = returnme + "'";
            }
            returnme = returnme + subjarray[subjarray.length - 1];
        }
        return returnme;
    }
}

