/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import javax.servlet.ServletContext;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;

public class PauseJobServlet
extends SecureController {
    private static final long serialVersionUID = 8523570823252127703L;
    private static String SCHEDULER = "schedulerFactoryBean";
    private static String groupImportName = "importTrigger";
    private StdScheduler scheduler;

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String triggerName = fp.getString("tname");
        String gName = this.request.getParameter("gname");
        String finalGroupName = "";
        finalGroupName = "".equals(gName) || "0".equals(gName) ? XsltTriggerService.TRIGGER_GROUP_NAME : groupImportName;
        String deleteMe = fp.getString("del");
        this.scheduler = this.getScheduler();
        TriggerKey triggerKey = new TriggerKey(triggerName, finalGroupName);
        try {
            if ("y".equals(deleteMe) && this.ub.isSysAdmin()) {
                this.scheduler.deleteJob(JobKey.jobKey((String)triggerName, (String)finalGroupName));
                logger.debug("deleted job: " + triggerName);
                this.addPageMessage("The following job " + triggerName + " and its corresponding Trigger have been deleted from the system.");
            } else if (this.scheduler.getTriggerState(triggerKey) == Trigger.TriggerState.PAUSED) {
                this.scheduler.resumeTrigger(triggerKey);
                logger.debug("-- resuming trigger! " + triggerName + " " + finalGroupName);
                this.addPageMessage("This trigger " + triggerName + " has been resumed and will continue to run until paused or deleted.");
            } else {
                this.scheduler.pauseTrigger(triggerKey);
                logger.debug("-- pausing trigger! " + triggerName + " " + finalGroupName);
                this.addPageMessage("This trigger " + triggerName + " has been paused, and will not run again until it is restored.");
            }
        }
        catch (NullPointerException e) {
            logger.error("Scheduler cannot deleteJob: ", (Throwable)e);
        }
        if ("".equals(gName) || "0".equals(gName)) {
            this.forwardPage(Page.VIEW_JOB_SERVLET);
        } else {
            this.forwardPage(Page.VIEW_IMPORT_JOB_SERVLET);
        }
    }
}

