/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class SetUserRoleServlet
extends SecureController {
    private static final long serialVersionUID = 5226407311524183121L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_USER_ACCOUNTS_SERVLET, resexception.getString("not_admin"), "1");
    }

    public void processRequest() throws Exception {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int userId = fp.getInt("userId");
        if (userId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_user_to_set_role_for"));
            this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
        } else {
            String action = this.request.getParameter("action");
            UserAccountBean user = udao.findByPK(userId);
            ArrayList studies = sdao.findAll();
            ArrayList studiesHaveRole = sdao.findAllByUser(user.getName());
            studies.removeAll(studiesHaveRole);
            HashSet<Object> studiesNotHaveRole = new HashSet<Object>();
            HashSet<Object> sitesNotHaveRole = new HashSet<Object>();
            for (int i = 0; i < studies.size(); ++i) {
                StudyBean study1 = (StudyBean)studies.get(i);
                boolean hasStudy = false;
                for (int j = 0; j < studiesHaveRole.size(); ++j) {
                    StudyBean study2 = (StudyBean)studiesHaveRole.get(j);
                    if (study2.getId() != study1.getId()) continue;
                    hasStudy = true;
                    break;
                }
                if (hasStudy) continue;
                if (study1.getParentStudyId() > 0) {
                    sitesNotHaveRole.add(study1);
                    continue;
                }
                studiesNotHaveRole.add(study1);
            }
            LinkedHashMap<Integer, String> roleMap = new LinkedHashMap<Integer, String>();
            for (Role role : this.getRoles()) {
                if (role.getId() == 7) continue;
                roleMap.put(role.getId(), role.getDescription());
            }
            Boolean changeRoles = this.request.getParameter("changeRoles") == null ? false : Boolean.parseBoolean(this.request.getParameter("changeRoles"));
            int studyId = fp.getInt("studyId");
            if (changeRoles.booleanValue()) {
                StudyBean study = sdao.findByPK(studyId);
                roleMap = new LinkedHashMap();
                ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
                if (study.getParentStudyId() > 0) {
                    for (Object role : this.getRoles()) {
                        switch (role.getId()) {
                            case 4: {
                                roleMap.put(role.getId(), resterm.getString("site_investigator").trim());
                                break;
                            }
                            case 5: {
                                roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person").trim());
                                break;
                            }
                            case 6: {
                                roleMap.put(role.getId(), resterm.getString("site_monitor").trim());
                                break;
                            }
                            case 7: {
                                roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person2").trim());
                                break;
                            }
                        }
                    }
                } else {
                    for (Object role : this.getRoles()) {
                        switch (role.getId()) {
                            case 2: {
                                roleMap.put(role.getId(), resterm.getString("Study_Coordinator").trim());
                                break;
                            }
                            case 3: {
                                roleMap.put(role.getId(), resterm.getString("Study_Director").trim());
                                break;
                            }
                            case 4: {
                                roleMap.put(role.getId(), resterm.getString("Investigator").trim());
                                break;
                            }
                            case 5: {
                                roleMap.put(role.getId(), resterm.getString("Data_Entry_Person").trim());
                                break;
                            }
                            case 6: {
                                roleMap.put(role.getId(), resterm.getString("Monitor").trim());
                                break;
                            }
                        }
                    }
                }
            } else if (this.currentStudy.getParentStudyId() > 0) {
                roleMap.remove(Role.COORDINATOR.getId());
                roleMap.remove(Role.STUDYDIRECTOR.getId());
            }
            this.request.setAttribute("roles", roleMap);
            this.request.setAttribute("studyId", (Object)studyId);
            if ("confirm".equalsIgnoreCase(action) || changeRoles.booleanValue()) {
                ArrayList<StudyBean> finalStudiesNotHaveRole = new ArrayList<StudyBean>();
                for (StudyBean studyBean : studiesNotHaveRole) {
                    finalStudiesNotHaveRole.add(studyBean);
                    for (StudyBean studyBean2 : sitesNotHaveRole) {
                        if (studyBean2.getParentStudyId() != studyBean.getId()) continue;
                        finalStudiesNotHaveRole.add(studyBean2);
                    }
                }
                this.request.setAttribute("user", (Object)user);
                this.request.setAttribute("studies", finalStudiesNotHaveRole);
                StudyUserRoleBean uRole = new StudyUserRoleBean();
                uRole.setFirstName(user.getFirstName());
                uRole.setLastName(user.getLastName());
                uRole.setUserName(user.getName());
                this.request.setAttribute("uRole", (Object)uRole);
                this.forwardPage(Page.SET_USER_ROLE);
            } else {
                String userName = fp.getString("name");
                studyId = fp.getInt("studyId");
                StudyBean userStudy = sdao.findByPK(studyId);
                int n = fp.getInt("roleId");
                StudyUserRoleBean sur = new StudyUserRoleBean();
                sur.setName(userName);
                sur.setRole(Role.get((int)n));
                sur.setStudyId(studyId);
                sur.setStudyName(userStudy.getName());
                sur.setStatus(Status.AVAILABLE);
                sur.setOwner(this.ub);
                sur.setCreatedDate(new Date());
                if (studyId > 0) {
                    udao.createStudyUserRole(user, sur);
                    this.addPageMessage(user.getFirstName() + " " + user.getLastName() + " (" + resword.getString("username") + ": " + user.getName() + ") " + respage.getString("has_been_granted_the_role") + " \"" + sur.getRole().getDescription() + "\" " + respage.getString("in_the_study_site") + " " + userStudy.getName() + ".");
                }
                ArrayList arrayList = ClassCastHelper.asArrayList((Object)this.request.getAttribute("pageMessages"), String.class);
                String url = this.response.encodeRedirectURL("ListUserAccounts?alertmessage=" + URLEncoder.encode((String)arrayList.get(0), "UTF-8"));
                this.response.sendRedirect(url);
            }
        }
    }

    protected String getAdminServlet() {
        return "admin";
    }

    private ArrayList<Role> getRoles() {
        ArrayList roles = Role.toArrayList();
        roles.remove(Role.ADMIN);
        return roles;
    }
}

