/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.StudySubjectStatusView;
import org.akaza.openclinica.control.admin.StudySubjectStatusStatisticsTableFactory;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.DateFilterMatcher;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Limit;
import org.jmesa.view.View;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.html.renderer.HtmlTableRenderer;

public class StudySubjectStatusStatisticsTableFactory
extends AbstractTableFactory {
    private StudyDAO studyDao;
    private StudySubjectDAO studySubjectDao;
    private StudyBean currentStudy;
    private ResourceBundle reswords = ResourceBundleProvider.getWordsBundle();

    protected String getTableName() {
        return "studySubjectStatusStatistics";
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade) {
        tableFacade.setView((View)new StudySubjectStatusView(this.getLocale()));
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"status", "studySubjects", "percentage"});
        ((HtmlTableRenderer)tableFacade.getTable().getTableRenderer()).setWidth("350px");
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("status"), this.reswords.getString("study_subject_status"), null, null, false, true);
        this.configureColumn(row.getColumn("studySubjects"), this.reswords.getString("n_study_subjects"), null, null, false, true);
        this.configureColumn(row.getColumn("percentage"), this.reswords.getString("percentage"), (CellEditor)new PercentageCellEditor(this, null), null, false, true);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        tableFacade.addFilterMatcher(new MatcherKey(Date.class, "loginAttemptDate"), (FilterMatcher)new DateFilterMatcher("yyyy-MM-dd hh:mm"));
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        Limit limit = tableFacade.getLimit();
        Status[] statuses = new Status[]{Status.AVAILABLE, Status.SIGNED, Status.DELETED};
        ArrayList theItems = new ArrayList();
        if (!limit.isComplete()) {
            int totalRows = statuses.length;
            tableFacade.setTotalRows(totalRows);
        }
        Integer totalStudySubjects = this.studySubjectDao.getCountofStudySubjects(this.currentStudy);
        for (Status status : statuses) {
            Integer totalStudySubjectsByStatus = this.studySubjectDao.getCountofStudySubjectsBasedOnStatus(this.currentStudy, status);
            Long percentage = totalStudySubjects == 0 ? 0L : Math.round(totalStudySubjectsByStatus.doubleValue() / totalStudySubjects.doubleValue() * 100.0);
            HashMap<String, Object> theItem = new HashMap<String, Object>();
            theItem.put("status", status.getName());
            theItem.put("studySubjects", totalStudySubjectsByStatus);
            theItem.put("percentage", String.valueOf(percentage) + "%");
            theItems.add(theItem);
        }
        tableFacade.setItems(theItems);
    }

    public StudyDAO getStudyDao() {
        return this.studyDao;
    }

    public void setStudyDao(StudyDAO studyDao) {
        this.studyDao = studyDao;
    }

    public StudySubjectDAO getStudySubjectDao() {
        return this.studySubjectDao;
    }

    public void setStudySubjectDao(StudySubjectDAO studySubjectDao) {
        this.studySubjectDao = studySubjectDao;
    }

    public StudyBean getCurrentStudy() {
        return this.currentStudy;
    }

    public void setCurrentStudy(StudyBean currentStudy) {
        this.currentStudy = currentStudy;
    }
}

