/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.EntityAction;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class UnLockUserServlet
extends SecureController {
    private static final long serialVersionUID = 5028384981301316490L;
    Locale locale;
    public static final String PATH = "DeleteUser";
    public static final String ARG_USERID = "userId";
    public static final String ARG_ACTION = "action";

    public static String getLink(UserAccountBean u, EntityAction action) {
        return "DeleteUser?userId=" + u.getId() + "&&" + ARG_ACTION + "=" + action.getId();
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (!this.ub.isSysAdmin()) {
            throw new InsufficientPermissionException(Page.MENU, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        String message;
        FormProcessor fp;
        int userId;
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean u = udao.findByPK(userId = (fp = new FormProcessor(this.request)).getInt(ARG_USERID));
        if (!u.isActive() || u.getAccountNonLocked().booleanValue()) {
            message = respage.getString("the_specified_user_not_exits");
        } else {
            u.setUpdater(this.ub);
            SecurityManager sm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
            String password = sm.genPassword();
            if (!u.isLdapUser()) {
                String passwordHash = sm.encryptPassword(password, u.getRunWebservices().booleanValue());
                u.setPasswd(passwordHash);
            }
            u.setPasswdTimestamp(null);
            u.setAccountNonLocked(Boolean.TRUE);
            u.setStatus(Status.AVAILABLE);
            u.setLockCounter(Integer.valueOf(0));
            udao.update(u);
            if (udao.isQuerySuccessful()) {
                message = respage.getString("the_user_has_been_unlocked");
                try {
                    if (!u.isLdapUser()) {
                        this.sendRestoreEmail(u, password);
                    }
                }
                catch (Exception e) {
                    logger.error("Error_sending_user_email_regarding: ", (Throwable)e);
                    message = message + respage.getString("however_was_error_sending_user_email_regarding");
                }
            } else {
                message = respage.getString("the_user_could_not_be_deleted_due_database_error");
            }
        }
        this.addPageMessage(message);
        this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
    }

    private void sendRestoreEmail(UserAccountBean u, String password) throws Exception {
        logger.info("Sending restore and password reset notification to " + u.getName());
        String body = resword.getString("dear") + u.getFirstName() + " " + u.getLastName() + ",<br>" + restext.getString("your_account_has_been_unlocked_and_password_reset") + ":<br><br>" + resword.getString("user_name") + u.getName() + "<br>" + resword.getString("password") + password + "<br><br>" + restext.getString("please_test_your_login_information_and_let") + "<br><A HREF='" + SQLInitServlet.getField((String)"sysURL.base") + "'>" + SQLInitServlet.getField((String)"sysURL.base") + "</A> <br><br>" + restext.getString("openclinica_system_administrator");
        logger.info("Sending email...begin");
        this.sendEmail(u.getEmail().trim(), restext.getString("your_new_openclinica_account_has_been_restored"), body, Boolean.valueOf(false));
        logger.info("Sending email...done");
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

