/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.job.ImportStatefulJob;
import org.akaza.openclinica.web.job.TriggerService;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;

public class UpdateJobImportServlet
extends SecureController {
    private static final long serialVersionUID = 4553819902500848985L;
    private static String SCHEDULER = "schedulerFactoryBean";
    private static String TRIGGER_IMPORT_GROUP = "importTrigger";
    private StdScheduler scheduler;
    private JobDataMap dataMap;
    private static final String IMPORT_DIR = SQLInitServlet.getField((String)"filePath") + "scheduled_data_import" + File.separator;

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    private void setUpServlet(Trigger trigger) throws Exception {
        this.request.setAttribute("jobName", (Object)trigger.getKey().getName());
        this.request.setAttribute("jobDesc", (Object)trigger.getDescription());
        this.dataMap = trigger.getJobDataMap();
        String contactEmail = this.dataMap.getString("contactEmail");
        logger.debug("found email: " + contactEmail);
        int hours = this.dataMap.getInt("hours");
        int minutes = this.dataMap.getInt("minutes");
        String directory = this.dataMap.getString("filePathDir");
        String studyName = this.dataMap.getString("study_name");
        this.request.setAttribute("contactEmail", (Object)contactEmail);
        this.request.setAttribute("study_name", (Object)studyName);
        this.request.setAttribute("filePath", (Object)directory);
        this.request.setAttribute("firstFilePath", (Object)IMPORT_DIR);
        this.request.setAttribute("hours", (Object)new Integer(hours).toString());
        this.request.setAttribute("minutes", (Object)new Integer(minutes).toString());
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList all = sdao.findAll();
        ArrayList<StudyBean> finalList = new ArrayList<StudyBean>();
        for (StudyBean sb : all) {
            if (sb.getParentStudyId() > 0) continue;
            finalList.add(sb);
            finalList.addAll(sdao.findAllByParent(sb.getId()));
        }
        this.addEntityList("studies", finalList, respage.getString("a_user_cannot_be_created_no_study_as_active"), Page.ADMIN_SYSTEM);
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        TriggerService triggerService = new TriggerService();
        String action = fp.getString("action");
        String triggerName = fp.getString("tname");
        this.scheduler = this.getScheduler();
        logger.debug("found trigger name " + triggerName);
        Trigger trigger = this.scheduler.getTrigger(new TriggerKey(triggerName, TRIGGER_IMPORT_GROUP));
        if (action == null || action.trim().isEmpty()) {
            this.setUpServlet(trigger);
            this.forwardPage(Page.UPDATE_JOB_IMPORT);
        } else if ("confirmall".equalsIgnoreCase(action)) {
            Set triggerKeys = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"DEFAULT"));
            String[] triggerNames = (String[])triggerKeys.stream().toArray(String[]::new);
            HashMap errors = triggerService.validateImportJobForm(fp, this.request, triggerNames, trigger.getKey().getName());
            if (!errors.isEmpty()) {
                this.addPageMessage("Your modifications caused an error, please see the messages for more information.");
                this.setUpServlet(trigger);
                this.forwardPage(Page.UPDATE_JOB_IMPORT);
            } else {
                StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                int studyId = fp.getInt("studyId");
                StudyBean study = studyDAO.findByPK(studyId);
                Date startDate = trigger.getStartTime();
                trigger = triggerService.generateImportTrigger(fp, this.sm.getUserBean(), study, startDate, LocaleResolver.getLocale((HttpServletRequest)this.request).getLanguage());
                JobDetailFactoryBean jobDetailBean = new JobDetailFactoryBean();
                jobDetailBean.setGroup(TRIGGER_IMPORT_GROUP);
                jobDetailBean.setName(trigger.getKey().getName());
                jobDetailBean.setJobClass(ImportStatefulJob.class);
                jobDetailBean.setJobDataMap(trigger.getJobDataMap());
                jobDetailBean.setDurability(true);
                jobDetailBean.afterPropertiesSet();
                try {
                    this.scheduler.deleteJob(new JobKey(triggerName, TRIGGER_IMPORT_GROUP));
                    this.scheduler.scheduleJob(jobDetailBean.getObject(), trigger);
                    this.addPageMessage("Your job has been successfully modified.");
                    this.forwardPage(Page.VIEW_IMPORT_JOB_SERVLET);
                }
                catch (SchedulerException se) {
                    logger.error("Job is not able to be modified: ", (Throwable)se);
                    this.setUpServlet(trigger);
                    this.addPageMessage("There was an unspecified error with your creation, please contact an administrator.");
                    this.forwardPage(Page.UPDATE_JOB_IMPORT);
                }
            }
        }
    }
}

