/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.TriggerBean;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.service.extract.XsltTriggerService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.TriggerRow;
import org.quartz.JobDataMap;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;

public class ViewJobServlet
extends SecureController {
    private static final long serialVersionUID = -1226529718566575419L;
    private static String SCHEDULER = "schedulerFactoryBean";
    private StdScheduler scheduler;

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private StdScheduler getScheduler() {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(SCHEDULER);
        return this.scheduler;
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        this.scheduler = this.getScheduler();
        XsltTriggerService xsltTriggerSrvc = new XsltTriggerService();
        Set triggerKeySet = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)xsltTriggerSrvc.getTriggerGroupNameForExportJobs()));
        TriggerKey[] triggerKeys = (TriggerKey[])triggerKeySet.stream().toArray(TriggerKey[]::new);
        ArrayList<TriggerBean> triggerBeans = new ArrayList<TriggerBean>();
        for (TriggerKey triggerKey : triggerKeys) {
            Trigger trigger = this.scheduler.getTrigger(triggerKey);
            try {
                logger.debug("prev fire time " + trigger.getPreviousFireTime().toString());
                logger.debug("next fire time " + trigger.getNextFireTime().toString());
                logger.debug("final fire time: " + trigger.getFinalFireTime().toString());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            TriggerBean triggerBean = new TriggerBean();
            triggerBean.setFullName(triggerKey.getName());
            triggerBean.setPreviousDate(trigger.getPreviousFireTime());
            triggerBean.setNextDate(trigger.getNextFireTime());
            if (trigger.getDescription() != null) {
                triggerBean.setDescription(trigger.getDescription());
            }
            JobDataMap dataMap = new JobDataMap();
            DatasetDAO datasetDAO = new DatasetDAO(this.sm.getDataSource());
            StudyDAO studyDao = new StudyDAO(this.sm.getDataSource());
            if (trigger.getJobDataMap().size() > 0) {
                dataMap = trigger.getJobDataMap();
                int dsId = dataMap.getInt("dsId");
                String periodToRun = dataMap.getString("periodToRun");
                triggerBean.setPeriodToRun(periodToRun);
                DatasetBean dataset = datasetDAO.findByPK(dsId);
                triggerBean.setDataset(dataset);
                triggerBean.setDatasetName(dataset.getName());
                StudyBean study = studyDao.findByPK(dataset.getStudyId());
                triggerBean.setStudyName(study.getName());
            }
            logger.debug("Trigger Priority: " + triggerKey.getName() + " " + trigger.getPriority());
            if (this.scheduler.getTriggerState(triggerKey) == Trigger.TriggerState.PAUSED) {
                triggerBean.setActive(false);
                logger.debug("setting active to false for trigger: " + triggerKey.getName());
            } else {
                triggerBean.setActive(true);
                logger.debug("setting active to TRUE for trigger: " + triggerKey.getName());
            }
            triggerBeans.add(triggerBean);
        }
        ArrayList allRows = TriggerRow.generateRowsFromBeans(triggerBeans);
        EntityBeanTable table = fp.getEntityBeanTable();
        String[] columns = new String[]{resword.getString("name"), resword.getString("previous_fire_time"), resword.getString("next_fire_time"), resword.getString("description"), resword.getString("period_to_run"), resword.getString("dataset"), resword.getString("study"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(3);
        table.hideColumnLink(7);
        table.setQuery("ViewJob", new HashMap());
        table.setSortingColumnInd(0);
        table.setRows(allRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.forwardPage(Page.VIEW_JOB);
    }
}

