/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.job.ImportSpringJob;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewLogMessageServlet
extends SecureController {
    private static final long serialVersionUID = 5409165798175683504L;
    private static final String LOG_MESSAGE = "logmsg";
    private static final String FILE_NAME = "filename";
    private static final String TRIGGER_NAME = "tname";
    private static final String GROUP_NAME = "gname";

    protected void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.ADMIN) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    protected void processRequest() throws Exception {
        try {
            File destDirectory = new File(ImportSpringJob.IMPORT_DIR_2);
            FormProcessor fp = new FormProcessor(this.request);
            String regex = "\\s+";
            String replacement = "_";
            String fileName = fp.getString("n");
            String triggerName = fp.getString("tn");
            String groupName = fp.getString("gn");
            logger.debug("found trigger name " + triggerName + " group name " + groupName);
            File logDestDirectory = new File(destDirectory + File.separator + fileName.replaceAll(regex, replacement) + ".log.txt" + File.separator + "log.txt");
            String fileContents = ViewLogMessageServlet.readFromFile((File)logDestDirectory);
            this.request.setAttribute("logmsg", (Object)fileContents);
            this.request.setAttribute("filename", (Object)fileName);
            this.request.setAttribute("tname", (Object)triggerName);
            this.request.setAttribute("gname", (Object)groupName);
            this.forwardPage(Page.VIEW_LOG_MESSAGE);
        }
        catch (Exception e) {
            logger.error("found IO exception: " + e.getMessage());
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            this.forwardPage(Page.MENU);
        }
    }

    public static String readFromFile(File filename) throws FileNotFoundException, IOException {
        int count;
        StringBuffer readBuffer = new StringBuffer();
        BufferedReader fileReader = new BufferedReader(new FileReader(filename));
        char[] readChars = new char[1024];
        while ((count = fileReader.read(readChars)) >= 0) {
            readBuffer.append(readChars, 0, count);
        }
        fileReader.close();
        return readBuffer.toString();
    }
}

