/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DatasetItemStatus;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.extract.FilterBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.extract.FilterDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.service.crfdata.HideCRFManager;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.FilterRow;

/*
 * Exception performing whole class analysis ignored.
 */
public class CreateDatasetServlet
extends SecureController {
    private static final long serialVersionUID = -3072489791090476232L;
    public static final String BEAN_YEARS = "years";
    public static final String BEAN_MONTHS = "months";
    public static final String EVENTS_FOR_CREATE_DATASET = "eventsForCreateDataset";
    public static final String SAVE_BUTTON = "save";
    public static final String SAVE_CONTINUE_BUTTON = "saveContinue";
    public static final String DOB = "dob";
    public static final String GENDER = "gender";
    public static final String EVENT_LOCATION = "location";
    public static final String EVENT_START = "start";
    public static final String EVENT_END = "end";
    public static final String SUBJ_STATUS = "subj_status";
    public static final String UNIQUE_ID = "unique_identifier";
    public static final String AGE_AT_EVENT = "age_at_event";
    public static final String SUBJ_SECONDARY_ID = "subj_secondary_id";
    public static final String GROUP_INFORMATION = "group_information";
    public static final String EVENT_STATUS = "event_status";
    public static final String DISCREPANCY_INFORMATION = "disc";
    public static final String CRF_STATUS = "crf_status";
    public static final String CRF_VERSION = "crf_version";
    public static final String INTERVIEWER_NAME = "interviewer";
    public static final String INTERVIEWER_DATE = "interviewer_date";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public ArrayList<StudyGroupClassBean> setUpStudyGroups() {
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        StudyGroupClassDAO sgclassdao = new StudyGroupClassDAO(this.sm.getDataSource());
        StudyBean theStudy = studydao.findByPK(this.sm.getUserBean().getActiveStudyId());
        ArrayList sgclasses = sgclassdao.findAllActiveByStudy(theStudy);
        return sgclasses;
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String action = fp.getString("action");
        if (action == null || action.trim().isEmpty()) {
            this.session.setAttribute("newDataset", (Object)new DatasetBean());
            this.session.setAttribute("allItems", new ArrayList());
            this.session.setAttribute("crf", (Object)new CRFBean());
            this.session.setAttribute("allSelectedItems", new ArrayList());
            this.forwardPage(Page.CREATE_DATASET_1);
        } else {
            StudyBean studyWithEventDefs = this.currentStudy;
            if (this.currentStudy.getParentStudyId() > 0) {
                studyWithEventDefs = new StudyBean();
                studyWithEventDefs.setId(this.currentStudy.getParentStudyId());
            }
            if ("begin".equalsIgnoreCase(action)) {
                StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
                StudyBean studyWithEventDefinitions = this.currentStudy;
                if (this.currentStudy.getParentStudyId() > 0) {
                    studyWithEventDefinitions = new StudyBean();
                    studyWithEventDefinitions.setId(this.currentStudy.getParentStudyId());
                }
                ArrayList seds = seddao.findAllActiveByStudy(studyWithEventDefinitions);
                CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
                LinkedHashMap<StudyEventDefinitionBean, ArrayList> events = new LinkedHashMap<StudyEventDefinitionBean, ArrayList>();
                for (int i = 0; i < seds.size(); ++i) {
                    StudyEventDefinitionBean sed = (StudyEventDefinitionBean)seds.get(i);
                    ArrayList crfs = crfdao.findAllActiveByDefinition(sed);
                    if (this.currentStudy.getParentStudyId() > 0) {
                        HideCRFManager hideCRFs = HideCRFManager.createHideCRFManager();
                        crfs = hideCRFs.removeHiddenCRFBeans(studyWithEventDefinitions, sed, crfs, this.sm.getDataSource());
                    }
                    if (crfs.isEmpty()) continue;
                    events.put(sed, crfs);
                }
                if (events.isEmpty()) {
                    this.addPageMessage(respage.getString("not_have_study_definitions_assigned"));
                    this.forwardPage(Page.CREATE_DATASET_1);
                } else {
                    crfdao = new CRFDAO(this.sm.getDataSource());
                    ItemDAO idao = new ItemDAO(this.sm.getDataSource());
                    ArrayList sedItemIds = CreateDatasetServlet.allSedItemIdsInStudy(events, (CRFDAO)crfdao, (ItemDAO)idao);
                    this.session.setAttribute("numberOfStudyItems", (Object)Integer.toString(sedItemIds.size()));
                    this.request.setAttribute("eventlist", events);
                    this.session.setAttribute("eventsForCreateDataset", events);
                    this.session.setAttribute("newDataset", (Object)new DatasetBean());
                    this.session.setAttribute("allItems", new ArrayList());
                    this.session.setAttribute("crf", (Object)new CRFBean());
                    this.forwardPage(Page.CREATE_DATASET_2);
                }
            } else if ("beginsubmit".equalsIgnoreCase(action)) {
                String saveItems = fp.getString("save");
                DatasetBean db = (DatasetBean)this.session.getAttribute("newDataset");
                if (db == null) {
                    db = new DatasetBean();
                }
                this.extractIdsFromForm(db);
                this.extractEventIds(db);
                this.session.setAttribute("newDataset", (Object)db);
                if (saveItems != null && !saveItems.trim().isEmpty()) {
                    this.request.setAttribute("eventlist", this.session.getAttribute("eventsForCreateDataset"));
                    String summary = respage.getString("you_have_selected") + " " + db.getItemIds().size() + " " + respage.getString("items_so_far");
                    summary = summary + this.genAttMsg(db);
                    this.addPageMessage(summary);
                    int crfId = fp.getInt("crfId");
                    if (crfId > 0) {
                        this.forwardPage(Page.CREATE_DATASET_2);
                    } else {
                        ArrayList sgclasses = ClassCastHelper.asArrayList((Object)this.session.getAttribute("allSelectedGroups"), StudyGroupClassBean.class);
                        if (sgclasses == null || sgclasses.size() == 0) {
                            sgclasses = this.setUpStudyGroups();
                        }
                        this.session.setAttribute("allSelectedGroups", (Object)sgclasses);
                        this.request.setAttribute("allSelectedGroups", (Object)sgclasses);
                        this.forwardPage(Page.CREATE_DATASET_VIEW_SELECTED);
                    }
                } else if (db.getItemIds().size() == 0) {
                    this.request.setAttribute("eventlist", this.session.getAttribute("eventsForCreateDataset"));
                    this.addPageMessage(respage.getString("should_select_one_item_to_create_dataset"));
                    this.forwardPage(Page.CREATE_DATASET_2);
                } else {
                    String summary = respage.getString("you_have_selected") + " " + db.getItemIds().size() + " " + respage.getString("items_totally_for_this_dataset");
                    summary = summary + this.genAttMsg(db);
                    this.addPageMessage(summary);
                    fp.addPresetValue("firstmonth", 0);
                    fp.addPresetValue("firstyear", 1900);
                    fp.addPresetValue("lastmonth", 0);
                    fp.addPresetValue("lastyear", 2100);
                    this.setPresetValues(fp.getPresetValues());
                    logger.warn("found preset values while setting date: " + fp.getPresetValues().toString());
                    this.request.setAttribute("months", (Object)this.getMonths());
                    this.request.setAttribute("years", (Object)this.getYears());
                    this.forwardPage(Page.CREATE_DATASET_3);
                }
            } else if ("scopesubmit".equalsIgnoreCase(action)) {
                int firstMonth = fp.getInt("firstmonth");
                int firstYear = fp.getInt("firstyear");
                int lastMonth = fp.getInt("lastmonth");
                int lastYear = fp.getInt("lastyear");
                if (fp.getInt("firstmonth") == 0) {
                    firstMonth = 1;
                }
                if (fp.getInt("lastmonth") == 0) {
                    lastMonth = 12;
                }
                this.errors = new HashMap();
                if (fp.getInt("firstmonth") > 0 && firstYear == 1900) {
                    Validator.addError((HashMap)this.errors, (String)"firstmonth", (String)restext.getString("if_specify_month_also_specify_year"));
                }
                if (fp.getInt("lastmonth") > 0 && lastYear == 2100) {
                    Validator.addError((HashMap)this.errors, (String)"lastmonth", (String)restext.getString("if_specify_month_also_specify_year"));
                }
                Date dateStart = this.getFirstDayOfMonth(firstYear, firstMonth);
                Date dateEnd = this.getLastDayOfMonth(lastYear, lastMonth);
                if (dateEnd.compareTo(dateStart) < 0) {
                    Validator.addError((HashMap)this.errors, (String)"firstmonth", (String)restext.getString("the_from_should_be_come_before_to"));
                }
                if (!this.errors.isEmpty()) {
                    String[] fieldNames = new String[]{"firstmonth", "firstyear", "lastmonth", "lastyear"};
                    fp.setCurrentIntValuesAsPreset(fieldNames);
                    this.setInputMessages(this.errors);
                    this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                    this.setPresetValues(fp.getPresetValues());
                    this.request.setAttribute("months", (Object)this.getMonths());
                    this.request.setAttribute("years", (Object)this.getYears());
                    this.forwardPage(Page.CREATE_DATASET_3);
                } else {
                    DatasetBean dsb = (DatasetBean)this.session.getAttribute("newDataset");
                    dsb.setDateStart(dateStart);
                    dsb.setDateEnd(dateEnd);
                    this.session.setAttribute("newDataset", (Object)dsb);
                    if (fp.getString("submit").equals(resword.getString("continue_to_apply_filter"))) {
                        EntityBeanTable table = this.getFilterTable();
                        this.session.setAttribute("partOfCreateDataset", (Object)new Integer(1));
                        this.request.setAttribute("table", (Object)table);
                        this.forwardPage(Page.APPLY_FILTER);
                    } else {
                        this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
                        String temp = dsb.getODMMetaDataVersionOid();
                        this.request.setAttribute("mdvOID", (Object)(temp != null && temp.length() > 0 ? temp : "v1.0.0"));
                        temp = dsb.getODMMetaDataVersionName();
                        this.request.setAttribute("mdvName", (Object)(temp != null && temp.length() > 0 ? temp : "MetaDataVersion_v1.0.0"));
                        this.request.setAttribute("mdvPrevStudy", (Object)dsb.getODMPriorStudyOid());
                        this.request.setAttribute("mdvPrevOID", (Object)dsb.getODMPriorMetaDataVersionOid());
                        this.forwardPage(Page.CREATE_DATASET_4);
                    }
                }
            } else if ("specifysubmit".equalsIgnoreCase(action)) {
                Validator v = new Validator(this.request);
                v.addValidation("dsName", 1);
                v.addValidation("dsName", 43);
                v.addValidation("dsDesc", 1);
                v.addValidation("dsStatus", 17, TermType.STATUS);
                v.addValidation("dsName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
                v.addValidation("dsDesc", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 2000);
                String mdvOID = fp.getString("mdvOID");
                String mdvName = fp.getString("mdvName");
                String mdvPrevStudy = fp.getString("mdvPrevStudy");
                if (mdvPrevStudy != null && mdvPrevStudy.length() > 0) {
                    v.addValidation("mdvPrevOID", 1);
                }
                String mdvPrevOID = fp.getString("mdvPrevOID");
                this.errors = v.validate();
                String dsName = fp.getString("dsName");
                if (dsName != null && !dsName.trim().isEmpty()) {
                    DatasetDAO dsdao;
                    DatasetBean dsBean;
                    if (dsName.contains("/") || dsName.contains("\\")) {
                        Validator.addError((HashMap)this.errors, (String)"dsName", (String)restext.getString("slash_not_allowed"));
                    }
                    if (((DatasetBean)this.session.getAttribute("newDataset")).getId() <= 0 && (dsBean = (dsdao = new DatasetDAO(this.sm.getDataSource())).findByNameAndStudy(fp.getString("dsName").trim(), this.currentStudy)).getId() > 0) {
                        Validator.addError((HashMap)this.errors, (String)"dsName", (String)restext.getString("dataset_name_used_by_another_choose_unique"));
                    }
                }
                if (!this.errors.isEmpty()) {
                    String[] fieldNames = new String[]{"dsName", "dsDesc"};
                    fp.setCurrentStringValuesAsPreset(fieldNames);
                    fp.addPresetValue("dsStatusId", fp.getInt("dsStatus"));
                    fp.addPresetValue("mdvOID", mdvOID);
                    fp.addPresetValue("mdvName", mdvName);
                    fp.addPresetValue("mdvPrevStudy", mdvPrevStudy);
                    fp.addPresetValue("mdvPrevOID", mdvPrevOID);
                    this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                    this.setInputMessages(this.errors);
                    this.setPresetValues(fp.getPresetValues());
                    this.request.setAttribute("statuses", (Object)Status.toActiveArrayList());
                    this.forwardPage(Page.CREATE_DATASET_4);
                } else {
                    FilterBean fb;
                    this.session.setAttribute("mdvOID", (Object)mdvOID);
                    this.session.setAttribute("mdvName", (Object)mdvName);
                    this.session.setAttribute("mdvPrevStudy", (Object)mdvPrevStudy);
                    this.session.setAttribute("mdvPrevOID", (Object)mdvPrevOID);
                    if (mdvPrevOID != null && mdvPrevOID.length() > 0 && (mdvPrevStudy == null || mdvPrevStudy.length() <= 0)) {
                        mdvPrevStudy = this.currentStudy.getId() + "";
                    }
                    DatasetBean dsb = (DatasetBean)this.session.getAttribute("newDataset");
                    dsb.setSQLStatement(dsb.generateQuery());
                    String dbName = SQLInitServlet.getField((String)"dataBase");
                    if ("oracle".equals(dbName)) {
                        dsb.setSQLStatement(dsb.generateOracleQuery());
                    }
                    if ((fb = (FilterBean)this.session.getAttribute("newFilter")) != null) {
                        dsb.setSQLStatement(dsb.getSQLStatement() + " " + fb.getSQLStatement());
                    }
                    if (dsb.getId() > 0 && !dsb.getName().equals(fp.getString("dsName"))) {
                        dsb.setId(0);
                    }
                    dsb.setODMMetaDataVersionName(mdvName);
                    dsb.setODMMetaDataVersionOid(mdvOID);
                    dsb.setODMPriorMetaDataVersionOid(mdvPrevOID);
                    dsb.setODMPriorStudyOid(mdvPrevStudy);
                    dsb.setName(fp.getString("dsName"));
                    dsb.setDescription(fp.getString("dsDesc"));
                    dsb.setStatus(Status.get((int)fp.getInt("dsStatus")));
                    dsb.setDatasetItemStatus(DatasetItemStatus.get((int)fp.getInt("itemStatus")));
                    this.session.removeAttribute("partOfCreateDataset");
                    Date ddate = new SimpleDateFormat("MM/dd/yyyy").parse("01/01/1900");
                    this.request.setAttribute("defaultStart", (Object)this.local_df.parse(this.local_df.format(ddate)));
                    this.request.setAttribute("defaultEnd", (Object)this.getLastDayOfMonth(2100, 12));
                    this.session.setAttribute("newDataset", (Object)dsb);
                    this.forwardPage(Page.CONFIRM_DATASET);
                }
            } else if ("confirmall".equalsIgnoreCase(action)) {
                String submit = fp.getString("btnSubmit");
                logger.info("reached confirm all");
                if (!resword.getString("confirm_and_save").equalsIgnoreCase(submit)) {
                    this.forwardPage(Page.CREATE_DATASET_4);
                } else {
                    DatasetDAO ddao = new DatasetDAO(this.sm.getDataSource());
                    DatasetBean dsb = (DatasetBean)this.session.getAttribute("newDataset");
                    dsb.setStudyId(this.currentStudy.getId());
                    dsb.setOwner(this.ub);
                    dsb = this.finalUpateDatasetBean(dsb);
                    if (dsb.getId() == 0) {
                        logger.info("*** about to create the dataset bean");
                        dsb = ddao.create(dsb);
                        logger.info("created dataset bean: " + dsb.getId() + ", name: " + dsb.getName());
                        if (!dsb.isActive()) {
                            this.addPageMessage(restext.getString("problem_creating_dataset_try_again"));
                            this.forwardPage(Page.EXTRACT_DATASETS_MAIN);
                        }
                    } else if (dsb.getId() > 0) {
                        if (!(dsb = ddao.updateAll(dsb)).isActive()) {
                            this.addPageMessage(restext.getString("problem_creating_dataset_try_again"));
                            this.forwardPage(Page.EXTRACT_DATASETS_MAIN);
                        }
                        if (!(dsb = (DatasetBean)ddao.updateGroupMap(dsb)).isActive()) {
                            this.addPageMessage(restext.getString("problem_updating_subject_group_class_when_updating_dataset"));
                            this.forwardPage(Page.EXTRACT_DATASETS_MAIN);
                        }
                    }
                    logger.info("setting data set id here");
                    this.request.setAttribute("dataset", (Object)dsb);
                    this.forwardPage(Page.EXPORT_DATASETS);
                }
            } else {
                this.addPageMessage(restext.getString("creating_new_dataset_cancelled"));
                this.forwardPage(Page.CREATE_DATASET_1);
            }
        }
    }

    public void extractIdsFromForm(DatasetBean db) {
        FormProcessor fp = new FormProcessor(this.request);
        int crfId = fp.getInt("crfId");
        int defId = fp.getInt("defId");
        boolean eventAttr = fp.getBoolean("eventAttr");
        boolean subAttr = fp.getBoolean("subAttr");
        boolean CRFAttr = fp.getBoolean("CRFAttr");
        boolean groupAttr = fp.getBoolean("groupAttr");
        ArrayList allItems = ClassCastHelper.asArrayList((Object)this.session.getAttribute("allItems"), ItemBean.class);
        if (defId > 0 && !db.getEventIds().contains(new Integer(defId))) {
            db.getEventIds().add(new Integer(defId));
        }
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        String defName = "";
        if (defId > 0 && crfId != -1) {
            StudyEventDefinitionBean sed = seddao.findByPK(defId);
            defName = sed.getName();
        }
        if (crfId == -1) {
            allItems = ClassCastHelper.asArrayList((Object)this.session.getAttribute("allSelectedItems"), ItemBean.class);
        } else if (crfId > 0) {
            for (int i = 0; i < allItems.size(); ++i) {
                ItemBean item = (ItemBean)allItems.get(i);
                item.setSelected(false);
                if (!db.getItemMap().containsKey(defId + "_" + item.getId())) continue;
                db.getItemIds().remove(new Integer(item.getId()));
                db.getItemMap().remove(defId + "_" + item.getId());
                for (int j = 0; j < db.getItemDefCrf().size(); ++j) {
                    ItemBean ib = (ItemBean)db.getItemDefCrf().get(j);
                    if (ib.getId() != item.getId()) continue;
                    db.getItemDefCrf().remove(j);
                }
            }
        }
        if (crfId != 0 && allItems != null) {
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFBean crf = cdao.findByPK(crfId);
            ArrayList<ItemBean> newSelectItems = new ArrayList<ItemBean>();
            for (int i = 0; i < allItems.size(); ++i) {
                String checked = fp.getString("itemSelected" + i);
                String itemCrfName = fp.getString("itemCrfName" + i);
                String itemDefName = fp.getString("itemDefName" + i);
                ItemBean selectedItem = (ItemBean)allItems.get(i);
                if (checked != null && !checked.trim().isEmpty() && "yes".equalsIgnoreCase(checked.trim())) {
                    selectedItem.setSelected(true);
                    if (!"".equals(crf.getName())) {
                        selectedItem.setCrfName(crf.getName());
                    } else {
                        selectedItem.setCrfName(itemCrfName);
                    }
                    if (!"".equals(defName)) {
                        selectedItem.setDefName(defName);
                    } else {
                        selectedItem.setDefName(itemDefName);
                    }
                    newSelectItems.add(selectedItem);
                    if (db.getItemMap().containsKey(selectedItem.getDatasetItemMapKey())) continue;
                    logger.info("one item selected");
                    db.getItemIds().add(new Integer(selectedItem.getId()));
                    if (selectedItem.getDefId() == 0) {
                        db.getItemMap().put(defId + "_" + selectedItem.getId(), selectedItem);
                    } else {
                        db.getItemMap().put(selectedItem.getDefId() + "_" + selectedItem.getId(), selectedItem);
                    }
                    db.getItemDefCrf().add(selectedItem);
                    continue;
                }
                if (crfId != -1 || !db.getItemMap().containsKey(selectedItem.getDatasetItemMapKey())) continue;
                for (int j = 0; j < db.getItemDefCrf().size(); ++j) {
                    ItemBean ib = (ItemBean)db.getItemDefCrf().get(j);
                    if (ib.getId() != selectedItem.getId()) continue;
                    db.getItemDefCrf().remove(j);
                }
                db.getItemIds().remove(new Integer(selectedItem.getId()));
                db.getItemMap().remove(selectedItem.getDatasetItemMapKey());
            }
            if (crfId == -1) {
                this.getSubAttr(fp, db);
                this.getEventAttr(fp, db);
                this.getGroupAttr(fp, db);
                this.getCRFAttr(fp, db);
            }
            this.session.setAttribute("allSelectedItems", newSelectItems);
        }
        if (crfId == 0) {
            if (subAttr) {
                this.getSubAttr(fp, db);
            } else if (eventAttr) {
                this.getEventAttr(fp, db);
            } else if (groupAttr) {
                this.getGroupAttr(fp, db);
            } else if (CRFAttr) {
                this.getCRFAttr(fp, db);
            }
        }
    }

    private Date getFirstDayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, --month, 1, 0, 0, 0);
        return new Date(c.getTimeInMillis());
    }

    private Date getLastDayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, --month, 1, 23, 59, 59);
        c.add(2, 1);
        c.add(5, -1);
        return new Date(c.getTimeInMillis());
    }

    private ArrayList<String> getMonths() {
        ArrayList<String> answer = new ArrayList<String>();
        answer.add(resword.getString("January"));
        answer.add(resword.getString("February"));
        answer.add(resword.getString("March"));
        answer.add(resword.getString("April"));
        answer.add(resword.getString("May"));
        answer.add(resword.getString("June"));
        answer.add(resword.getString("July"));
        answer.add(resword.getString("August"));
        answer.add(resword.getString("September"));
        answer.add(resword.getString("October"));
        answer.add(resword.getString("November"));
        answer.add(resword.getString("December"));
        return answer;
    }

    private ArrayList<String> getYears() {
        ArrayList<String> answer = new ArrayList<String>();
        Calendar currTime = Calendar.getInstance();
        int currYear = currTime.get(1);
        for (int i = 1980; i <= currYear; ++i) {
            answer.add(String.valueOf(i));
        }
        return answer;
    }

    private EntityBeanTable getFilterTable() {
        FormProcessor fp = new FormProcessor(this.request);
        FilterDAO fdao = new FilterDAO(this.sm.getDataSource());
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList filters = fdao.findAll();
        ArrayList filterRows = FilterRow.generateRowsFromBeans((ArrayList)filters);
        String[] columns = new String[]{resword.getString("filter_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(5);
        table.setQuery("ApplyFilter", new HashMap());
        table.setRows(filterRows);
        table.computeDisplay();
        return table;
    }

    private String genAttMsg(DatasetBean db) {
        String summary = "";
        if (db.isShowEventEnd() || db.isShowEventLocation() || db.isShowEventStart() || db.isShowEventStatus() || db.isShowSubjectAgeAtEvent()) {
            summary = summary + respage.getString("you_choose_to_show_event_attributes");
            if (db.isShowEventLocation()) {
                summary = summary + resword.getString("location") + ", ";
            }
            if (db.isShowEventStart()) {
                summary = summary + resword.getString("start_date") + ", ";
            }
            if (db.isShowEventEnd()) {
                summary = summary + resword.getString("end_date") + ", ";
            }
            if (db.isShowEventStatus()) {
                summary = summary + resword.getString("status") + ", ";
            }
            if (db.isShowSubjectAgeAtEvent()) {
                summary = summary + " " + resword.getString("age_at_event") + ", ";
            }
        }
        if (db.isShowSubjectDob() || db.isShowSubjectGender() || db.isShowSubjectStatus() || db.isShowSubjectUniqueIdentifier() || db.isShowSubjectSecondaryId()) {
            summary = (summary = summary.trim()).endsWith(",") ? summary.substring(0, summary.length() - 1) : summary;
            summary = summary + (summary.length() > 0 ? ". " : " ");
            summary = summary + respage.getString("you_choose_to_show_subject_attributes");
            if (db.isShowSubjectDob()) {
                summary = summary + resword.getString("date_year_of_birth") + ", ";
            }
            if (db.isShowSubjectGender()) {
                summary = summary + resword.getString("gender") + ", ";
            }
            if (db.isShowSubjectStatus()) {
                summary = summary + " " + resword.getString("status") + ", ";
            }
            if (db.isShowSubjectUniqueIdentifier()) {
                summary = summary + " " + resword.getString("person_ID") + ", ";
            }
            if (db.isShowSubjectSecondaryId()) {
                summary = summary + " " + resword.getString("secondary_ID") + ", ";
            }
        }
        if (db.isShowCRFcompletionDate() || db.isShowCRFinterviewerDate() || db.isShowCRFinterviewerName() || db.isShowCRFstatus() || db.isShowCRFversion()) {
            summary = (summary = summary.trim()).endsWith(",") ? summary.substring(0, summary.length() - 1) : summary;
            summary = summary + (summary.length() > 0 ? ". " : " ");
            summary = summary + resword.getString("you_choose_to_show_CRF") + ": ";
            if (db.isShowCRFcompletionDate()) {
                summary = summary + " " + resword.getString("completion_date") + ", ";
            }
            if (db.isShowCRFinterviewerDate()) {
                summary = summary + " " + resword.getString("interview_date") + ", ";
            }
            if (db.isShowCRFinterviewerName()) {
                summary = summary + " " + resword.getString("interviewer_name") + ", ";
            }
            if (db.isShowCRFstatus()) {
                summary = summary + " " + resword.getString("CRF_status") + ", ";
            }
            if (db.isShowCRFversion()) {
                summary = summary + " " + resword.getString("CRF_version") + ", ";
            }
        }
        summary = (summary = summary.trim()).endsWith(",") ? summary.substring(0, summary.length() - 1) : summary;
        summary = summary + (summary.length() > 0 ? ". " : " ");
        if (db.isShowSubjectGroupInformation()) {
            summary = summary + resword.getString("you_choose_to_show_subject_group");
        }
        return summary;
    }

    private void getSubAttr(FormProcessor fp, DatasetBean db) {
        String dob = fp.getString("dob");
        if (dob != null && !dob.trim().isEmpty() && "yes".equalsIgnoreCase(dob.trim())) {
            db.setShowSubjectDob(true);
        } else if (db.isShowSubjectDob()) {
            db.setShowSubjectDob(false);
        }
        String gender = fp.getString("gender");
        if (gender != null && !gender.trim().isEmpty() && "yes".equalsIgnoreCase(gender.trim())) {
            db.setShowSubjectGender(true);
        } else if (db.isShowSubjectGender()) {
            db.setShowSubjectGender(false);
        }
        String status = fp.getString("subj_status");
        if (status != null && !status.trim().isEmpty() && "yes".equalsIgnoreCase(status.trim())) {
            db.setShowSubjectStatus(true);
            logger.info("added subject status");
        } else if (db.isShowSubjectStatus()) {
            db.setShowSubjectStatus(false);
        }
        String unique_id = fp.getString("unique_identifier");
        if (unique_id != null && !unique_id.trim().isEmpty() && "yes".equalsIgnoreCase(unique_id.trim())) {
            db.setShowSubjectUniqueIdentifier(true);
            logger.info("added unique id");
        } else if (db.isShowSubjectUniqueIdentifier()) {
            db.setShowSubjectUniqueIdentifier(false);
        }
        String secondary_id = fp.getString("subj_secondary_id");
        if (secondary_id != null && !secondary_id.trim().isEmpty() && "yes".equalsIgnoreCase(secondary_id.trim())) {
            db.setShowSubjectSecondaryId(true);
            logger.info("added secondary id");
        } else if (db.isShowSubjectSecondaryId()) {
            db.setShowSubjectSecondaryId(false);
        }
    }

    private void getEventAttr(FormProcessor fp, DatasetBean db) {
        String location = fp.getString("location");
        if (location != null && !location.trim().isEmpty() && "yes".equalsIgnoreCase(location.trim())) {
            db.setShowEventLocation(true);
        } else if (db.isShowEventLocation()) {
            db.setShowEventLocation(false);
        }
        String start = fp.getString("start");
        if (start != null && !start.trim().isEmpty() && "yes".equalsIgnoreCase(start.trim())) {
            db.setShowEventStart(true);
        } else if (db.isShowEventStart()) {
            db.setShowEventStart(false);
        }
        String end = fp.getString("end");
        if (end != null && !end.trim().isEmpty() && "yes".equalsIgnoreCase(end.trim())) {
            db.setShowEventEnd(true);
        } else if (db.isShowEventEnd()) {
            db.setShowEventEnd(false);
        }
        String status = fp.getString("event_status");
        if (status != null && !status.trim().isEmpty() && "yes".equalsIgnoreCase(status.trim())) {
            db.setShowEventStatus(true);
            logger.info("added event status");
        } else if (db.isShowEventStatus()) {
            db.setShowEventStatus(false);
        }
        String ageatevent = fp.getString("age_at_event");
        if (ageatevent != null && !ageatevent.trim().isEmpty() && "yes".equalsIgnoreCase(ageatevent.trim())) {
            db.setShowSubjectAgeAtEvent(true);
            logger.info("added age at event");
        } else if (db.isShowSubjectAgeAtEvent()) {
            db.setShowSubjectAgeAtEvent(false);
        }
    }

    private void getGroupAttr(FormProcessor fp, DatasetBean db) {
        ArrayList<StudyGroupClassBean> allSelectedGroups = new ArrayList<StudyGroupClassBean>();
        ArrayList allGroups = this.setUpStudyGroups();
        for (int j = 0; j < allGroups.size(); ++j) {
            StudyGroupClassBean sgclass = (StudyGroupClassBean)allGroups.get(j);
            String checked = fp.getString("groupSelected" + sgclass.getId());
            if (checked != null && !checked.trim().isEmpty() && "yes".equalsIgnoreCase(checked.trim())) {
                db.setShowSubjectGroupInformation(true);
                sgclass.setSelected(true);
                logger.info("just set a group to true: " + sgclass.getName());
                if (db.getSubjectGroupIds() != null && !db.getSubjectGroupIds().contains(sgclass.getId())) {
                    db.getSubjectGroupIds().add(new Integer(sgclass.getId()));
                }
            } else {
                sgclass.setSelected(false);
                if (db.getSubjectGroupIds() != null && db.getSubjectGroupIds().contains(sgclass.getId())) {
                    db.getSubjectGroupIds().remove(new Integer(sgclass.getId()));
                }
            }
            allSelectedGroups.add(sgclass);
            logger.info("just added subject group ids: " + sgclass.getId());
        }
        this.session.setAttribute("allSelectedGroups", allSelectedGroups);
        this.request.setAttribute("allSelectedGroups", allSelectedGroups);
        logger.info("added SUBJECT group info");
        if (db.isShowSubjectGroupInformation() && allSelectedGroups.size() == 0) {
            db.setShowSubjectGroupInformation(false);
            logger.info("show subject group info was TRUE, set to FALSE");
        }
    }

    private void getCRFAttr(FormProcessor fp, DatasetBean db) {
        String status = fp.getString("crf_status");
        if (status != null && !status.trim().isEmpty() && "yes".equalsIgnoreCase(status.trim())) {
            db.setShowCRFstatus(true);
            logger.info("added crf status");
        } else if (db.isShowCRFstatus()) {
            db.setShowCRFstatus(false);
        }
        String version = fp.getString("crf_version");
        if (version != null && !version.trim().isEmpty() && "yes".equalsIgnoreCase(version.trim())) {
            db.setShowCRFversion(true);
            logger.info("added crf version");
        } else if (db.isShowCRFversion()) {
            db.setShowCRFversion(false);
        }
        String idate = fp.getString("interviewer_date");
        if (idate != null && !idate.trim().isEmpty() && "yes".equalsIgnoreCase(idate.trim())) {
            db.setShowCRFinterviewerDate(true);
            logger.info("added interviewer date");
        } else if (db.isShowCRFinterviewerDate()) {
            db.setShowCRFinterviewerDate(false);
        }
        String iname = fp.getString("interviewer");
        if (iname != null && !iname.trim().isEmpty() && "yes".equalsIgnoreCase(iname.trim())) {
            db.setShowCRFinterviewerName(true);
            logger.info("added interviewer name");
        } else if (db.isShowCRFinterviewerName()) {
            db.setShowCRFinterviewerName(false);
        }
    }

    private void extractEventIds(DatasetBean db) {
        HashMap dbItemMap;
        ArrayList<Integer> selectedSedIds = new ArrayList<Integer>();
        HashMap hashMap = dbItemMap = db != null ? db.getItemMap() : new HashMap();
        if (dbItemMap.size() > 0) {
            Iterator it = dbItemMap.keySet().iterator();
            while (it.hasNext()) {
                Integer selected = Integer.valueOf(((String)it.next()).split("_")[0].trim());
                if (Integer.valueOf(0).equals(selected) || selectedSedIds.contains(selected)) continue;
                selectedSedIds.add(selected);
            }
        }
        if (selectedSedIds.size() > 0) {
            db.getEventIds().clear();
            db.setEventIds(selectedSedIds);
        }
    }

    public static ArrayList<String> allSedItemIdsInStudy(HashMap<StudyEventDefinitionBean, ?> events, CRFDAO crfdao, ItemDAO idao) {
        ArrayList<String> sedItemIds = new ArrayList<String>();
        for (StudyEventDefinitionBean sed : events.keySet()) {
            ArrayList crfs = crfdao.findAllActiveByDefinition(sed);
            for (int i = 0; i < crfs.size(); ++i) {
                CRFBean crf = (CRFBean)crfs.get(i);
                ArrayList items = idao.findAllActiveByCRF(crf);
                for (ItemBean item : items) {
                    Integer itemId = item.getId();
                    if (sedItemIds.contains(itemId.toString())) continue;
                    sedItemIds.add(sed.getId() + "-" + item.getId());
                }
            }
        }
        return sedItemIds;
    }

    protected DatasetBean finalUpateDatasetBean(DatasetBean db) {
        DatasetBean dsb = db;
        ArrayList<Integer> itemIds = new ArrayList<Integer>();
        HashSet<Integer> ids = new HashSet<Integer>();
        String idList = "item_id in (";
        if (dsb.getItemIds().size() > 0) {
            for (Integer itemId : dsb.getItemIds()) {
                if (ids.contains(itemId)) continue;
                ids.add(itemId);
                itemIds.add(itemId);
                idList = idList + itemId + ", ";
            }
        }
        idList = idList.length() > 12 ? idList.substring(0, idList.length() - 2) : idList;
        dsb.getItemIds().clear();
        dsb.setItemIds(itemIds);
        dsb.setSQLStatement(dsb.sqlWithUniqeItemIds(idList));
        return dsb;
    }
}

