/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.login.PasswordValidator;
import org.akaza.openclinica.core.SecurityManager;
import org.akaza.openclinica.dao.hibernate.ConfigurationDao;
import org.akaza.openclinica.dao.hibernate.PasswordRequirementsDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.lang.StringUtils;

public class UpdateProfileServlet
extends SecureController {
    private static final long serialVersionUID = -2519124535258437372L;

    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean userBean1 = udao.findByUserName(this.ub.getName());
        ArrayList studies = sdao.findAllByUser(this.ub.getName());
        if (StringUtils.isBlank((String)action)) {
            this.request.setAttribute("studies", (Object)studies);
            this.session.setAttribute("userBean1", (Object)userBean1);
            this.forwardPage(Page.UPDATE_PROFILE);
        } else if ("confirm".equalsIgnoreCase(action)) {
            logger.info("confirm");
            this.request.setAttribute("studies", (Object)studies);
            this.confirmProfile(userBean1, udao);
        } else if ("submit".equalsIgnoreCase(action)) {
            logger.info("submit");
            this.submitProfile(udao);
            this.addPageMessage(respage.getString("profile_updated_succesfully"));
            this.ub.incNumVisitsToMainMenu();
            this.forwardPage(Page.MENU_SERVLET);
        }
    }

    private void confirmProfile(UserAccountBean userBean1, UserAccountDAO udao) throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("firstName", 1);
        v.addValidation("lastName", 1);
        v.addValidation("email", 6);
        if (!userBean1.isLdapUser()) {
            v.addValidation("passwdChallengeQuestion", 1);
            v.addValidation("passwdChallengeAnswer", 1);
            v.addValidation("oldPasswd", 1);
            String password = fp.getString("passwd").trim();
            ConfigurationDao configurationDao = (ConfigurationDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(ConfigurationDao.class);
            SecurityManager sm = (SecurityManager)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("securityManager");
            String newDigestPass = sm.encryptPassword(password, userBean1.getRunWebservices().booleanValue());
            List pwdErrors = new ArrayList();
            if (!StringUtils.isBlank((String)password)) {
                v.addValidation("passwd", 15);
                v.addValidation("passwd1", 5, "passwd");
                PasswordRequirementsDao passwordRequirementsDao = new PasswordRequirementsDao(configurationDao);
                Locale locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
                ResourceBundle resexception = ResourceBundleProvider.getExceptionsBundle((Locale)locale);
                pwdErrors = PasswordValidator.validatePassword((PasswordRequirementsDao)passwordRequirementsDao, (UserAccountDAO)udao, (int)userBean1.getId(), (String)password, (String)newDigestPass, (ResourceBundle)resexception);
            }
            v.addValidation("phone", 1);
            this.errors = v.validate();
            for (String err : pwdErrors) {
                Validator.addError((HashMap)this.errors, (String)"passwd", (String)err);
            }
            userBean1.setFirstName(fp.getString("firstName"));
            userBean1.setLastName(fp.getString("lastName"));
            userBean1.setEmail(fp.getString("email"));
            userBean1.setInstitutionalAffiliation(fp.getString("institutionalAffiliation"));
            userBean1.setPasswdChallengeQuestion(fp.getString("passwdChallengeQuestion"));
            userBean1.setPasswdChallengeAnswer(fp.getString("passwdChallengeAnswer"));
            userBean1.setPhone(fp.getString("phone"));
            userBean1.setActiveStudyId(fp.getInt("activeStudyId"));
            StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
            StudyBean newActiveStudy = sdao.findByPK(userBean1.getActiveStudyId());
            this.request.setAttribute("newActiveStudy", (Object)newActiveStudy);
            if (this.errors.isEmpty()) {
                logger.info("no errors");
                this.session.setAttribute("userBean1", (Object)userBean1);
                String oldPass = fp.getString("oldPasswd").trim();
                if (!userBean1.isLdapUser() && !sm.verifyPassword(oldPass, this.getUserDetails())) {
                    Validator.addError((HashMap)this.errors, (String)"oldPasswd", (String)resexception.getString("wrong_old_password"));
                    this.request.setAttribute("formMessages", (Object)this.errors);
                    this.forwardPage(Page.UPDATE_PROFILE);
                } else {
                    if (!StringUtils.isBlank((String)fp.getString("passwd"))) {
                        userBean1.setPasswd(newDigestPass);
                        userBean1.setPasswdTimestamp(new Date());
                    }
                    this.session.setAttribute("userBean1", (Object)userBean1);
                    this.forwardPage(Page.UPDATE_PROFILE_CONFIRM);
                }
            } else {
                logger.info("has validation errors");
                this.session.setAttribute("userBean1", (Object)userBean1);
                this.request.setAttribute("formMessages", (Object)this.errors);
                this.forwardPage(Page.UPDATE_PROFILE);
            }
        }
    }

    private void submitProfile(UserAccountDAO udao) {
        logger.info("user bean to be updated:" + this.ub.getId() + this.ub.getFirstName());
        UserAccountBean userBean1 = (UserAccountBean)this.session.getAttribute("userBean1");
        if (userBean1 != null) {
            userBean1.setLastVisitDate(new Date());
            userBean1.setUpdater(this.ub);
            udao.update(userBean1);
            this.session.setAttribute("userBean", (Object)userBean1);
            this.ub = userBean1;
            this.session.removeAttribute("userBean1");
        }
    }
}

