/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BeanFactory {
    public static final String UNGROUPED = "Ungrouped";
    protected static final Logger logger = LoggerFactory.getLogger((String)"org.akaza.openclinica.control.managestudy.BeanFactory");
    private static Map<String, Map<String, String[]>> cachedResponseLabels = Collections.synchronizedMap(new HashMap());

    public List<DisplayItemGroupBean> createGroupBeans(Map<Integer, Map<String, String>> itemsMap, Map<Integer, Map<String, String>> groupsMap, String sectionLabel, String crfName) {
        ArrayList<DisplayItemGroupBean> groupBeans = new ArrayList<DisplayItemGroupBean>();
        if (groupsMap == null || groupsMap.isEmpty() || sectionLabel == null || sectionLabel.length() < 1 || sectionLabel.equalsIgnoreCase("Ungrouped") || itemsMap == null || itemsMap.isEmpty()) {
            return groupBeans;
        }
        HashMap<Integer, Map<String, String>> newMap = new HashMap<Integer, Map<String, String>>();
        for (Map.Entry<Integer, Map<String, String>> me : itemsMap.entrySet()) {
            Map<String, String> innermap = me.getValue();
            String lab = innermap.get("section_label");
            if (lab == null || !lab.equalsIgnoreCase(sectionLabel)) continue;
            newMap.put(me.getKey(), innermap);
        }
        List displayItems = this.createDisplayItemBeansFromMap(newMap, crfName);
        boolean validGroupFlag = false;
        int ordinal = 0;
        for (DisplayItemBean disBean : displayItems) {
            ItemGroupBean fgBean;
            DisplayItemGroupBean disFgBean;
            String latestGroupLabel = disBean.getMetadata().getGroupLabel();
            if (latestGroupLabel != null && latestGroupLabel.length() > 0 && !latestGroupLabel.equalsIgnoreCase("Ungrouped")) {
                validGroupFlag = true;
                disFgBean = this.getGroupFromLabel(latestGroupLabel, groupBeans);
                if (disFgBean.getItemGroupBean().getName().length() <= 0) {
                    fgBean = this.initFormGroupFromMap(latestGroupLabel, groupsMap);
                    fgBean.getMeta().setOrdinal(Integer.valueOf(++ordinal));
                    disFgBean.setItemGroupBean(fgBean);
                    disFgBean.setGroupMetaBean(fgBean.getMeta());
                    groupBeans.add(disFgBean);
                }
            } else {
                boolean isFirst = this.isFirstUngroupedItem(groupBeans);
                if (validGroupFlag || isFirst) {
                    disFgBean = new DisplayItemGroupBean();
                    fgBean = new ItemGroupBean();
                    fgBean.getMeta().setOrdinal(Integer.valueOf(++ordinal));
                    fgBean.setName("Ungrouped");
                    disFgBean.setItemGroupBean(fgBean);
                    disFgBean.setGroupMetaBean(fgBean.getMeta());
                    groupBeans.add(disFgBean);
                } else {
                    disFgBean = this.getLatestDisFormBeanForOrphanedItems(groupBeans);
                }
                validGroupFlag = false;
            }
            disFgBean.getItems().add(disBean);
        }
        return groupBeans;
    }

    private boolean isFirstUngroupedItem(List<DisplayItemGroupBean> groupBeans) {
        for (DisplayItemGroupBean digBean : groupBeans) {
            if (!digBean.getItemGroupBean().getName().equalsIgnoreCase("Ungrouped")) continue;
            return false;
        }
        return true;
    }

    private DisplayItemGroupBean getLatestDisFormBeanForOrphanedItems(List<DisplayItemGroupBean> beans) {
        if (beans == null || beans.isEmpty()) {
            return new DisplayItemGroupBean();
        }
        LinkedList<DisplayItemGroupBean> list = new LinkedList<DisplayItemGroupBean>();
        for (DisplayItemGroupBean dBean : beans) {
            if (dBean.getItemGroupBean().getName().length() >= 1 && !dBean.getItemGroupBean().getName().equalsIgnoreCase("Ungrouped")) continue;
            list.add(dBean);
        }
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        return (DisplayItemGroupBean)list.getLast();
    }

    private ItemGroupBean initFormGroupFromMap(String groupLabel, Map<Integer, Map<String, String>> groupMap) {
        ItemGroupBean formGroupBean = new ItemGroupBean();
        ItemGroupMetadataBean igMetaBean = new ItemGroupMetadataBean();
        NumberFormat numFormatter = NumberFormat.getInstance();
        numFormatter.setMaximumFractionDigits(0);
        for (Map.Entry<Integer, Map<String, String>> entry : groupMap.entrySet()) {
            String tempValue;
            Map<String, String> groupValues = entry.getValue();
            if (!groupValues.get("group_label").equalsIgnoreCase(groupLabel)) continue;
            formGroupBean.setName(groupLabel);
            igMetaBean.setHeader(groupValues.get("group_header"));
            if (groupValues.get("repeating_group") != null) {
                igMetaBean.setRepeatingGroup(Boolean.parseBoolean(groupValues.get("repeating_group")));
            }
            if ((tempValue = groupValues.get("group_repeat_max")) == null || tempValue.trim().isEmpty()) {
                tempValue = "0";
            } else if ("0.0".equalsIgnoreCase(tempValue)) {
                tempValue = "22000";
            }
            try {
                igMetaBean.setRepeatMax(new Integer(numFormatter.format(Double.parseDouble(tempValue))));
            }
            catch (NumberFormatException nfe) {
                igMetaBean.setRepeatMax(Integer.valueOf(22000));
            }
            tempValue = groupValues.get("group_repeat_number");
            if (igMetaBean.isRepeatingGroup() && (tempValue == null || tempValue.trim().isEmpty())) {
                tempValue = "1";
            } else if (tempValue == null || tempValue.trim().isEmpty()) {
                tempValue = "0";
            } else if ("0.0".equalsIgnoreCase(tempValue)) {
                tempValue = "1";
            }
            try {
                igMetaBean.setRepeatNum(new Integer(numFormatter.format(Double.parseDouble(tempValue))));
            }
            catch (NumberFormatException nfe) {
                igMetaBean.setRepeatNum(Integer.valueOf(1));
            }
        }
        formGroupBean.setMeta(igMetaBean);
        return formGroupBean;
    }

    private DisplayItemGroupBean getGroupFromLabel(String label, List<DisplayItemGroupBean> groupBeans) {
        if (groupBeans == null || groupBeans.isEmpty()) {
            return new DisplayItemGroupBean();
        }
        for (DisplayItemGroupBean dBean : groupBeans) {
            if (!dBean.getItemGroupBean().getName().equalsIgnoreCase(label)) continue;
            return dBean;
        }
        return new DisplayItemGroupBean();
    }

    public ItemGroupBean createFormGroupBeanFromMap(Map<Integer, Map<String, String>> groupMap) {
        ItemGroupBean fBean = new ItemGroupBean();
        NumberFormat numFormatter = NumberFormat.getInstance();
        numFormatter.setMaximumFractionDigits(0);
        for (Map.Entry<Integer, Map<String, String>> me : groupMap.entrySet()) {
            Map<String, String> beanMap = me.getValue();
            fBean.setName(beanMap.get("group_label"));
            String tempValue = beanMap.get("group_repeat_number");
            if ("0.0".equalsIgnoreCase(tempValue)) {
                tempValue = "1";
            }
            try {
                fBean.getMeta().setRepeatNum(new Integer(numFormatter.format(Double.parseDouble(tempValue))));
            }
            catch (NumberFormatException nfe) {
                fBean.getMeta().setRepeatNum(Integer.valueOf(1));
            }
            tempValue = beanMap.get("group_repeat_max");
            if ("0.0".equalsIgnoreCase(tempValue)) {
                tempValue = "22000";
            }
            try {
                fBean.getMeta().setRepeatMax(new Integer(numFormatter.format(Double.parseDouble(tempValue))));
            }
            catch (NumberFormatException nfe) {
                fBean.getMeta().setRepeatMax(Integer.valueOf(22000));
            }
            fBean.getMeta().setHeader(beanMap.get("group_header"));
        }
        return fBean;
    }

    public ArrayList<DisplayItemBean> createChildren(List<DisplayItemBean> childrenItems, DisplayItemBean parent) {
        ArrayList<DisplayItemBean> children = new ArrayList<DisplayItemBean>();
        for (DisplayItemBean bean : childrenItems) {
            if (!bean.getMetadata().getParentLabel().equalsIgnoreCase(parent.getItem().getName())) continue;
            children.add(bean);
        }
        Collections.sort(children, new /* Unavailable Anonymous Inner Class!! */);
        return children;
    }

    public ItemBean createItemBean(Map<String, String> itemValuesMap) {
        ItemBean iBean = new ItemBean();
        String itemDesc = itemValuesMap.get("description_label");
        iBean.setDescription(itemDesc);
        itemDesc = itemValuesMap.get("item_name");
        iBean.setName(itemDesc);
        itemDesc = itemValuesMap.get("units");
        iBean.setUnits(itemDesc);
        String itemDataType = itemValuesMap.get("data_type");
        ItemDataType itemDT = ItemDataType.getByName((String)itemDataType);
        iBean.setItemDataTypeId(itemDT.getId());
        return iBean;
    }

    public ResponseSetBean createResponseSetBean(Map<String, String> itemValuesMap, String crfName) {
        String[] tmpArr;
        ResponseSetBean rBean = new ResponseSetBean();
        String[] innerArray = new String[2];
        String responseType = itemValuesMap.get("response_type");
        String responseLab = itemValuesMap.get("response_label");
        String optionsTxt = itemValuesMap.get("response_options_text");
        String optionsVals = itemValuesMap.get("response_values");
        rBean.setResponseType(ResponseType.getByName((String)responseType));
        rBean.setLabel(itemValuesMap.get("response_label"));
        HashMap<String, String[]> responseLabels = (HashMap<String, String[]>)cachedResponseLabels.get(crfName);
        if (responseLabels == null) {
            responseLabels = new HashMap<String, String[]>();
            cachedResponseLabels.put(crfName, responseLabels);
        }
        if (responseLabels.get(responseLab) == null) {
            innerArray[0] = optionsTxt;
            innerArray[1] = optionsVals;
            responseLabels.put(responseLab, innerArray);
        }
        if (responseLab != null && responseLab.length() != 0 && optionsTxt != null && optionsTxt.length() == 0 && optionsVals != null && optionsVals.length() == 0 && (tmpArr = (String[])responseLabels.get(responseLab)) != null) {
            rBean.setOptions(tmpArr[0], tmpArr[1]);
            return rBean;
        }
        rBean.setOptions(optionsTxt, optionsVals);
        return rBean;
    }

    public ItemFormMetadataBean createItemFormMetadataBean(Map.Entry<Integer, Map<String, String>> me, String crfName) {
        double required;
        if (me == null) {
            return new ItemFormMetadataBean();
        }
        ItemFormMetadataBean metadataBean = new ItemFormMetadataBean();
        NumberFormat numFormatter = NumberFormat.getInstance();
        numFormatter.setMaximumFractionDigits(0);
        metadataBean.setOrdinal(me.getKey().intValue());
        Map<String, String> map = me.getValue();
        metadataBean.setResponseLayout(map.get("response_layout"));
        metadataBean.setDefaultValue(map.get("default_value"));
        metadataBean.setParentLabel(map.get("parent_item"));
        metadataBean.setLeftItemText(map.get("left_item_text"));
        metadataBean.setRightItemText(map.get("right_item_text"));
        metadataBean.setHeader(map.get("header"));
        metadataBean.setSubHeader(map.get("subheader"));
        metadataBean.setGroupLabel(map.get("group_label"));
        String itemPageNum = map.get("page_number");
        try {
            itemPageNum = numFormatter.format(Double.parseDouble(itemPageNum));
        }
        catch (NumberFormatException nfe) {
            itemPageNum = "";
        }
        metadataBean.setPageNumberLabel(itemPageNum);
        String columnNum = map.get("column_number");
        try {
            columnNum = numFormatter.format(Double.parseDouble(columnNum));
            metadataBean.setColumnNumber(Integer.parseInt(columnNum));
        }
        catch (NumberFormatException nfe) {
            metadataBean.setColumnNumber(0);
        }
        String questNum = map.get("question_number");
        metadataBean.setQuestionNumberLabel(questNum);
        String requStr = map.get("required");
        requStr = requStr.equalsIgnoreCase("") ? "0" : requStr;
        try {
            required = Double.parseDouble(requStr);
        }
        catch (NumberFormatException nfe) {
            required = 0.0;
        }
        if (required > 0.0) {
            metadataBean.setRequired(true);
        }
        ResponseSetBean respBean = this.createResponseSetBean(map, crfName);
        metadataBean.setResponseSet(respBean);
        return metadataBean;
    }

    public ItemFormMetadataBean createMetadataBean(Map<String, String> map, int ordinal, String crfName) {
        double required;
        if (map == null) {
            return new ItemFormMetadataBean();
        }
        ItemFormMetadataBean metadataBean = new ItemFormMetadataBean();
        NumberFormat numFormatter = NumberFormat.getInstance();
        numFormatter.setMaximumFractionDigits(0);
        metadataBean.setOrdinal(ordinal);
        metadataBean.setResponseLayout(map.get("response_layout"));
        metadataBean.setParentLabel(map.get("parent_item"));
        metadataBean.setLeftItemText(map.get("left_item_text"));
        metadataBean.setRightItemText(map.get("right_item_text"));
        metadataBean.setDefaultValue(map.get("default_value"));
        metadataBean.setHeader(map.get("header"));
        metadataBean.setSubHeader(map.get("subheader"));
        String itemPageNum = map.get("page_number");
        try {
            itemPageNum = numFormatter.format(Double.parseDouble(itemPageNum));
        }
        catch (NumberFormatException nfe) {
            itemPageNum = "";
        }
        metadataBean.setPageNumberLabel(itemPageNum);
        String columnNum = map.get("column_number");
        try {
            columnNum = numFormatter.format(Double.parseDouble(columnNum));
            metadataBean.setColumnNumber(Integer.parseInt(columnNum));
        }
        catch (NumberFormatException nfe) {
            metadataBean.setColumnNumber(0);
        }
        String questNum = map.get("question_number");
        try {
            questNum = numFormatter.format(Double.parseDouble(questNum));
        }
        catch (NumberFormatException nfe) {
            questNum = "";
        }
        metadataBean.setQuestionNumberLabel(questNum);
        String requStr = map.get("required");
        requStr = requStr.equalsIgnoreCase("") ? "0" : requStr;
        try {
            required = Double.parseDouble(requStr);
        }
        catch (NumberFormatException nfe) {
            required = 0.0;
        }
        if (required > 0.0) {
            metadataBean.setRequired(true);
        }
        ResponseSetBean respBean = this.createResponseSetBean(map, crfName);
        metadataBean.setResponseSet(respBean);
        return metadataBean;
    }

    public DisplaySectionBean createDisplaySectionBean(Map<Integer, Map<String, String>> map, String sectionTitle, String sectionLabel, String sectionSubtitle, String instructions, String crfName, int sectionBorders) {
        if (map == null) {
            return new DisplaySectionBean();
        }
        SectionBean sbean = new SectionBean();
        sbean.setTitle(sectionTitle);
        sbean.setSubtitle(sectionSubtitle);
        sbean.setInstructions(instructions);
        sbean.setBorders(sectionBorders);
        DisplaySectionBean displaySectionBean = new DisplaySectionBean();
        displaySectionBean.setSection(sbean);
        ArrayList<DisplayItemBean> allDisplayItems = new ArrayList<DisplayItemBean>();
        ArrayList<DisplayItemBean> childrenItems = new ArrayList<DisplayItemBean>();
        Iterator<Map.Entry<Integer, Map<String, String>>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            DisplayItemBean displayItem = new DisplayItemBean();
            Map.Entry<Integer, Map<String, String>> me = iter.next();
            if (!this.itemSecLabelMatchesSection(me, sectionLabel)) continue;
            ItemFormMetadataBean itemMeta = this.createItemFormMetadataBean(me, crfName);
            displayItem.setMetadata(itemMeta);
            Map<String, String> innerMap = me.getValue();
            displayItem.setItem(this.createItemBean(innerMap));
            String parentName = displayItem.getMetadata().getParentLabel();
            if (parentName.length() > 0 && !displayItem.getItem().getName().equalsIgnoreCase(parentName)) {
                displayItem.getMetadata().setParentId(1);
                childrenItems.add(displayItem);
                continue;
            }
            allDisplayItems.add(displayItem);
        }
        for (DisplayItemBean parentBean : allDisplayItems) {
            parentBean.setChildren(this.createChildren(childrenItems, parentBean));
        }
        Collections.sort(allDisplayItems);
        displaySectionBean.setItems(allDisplayItems);
        return displaySectionBean;
    }

    public ArrayList<ItemBean> createItemBeanList(Map<Integer, Map<String, String>> itemsMap, String secLabel, String crfName) {
        if (itemsMap == null) {
            return new ArrayList<ItemBean>();
        }
        ArrayList<ItemBean> itemList = new ArrayList<ItemBean>();
        NumberFormat numFormatter = NumberFormat.getInstance();
        numFormatter.setMaximumFractionDigits(0);
        for (Map.Entry<Integer, Map<String, String>> me : itemsMap.entrySet()) {
            Map<String, String> innerMap = me.getValue();
            String itemSectionLabel = innerMap.get("section_label");
            if (!itemSectionLabel.equalsIgnoreCase(secLabel)) continue;
            ItemBean itemBean = this.createItemBean(innerMap);
            ItemFormMetadataBean metaBean = this.createItemFormMetadataBean(me, crfName);
            itemBean.setItemMeta(metaBean);
            itemList.add(itemBean);
        }
        return itemList;
    }

    public List<SectionBean> createSectionBeanList(Map<Integer, Map<String, String>> sectionsMap, Map<Integer, Map<String, String>> itemsMap, String crfName, Map<Integer, Map<String, String>> groupsMap) {
        if (sectionsMap == null || itemsMap == null) {
            return new ArrayList<SectionBean>();
        }
        ArrayList<SectionBean> secsList = new ArrayList();
        NumberFormat numFormatter = NumberFormat.getInstance();
        numFormatter.setMaximumFractionDigits(0);
        Iterator<Map.Entry<Integer, Map<String, String>>> iter = sectionsMap.entrySet().iterator();
        while (iter.hasNext()) {
            SectionBean secBean = new SectionBean();
            Map.Entry<Integer, Map<String, String>> me = iter.next();
            Map<String, String> sectionVals = me.getValue();
            String sectionLabel = sectionVals.get("section_label");
            secBean.setName(sectionLabel);
            int borders = 0;
            String bordersTemp = sectionVals.get("borders");
            if (bordersTemp != null) {
                borders = new Integer(bordersTemp);
            }
            secBean.setBorders(borders);
            secBean.setParent(BeanFactory.createSectionBean((String)sectionVals.get("parent_section")));
            secBean.setTitle(sectionVals.get("section_title"));
            secBean.setSubtitle(sectionVals.get("subtitle"));
            secBean.setInstructions(sectionVals.get("instructions"));
            String pagNumber = sectionVals.get("page_number");
            try {
                pagNumber = numFormatter.format(Double.parseDouble(pagNumber));
            }
            catch (NumberFormatException nfe) {
                pagNumber = "0";
            }
            secBean.setItems(this.createItemBeanList(itemsMap, sectionLabel, crfName));
            secBean.setPageNumberLabel(pagNumber);
            secsList.add(secBean);
        }
        secsList = this.addPreviewGroupsInfo(secsList, groupsMap);
        return secsList;
    }

    public List<SectionBean> addPreviewGroupsInfo(List<SectionBean> secsList, Map<Integer, Map<String, String>> groupsMap) {
        if (secsList == null || secsList.isEmpty()) {
            return secsList;
        }
        ItemGroupBean groupBean = new ItemGroupBean();
        String groupLabel = "";
        for (Map.Entry<Integer, Map<String, String>> entry : groupsMap.entrySet()) {
            Map<String, String> groupValues = entry.getValue();
            groupLabel = groupValues.get("group_label");
            groupBean = this.initFormGroupFromMap(groupLabel, groupsMap);
            for (SectionBean secBean : secsList) {
                if (!this.sectionHasGroup(groupLabel, secBean)) continue;
                secBean.getGroups().add(groupBean);
            }
        }
        return secsList;
    }

    private boolean sectionHasGroup(String groupLabel, SectionBean secBean) {
        for (Object itemObj : secBean.getItems()) {
            if (!((ItemBean)itemObj).getItemMeta().getGroupLabel().equalsIgnoreCase(groupLabel)) continue;
            return true;
        }
        return false;
    }

    private boolean itemSecLabelMatchesSection(Map.Entry<Integer, Map<String, String>> me, String sectionLabel) {
        Map<String, String> map = me.getValue();
        String tmp = map.get("section_label");
        return tmp.equalsIgnoreCase(sectionLabel);
    }

    public List<DisplayItemBean> createDisplayItemBeansFromMap(Map<Integer, Map<String, String>> itemsMap, String crfName) {
        ArrayList<DisplayItemBean> allDisplayItems = new ArrayList<DisplayItemBean>();
        Iterator<Map.Entry<Integer, Map<String, String>>> iter = itemsMap.entrySet().iterator();
        while (iter.hasNext()) {
            DisplayItemBean displayItem = new DisplayItemBean();
            Map.Entry<Integer, Map<String, String>> me = iter.next();
            ItemFormMetadataBean itemMeta = this.createItemFormMetadataBean(me, crfName);
            Map<String, String> innerMap = me.getValue();
            String labeltmp = innerMap.get("group_label");
            if (labeltmp.length() < 1) {
                itemMeta.setGroupLabel("Ungrouped");
            } else {
                itemMeta.setGroupLabel(labeltmp);
            }
            displayItem.setMetadata(itemMeta);
            displayItem.setItem(this.createItemBean(innerMap));
            allDisplayItems.add(displayItem);
        }
        Collections.sort(allDisplayItems);
        return allDisplayItems;
    }

    public static SectionBean createSectionBean(String secLabel) {
        return new SectionBean();
    }
}

