/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.GroupClassType;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyGroupBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class CreateSubjectGroupClassServlet
extends SecureController {
    private static final long serialVersionUID = 8536912009639036567L;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, respage.getString("current_study_locked"));
        this.checkStudyFrozen(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, respage.getString("current_study_frozen"));
        if (this.currentStudy.getParentStudyId() > 0) {
            this.addPageMessage(respage.getString("subject_group_class_only_added_top_level") + " " + respage.getString("please_contact_sysadmin_questions"));
            throw new InsufficientPermissionException(Page.SUBJECT_GROUP_CLASS_LIST, resexception.getString("not_top_study"), "1");
        }
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SUBJECT_GROUP_CLASS_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        if (action == null || action.trim().isEmpty()) {
            ArrayList<StudyGroupBean> studyGroups = new ArrayList<StudyGroupBean>();
            for (int i = 0; i < 10; ++i) {
                studyGroups.add(new StudyGroupBean());
            }
            StudyGroupClassBean group = new StudyGroupClassBean();
            this.request.setAttribute("groupTypes", (Object)GroupClassType.toArrayList());
            this.session.setAttribute("group", (Object)group);
            this.session.setAttribute("studyGroups", studyGroups);
            this.forwardPage(Page.CREATE_SUBJECT_GROUP_CLASS);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmGroup();
        } else if ("submit".equalsIgnoreCase(action)) {
            this.submitGroup();
        }
    }

    private void confirmGroup() throws Exception {
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("subjectAssignment", 1);
        v.addValidation("name", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 30);
        v.addValidation("subjectAssignment", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 30);
        ArrayList<StudyGroupBean> studyGroups = new ArrayList<StudyGroupBean>();
        for (int i = 0; i < 10; ++i) {
            String name = fp.getString("studyGroup" + i);
            String description = fp.getString("studyGroupDescription" + i);
            if (name == null || name.trim().isEmpty()) continue;
            StudyGroupBean group = new StudyGroupBean();
            group.setName(name);
            group.setDescription(description);
            studyGroups.add(group);
            if (name.length() > 255) {
                this.request.setAttribute("studyGroupError", (Object)respage.getString("group_name_cannot_be_more_255"));
                break;
            }
            if (description.length() <= 1000) continue;
            this.request.setAttribute("studyGroupError", (Object)respage.getString("group_description_cannot_be_more_100"));
            break;
        }
        this.errors = v.validate();
        if (fp.getInt("groupClassTypeId") == 0) {
            Validator.addError((HashMap)this.errors, (String)"groupClassTypeId", (String)resexception.getString("group_class_type_is_required"));
        }
        StudyGroupClassBean group = new StudyGroupClassBean();
        group.setName(fp.getString("name"));
        group.setGroupClassTypeId(fp.getInt("groupClassTypeId"));
        group.setSubjectAssignment(fp.getString("subjectAssignment"));
        this.session.setAttribute("group", (Object)group);
        this.session.setAttribute("studyGroups", studyGroups);
        if (this.errors.isEmpty()) {
            logger.info("no errors in the first section");
            group.setGroupClassTypeName(GroupClassType.get((int)group.getGroupClassTypeId()).getName());
            this.forwardPage(Page.CREATE_SUBJECT_GROUP_CLASS_CONFIRM);
        } else {
            logger.info("has validation errors in the first section");
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("groupTypes", (Object)GroupClassType.toArrayList());
            this.forwardPage(Page.CREATE_SUBJECT_GROUP_CLASS);
        }
    }

    private void submitGroup() throws OpenClinicaException, IOException {
        StudyGroupClassBean group = (StudyGroupClassBean)this.session.getAttribute("group");
        ArrayList studyGroups = ClassCastHelper.asArrayList((Object)this.session.getAttribute("studyGroups"), StudyGroupBean.class);
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        group.setStudyId(this.currentStudy.getId());
        group.setOwner(this.ub);
        group.setStatus(Status.AVAILABLE);
        group = sgcdao.create(group);
        if (!group.isActive()) {
            this.addPageMessage(respage.getString("the_subject_group_class_not_created_database"));
        } else {
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            for (int i = 0; i < studyGroups.size(); ++i) {
                StudyGroupBean sg = (StudyGroupBean)studyGroups.get(i);
                sg.setStudyGroupClassId(group.getId());
                sg.setOwner(this.ub);
                sg.setStatus(Status.AVAILABLE);
                sgdao.create(sg);
            }
            this.addPageMessage(respage.getString("the_subject_group_class_created_succesfully"));
        }
        ArrayList pageMessages = ClassCastHelper.asArrayList((Object)this.request.getAttribute("pageMessages"), String.class);
        this.session.setAttribute("pageMessages", (Object)pageMessages);
        this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
    }
}

