/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.Date;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class DeleteStudyEventServlet
extends SecureController {
    private static final long serialVersionUID = 2156394172493768917L;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_frozen"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int studyEventId = fp.getInt("id");
        int studySubId = fp.getInt("studySubId");
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        if (studyEventId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_SE_to_remove"));
            this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
        } else {
            StudyEventBean event = sedao.findByPK(studyEventId);
            StudySubjectBean studySub = subdao.findByPK(studySubId);
            this.request.setAttribute("studySub", (Object)studySub);
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDefinitionBean sed = seddao.findByPK(event.getStudyEventDefinitionId());
            event.setStudyEventDefinition(sed);
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyBean study = studydao.findByPK(studySub.getStudyId());
            String action = this.request.getParameter("action");
            if ("confirm".equalsIgnoreCase(action)) {
                DisplayStudyEventBean de = new DisplayStudyEventBean();
                de.setStudyEvent(event);
                this.request.setAttribute("displayEvent", (Object)de);
                this.forwardPage(Page.DELETE_STUDY_EVENT);
            } else {
                logger.info("submit to delete the event from study");
                event.setSubjectEventStatus(SubjectEventStatus.NOT_SCHEDULED);
                event.setUpdater(this.ub);
                event.setUpdatedDate(new Date());
                sedao.update(event);
                String emailBody = respage.getString("the_event") + " " + event.getStudyEventDefinition().getName() + " " + respage.getString("has_been_removed_from_the_subject_record_for") + " " + studySub.getLabel() + " " + respage.getString("in_the_study") + " " + study.getName() + ".";
                this.addPageMessage(emailBody);
                this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            }
        }
    }
}

