/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.PrintCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.view.display.DisplaySectionBeanHandler;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class PrintAllSiteEventCRFServlet
extends DataEntryServlet {
    private static final long serialVersionUID = 8999240611049740466L;
    Locale locale;

    public void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        if (ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)ub, (StudyUserRoleBean)currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"), request);
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FormProcessor fp = new FormProcessor(request);
        int siteId = fp.getInt("siteId");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        SectionBean sb = (SectionBean)request.getAttribute("section_bean");
        StudyEventDefinitionDAO sedao = new StudyEventDefinitionDAO(this.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.getDataSource());
        StudyDAO studyDao = new StudyDAO(this.getDataSource());
        StudyBean site = studyDao.findByPK(siteId);
        ArrayList seds = new ArrayList();
        seds = sedao.findAllByStudy(site);
        CRFVersionDAO cvdao = new CRFVersionDAO(this.getDataSource());
        CRFDAO cdao = new CRFDAO(this.getDataSource());
        boolean isSubmitted = false;
        ArrayList edcs = new ArrayList();
        for (StudyEventDefinitionBean sed : seds) {
            int defId = sed.getId();
            edcs.addAll(edcdao.findAllByDefinitionAndSiteIdAndParentStudyId(defId, siteId, site.getParentStudyId()));
        }
        LinkedHashMap<StudyEventDefinitionBean, ArrayList<CRFVersionBean>> eventDefinitionDefaultVersions = new LinkedHashMap<StudyEventDefinitionBean, ArrayList<CRFVersionBean>>();
        LinkedHashMap<StudyEventDefinitionBean, EventDefinitionCRFBean> eventDefinitionEventDefCrf = new LinkedHashMap<StudyEventDefinitionBean, EventDefinitionCRFBean>();
        for (int i = 0; i < edcs.size(); ++i) {
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)edcs.get(i);
            if (!edc.getStatus().equals((Term)Status.AVAILABLE)) continue;
            ArrayList versions = cvdao.findAllByCRF(edc.getCrfId());
            edc.setVersions(versions);
            CRFBean crf = cdao.findByPK(edc.getCrfId());
            edc.setCrfName(crf.getName());
            if (crf.getStatus().equals((Term)Status.AVAILABLE)) {
                edc.setOwner(crf.getOwner());
            }
            CRFVersionBean defaultVersion = cvdao.findByPK(edc.getDefaultVersionId());
            StudyEventDefinitionBean studyEventDefinitionBean = sedao.findByPK(edc.getStudyEventDefinitionId());
            edc.setDefaultVersionName(defaultVersion.getName());
            if (!defaultVersion.getStatus().isAvailable()) continue;
            ArrayList<CRFVersionBean> list = (ArrayList<CRFVersionBean>)eventDefinitionDefaultVersions.get(studyEventDefinitionBean);
            if (list == null) {
                list = new ArrayList<CRFVersionBean>();
            }
            list.add(defaultVersion);
            eventDefinitionDefaultVersions.put(studyEventDefinitionBean, list);
            eventDefinitionEventDefCrf.put(studyEventDefinitionBean, edc);
        }
        String isIE = fp.getString("ie");
        if ("y".equalsIgnoreCase(isIE)) {
            request.setAttribute("isInternetExplorer", (Object)"true");
        }
        SectionDAO sdao = new SectionDAO(this.getDataSource());
        CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.getDataSource());
        CRFDAO crfDao = new CRFDAO(this.getDataSource());
        LinkedHashMap<StudyEventDefinitionBean, ArrayList<PrintCRFBean>> sedCrfBeans = null;
        for (StudyEventDefinitionBean sedBean : eventDefinitionDefaultVersions.keySet()) {
            if (sedCrfBeans == null) {
                sedCrfBeans = new LinkedHashMap<StudyEventDefinitionBean, ArrayList<PrintCRFBean>>();
            }
            ArrayList crfVersions = (ArrayList)eventDefinitionDefaultVersions.get(sedBean);
            for (CRFVersionBean crfVersionBean : crfVersions) {
                ArrayList<SectionBean> allSectionBeans = new ArrayList<SectionBean>();
                ArrayList sectionBeans = new ArrayList();
                ItemGroupDAO itemGroupDao = new ItemGroupDAO(this.getDataSource());
                List itemGroupBeans = itemGroupDao.findOnlyGroupsByCRFVersionID(crfVersionBean.getId());
                CRFBean crfBean = crfDao.findByVersionId(crfVersionBean.getId());
                if (itemGroupBeans.size() > 0) {
                    DisplaySectionBeanHandler handler = new DisplaySectionBeanHandler(false, this.getDataSource(), this.getServletContext());
                    handler.setCrfVersionId(crfVersionBean.getId());
                    List displaySectionBeans = handler.getDisplaySectionBeans();
                    request.setAttribute("listOfDisplaySectionBeans", (Object)displaySectionBeans);
                    CRFVersionBean crfverBean = crfVersionDAO.findByPK(crfVersionBean.getId());
                    request.setAttribute("crfVersionBean", (Object)crfverBean);
                    request.setAttribute("crfBean", (Object)crfBean);
                    request.setAttribute("dataInvolved", (Object)"false");
                    PrintCRFBean printCrfBean = new PrintCRFBean();
                    printCrfBean.setDisplaySectionBeans(displaySectionBeans);
                    printCrfBean.setCrfVersionBean(crfVersionBean);
                    printCrfBean.setCrfBean(crfBean);
                    printCrfBean.setEventCrfBean(ecb);
                    printCrfBean.setGrouped(true);
                    ArrayList<PrintCRFBean> list = (ArrayList<PrintCRFBean>)sedCrfBeans.get(sedBean);
                    if (list == null) {
                        list = new ArrayList<PrintCRFBean>();
                    }
                    list.add(printCrfBean);
                    sedCrfBeans.put(sedBean, list);
                    continue;
                }
                ecb = new EventCRFBean();
                ecb.setCRFVersionId(crfVersionBean.getId());
                CRFVersionBean version = crfVersionDAO.findByPK(crfVersionBean.getId());
                ArrayList sects = sdao.findByVersionId(version.getId());
                for (int i = 0; i < sects.size(); ++i) {
                    sb = (SectionBean)sects.get(i);
                    int sectId = sb.getId();
                    if (sectId <= 0) continue;
                    allSectionBeans.add(sdao.findByPK(sectId));
                }
                EventDefinitionCRFBean edcBean = (EventDefinitionCRFBean)eventDefinitionEventDefCrf.get(sedBean);
                request.setAttribute("event_def_crf_bean", (Object)edcBean);
                request.setAttribute("event", (Object)ecb);
                request.setAttribute("section_bean", (Object)sb);
                request.setAttribute("all_section_bean", allSectionBeans);
                sectionBeans = super.getAllDisplayBeans(request);
                DisplaySectionBean dsb = super.getDisplayBean(false, false, request, isSubmitted);
                PrintCRFBean printCrfBean = new PrintCRFBean();
                printCrfBean.setAllSections((List)sectionBeans);
                printCrfBean.setDisplaySectionBean(dsb);
                printCrfBean.setEventCrfBean(ecb);
                printCrfBean.setCrfVersionBean(crfVersionBean);
                printCrfBean.setCrfBean(crfBean);
                printCrfBean.setGrouped(false);
                ArrayList<PrintCRFBean> list = (ArrayList<PrintCRFBean>)sedCrfBeans.get(sedBean);
                if (list == null) {
                    list = new ArrayList<PrintCRFBean>();
                }
                list.add(printCrfBean);
                sedCrfBeans.put(sedBean, list);
            }
        }
        StudyBean parentStudy = studyDao.findByPK(site.getParentStudyId());
        String studyName = parentStudy.getName();
        String siteName = site.getName();
        request.setAttribute("sedCrfBeans", sedCrfBeans);
        request.setAttribute("studyName", (Object)studyName);
        request.setAttribute("site", (Object)siteName);
        this.forwardPage(Page.VIEW_ALL_SITE_DEFAULT_CRF_VERSIONS_PRINT, request, response);
    }

    protected Status getBlankItemStatus() {
        return Status.AVAILABLE;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        return edcb.isDoubleEntry() ? Status.PENDING : Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getAnnotations();
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setAnnotations(annotations);
    }

    protected Page getJSPPage() {
        return Page.VIEW_SECTION_DATA_ENTRY;
    }

    protected String getServletPage(HttpServletRequest request) {
        return Page.VIEW_SECTION_DATA_ENTRY_SERVLET.getFileName();
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        dib = this.loadFormValue(dib, request);
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        return formGroups;
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        return true;
    }

    protected boolean shouldRunRules() {
        return false;
    }

    protected boolean isAdministrativeEditing() {
        return false;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        return false;
    }
}

