/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.PrintCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.DisplaySectionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.DataEntryServlet;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.view.display.DisplaySectionBeanHandler;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class PrintEventCRFServlet
extends DataEntryServlet {
    private static final long serialVersionUID = -2429929031727045805L;
    Locale locale;

    public void mayProceed(HttpServletRequest request, HttpServletResponse response) throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        if (ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)ub, (StudyUserRoleBean)currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"), request);
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FormProcessor fp = new FormProcessor(request);
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        SectionBean sb = (SectionBean)request.getAttribute("section_bean");
        int eventCRFId = fp.getInt("ecId");
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        StudyEventDefinitionDAO sedao = new StudyEventDefinitionDAO(this.getDataSource());
        int defId = fp.getInt("id", true);
        boolean isSubmitted = false;
        if (defId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_definition_to_view"), request);
            this.forwardPage(Page.LIST_DEFINITION_SERVLET, request, response);
        } else {
            StudyEventDefinitionBean sed = sedao.findByPK(defId);
            EventDefinitionCRFDAO edao = new EventDefinitionCRFDAO(this.getDataSource());
            ArrayList eventDefinitionCRFs = edao.findAllByDefinition(defId);
            CRFVersionDAO cvdao = new CRFVersionDAO(this.getDataSource());
            CRFDAO cdao = new CRFDAO(this.getDataSource());
            ArrayList<CRFVersionBean> defaultVersions = new ArrayList<CRFVersionBean>();
            for (int i = 0; i < eventDefinitionCRFs.size(); ++i) {
                CRFVersionBean defaultVersion;
                EventDefinitionCRFBean edc = (EventDefinitionCRFBean)eventDefinitionCRFs.get(i);
                ArrayList versions = cvdao.findAllByCRF(edc.getCrfId());
                edc.setVersions(versions);
                CRFBean crf = cdao.findByPK(edc.getCrfId());
                edc.setCrfName(crf.getName());
                if (crf.getStatus().equals((Term)Status.AVAILABLE)) {
                    edc.setOwner(crf.getOwner());
                }
                if (defaultVersions.contains(defaultVersion = cvdao.findByPK(edc.getDefaultVersionId()))) continue;
                edc.setDefaultVersionName(defaultVersion.getName());
                if (!edc.getStatus().isAvailable()) continue;
                defaultVersions.add(defaultVersion);
            }
            String isIE = fp.getString("ie");
            if ("y".equalsIgnoreCase(isIE)) {
                request.setAttribute("isInternetExplorer", (Object)"true");
            }
            SectionDAO sdao = new SectionDAO(this.getDataSource());
            CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.getDataSource());
            CRFDAO crfDao = new CRFDAO(this.getDataSource());
            ArrayList<PrintCRFBean> printCrfBeans = new ArrayList<PrintCRFBean>();
            for (CRFVersionBean crfVersionBean : defaultVersions) {
                PrintCRFBean printCrfBean;
                ArrayList<SectionBean> allSectionBeans = new ArrayList<SectionBean>();
                ArrayList sectionBeans = new ArrayList();
                ItemGroupDAO itemGroupDao = new ItemGroupDAO(this.getDataSource());
                List itemGroupBeans = itemGroupDao.findOnlyGroupsByCRFVersionID(crfVersionBean.getId());
                CRFBean crfBean = crfDao.findByVersionId(crfVersionBean.getId());
                if (itemGroupBeans.size() > 0) {
                    DisplaySectionBeanHandler handler = new DisplaySectionBeanHandler(false, this.getDataSource(), this.getServletContext());
                    handler.setCrfVersionId(crfVersionBean.getId());
                    handler.setEventCRFId(eventCRFId);
                    List displaySectionBeans = handler.getDisplaySectionBeans();
                    request.setAttribute("listOfDisplaySectionBeans", (Object)displaySectionBeans);
                    CRFVersionBean crfverBean = crfVersionDAO.findByPK(crfVersionBean.getId());
                    request.setAttribute("crfVersionBean", (Object)crfverBean);
                    request.setAttribute("crfBean", (Object)crfBean);
                    request.setAttribute("dataInvolved", (Object)"false");
                    printCrfBean = new PrintCRFBean();
                    printCrfBean.setDisplaySectionBeans(displaySectionBeans);
                    printCrfBean.setCrfVersionBean(crfVersionBean);
                    printCrfBean.setCrfBean(crfBean);
                    printCrfBean.setEventCrfBean(ecb);
                    printCrfBeans.add(printCrfBean);
                    printCrfBean.setGrouped(true);
                    continue;
                }
                ecb = new EventCRFBean();
                ecb.setCRFVersionId(crfVersionBean.getId());
                CRFVersionBean version = crfVersionDAO.findByPK(crfVersionBean.getId());
                ArrayList sects = sdao.findByVersionId(version.getId());
                for (int i = 0; i < sects.size(); ++i) {
                    sb = (SectionBean)sects.get(i);
                    int sectId = sb.getId();
                    if (sectId <= 0) continue;
                    allSectionBeans.add(sdao.findByPK(sectId));
                }
                request.setAttribute("all_section_bean", allSectionBeans);
                request.setAttribute("event", (Object)ecb);
                sectionBeans = super.getAllDisplayBeans(request);
                request.setAttribute("section_bean", (Object)sb);
                DisplaySectionBean dsb = super.getDisplayBean(false, false, request, isSubmitted);
                printCrfBean = new PrintCRFBean();
                printCrfBean.setAllSections((List)sectionBeans);
                printCrfBean.setDisplaySectionBean(dsb);
                printCrfBean.setEventCrfBean(ecb);
                printCrfBean.setCrfVersionBean(crfVersionBean);
                printCrfBean.setCrfBean(crfBean);
                printCrfBeans.add(printCrfBean);
                printCrfBean.setGrouped(false);
            }
            String studyName = null;
            String siteName = null;
            if (currentStudy.getParentStudyId() > 0) {
                studyName = currentStudy.getParentStudyName();
                siteName = currentStudy.getName();
            } else {
                studyName = currentStudy.getName();
            }
            request.setAttribute("printCrfBeans", printCrfBeans);
            request.setAttribute("studyName", (Object)studyName);
            request.setAttribute("site", (Object)siteName);
            request.setAttribute("eventDefinition", (Object)sed.getName());
            this.forwardPage(Page.VIEW_DEFAULT_CRF_VERSIONS_PRINT, request, response);
        }
    }

    protected Status getBlankItemStatus() {
        return Status.AVAILABLE;
    }

    protected Status getNonBlankItemStatus(HttpServletRequest request) {
        EventDefinitionCRFBean edcb = (EventDefinitionCRFBean)request.getAttribute("event_def_crf_bean");
        return edcb.isDoubleEntry() ? Status.PENDING : Status.UNAVAILABLE;
    }

    protected String getEventCRFAnnotations(HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        return ecb.getAnnotations();
    }

    protected void setEventCRFAnnotations(String annotations, HttpServletRequest request) {
        EventCRFBean ecb = (EventCRFBean)request.getAttribute("event");
        ecb.setAnnotations(annotations);
    }

    protected Page getJSPPage() {
        return Page.VIEW_SECTION_DATA_ENTRY;
    }

    protected String getServletPage(HttpServletRequest request) {
        return Page.VIEW_SECTION_DATA_ENTRY_SERVLET.getFileName();
    }

    protected boolean validateInputOnFirstRound() {
        return true;
    }

    protected DisplayItemBean validateDisplayItemBean(DiscrepancyValidator v, DisplayItemBean dib, String inputName, HttpServletRequest request) {
        ResponseType rt = dib.getMetadata().getResponseSet().getResponseType();
        dib = this.loadFormValue(dib, request);
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            dib = this.validateDisplayItemBeanSingleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            dib = this.validateDisplayItemBeanMultipleCV(v, dib, inputName);
        } else if (rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            dib = this.validateDisplayItemBeanText(v, dib, inputName, request);
        }
        return dib;
    }

    protected List<DisplayItemGroupBean> validateDisplayItemGroupBean(DiscrepancyValidator v, DisplayItemGroupBean digb, List<DisplayItemGroupBean> digbs, List<DisplayItemGroupBean> formGroups, HttpServletRequest request, HttpServletResponse response) {
        return formGroups;
    }

    protected boolean shouldLoadDBValues(DisplayItemBean dib) {
        return true;
    }

    protected boolean shouldRunRules() {
        return false;
    }

    protected boolean isAdministrativeEditing() {
        return false;
    }

    protected boolean isAdminForcedReasonForChange(HttpServletRequest request) {
        return false;
    }
}

