/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.Date;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveStudyUserRoleServlet
extends SecureController {
    private static final long serialVersionUID = 9002693250126772488L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_USER_IN_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        String name = this.request.getParameter("name");
        String studyIdString = this.request.getParameter("studyId");
        if (name == null || name.trim().isEmpty() || studyIdString == null || studyIdString.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_user_to_remove_his_role"));
            this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
        } else {
            String action = this.request.getParameter("action");
            UserAccountBean user = udao.findByUserName(name);
            if ("confirm".equalsIgnoreCase(action)) {
                int studyId = Integer.valueOf(studyIdString.trim());
                this.request.setAttribute("user", (Object)user);
                StudyUserRoleBean uRole = udao.findRoleByUserNameAndStudyId(name, studyId);
                this.request.setAttribute("uRole", (Object)uRole);
                StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
                StudyBean study = sdao.findByPK(studyId);
                this.request.setAttribute("uStudy", (Object)study);
                this.forwardPage(Page.REMOVE_USER_ROLE_IN_STUDY);
            } else {
                FormProcessor fp = new FormProcessor(this.request);
                String userName = fp.getString("name");
                int studyId = fp.getInt("studyId");
                int roleId = fp.getInt("roleId");
                StudyUserRoleBean sur = new StudyUserRoleBean();
                sur.setName(userName);
                sur.setRole(Role.get((int)roleId));
                sur.setStudyId(studyId);
                sur.setStatus(Status.DELETED);
                sur.setUpdater(this.ub);
                sur.setUpdatedDate(new Date());
                udao.updateStudyUserRole(sur, userName);
                this.addPageMessage(this.sendEmail(user, sur));
                this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
            }
        }
    }

    private String sendEmail(UserAccountBean u, StudyUserRoleBean sub) throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = sdao.findByPK(sub.getStudyId());
        logger.info("Sending email...");
        String body = u.getFirstName() + " " + u.getLastName() + "(" + resword.getString("username") + ": " + u.getName() + ") " + respage.getString("has_been_removed_from_the_study_site") + study.getName() + " " + respage.getString("with_role") + " " + sub.getRoleName() + ". " + respage.getString("the_user_will_no_longer_access_to_the_study");
        return body;
    }
}

