/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.Date;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreStudyUserRoleServlet
extends SecureController {
    private static final long serialVersionUID = 1772512586472947684L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_USER_IN_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        String name = this.request.getParameter("name");
        String studyIdString = this.request.getParameter("studyId");
        if (name == null || name.trim().isEmpty() || studyIdString == null || studyIdString.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_user_to_restore_his_role"));
            this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
        } else {
            String action = this.request.getParameter("action");
            int studyId = Integer.valueOf(studyIdString.trim());
            StudyBean study = sdao.findByPK(studyId);
            UserAccountBean user = udao.findByUserName(name);
            if ("confirm".equalsIgnoreCase(action)) {
                this.request.setAttribute("user", (Object)user);
                StudyUserRoleBean uRole = udao.findRoleByUserNameAndStudyId(name, studyId);
                this.request.setAttribute("uRole", (Object)uRole);
                this.request.setAttribute("uStudy", (Object)study);
                this.forwardPage(Page.RESTORE_USER_ROLE_IN_STUDY);
            } else {
                FormProcessor fp = new FormProcessor(this.request);
                String userName = fp.getString("name");
                int roleId = fp.getInt("roleId");
                StudyUserRoleBean sur = new StudyUserRoleBean();
                sur.setName(userName);
                sur.setRole(Role.get((int)roleId));
                sur.setStudyId(studyId);
                sur.setStatus(Status.AVAILABLE);
                sur.setUpdater(this.ub);
                sur.setUpdatedDate(new Date());
                udao.updateStudyUserRole(sur, userName);
                String restoreMessage = user.getFirstName() + " " + user.getLastName() + " (" + resword.getString("username") + ": " + user.getName() + ") " + respage.getString("has_been_restored_to_the_study_site") + " " + study.getName() + " " + respage.getString("with_the_role") + " " + sur.getRoleName() + ". " + respage.getString("the_user_is_now_be_able_to_access_study");
                this.addPageMessage(restoreMessage);
                this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
            }
        }
    }
}

