/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.NumericComparisonOperator;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.service.StudyParamsConfig;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.managestudy.CreateStudyServlet;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSubStudyServlet
extends SecureController {
    private static final long serialVersionUID = -2416194262084852024L;
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String INPUT_START_DATE = "startDate";
    public static final String INPUT_VER_DATE = "protocolDateVerification";
    public static final String INPUT_END_DATE = "endDate";
    public static StudyBean parentStudy;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.SITE_LIST_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.STUDY_LIST, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = (StudyBean)this.session.getAttribute("newStudy");
        parentStudy = sdao.findByPK(study.getParentStudyId());
        this.logger.info("study from session:" + study.getName() + "\n" + study.getCreatedDate() + "\n");
        String action = this.request.getParameter("action");
        if (action == null || action.trim().isEmpty()) {
            this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
            this.request.setAttribute("statuses", (Object)Status.toStudyUpdateMembersList());
            FormProcessor fp = new FormProcessor(this.request);
            this.logger.info("start date:" + study.getDatePlannedEnd());
            if (study.getDatePlannedEnd() != null) {
                fp.addPresetValue(INPUT_END_DATE, this.local_df.format(study.getDatePlannedEnd()));
            }
            if (study.getDatePlannedStart() != null) {
                fp.addPresetValue(INPUT_START_DATE, this.local_df.format(study.getDatePlannedStart()));
            }
            if (study.getProtocolDateVerification() != null) {
                fp.addPresetValue(INPUT_VER_DATE, this.local_df.format(study.getProtocolDateVerification()));
            }
            this.setPresetValues(fp.getPresetValues());
            this.forwardPage(Page.UPDATE_SUB_STUDY);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.confirmStudy();
        }
    }

    private void confirmStudy() throws Exception {
        String contactEmail;
        String verDate;
        String endDate;
        Validator v = new Validator(this.request);
        FormProcessor fp = new FormProcessor(this.request);
        v.addValidation("name", 1);
        v.addValidation("uniqueProId", 1);
        v.addValidation("prinInvestigator", 1);
        String startDate = fp.getString(INPUT_START_DATE);
        if (startDate != null && !startDate.trim().isEmpty()) {
            v.addValidation(INPUT_START_DATE, 4);
        }
        if ((endDate = fp.getString(INPUT_END_DATE)) != null && !endDate.trim().isEmpty()) {
            v.addValidation(INPUT_END_DATE, 4);
        }
        if ((verDate = fp.getString(INPUT_VER_DATE)) != null && !verDate.trim().isEmpty()) {
            v.addValidation(INPUT_VER_DATE, 4);
        }
        if ((contactEmail = fp.getString("facConEmail")) != null && !contactEmail.trim().isEmpty()) {
            v.addValidation("facConEmail", 6);
        }
        v.addValidation("secondProId", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facCity", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facState", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 20);
        v.addValidation("facZip", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facCountry", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 64);
        v.addValidation("facConName", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConDegree", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConPhone", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        v.addValidation("facConEmail", 7, NumericComparisonOperator.LESS_THAN_OR_EQUAL_TO, 255);
        this.errors = v.validate();
        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
        ArrayList allStudies = studyDAO.findAll();
        StudyBean oldStudy = (StudyBean)this.session.getAttribute("newStudy");
        for (StudyBean thisBean : allStudies) {
            if (!fp.getString("uniqueProId").trim().equals(thisBean.getIdentifier()) || thisBean.getIdentifier().equals(oldStudy.getIdentifier())) continue;
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("unique_protocol_id_existed"));
        }
        if (fp.getString("name").trim().length() > 100) {
            Validator.addError((HashMap)this.errors, (String)"name", (String)resexception.getString("maximum_lenght_name_100"));
        }
        if (fp.getString("uniqueProId").trim().length() > 30) {
            Validator.addError((HashMap)this.errors, (String)"uniqueProId", (String)resexception.getString("maximum_lenght_unique_protocol_30"));
        }
        if (fp.getString("description").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"description", (String)resexception.getString("maximum_lenght_brief_summary_255"));
        }
        if (fp.getString("prinInvestigator").trim().length() > 255) {
            Validator.addError((HashMap)this.errors, (String)"prinInvestigator", (String)resexception.getString("maximum_lenght_principal_investigator_255"));
        }
        if (fp.getInt("expectedTotalEnrollment") <= 0) {
            Validator.addError((HashMap)this.errors, (String)"expectedTotalEnrollment", (String)respage.getString("expected_total_enrollment_must_be_a_positive_number"));
        }
        if (parentStudy.getStatus().equals((Term)Status.LOCKED) && fp.getInt("statusId") != Status.LOCKED.getId()) {
            Validator.addError((HashMap)this.errors, (String)"statusId", (String)respage.getString("study_locked_site_status_locked"));
        }
        StudyBean study = this.createStudyBean();
        this.session.setAttribute("newStudy", (Object)study);
        if (this.errors.isEmpty()) {
            this.logger.info("no errors");
            this.submitStudy();
        } else {
            StudyBean studyCheck = (StudyBean)this.session.getAttribute("newStudy");
            parentStudy = studyDAO.findByPK(studyCheck.getParentStudyId());
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            String participateFormStatus = spvdao.findByHandleAndStudy(parentStudy.getId(), "participantPortal").getValue();
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            this.logger.info("has validation errors");
            fp.addPresetValue(INPUT_START_DATE, startDate);
            fp.addPresetValue(INPUT_VER_DATE, verDate);
            fp.addPresetValue(INPUT_END_DATE, endDate);
            this.setPresetValues(fp.getPresetValues());
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
            this.request.setAttribute("statuses", (Object)Status.toStudyUpdateMembersList());
            this.forwardPage(Page.UPDATE_SUB_STUDY);
        }
    }

    private StudyBean createStudyBean() {
        FormProcessor fp = new FormProcessor(this.request);
        StudyBean study = (StudyBean)this.session.getAttribute("newStudy");
        study.setName(fp.getString("name"));
        study.setIdentifier(fp.getString("uniqueProId"));
        study.setSecondaryIdentifier(fp.getString("secondProId"));
        study.setSummary(fp.getString("description"));
        study.setPrincipalInvestigator(fp.getString("prinInvestigator"));
        study.setExpectedTotalEnrollment(fp.getInt("expectedTotalEnrollment"));
        String startDate = fp.getString(INPUT_START_DATE);
        if (startDate != null && !startDate.trim().isEmpty()) {
            study.setDatePlannedStart(fp.getDate(INPUT_START_DATE));
        } else {
            study.setDatePlannedStart(null);
        }
        String endDate = fp.getString(INPUT_END_DATE);
        if (endDate != null && !endDate.trim().isEmpty()) {
            study.setDatePlannedEnd(fp.getDate(INPUT_END_DATE));
        } else {
            study.setDatePlannedEnd(null);
        }
        String verDate = fp.getString(INPUT_VER_DATE);
        if (verDate != null && !verDate.trim().isEmpty()) {
            study.setProtocolDateVerification(fp.getDate(INPUT_VER_DATE));
        } else {
            study.setProtocolDateVerification(null);
        }
        study.setFacilityCity(fp.getString("facCity"));
        study.setFacilityContactDegree(fp.getString("facConDrgree"));
        study.setFacilityName(fp.getString("facName"));
        study.setFacilityContactEmail(fp.getString("facConEmail"));
        study.setFacilityContactPhone(fp.getString("facConPhone"));
        study.setFacilityContactName(fp.getString("facConName"));
        study.setFacilityContactDegree(fp.getString("facConDegree"));
        study.setFacilityCountry(fp.getString("facCountry"));
        study.setFacilityRecruitmentStatus(fp.getString("facRecStatus"));
        study.setFacilityState(fp.getString("facState"));
        study.setFacilityZip(fp.getString("facZip"));
        study.setStatus(Status.get((int)fp.getInt("statusId")));
        study.getStudyParameterConfig().setInterviewerNameRequired(fp.getString("interviewerNameRequired"));
        study.getStudyParameterConfig().setInterviewerNameDefault(fp.getString("interviewerNameDefault"));
        study.getStudyParameterConfig().setInterviewDateRequired(fp.getString("interviewDateRequired"));
        study.getStudyParameterConfig().setInterviewDateDefault(fp.getString("interviewDateDefault"));
        ArrayList parameters = study.getStudyParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            StudyParamsConfig scg = (StudyParamsConfig)parameters.get(i);
            String value = fp.getString(scg.getParameter().getHandle());
            this.logger.info("get value:" + value);
            scg.getValue().setStudyId(study.getId());
            scg.getValue().setParameter(scg.getParameter().getHandle());
            scg.getValue().setValue(value);
        }
        return study;
    }

    private void submitSiteEventDefinitions(StudyBean site) throws MalformedURLException {
        StudyBean parentStudyBean;
        FormProcessor fp = new FormProcessor(this.request);
        Validator v = new Validator(this.request);
        HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
        HashMap changeStatus = ClassCastHelper.asHashMap((Object)this.session.getAttribute("changed"), String.class, Boolean.class);
        ArrayList seds = new ArrayList();
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        if (site.getParentStudyId() == 0) {
            parentStudyBean = site;
        } else {
            StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
            parentStudyBean = studyDAO.findByPK(site.getParentStudyId());
        }
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ArrayList eventDefCrfList = edcdao.findAllActiveSitesAndStudiesPerParentStudy(parentStudyBean.getId());
        ArrayList<EventDefinitionCRFBean> toBeCreatedEventDefBean = new ArrayList<EventDefinitionCRFBean>();
        ArrayList<EventDefinitionCRFBean> toBeUpdatedEventDefBean = new ArrayList<EventDefinitionCRFBean>();
        ArrayList<EventDefinitionCRFBean> edcsInSession = new ArrayList<EventDefinitionCRFBean>();
        seds = ClassCastHelper.asArrayList((Object)this.session.getAttribute("definitions"), StudyEventDefinitionBean.class);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        String participateFormStatus = spvdao.findByHandleAndStudy(parentStudyBean.getId(), "participantPortal").getValue();
        if (participateFormStatus.equals("enabled")) {
            this.baseUrl();
        }
        this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
        for (StudyEventDefinitionBean sed : seds) {
            ArrayList edcs = ClassCastHelper.asArrayList((Object)sed.getCrfs(), EventDefinitionCRFBean.class);
            int start = 0;
            for (EventDefinitionCRFBean edcBean : edcs) {
                int edcStatusId = edcBean.getStatus().getId();
                if (edcStatusId != 5 && edcStatusId != 7) {
                    String order = start + "-" + edcBean.getId();
                    int defaultVersionId = fp.getInt("defaultVersionId" + order);
                    String requiredCRF = fp.getString("requiredCRF" + order);
                    String doubleEntry = fp.getString("doubleEntry" + order);
                    String electronicSignature = fp.getString("electronicSignature" + order);
                    String hideCRF = fp.getString("hideCRF" + order);
                    String submissionUrl = fp.getString("submissionUrl" + order);
                    int sdvId = fp.getInt("sdvOption" + order);
                    ArrayList selectedVersionIdList = fp.getStringArray("versionSelection" + order);
                    int selectedVersionIdListSize = selectedVersionIdList.size();
                    String selectedVersionIds = "";
                    if (selectedVersionIdListSize > 0) {
                        for (String id : selectedVersionIdList) {
                            selectedVersionIds = selectedVersionIds + id + ",";
                        }
                        selectedVersionIds = selectedVersionIds.substring(0, selectedVersionIds.length() - 1);
                    }
                    boolean changed = false;
                    if (changeStatus != null && changeStatus.get(sed.getId() + "-" + edcBean.getId()) != null) {
                        changed = (Boolean)changeStatus.get(sed.getId() + "-" + edcBean.getId());
                        edcBean.setSubmissionUrl(submissionUrl);
                    }
                    boolean isRequired = requiredCRF != null && !requiredCRF.trim().isEmpty() && "yes".equalsIgnoreCase(requiredCRF.trim());
                    boolean isDouble = doubleEntry != null && !doubleEntry.trim().isEmpty() && "yes".equalsIgnoreCase(doubleEntry.trim());
                    boolean hasPassword = electronicSignature != null && !electronicSignature.trim().isEmpty() && "yes".equalsIgnoreCase(electronicSignature.trim());
                    boolean isHide = hideCRF != null && !hideCRF.trim().isEmpty() && "yes".equalsIgnoreCase(hideCRF.trim());
                    this.logger.debug("crf name : {}", (Object)edcBean.getCrfName());
                    this.logger.debug("submissionUrl: {}", (Object)submissionUrl);
                    if (edcBean.getParentId() > 0) {
                        int dbDefaultVersionId = edcBean.getDefaultVersionId();
                        if (defaultVersionId != dbDefaultVersionId) {
                            changed = true;
                            CRFVersionBean defaultVersion = cvdao.findByPK(defaultVersionId);
                            edcBean.setDefaultVersionId(defaultVersionId);
                            edcBean.setDefaultVersionName(defaultVersion.getName());
                        }
                        if (isRequired != edcBean.isRequiredCRF()) {
                            changed = true;
                            edcBean.setRequiredCRF(isRequired);
                        }
                        if (isDouble != edcBean.isDoubleEntry()) {
                            changed = true;
                            edcBean.setDoubleEntry(isDouble);
                        }
                        if (hasPassword != edcBean.isElectronicSignature()) {
                            changed = true;
                            edcBean.setElectronicSignature(hasPassword);
                        }
                        if (isHide != edcBean.isHideCrf()) {
                            changed = true;
                            edcBean.setHideCrf(isHide);
                        }
                        if (!submissionUrl.equals(edcBean.getSubmissionUrl())) {
                            changed = true;
                            edcBean.setSubmissionUrl(submissionUrl);
                        }
                        if (selectedVersionIds != null && !selectedVersionIds.trim().isEmpty() && !selectedVersionIds.equals(edcBean.getSelectedVersionIds())) {
                            changed = true;
                            String[] ids = selectedVersionIds.split(",");
                            ArrayList<Integer> idList = new ArrayList<Integer>();
                            for (String id : ids) {
                                idList.add(Integer.valueOf(id));
                            }
                            edcBean.setSelectedVersionIdList(idList);
                            edcBean.setSelectedVersionIds(selectedVersionIds);
                        }
                        if (sdvId > 0 && sdvId != edcBean.getSourceDataVerification().getCode()) {
                            changed = true;
                            edcBean.setSourceDataVerification(SourceDataVerification.getByCode((Integer)sdvId));
                        }
                        if (changed) {
                            edcBean.setUpdater(this.ub);
                            edcBean.setUpdatedDate(new Date());
                            this.logger.debug("update for site");
                            toBeUpdatedEventDefBean.add(edcBean);
                        }
                    } else {
                        int defaultId = defaultVersionId > 0 ? defaultVersionId : edcBean.getDefaultVersionId();
                        int dbDefaultVersionId = edcBean.getDefaultVersionId();
                        changed = changed || defaultId != dbDefaultVersionId;
                        changed = changed || isRequired != edcBean.isRequiredCRF();
                        changed = changed || isDouble != edcBean.isDoubleEntry();
                        changed = changed || hasPassword != edcBean.isElectronicSignature();
                        changed = changed || isHide != edcBean.isHideCrf();
                        changed = changed || !submissionUrl.equals("");
                        changed = changed || selectedVersionIdListSize > 0 && selectedVersionIdListSize != edcBean.getVersions().size();
                        boolean bl = changed = changed || sdvId > 0 && sdvId != edcBean.getSourceDataVerification().getCode();
                        if (changed) {
                            CRFVersionBean defaultVersion = cvdao.findByPK(defaultId);
                            edcBean.setDefaultVersionId(defaultId);
                            edcBean.setDefaultVersionName(defaultVersion.getName());
                            edcBean.setRequiredCRF(isRequired);
                            edcBean.setDoubleEntry(isDouble);
                            edcBean.setElectronicSignature(hasPassword);
                            edcBean.setHideCrf(isHide);
                            edcBean.setSubmissionUrl(submissionUrl);
                            if (selectedVersionIdListSize > 0 && selectedVersionIdListSize != edcBean.getVersions().size()) {
                                String[] ids = selectedVersionIds.split(",");
                                ArrayList<Integer> idList = new ArrayList<Integer>();
                                for (String id : ids) {
                                    idList.add(Integer.valueOf(id));
                                }
                                edcBean.setSelectedVersionIdList(idList);
                                edcBean.setSelectedVersionIds(selectedVersionIds);
                            }
                            if (sdvId > 0 && sdvId != edcBean.getSourceDataVerification().getCode()) {
                                edcBean.setSourceDataVerification(SourceDataVerification.getByCode((Integer)sdvId));
                            }
                            edcBean.setStudyId(site.getId());
                            edcBean.setUpdater(this.ub);
                            edcBean.setUpdatedDate(new Date());
                            this.logger.debug("create for the site");
                            toBeCreatedEventDefBean.add(edcBean);
                        }
                    }
                    ++start;
                    changes.put(sed.getId() + "-" + edcBean.getId(), changed);
                }
                edcsInSession.add(edcBean);
            }
            sed.setPopulated(false);
            eventDefCrfList = this.validateSubmissionUrl(edcsInSession, eventDefCrfList, v, sed);
            edcsInSession.clear();
        }
        this.errors = v.validate();
        if (!this.errors.isEmpty()) {
            this.logger.info("has errors");
            StudyBean study = this.createStudyBean();
            this.session.setAttribute("newStudy", (Object)study);
            this.request.setAttribute("formMessages", (Object)this.errors);
            this.session.setAttribute("changed", changes);
            this.forwardPage(Page.UPDATE_SUB_STUDY);
        } else {
            for (EventDefinitionCRFBean toBeCreated : toBeCreatedEventDefBean) {
                toBeCreated.setParentId(toBeCreated.getId());
                edcdao.create(toBeCreated);
            }
            for (EventDefinitionCRFBean toBeUpdated : toBeUpdatedEventDefBean) {
                edcdao.update(toBeUpdated);
            }
        }
    }

    private void submitStudy() throws MalformedURLException {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = (StudyBean)this.session.getAttribute("newStudy");
        ArrayList parameters = study.getStudyParameters();
        study.setUpdatedDate(new Date());
        study.setUpdater(this.ub);
        sdao.update(study);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        for (int i = 0; i < parameters.size(); ++i) {
            StudyParamsConfig config = (StudyParamsConfig)parameters.get(i);
            StudyParameterValueBean spv = config.getValue();
            StudyParameterValueBean spv1 = spvdao.findByHandleAndStudy(spv.getStudyId(), spv.getParameter());
            spv = spv1.getId() > 0 ? spvdao.update(spv) : spvdao.create(spv);
        }
        this.submitSiteEventDefinitions(study);
        this.addPageMessage(respage.getString("the_site_has_been_updated_succesfully"));
        String fromListSite = (String)this.session.getAttribute("fromListSite");
        if (fromListSite != null && fromListSite.equals("yes")) {
            this.forwardPage(Page.SITE_LIST_SERVLET);
        } else {
            this.forwardPage(Page.STUDY_LIST_SERVLET);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public ArrayList<EventDefinitionCRFBean> validateSubmissionUrl(ArrayList<EventDefinitionCRFBean> edcsInSession, ArrayList<EventDefinitionCRFBean> eventDefCrfList, Validator v, StudyEventDefinitionBean sed) {
        for (int i = 0; i < edcsInSession.size(); ++i) {
            String order = i + "-" + edcsInSession.get(i).getId();
            v.addValidation("submissionUrl" + order, 44);
            EventDefinitionCRFBean sessionBean = null;
            boolean isExist = false;
            for (EventDefinitionCRFBean eventDef : eventDefCrfList) {
                sessionBean = edcsInSession.get(i);
                this.logger.debug("iter:           {} --db: {}", (Object)eventDef.getId(), (Object)eventDef.getSubmissionUrl());
                this.logger.debug("edcsInSession:  {}--session: {}", (Object)sessionBean.getId(), (Object)sessionBean.getSubmissionUrl());
                if (sessionBean.getSubmissionUrl() == null || sessionBean.getSubmissionUrl().trim().equals("")) break;
                if (eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) && eventDef.getId() != sessionBean.getId() || eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) && eventDef.getId() == sessionBean.getId() && eventDef.getId() == 0) {
                    v.addValidation("submissionUrl" + order, 45);
                    sed.setPopulated(true);
                    this.logger.debug("Duplicate *****************");
                    isExist = true;
                    break;
                }
                if (!eventDef.getSubmissionUrl().trim().equalsIgnoreCase(sessionBean.getSubmissionUrl().trim()) || eventDef.getId() != sessionBean.getId()) continue;
                this.logger.debug("Not Duplicate **********");
                isExist = true;
                break;
            }
            if (isExist) continue;
            eventDefCrfList.add(sessionBean);
        }
        return eventDefCrfList;
    }
}

