/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.AuditableEntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.DisplayTableOfContentsBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.TableOfContentsServlet;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewEventCRFContentServlet
extends SecureController {
    private static final long serialVersionUID = 6312222590107479913L;
    public static final String BEAN_STUDY_EVENT = "studyEvent";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT) || this.currentRole.getRole().equals((Term)Role.RESEARCHASSISTANT2)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("no_permission"), "1");
    }

    private StudyEventBean getStudyEvent(int eventId) throws Exception {
        AuditableEntityBean aeb;
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyBean studyWithSED = this.currentStudy;
        if (this.currentStudy.getParentStudyId() > 0) {
            studyWithSED = new StudyBean();
            studyWithSED.setId(this.currentStudy.getParentStudyId());
        }
        if (!(aeb = (AuditableEntityBean)sedao.findByPKAndStudy(eventId, studyWithSED)).isActive()) {
            this.addPageMessage(respage.getString("the_SE_you_attempting_enter_data_not_belong"));
            throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS_SERVLET, resexception.getString("SE_does_not_belong_current_study"), "1");
        }
        StudyEventBean seb = (StudyEventBean)aeb;
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        StudyEventDefinitionBean sedb = seddao.findByPK(seb.getStudyEventDefinitionId());
        seb.setStudyEventDefinition(sedb);
        return seb;
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int eventCRFId = fp.getInt("ecId", true);
        int studySubId = fp.getInt("id", true);
        int eventId = fp.getInt("eventId", true);
        if (eventCRFId == 0) {
            this.addPageMessage(respage.getString("please_choose_an_event_CRF_to_view"));
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            return;
        }
        StudyEventBean seb = this.getStudyEvent(eventId);
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        StudySubjectBean studySub = subdao.findByPK(studySubId);
        this.request.setAttribute("studySub", (Object)studySub);
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        EventCRFBean eventCRF = ecdao.findByPK(eventCRFId);
        DisplayTableOfContentsBean displayBean = TableOfContentsServlet.getDisplayBean((EventCRFBean)eventCRF, (DataSource)this.sm.getDataSource(), (StudyBean)this.currentStudy);
        this.request.setAttribute("toc", (Object)displayBean);
        this.request.getSession().setAttribute(BEAN_STUDY_EVENT, (Object)seb);
        this.forwardPage(Page.VIEW_EVENT_CRF_CONTENT);
    }
}

