/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class DownloadAttachedFileServlet
extends SecureController {
    private static final long serialVersionUID = 3098103596566845378L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.request.setAttribute("downloadStatus", (Object)"false");
        this.addPageMessage(respage.getString("you_not_have_permission_download_attached_file"));
        throw new InsufficientPermissionException(Page.DOWNLOAD_ATTACHED_FILE, resexception.getString("no_permission"), "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest() throws Exception {
        String fileName;
        String filePathName;
        block12: {
            String testName;
            String tail;
            String testPath;
            block14: {
                File temp;
                int parentStudyId;
                block13: {
                    FormProcessor fp = new FormProcessor(this.request);
                    filePathName = "";
                    fileName = fp.getString("fileName");
                    File f = new File(fileName);
                    if (fileName == null || fileName.length() <= 0) break block12;
                    parentStudyId = this.currentStudy.getParentStudyId();
                    testPath = Utils.getAttachedFileRootPath();
                    tail = File.separator + f.getName();
                    testName = testPath + this.currentStudy.getOid() + tail;
                    temp = new File(testName);
                    if (!temp.exists()) break block13;
                    filePathName = testName;
                    logger.info(this.currentStudy.getName() + " existing filePathName=" + filePathName);
                    break block12;
                }
                if (!this.currentStudy.isSite(parentStudyId)) break block14;
                testName = testPath + new StudyDAO(this.sm.getDataSource()).findByPK(parentStudyId).getOid() + tail;
                temp = new File(testName);
                if (!temp.exists()) break block12;
                filePathName = testName;
                logger.info("parent existing filePathName=" + filePathName);
                break block12;
            }
            ArrayList sites = new StudyDAO(this.sm.getDataSource()).findAllByParent(this.currentStudy.getId());
            for (StudyBean s : sites) {
                testPath = Utils.getAttachedFilePath((StudyBean)s);
                testName = testPath + tail;
                File test = new File(testName);
                if (!test.exists()) continue;
                filePathName = testName;
                logger.info("site of currentStudy existing filePathName=" + filePathName);
                break;
            }
        }
        logger.info("filePathName=" + filePathName + " fileName=" + fileName);
        File file = new File(filePathName);
        if (!file.exists() || file.length() <= 0L) {
            this.addPageMessage("File " + filePathName + " " + respage.getString("not_exist"));
        } else {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\";");
            this.response.setHeader("Pragma", "public");
            ServletOutputStream outStream = this.response.getOutputStream();
            FilterInputStream inStream = null;
            try {
                int length;
                this.response.setContentType("application/download");
                this.response.setHeader("Cache-Control", "max-age=0");
                this.response.setContentLength((int)file.length());
                byte[] bbuf = new byte[(int)file.length()];
                inStream = new DataInputStream(new FileInputStream(file));
                while (inStream != null && (length = ((DataInputStream)inStream).read(bbuf)) != -1) {
                    outStream.write(bbuf, 0, length);
                }
                inStream.close();
                outStream.flush();
                outStream.close();
            }
            catch (Exception ee) {
                logger.error("InputStream is not working properly: ", (Throwable)ee);
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
    }
}

