/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.crfdata.FormDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ODMContainer;
import org.akaza.openclinica.bean.submit.crfdata.StudyEventDataBean;
import org.akaza.openclinica.bean.submit.crfdata.SubjectDataBean;
import org.akaza.openclinica.bean.submit.crfdata.UpsertOnBean;
import org.akaza.openclinica.control.submit.ImportCRFInfo;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCRFInfoContainer {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Map<String, Map<String, Map<String, String>>> importCRFMap;
    private List<ImportCRFInfo> importCRFList = new ArrayList();

    public ImportCRFInfoContainer(ODMContainer odmContainer, DataSource ds) {
        EventCRFDAO eventCrfDAO = new EventCRFDAO(ds);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(ds);
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(ds);
        StudyDAO studyDAO = new StudyDAO(ds);
        StudyEventDAO studyEventDAO = new StudyEventDAO(ds);
        UpsertOnBean upsert = odmContainer.getCrfDataPostImportContainer().getUpsertOn();
        if (upsert == null) {
            upsert = new UpsertOnBean();
        }
        String studyOID = odmContainer.getCrfDataPostImportContainer().getStudyOID();
        StudyBean studyBean = studyDAO.findByOid(studyOID);
        ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
        HashMap subjectMap = new HashMap();
        for (SubjectDataBean subjectDataBean : subjectDataBeans) {
            ArrayList studyEventDataBeans = subjectDataBean.getStudyEventData();
            StudySubjectBean studySubjectBean = studySubjectDAO.findByOidAndStudy(subjectDataBean.getSubjectOID(), studyBean.getId());
            HashMap eventMap = new HashMap();
            for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                ArrayList formDataBeans = studyEventDataBean.getFormData();
                String sampleOrdinal = studyEventDataBean.getStudyEventRepeatKey() == null ? "1" : studyEventDataBean.getStudyEventRepeatKey();
                StudyEventDefinitionBean studyEventDefinitionBean = studyEventDefinitionDAO.findByOidAndStudy(studyEventDataBean.getStudyEventOID(), studyBean.getId(), studyBean.getParentStudyId());
                this.logger.info("find all by def and subject " + studyEventDefinitionBean.getName() + " study subject " + studySubjectBean.getName());
                StudyEventBean studyEventBean = (StudyEventBean)studyEventDAO.findByStudySubjectIdAndDefinitionIdAndOrdinal(studySubjectBean.getId(), studyEventDefinitionBean.getId(), Integer.parseInt(sampleOrdinal));
                HashMap<String, String> formMap = new HashMap<String, String>();
                for (FormDataBean formDataBean : formDataBeans) {
                    CRFVersionDAO crfVersionDAO = new CRFVersionDAO(ds);
                    ArrayList crfVersionBeans = crfVersionDAO.findAllByOid(formDataBean.getFormOID());
                    for (CRFVersionBean crfVersionBean : crfVersionBeans) {
                        ArrayList eventCrfBeans = eventCrfDAO.findByEventSubjectVersion(studyEventBean, studySubjectBean, crfVersionBean);
                        if (eventCrfBeans.isEmpty()) {
                            this.logger.debug("   found no event crfs from Study Event id " + studyEventBean.getId() + ", location " + studyEventBean.getLocation());
                            ImportCRFInfo importCrfInfo = new ImportCRFInfo(studyOID, subjectDataBean.getSubjectOID(), studyEventDataBean.getStudyEventOID(), formDataBean.getFormOID());
                            importCrfInfo.setPreImportStage(DataEntryStage.UNCOMPLETED);
                            String crfStatus = formDataBean.getEventCRFStatus();
                            if (crfStatus != null && crfStatus.equals(DataEntryStage.INITIAL_DATA_ENTRY.getName())) {
                                importCrfInfo.setPostImportStage(DataEntryStage.INITIAL_DATA_ENTRY);
                            }
                            if ((studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.DATA_ENTRY_STARTED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.COMPLETED)) && !upsert.isNotStarted()) {
                                importCrfInfo.setProcessImport(false);
                                importCrfInfo.setEventCRFID(null);
                            }
                            this.importCRFList.add(importCrfInfo);
                            if (importCrfInfo.isProcessImport()) {
                                formMap.put(formDataBean.getFormOID(), "true");
                            }
                        }
                        for (EventCRFBean ecb : eventCrfBeans) {
                            ImportCRFInfo importCrfInfo = new ImportCRFInfo(studyOID, subjectDataBean.getSubjectOID(), studyEventDataBean.getStudyEventOID(), formDataBean.getFormOID());
                            importCrfInfo.setPreImportStage(ecb.getStage());
                            String crfStatus = formDataBean.getEventCRFStatus();
                            if (crfStatus != null && crfStatus.equals(DataEntryStage.INITIAL_DATA_ENTRY.getName())) {
                                importCrfInfo.setPostImportStage(DataEntryStage.INITIAL_DATA_ENTRY);
                            }
                            importCrfInfo.setEventCRFID(new Integer(ecb.getId()));
                            if (!(ecb.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && upsert.isDataEntryStarted() || ecb.getStage().equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) && upsert.isDataEntryComplete())) {
                                importCrfInfo.setProcessImport(false);
                            }
                            this.importCRFList.add(importCrfInfo);
                            if (!importCrfInfo.isProcessImport()) continue;
                            formMap.put(formDataBean.getFormOID(), "true");
                        }
                    }
                }
                if (formMap.size() <= 0) continue;
                eventMap.put(studyEventDataBean.getStudyEventOID(), formMap);
            }
            if (eventMap.size() <= 0) continue;
            subjectMap.put(subjectDataBean.getSubjectOID(), eventMap);
        }
        this.importCRFMap = subjectMap;
    }

    public int getCountSkippedEventCrfs() {
        int countSkippedCrfs = 0;
        for (ImportCRFInfo importCrf : this.importCRFList) {
            if (importCrf.isProcessImport()) continue;
            ++countSkippedCrfs;
        }
        return countSkippedCrfs;
    }

    public List<ImportCRFInfo> getImportCRFList() {
        return this.importCRFList;
    }

    public void setImportCRFList(List<ImportCRFInfo> importCRFList) {
        this.importCRFList = importCRFList;
    }

    public Map<String, Map<String, Map<String, String>>> getImportCRFMap() {
        return this.importCRFMap;
    }

    public void setImportCRFMap(Map<String, Map<String, Map<String, String>>> importCRFMap) {
        this.importCRFMap = importCRFMap;
    }
}

