/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.submit.ListDiscNotesSubjectTableFactory;
import org.akaza.openclinica.control.submit.ListDiscNotesSubjectTableToolbar;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.ListDiscNotesSubjectFilter;
import org.akaza.openclinica.dao.managestudy.ListDiscNotesSubjectSort;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.HtmlBuilder;
import org.jmesa.view.html.toolbar.Toolbar;

public class ListDiscNotesSubjectTableFactory
extends AbstractTableFactory {
    private StudyEventDefinitionDAO studyEventDefinitionDao;
    private StudySubjectDAO studySubjectDAO;
    private SubjectDAO subjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyGroupDAO studyGroupDAO;
    private StudyDAO studyDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private DiscrepancyNoteDAO discrepancyNoteDAO;
    private StudyBean studyBean;
    private String[] columnNames = new String[0];
    private ArrayList<StudyEventDefinitionBean> studyEventDefinitions;
    private StudyUserRoleBean currentRole;
    private UserAccountBean currentUser;
    private ResourceBundle resword;
    private ResourceBundle resterm;
    private String module;
    private Integer resolutionStatus;
    private Integer discNoteType;
    private Boolean studyHasDiscNotes;
    private Set<Integer> resolutionStatusIds;
    final HashMap<Integer, String> imageIconPaths = new HashMap(8);
    final HashMap<Integer, String> discNoteIconPaths = new HashMap(8);

    public ListDiscNotesSubjectTableFactory(ResourceBundle resterm) {
        this.resterm = resterm;
        this.imageIconPaths.put(1, "images/icon_Scheduled.gif");
        this.imageIconPaths.put(2, "images/icon_NotStarted.gif");
        this.imageIconPaths.put(3, "images/icon_InitialDE.gif");
        this.imageIconPaths.put(4, "images/icon_DEcomplete.gif");
        this.imageIconPaths.put(5, "images/icon_Stopped.gif");
        this.imageIconPaths.put(6, "images/icon_Skipped.gif");
        this.imageIconPaths.put(7, "images/icon_Locked.gif");
        this.imageIconPaths.put(8, "images/icon_Signed.gif");
        this.discNoteIconPaths.put(1, "<img name='icon_Note' src='images/icon_Note.gif' border='0' alt='" + resterm.getString("Open") + "' title='" + resterm.getString("Open") + "' align='left'/>");
        this.discNoteIconPaths.put(2, "<img name='icon_flagYellow' src='images/icon_flagYellow.gif' border='0' alt='" + resterm.getString("Updated") + "' title='" + resterm.getString("Updated") + "' align='left'/>");
        this.discNoteIconPaths.put(3, "<img name='icon_flagGreen' src='images/icon_flagGreen.gif' border='0' alt='" + resterm.getString("Resolved") + "' title='" + resterm.getString("Resolved") + "' align='left'/>");
        this.discNoteIconPaths.put(4, "<img name='icon_flagBlack' src='images/icon_flagBlack.gif' border='0' alt='" + resterm.getString("Closed") + "' title='" + resterm.getString("Closed") + "' align='left'/>");
        this.discNoteIconPaths.put(5, "<img name='icon_flagWhite' src='images/icon_flagWhite.gif' border='0' alt='" + resterm.getString("Not_Applicable") + "' title='" + resterm.getString("Not_Applicable") + "' align='left'/>");
    }

    protected String getTableName() {
        return "listDiscNotes";
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        tableFacade.setColumnProperties(this.columnNames);
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn(this.columnNames[0]), this.resword.getString("study_subject_ID"), null, null);
        this.configureColumn(row.getColumn(this.columnNames[1]), this.resword.getString("subject_status"), (CellEditor)new StatusCellEditor(this, null), (FilterEditor)new StatusDroplistFilterEditor(this, null));
        this.configureColumn(row.getColumn(this.columnNames[2]), "Site ID", null, null);
        for (int i = 3; i < this.columnNames.length - 1; ++i) {
            StudyEventDefinitionBean studyEventDefinition = (StudyEventDefinitionBean)this.studyEventDefinitions.get(i - 3);
            this.configureColumn(row.getColumn(this.columnNames[i]), studyEventDefinition.getName(), (CellEditor)new StudyEventDefinitionMapCellEditor(this, null), (FilterEditor)new SubjectEventStatusDroplistFilterEditor(this, null), true, false);
        }
        String actionsHeader = this.resword.getString("rule_actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn(this.columnNames[this.columnNames.length - 1]), actionsHeader, (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        this.getColumnNamesMap();
        tableFacade.addFilterMatcher(new MatcherKey(Character.class), (FilterMatcher)new CharFilterMatcher(this, null));
        tableFacade.addFilterMatcher(new MatcherKey(Status.class), (FilterMatcher)new StatusFilterMatcher(this));
        for (int i = 3; i < this.columnNames.length - 1; ++i) {
            tableFacade.addFilterMatcher(new MatcherKey(Integer.class, this.columnNames[i]), (FilterMatcher)new SubjectEventStatusFilterMatcher(this));
        }
    }

    public void configureTableFacadePostColumnConfiguration(TableFacade tableFacade) {
        ListDiscNotesSubjectTableToolbar toolbar = new ListDiscNotesSubjectTableToolbar(this.getStudyEventDefinitions());
        toolbar.setStudyHasDiscNotes(this.studyHasDiscNotes.booleanValue());
        toolbar.setDiscNoteType(this.discNoteType.intValue());
        toolbar.setResolutionStatus(this.resolutionStatus.intValue());
        toolbar.setResword(this.resword);
        toolbar.setModule(this.module);
        tableFacade.setToolbar((Toolbar)toolbar);
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        StudyBean study = this.getStudyBean();
        Limit limit = tableFacade.getLimit();
        ListDiscNotesSubjectFilter subjectFilter = this.getSubjectFilter(limit);
        subjectFilter.addFilter("dn.discrepancy_note_type_id", (Object)this.discNoteType);
        StringBuffer constraints = new StringBuffer();
        if (this.discNoteType > 0 && this.discNoteType < 10) {
            constraints.append(" and dn.discrepancy_note_type_id=" + this.discNoteType);
        }
        if (this.resolutionStatusIds != null && this.resolutionStatusIds.size() > 0) {
            String s = " and (";
            for (Integer resolutionStatusId : this.resolutionStatusIds) {
                s = s + "dn.resolution_status_id = " + resolutionStatusId + " or ";
            }
            s = s.substring(0, s.length() - 3) + " )";
            subjectFilter.addFilter("dn.resolution_status_id", (Object)s);
            constraints.append(s);
        }
        if (!limit.isComplete()) {
            int totalRows = this.getStudySubjectDAO().getCountWithFilter(subjectFilter, study);
            tableFacade.setTotalRows(totalRows);
        }
        ListDiscNotesSubjectSort subjectSort = this.getSubjectSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        ArrayList items = this.getStudySubjectDAO().getWithFilterAndSort(study, subjectFilter, subjectSort, rowStart, rowEnd);
        ArrayList theItems = new ArrayList();
        boolean hasDN = false;
        for (StudySubjectBean studySubjectBean : items) {
            HashMap<String, Object> theItem = new HashMap<String, Object>();
            theItem.put("studySubject", studySubjectBean);
            theItem.put("studySubject.label", studySubjectBean.getLabel());
            theItem.put("studySubject.status", studySubjectBean.getStatus());
            theItem.put("enrolledAt", this.getStudyDAO().findByPK(studySubjectBean.getStudyId()).getIdentifier());
            ArrayList allStudyEventsForStudySubject = this.getStudyEventDAO().findAllByStudySubject(studySubjectBean);
            HashMap allStudyEventsForStudySubjectBySedId = new HashMap();
            theItem.put("isSignable", this.isSignable((List)allStudyEventsForStudySubject));
            for (StudyEventBean studyEventBean : allStudyEventsForStudySubject) {
                if (allStudyEventsForStudySubjectBySedId.get(studyEventBean.getStudyEventDefinitionId()) == null) {
                    ArrayList<StudyEventBean> a = new ArrayList<StudyEventBean>();
                    a.add(studyEventBean);
                    allStudyEventsForStudySubjectBySedId.put(studyEventBean.getStudyEventDefinitionId(), a);
                    continue;
                }
                ((List)allStudyEventsForStudySubjectBySedId.get(studyEventBean.getStudyEventDefinitionId())).add(studyEventBean);
            }
            for (StudyEventDefinitionBean studyEventDefinition : this.getStudyEventDefinitions()) {
                List studyEvents = (List)allStudyEventsForStudySubjectBySedId.get(studyEventDefinition.getId());
                SubjectEventStatus subjectEventStatus = null;
                HashMap discCounts = new HashMap();
                List list = studyEvents = studyEvents == null ? new ArrayList() : studyEvents;
                if (studyEvents.size() < 1) {
                    subjectEventStatus = SubjectEventStatus.NOT_SCHEDULED;
                } else {
                    for (StudyEventBean studyEventBean : studyEvents) {
                        discCounts = this.countAll(discCounts, studyEventBean, constraints, study.isSite(study.getParentStudyId()));
                        boolean bl = !hasDN ? discCounts.size() > 0 : (hasDN = hasDN);
                        if (studyEventBean.getSampleOrdinal() != 1) continue;
                        subjectEventStatus = studyEventBean.getSubjectEventStatus();
                    }
                }
                theItem.put("sed_" + studyEventDefinition.getId() + "_discCounts", discCounts);
                theItem.put("sed_" + studyEventDefinition.getId(), subjectEventStatus.getId());
                theItem.put("sed_" + studyEventDefinition.getId() + "_studyEvents", studyEvents);
                theItem.put("sed_" + studyEventDefinition.getId() + "_object", studyEventDefinition);
            }
            theItems.add(theItem);
        }
        tableFacade.setItems(theItems);
        this.setStudyHasDiscNotes(Boolean.valueOf(hasDN));
    }

    private Boolean isSignable(List<StudyEventBean> allStudyEventsForStudySubject) {
        boolean isSignable = true;
        for (StudyEventBean studyEventBean : allStudyEventsForStudySubject) {
            if (studyEventBean.getSubjectEventStatus() == SubjectEventStatus.DATA_ENTRY_STARTED) {
                isSignable = false;
                break;
            }
            boolean isRequiredUncomplete = this.eventHasRequiredUncompleteCRFs(studyEventBean);
            if (!isRequiredUncomplete) continue;
            isSignable = false;
            break;
        }
        return isSignable;
    }

    private boolean eventHasRequiredUncompleteCRFs(StudyEventBean studyEventBean) {
        ArrayList eventCrfBeans = new ArrayList();
        eventCrfBeans.addAll(this.getEventCRFDAO().findAllByStudyEvent(studyEventBean));
        for (EventCRFBean crfBean : eventCrfBeans) {
            if (crfBean == null || crfBean.getCompletionStatusId() != 0 || !this.getEventDefintionCRFDAO().isRequiredInDefinition(crfBean.getCRFVersionId(), studyEventBean)) continue;
            return true;
        }
        return false;
    }

    private void getColumnNamesMap() {
        ArrayList<String> columnNamesList = new ArrayList<String>();
        columnNamesList.add("studySubject.label");
        columnNamesList.add("studySubject.status");
        columnNamesList.add("enrolledAt");
        for (StudyEventDefinitionBean studyEventDefinition : this.getStudyEventDefinitions()) {
            columnNamesList.add("sed_" + studyEventDefinition.getId());
        }
        columnNamesList.add("actions");
        this.columnNames = columnNamesList.toArray(this.columnNames);
    }

    protected ListDiscNotesSubjectFilter getSubjectFilter(Limit limit) {
        ListDiscNotesSubjectFilter listDiscNotesSubjectFilter = new ListDiscNotesSubjectFilter();
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            listDiscNotesSubjectFilter.addFilter(property, (Object)value);
        }
        return listDiscNotesSubjectFilter;
    }

    protected ListDiscNotesSubjectSort getSubjectSort(Limit limit) {
        ListDiscNotesSubjectSort listDiscNotesSubjectSort = new ListDiscNotesSubjectSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            listDiscNotesSubjectSort.addSort(property, order);
        }
        return listDiscNotesSubjectSort;
    }

    private ArrayList<StudyEventDefinitionBean> getStudyEventDefinitions() {
        if (this.studyEventDefinitions == null) {
            if (this.studyBean.getParentStudyId() > 0) {
                StudyBean parentStudy = this.getStudyDAO().findByPK(this.studyBean.getParentStudyId());
                this.studyEventDefinitions = this.getStudyEventDefinitionDao().findAllByStudy(parentStudy);
            } else {
                this.studyEventDefinitions = this.getStudyEventDefinitionDao().findAllByStudy(this.studyBean);
            }
        }
        return this.studyEventDefinitions;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        return this.studyEventDefinitionDao;
    }

    public void setStudyEventDefinitionDao(StudyEventDefinitionDAO studyEventDefinitionDao) {
        this.studyEventDefinitionDao = studyEventDefinitionDao;
    }

    public StudyBean getStudyBean() {
        return this.studyBean;
    }

    public void setStudyBean(StudyBean studyBean) {
        this.studyBean = studyBean;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        return this.studySubjectDAO;
    }

    public void setStudySubjectDAO(StudySubjectDAO studySubjectDAO) {
        this.studySubjectDAO = studySubjectDAO;
    }

    public SubjectDAO getSubjectDAO() {
        return this.subjectDAO;
    }

    public void setSubjectDAO(SubjectDAO subjectDAO) {
        this.subjectDAO = subjectDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        return this.studyEventDAO;
    }

    public void setStudyEventDAO(StudyEventDAO studyEventDAO) {
        this.studyEventDAO = studyEventDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        return this.studyGroupClassDAO;
    }

    public void setStudyGroupClassDAO(StudyGroupClassDAO studyGroupClassDAO) {
        this.studyGroupClassDAO = studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        return this.subjectGroupMapDAO;
    }

    public void setSubjectGroupMapDAO(SubjectGroupMapDAO subjectGroupMapDAO) {
        this.subjectGroupMapDAO = subjectGroupMapDAO;
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO;
    }

    public void setStudyDAO(StudyDAO studyDAO) {
        this.studyDAO = studyDAO;
    }

    public StudyUserRoleBean getCurrentRole() {
        return this.currentRole;
    }

    public void setCurrentRole(StudyUserRoleBean currentRole) {
        this.currentRole = currentRole;
    }

    public EventCRFDAO getEventCRFDAO() {
        return this.eventCRFDAO;
    }

    public void setEventCRFDAO(EventCRFDAO eventCRFDAO) {
        this.eventCRFDAO = eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefintionCRFDAO() {
        return this.eventDefintionCRFDAO;
    }

    public void setEventDefintionCRFDAO(EventDefinitionCRFDAO eventDefintionCRFDAO) {
        this.eventDefintionCRFDAO = eventDefintionCRFDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        return this.studyGroupDAO;
    }

    public void setStudyGroupDAO(StudyGroupDAO studyGroupDAO) {
        this.studyGroupDAO = studyGroupDAO;
    }

    public DiscrepancyNoteDAO getDiscrepancyNoteDAO() {
        return this.discrepancyNoteDAO;
    }

    public void setDiscrepancyNoteDAO(DiscrepancyNoteDAO discrepancyNoteDAO) {
        this.discrepancyNoteDAO = discrepancyNoteDAO;
    }

    public ResourceBundle getResword() {
        return this.resword;
    }

    public void setResword(ResourceBundle resword) {
        this.resword = resword;
    }

    public ResourceBundle getResterm() {
        return this.resterm;
    }

    public void setResterm(ResourceBundle resterm) {
        this.resterm = resterm;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public UserAccountBean getCurrentUser() {
        return this.currentUser;
    }

    public Integer getResolutionStatus() {
        return this.resolutionStatus;
    }

    public void setResolutionStatus(Integer resolutionStatus) {
        this.resolutionStatus = resolutionStatus;
    }

    public Integer getDiscNoteType() {
        return this.discNoteType;
    }

    public void setDiscNoteType(Integer discNoteType) {
        this.discNoteType = discNoteType;
    }

    public Boolean isStudyHasDiscNotes() {
        return this.studyHasDiscNotes;
    }

    public void setStudyHasDiscNotes(Boolean studyHasDiscNotes) {
        this.studyHasDiscNotes = studyHasDiscNotes;
    }

    public void setCurrentUser(UserAccountBean currentUser) {
        this.currentUser = currentUser;
    }

    private String viewNotesLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        if (this.getResolutionStatus() >= 1 && this.getResolutionStatus() <= 5) {
            actionLink.a().href("ViewNotes?viewForOne=y&id=" + studySubject.getId() + "&resolutionStatus=" + this.resolutionStatus + "discNoteType=" + this.discNoteType + "&module=" + this.module + "&listNotes_f_studySubject.label=" + studySubject.getLabel());
            actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\"");
            actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_View1','images/bt_View.gif');\"").close();
            actionLink.img().name("bt_View1").src("images/bt_View.gif").border("0").alt(this.resword.getString("view")).title(this.resword.getString("view")).append((Object)"hspace=\"4\" style=\"float:left\" width=\"24 \" height=\"15\" align=\"left\"").end().aEnd();
            actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        } else {
            actionLink.a().href("ViewNotes?viewForOne=y&id=" + studySubject.getId() + "&module=" + this.module + "&listNotes_f_studySubject.label=" + studySubject.getLabel());
            actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\"");
            actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_View1','images/bt_View.gif');\"").close();
            actionLink.img().name("bt_View1").src("images/bt_View.gif").border("0").alt(this.resword.getString("view")).title(this.resword.getString("view")).append((Object)"hspace=\"2\" style=\"float:left\" width=\"24 \" height=\"15\" align=\"left\"").end().aEnd();
            actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        }
        return actionLink.toString();
    }

    private String downloadNotesLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        if (this.isStudyHasDiscNotes().booleanValue()) {
            if (this.getResolutionStatus() >= 1 && this.getResolutionStatus() <= 5) {
                actionLink.a().href("javascript:openDocWindow('ChooseDownloadFormat?subjectId=" + studySubject.getId() + "&discNoteType=" + this.discNoteType + "&resolutionStatus=" + this.resolutionStatus + "')").close();
                actionLink.img().name("bt_Download").src("images/bt_Download.gif").border("0").alt(this.resword.getString("download_discrepancy_notes")).title(this.resword.getString("download_discrepancy_notes")).append((Object)"hspace=\"4\" width=\"24 \" height=\"15\"").end().aEnd();
                actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
            } else {
                actionLink.a().href("javascript:openDocWindow('ChooseDownloadFormat?subjectId=" + studySubject.getId() + "&discNoteType=" + this.discNoteType + "&module=" + this.module + "')").close();
                actionLink.img().name("bt_View1").src("images/bt_Download.gif").border("0").alt(this.resword.getString("download_discrepancy_notes")).title(this.resword.getString("download_discrepancy_notes")).append((Object)"hspace=\"2\" width=\"24 \" height=\"15\"").end().aEnd();
                actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
            }
        }
        return actionLink.toString();
    }

    public Set<Integer> getResolutionStatusIds() {
        return this.resolutionStatusIds;
    }

    public void setResolutionStatusIds(Set<Integer> resolutionStatusIds) {
        this.resolutionStatusIds = resolutionStatusIds;
    }

    public HashMap<ResolutionStatus, Integer> countAll(HashMap<ResolutionStatus, Integer> discCounts, StudyEventBean studyEvent, StringBuffer constraints, boolean isSite) {
        HashMap temp = new HashMap();
        temp = this.getDiscrepancyNoteDAO().countByEntityTypeAndStudyEventWithConstraints("itemData", studyEvent, constraints, isSite);
        this.getTotal(discCounts, temp);
        temp = this.getDiscrepancyNoteDAO().countByEntityTypeAndStudyEventWithConstraints("subject", studyEvent, constraints, isSite);
        this.getTotal(discCounts, temp);
        temp = this.getDiscrepancyNoteDAO().countByEntityTypeAndStudyEventWithConstraints("eventCrf", studyEvent, constraints, isSite);
        this.getTotal(discCounts, temp);
        temp = this.getDiscrepancyNoteDAO().countByEntityTypeAndStudyEventWithConstraints("StudySub", studyEvent, constraints, isSite);
        this.getTotal(discCounts, temp);
        temp = this.getDiscrepancyNoteDAO().countByEntityTypeAndStudyEventWithConstraints("studyEvent", studyEvent, constraints, isSite);
        this.getTotal(discCounts, temp);
        return discCounts;
    }

    public HashMap<ResolutionStatus, Integer> getTotal(HashMap<ResolutionStatus, Integer> discCounts, HashMap<ResolutionStatus, Integer> discCountsTemp) {
        if (discCountsTemp.size() > 0) {
            for (int i = 1; i < 6; ++i) {
                Integer c = 0;
                if (discCounts.get(ResolutionStatus.get((int)i)) != null) {
                    c = discCounts.get(ResolutionStatus.get((int)i));
                }
                if (discCountsTemp.get(ResolutionStatus.get((int)i)) == null) continue;
                discCounts.put(ResolutionStatus.get((int)i), c + discCountsTemp.get(ResolutionStatus.get((int)i)));
            }
        }
        return discCounts;
    }

    static /* synthetic */ String access$600(ListDiscNotesSubjectTableFactory x0, StudySubjectBean x1) {
        return x0.viewNotesLinkBuilder(x1);
    }

    static /* synthetic */ String access$700(ListDiscNotesSubjectTableFactory x0, StudySubjectBean x1) {
        return x0.downloadNotesLinkBuilder(x1);
    }
}

