/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.hibernate.RuleSetDao;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleAuditDao;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleAuditBean;
import org.akaza.openclinica.domain.rule.RuleSetRuleBean;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class UpdateRuleSetRuleServlet
extends SecureController {
    private static final long serialVersionUID = 1L;
    RuleSetDao ruleSetDao;
    RuleSetServiceInterface ruleSetService;
    RuleSetRuleDao ruleSetRuleDao;
    RuleSetRuleAuditDao ruleSetRuleAuditDao;
    private static String RULESET_ID = "ruleSetId";
    private static String RULESETRULE_ID = "ruleSetRuleId";
    private static String ACTION = "action";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String ruleSetId = this.request.getParameter(RULESET_ID);
        String ruleSetRuleId = this.request.getParameter(RULESETRULE_ID);
        String source = this.request.getParameter("source");
        String action = this.request.getParameter(ACTION);
        Status status = null;
        String pageMessage = "";
        if (ruleSetRuleId != null) {
            RuleSetRuleBean ruleSetRule = (RuleSetRuleBean)this.getRuleSetRuleDao().findById(Integer.valueOf(ruleSetRuleId));
            if (ruleSetRuleId != null && action.equals("remove")) {
                status = Status.DELETED;
                this.updateRuleSetRule(ruleSetRule, status);
                pageMessage = "view_rules_remove_confirmation";
            } else if (ruleSetRuleId != null && action.equals("restore")) {
                status = Status.AVAILABLE;
                ruleSetRule.getRuleSetBean().setStatus(Status.AVAILABLE);
                this.updateRuleSetRule(ruleSetRule, status);
                pageMessage = "view_rules_restore_confirmation";
            }
        }
        if (ruleSetRuleId == null && ruleSetId != null && action.equals("remove")) {
            RuleSetBean rs = (RuleSetBean)this.getRuleSetDao().findById(Integer.valueOf(ruleSetId));
            for (RuleSetRuleBean theRuleSetRule : rs.getRuleSetRules()) {
                if (theRuleSetRule.getStatus() == Status.DELETED) continue;
                status = Status.DELETED;
                this.updateRuleSetRule(theRuleSetRule, status);
            }
            pageMessage = "view_rules_remove_confirmation";
        }
        this.addPageMessage(resword.getString(pageMessage));
        if (source != null && source.equals("ViewRuleSet")) {
            this.context.getRequestDispatcher("/ViewRuleSet?ruleSetId=" + ruleSetId).forward((ServletRequest)this.request, (ServletResponse)this.response);
        } else {
            this.forwardPage(Page.LIST_RULE_SETS_SERVLET);
        }
    }

    private void updateRuleSetRule(RuleSetRuleBean ruleSetRule, Status status) {
        ruleSetRule.setStatus(status);
        ruleSetRule.setUpdater(this.ub);
        ruleSetRule = (RuleSetRuleBean)this.getRuleSetRuleDao().saveOrUpdate((DomainObject)ruleSetRule);
        this.createRuleSetRuleAuditBean(ruleSetRule, this.ub, status);
    }

    private void createRuleSetRuleAuditBean(RuleSetRuleBean ruleSetRuleBean, UserAccountBean ub, Status status) {
        RuleSetRuleAuditBean ruleSetRuleAuditBean = new RuleSetRuleAuditBean();
        ruleSetRuleAuditBean.setRuleSetRuleBean(ruleSetRuleBean);
        ruleSetRuleAuditBean.setUpdater(ub);
        ruleSetRuleAuditBean.setStatus(status);
        this.getRuleSetRuleAuditDao().saveOrUpdate((DomainObject)ruleSetRuleAuditBean);
    }

    private RuleSetDao getRuleSetDao() {
        this.ruleSetDao = this.ruleSetDao != null ? this.ruleSetDao : (RuleSetDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetDao");
        return this.ruleSetDao;
    }

    private RuleSetRuleDao getRuleSetRuleDao() {
        this.ruleSetRuleDao = this.ruleSetRuleDao != null ? this.ruleSetRuleDao : (RuleSetRuleDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetRuleDao");
        return this.ruleSetRuleDao;
    }

    private RuleSetRuleAuditDao getRuleSetRuleAuditDao() {
        this.ruleSetRuleAuditDao = this.ruleSetRuleAuditDao != null ? this.ruleSetRuleAuditDao : (RuleSetRuleAuditDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetRuleAuditDao");
        return this.ruleSetRuleAuditDao;
    }
}

