/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.ws.rs.Produces;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.controller.helper.HelperObject;
import org.akaza.openclinica.controller.helper.ReportLog;
import org.akaza.openclinica.controller.helper.TransferObject;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.OpenClinicaMailSender;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.CrfVersionDao;
import org.akaza.openclinica.dao.hibernate.EventCrfDao;
import org.akaza.openclinica.dao.hibernate.StudyEventDao;
import org.akaza.openclinica.dao.hibernate.StudySubjectDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.datamap.CrfVersion;
import org.akaza.openclinica.domain.datamap.EventCrf;
import org.akaza.openclinica.domain.datamap.StudyEvent;
import org.akaza.openclinica.domain.datamap.StudySubject;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BatchCRFMigrationController
implements Runnable {
    @Autowired
    private DataSource dataSource;
    @Autowired
    OpenClinicaMailSender openClinicaMailSender;
    @Autowired
    private EventCrfDao eventCrfDao;
    @Autowired
    private StudySubjectDao studySubjectDao;
    @Autowired
    private StudyEventDao studyEventDao;
    @Autowired
    private CrfVersionDao crfVersionDao;
    @Autowired
    private SessionFactory sessionFactory;
    private HelperObject helperObject;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    ResourceBundle resterms;
    List<EventCRFBean> eventCrfListToMigrate;
    CRFVersionBean sourceCrfVersionBean;
    CRFVersionBean targetCrfVersionBean;
    ReportLog reportLog;
    StudyBean stBean;
    CRFBean cBean;
    UserAccountBean userAccountBean;
    HttpServletRequest request;
    String urlBase;

    public BatchCRFMigrationController() {
    }

    public BatchCRFMigrationController(HelperObject helperObject) {
        this.helperObject = helperObject;
    }

    @RequestMapping(value={"/forms/migrate/{filename}/downloadLogFile"})
    public void getLogFile(@PathVariable(value="filename") String fileName, HttpServletResponse response) throws Exception {
        InputStream inputStream = null;
        try {
            String logFileName = this.getFilePath() + File.separator + fileName;
            File fileToDownload = new File(logFileName);
            inputStream = new FileInputStream(fileToDownload);
            response.setContentType("application/force-download");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (Exception e) {
            this.logger.debug("Request could not be completed at this moment. Please try again.");
            this.logger.debug(e.getStackTrace().toString());
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.debug(e.getStackTrace().toString());
                    throw e;
                }
            }
        }
    }

    @Produces(value={"application/json"})
    @RequestMapping(value={"/auth/api/v1/forms/migrate/run"}, method={RequestMethod.POST})
    public ResponseEntity<ReportLog> runAuthMigration(@RequestBody TransferObject transferObject, HttpServletRequest request) throws Exception {
        ResponseEntity res = this.runPreviewTest(transferObject, request);
        HelperObject helperObject = (HelperObject)res.getBody();
        helperObject.setRequest(request);
        this.fillHelperObject(helperObject);
        ReportLog reportLog = helperObject.getReportLog();
        String str = "";
        if (reportLog.getSubjectCount() != 0 && reportLog.getEventCrfCount() != 0 && reportLog.getErrors().size() == 0) {
            BatchCRFMigrationController bcmController = new BatchCRFMigrationController(helperObject);
            Thread thread = new Thread((Runnable)bcmController);
            thread.start();
            str = this.resterms.getString("Batch_CRF_version_migration_is_running_You_will_receive_an_email_once_the_process_is_complete");
            reportLog.setReportPreview(str);
            return new ResponseEntity((Object)reportLog, HttpStatus.OK);
        }
        if (reportLog.getErrors().size() > 0) {
            return new ResponseEntity((Object)reportLog, HttpStatus.NOT_ACCEPTABLE);
        }
        str = this.resterms.getString("Migration_did_not_run_due_to_no_affected_subject");
        reportLog.setReportPreview(str);
        return new ResponseEntity((Object)reportLog, HttpStatus.OK);
    }

    @Produces(value={"application/json"})
    @RequestMapping(value={"/api/v1/forms/migrate/run"}, method={RequestMethod.POST})
    @ResponseBody
    public String runMigration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        TransferObject transferObject = this.getUIComponents(request);
        String crfId = request.getParameter("crfId");
        ResponseEntity res = this.runPreviewTest(transferObject, request);
        HelperObject helperObject = (HelperObject)res.getBody();
        this.fillHelperObject(helperObject);
        helperObject.setRequest(request);
        ReportLog reportLog = helperObject.getReportLog();
        String pageMessages = null;
        if (reportLog.getSubjectCount() != 0 && reportLog.getEventCrfCount() != 0 && reportLog.getErrors().size() == 0) {
            BatchCRFMigrationController bcmController = new BatchCRFMigrationController(helperObject);
            Thread thread = new Thread((Runnable)bcmController);
            thread.start();
            pageMessages = this.resterms.getString("Batch_CRF_version_migration_is_running_You_will_receive_an_email_once_the_process_is_complete");
            return (String)this.redirect(request, response, "/ListCRF?module=manage&isFromCRFVersionBatchChange=" + pageMessages);
        }
        pageMessages = this.resterms.getString("Error_in_Running_Migration_Please_try_again");
        return (String)this.redirect(request, response, "/BatchCRFMigration?module=manage&crfId=" + crfId + "&isFromCRFVersionBatchChange=" + pageMessages);
    }

    @Produces(value={"application/json"})
    @RequestMapping(value={"/auth/api/v1/forms/migrate/preview"}, method={RequestMethod.POST})
    public ResponseEntity<ReportLog> runAuthPreview(@RequestBody TransferObject transferObject, HttpServletRequest request) throws Exception {
        ResponseEntity res = this.runPreviewTest(transferObject, request);
        HelperObject helperObject = (HelperObject)res.getBody();
        return new ResponseEntity((Object)helperObject.getReportLog(), HttpStatus.OK);
    }

    @Produces(value={"application/json"})
    @RequestMapping(value={"/api/v1/forms/migrate/preview"}, method={RequestMethod.POST})
    @ResponseBody
    public ReportLog runPreview(HttpServletRequest request, HttpServletResponse response) throws Exception {
        TransferObject transferObject = this.getUIComponents(request);
        ResponseEntity res = this.runPreviewTest(transferObject, request);
        HelperObject helperObject = (HelperObject)res.getBody();
        helperObject.getReportLog().setReportPreview(this.toStringHtmlFormat(helperObject.getReportLog(), this.resterms));
        return helperObject.getReportLog();
    }

    public void executeMigrationAction(HelperObject helperObject, EventCRFBean eventCRFBean) {
        Session session = helperObject.getSession();
        EventCrf eventCrf = (EventCrf)helperObject.getEventCrfDao().findById(Integer.valueOf(eventCRFBean.getId()));
        StudyEvent studyEvent = (StudyEvent)helperObject.getStudyEventDao().findById(Integer.valueOf(eventCRFBean.getStudyEventId()));
        CrfVersion crfVersion = (CrfVersion)helperObject.getCrfVersionDao().findById(Integer.valueOf(helperObject.getTargetCrfVersionBean().getId()));
        StudySubject studySubject = (StudySubject)helperObject.getStudySubjectDao().findById(Integer.valueOf(eventCRFBean.getStudySubjectId()));
        eventCrf.setSdvStatus(false);
        eventCrf.setDateUpdated(new Date());
        eventCrf.setSdvUpdateId(Integer.valueOf(helperObject.getUserAccountBean().getId()));
        eventCrf.setUpdateId(Integer.valueOf(helperObject.getUserAccountBean().getId()));
        eventCrf.setCrfVersion(crfVersion);
        session.saveOrUpdate((Object)eventCrf);
        String status_before_update = null;
        SubjectEventStatus eventStatus = null;
        if (studySubject.getStatus() == Status.SIGNED) {
            status_before_update = this.auditDao().findLastStatus("study_subject", studySubject.getStudySubjectId(), "8");
            if (status_before_update != null && status_before_update.length() == 1) {
                int subject_status = Integer.parseInt(status_before_update);
                Status status = Status.getByCode((Integer)subject_status);
                studySubject.setStatus(status);
            }
            studySubject.setUpdateId(Integer.valueOf(helperObject.getUserAccountBean().getId()));
            session.saveOrUpdate((Object)studySubject);
        }
        studyEvent.setUpdateId(Integer.valueOf(helperObject.getUserAccountBean().getId()));
        studyEvent.setDateUpdated(new Date());
        status_before_update = this.auditDao().findLastStatus("study_event", studyEvent.getStudyEventId(), "8");
        if (status_before_update != null && status_before_update.length() == 1) {
            int status = Integer.parseInt(status_before_update);
            eventStatus = SubjectEventStatus.get((int)status);
            studyEvent.setSubjectEventStatusId(Integer.valueOf(eventStatus.getId()));
        }
        session.saveOrUpdate((Object)studyEvent);
    }

    public ResponseEntity<HelperObject> runPreviewTest(TransferObject transferObject, HttpServletRequest request) throws Exception {
        HelperObject helperObject = new HelperObject();
        Locale locale = request.getLocale();
        this.resterms = ResourceBundleProvider.getTermsBundle((Locale)locale);
        UserAccountBean userAccountBean = this.getCurrentUser(request);
        ReportLog reportLog = new ReportLog();
        String studyOid = transferObject.getStudyOID();
        String sourceCrfVersion = transferObject.getSourceFormVersion();
        String targetCrfVersion = transferObject.getTargetFormVersion();
        ArrayList<String> studyEventDefnlist = transferObject.getStudyEventDefs();
        ArrayList<String> studyEventDefnlistFiltered = new ArrayList<String>();
        ArrayList<String> sitelist = transferObject.getSites();
        ArrayList<String> sitelistFiltered = new ArrayList<String>();
        CRFVersionBean sourceCrfVersionBean = this.cvdao().findByOid(sourceCrfVersion);
        CRFVersionBean targetCrfVersionBean = this.cvdao().findByOid(targetCrfVersion);
        StudyBean stBean = this.sdao().findByOid(studyOid);
        if (stBean == null || !stBean.getStatus().isAvailable() || stBean.getParentStudyId() != 0) {
            reportLog.getErrors().add(this.resterms.getString("The_OID_of_the_Target_Study_that_you_provided_is_invalid"));
            helperObject.setReportLog(reportLog);
            return new ResponseEntity((Object)helperObject, HttpStatus.NOT_ACCEPTABLE);
        }
        StudyUserRoleBean suRole = this.uadao().findRoleByUserNameAndStudyId(userAccountBean.getName(), stBean.getId());
        Role r = suRole.getRole();
        if (suRole == null || !r.equals((Term)Role.STUDYDIRECTOR) && !r.equals((Term)Role.COORDINATOR)) {
            reportLog.getErrors().add(this.resterms.getString("You_do_not_have_permission_to_perform_CRF_version_migration_in_this_study"));
            helperObject.setReportLog(reportLog);
            return new ResponseEntity((Object)helperObject, HttpStatus.NOT_ACCEPTABLE);
        }
        if (sourceCrfVersionBean == null || targetCrfVersionBean == null) {
            if (sourceCrfVersion.equals("-1") || targetCrfVersion.equals("-1")) {
                reportLog.getErrors().add(this.resterms.getString("Current_CRF_version_and_New_CRF_version_should_be_selected"));
            } else {
                reportLog.getErrors().add(this.resterms.getString("The_OID_of_the_CRF_Version_that_you_provided_is_invalid"));
            }
            helperObject.setReportLog(reportLog);
            return new ResponseEntity((Object)helperObject, HttpStatus.NOT_ACCEPTABLE);
        }
        if (sourceCrfVersionBean.getId() == targetCrfVersionBean.getId()) {
            reportLog.getErrors().add(this.resterms.getString("Current_CRF_version_and_New_CRF_version_can_not_be_same"));
            helperObject.setReportLog(reportLog);
            return new ResponseEntity((Object)helperObject, HttpStatus.NOT_ACCEPTABLE);
        }
        if (sourceCrfVersionBean.getCrfId() != targetCrfVersionBean.getCrfId() || !sourceCrfVersionBean.getStatus().isAvailable() || !targetCrfVersionBean.getStatus().isAvailable()) {
            reportLog.getErrors().add(this.resterms.getString("The_OID_of_the_CRF_Version_that_you_provided_is_invalid"));
            helperObject.setReportLog(reportLog);
            return new ResponseEntity((Object)helperObject, HttpStatus.NOT_ACCEPTABLE);
        }
        CRFBean cBean = this.cdao().findByPK(sourceCrfVersionBean.getCrfId());
        if (sitelist.size() == 0) {
            ArrayList listOfSites = this.sdao().findAllByParent(stBean.getId());
            sitelist.add(stBean.getOid());
            Iterator iterator = listOfSites.iterator();
            while (iterator.hasNext()) {
                StudyBean s = (StudyBean)iterator.next();
                if (!s.getStatus().isAvailable()) continue;
                sitelist.add(s.getOid());
            }
        } else {
            for (String string : sitelist) {
                StudyBean siteBean = this.sdao().findByOid(string.trim());
                if (siteBean == null || this.getParentStudy(siteBean).getId() != stBean.getId()) {
                    reportLog.getErrors().add(this.resterms.getString("The_OID_of_the_Site_that_you_provided_is_invalid"));
                    helperObject.setReportLog(reportLog);
                    return new ResponseEntity((Object)helperObject, HttpStatus.NOT_ACCEPTABLE);
                }
                if (!siteBean.getStatus().isAvailable()) continue;
                sitelistFiltered.add(string);
            }
            sitelist = sitelistFiltered;
        }
        if (studyEventDefnlist.size() == 0) {
            ArrayList listOfDefn = this.seddao().findAllByStudy(stBean);
            Iterator iterator = listOfDefn.iterator();
            while (iterator.hasNext()) {
                StudyEventDefinitionBean d = (StudyEventDefinitionBean)iterator.next();
                if (!d.getStatus().isAvailable()) continue;
                studyEventDefnlist.add(d.getOid());
            }
        } else {
            for (String string : studyEventDefnlist) {
                StudyEventDefinitionBean sedefnBean = this.seddao().findByOid(string);
                if (sedefnBean == null || sedefnBean.getStudyId() != stBean.getId()) {
                    reportLog.getErrors().add(this.resterms.getString("The_OID_of_the_Event_that_you_provided_is_invalid"));
                    helperObject.setReportLog(reportLog);
                    return new ResponseEntity((Object)helperObject, HttpStatus.NOT_ACCEPTABLE);
                }
                if (!sedefnBean.getStatus().isAvailable()) continue;
                studyEventDefnlistFiltered.add(string);
            }
            studyEventDefnlist = studyEventDefnlistFiltered;
        }
        int eventCrfCount = this.ssdao().getTotalEventCrfCountForCrfMigration(sourceCrfVersionBean, targetCrfVersionBean, studyEventDefnlist, sitelist);
        reportLog.setEventCrfCount(eventCrfCount);
        int n = this.ssdao().getTotalCountStudySubjectForCrfMigration(sourceCrfVersionBean, targetCrfVersionBean, studyEventDefnlist, sitelist);
        reportLog.setSubjectCount(n);
        ArrayList crfMigrationDoesNotPerformList = this.edcdao().findAllCrfMigrationDoesNotPerform(sourceCrfVersionBean, targetCrfVersionBean, studyEventDefnlist, sitelist);
        for (EventDefinitionCRFBean crfMigrationDoesNotPerform : crfMigrationDoesNotPerformList) {
            StudyEventDefinitionBean seddBean = this.seddao().findByPK(crfMigrationDoesNotPerform.getStudyEventDefinitionId());
            StudyBean sssBean = this.sdao().findByPK(crfMigrationDoesNotPerform.getStudyId());
            reportLog.getCanNotMigrate().add(this.resterms.getString("CRF_Version_Migration_cannot_be_performed_for") + " " + sssBean.getName() + " " + seddBean.getName() + ". " + this.resterms.getString("Both_CRF_versions_are_not_available_at_the_Site"));
        }
        List eventCrfListToMigrate = this.ecdao().findAllCRFMigrationReportList(sourceCrfVersionBean, targetCrfVersionBean, studyEventDefnlist, sitelist);
        helperObject.setReportLog(reportLog);
        helperObject.setStBean(stBean);
        helperObject.setcBean(cBean);
        helperObject.setEventCrfListToMigrate(eventCrfListToMigrate);
        helperObject.setSourceCrfVersionBean(sourceCrfVersionBean);
        helperObject.setTargetCrfVersionBean(targetCrfVersionBean);
        helperObject.setUserAccountBean(userAccountBean);
        return new ResponseEntity((Object)helperObject, HttpStatus.OK);
    }

    private StudyBean getParentStudy(StudyBean study) {
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = this.sdao().findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private StudyDAO sdao() {
        return new StudyDAO(this.dataSource);
    }

    private EventCRFDAO ecdao() {
        return new EventCRFDAO(this.dataSource);
    }

    private StudyEventDAO sedao() {
        return new StudyEventDAO(this.dataSource);
    }

    private StudyEventDefinitionDAO seddao() {
        return new StudyEventDefinitionDAO(this.dataSource);
    }

    private StudySubjectDAO ssdao() {
        return new StudySubjectDAO(this.dataSource);
    }

    private EventDefinitionCRFDAO edcdao() {
        return new EventDefinitionCRFDAO(this.dataSource);
    }

    private UserAccountDAO uadao() {
        return new UserAccountDAO(this.dataSource);
    }

    private CRFDAO cdao() {
        return new CRFDAO(this.dataSource);
    }

    private CRFVersionDAO cvdao() {
        return new CRFVersionDAO(this.dataSource);
    }

    private AuditDAO auditDao() {
        return new AuditDAO(this.dataSource);
    }

    private UserAccountBean getCurrentUser(HttpServletRequest request) {
        UserAccountBean ub = (UserAccountBean)request.getSession().getAttribute("userBean");
        return ub;
    }

    private File createLogFile(String fileName) {
        new File(this.getFilePath()).mkdir();
        String logFileName = this.getFilePath() + File.separator + fileName;
        File logFile = new File(logFileName);
        return logFile;
    }

    private String getFilePath() {
        String versionMigrationFilePath = CoreResources.getField((String)"filePath") + "crf_version_migration_batch_log_file";
        return versionMigrationFilePath;
    }

    private PrintWriter openFile(File file) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(file.getPath(), "UTF-8");
        return writer;
    }

    private void closeFile(PrintWriter writer) {
        writer.close();
    }

    private String getReportUrl(String filename, String urlBase) {
        String reportUrl = urlBase + "/pages/forms/migrate/" + filename + "/downloadLogFile";
        return reportUrl;
    }

    public TransferObject getUIComponents(HttpServletRequest request) {
        String selectedSites = request.getParameter("selectedSites");
        String selectedEvents = request.getParameter("selectedEvents");
        List<String> selectedSiteList = Arrays.asList(selectedSites.split(","));
        List<String> selectedEventList = Arrays.asList(selectedEvents.split(","));
        ArrayList<String> selectedSiteArrayList = new ArrayList<String>(selectedSiteList);
        ArrayList<String> selectedEventArrayList = new ArrayList<String>(selectedEventList);
        if (selectedSiteArrayList.contains("-1")) {
            selectedSiteArrayList.clear();
        }
        if (selectedEventArrayList.contains("-1")) {
            selectedEventArrayList.clear();
        }
        TransferObject transferObject = new TransferObject();
        transferObject.setSites(selectedSiteArrayList);
        transferObject.setStudyEventDefs(selectedEventArrayList);
        transferObject.setSourceFormVersion(request.getParameter("selectedSourceVersion"));
        transferObject.setTargetFormVersion(request.getParameter("selectedTargetVersion"));
        transferObject.setStudyOID(request.getParameter("studyOid"));
        return transferObject;
    }

    public String toStringTextFormat(ReportLog reportLog, ResourceBundle resterms, StudyBean stBean, CRFBean cBean) {
        StringBuffer text1 = new StringBuffer();
        for (Object migrationPerform : reportLog.getCanNotMigrate()) {
            text1.append(((String)migrationPerform).toString()).append('\n');
        }
        StringBuffer text2 = new StringBuffer();
        for (Object error : reportLog.getErrors()) {
            text2.append(((String)error).toString()).append('\n');
        }
        StringBuffer text3 = new StringBuffer();
        for (String log : reportLog.getLogs()) {
            text3.append(log.toString()).append('\n');
        }
        StringBuilder sb = new StringBuilder();
        sb.append(resterms.getString("Study") + ": " + stBean.getName() + "\n");
        sb.append(resterms.getString("CRF") + ": " + cBean.getName() + "\n\n");
        sb.append(resterms.getString("Migration_Summary") + ":\n" + resterms.getString("Number_of_Subjects_affected_by_migration") + ": " + reportLog.getSubjectCount() + "\n");
        sb.append(resterms.getString("Number_of_Event_CRF_affected_by_migration") + ": " + reportLog.getEventCrfCount() + "\n");
        sb.append(text1.toString() + "\n");
        if (reportLog.getErrors().size() != 0) {
            sb.append(resterms.getString("Errors") + ":\n" + text2.toString() + "\n");
        }
        sb.append(resterms.getString("Report_Log") + ":\n" + resterms.getString("CRF_Name__Origin_Version__Target_Version__Subject_ID__Site__Event__Event_Ordinal") + "\n" + text3.toString());
        return sb.toString();
    }

    public String toStringHtmlFormat(ReportLog reportLog, ResourceBundle resterms) {
        StringBuffer text1 = new StringBuffer();
        for (Object migrationPerform : reportLog.getCanNotMigrate()) {
            text1.append(((String)migrationPerform).toString()).append("<br>");
        }
        StringBuffer text2 = new StringBuffer();
        for (Object error : reportLog.getErrors()) {
            text2.append(((String)error).toString()).append("<br>");
        }
        StringBuffer text3 = new StringBuffer();
        for (String log : reportLog.getLogs()) {
            text3.append(log.toString()).append("<br>");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<br>");
        if (reportLog.getErrors().size() == 0) {
            sb.append("<font size=\"3\" color=\"#D4A718\"><b>");
            sb.append(resterms.getString("Migration_Summary") + ":");
            sb.append("</b></font>");
            sb.append("<br>");
            sb.append("<br>");
            sb.append(resterms.getString("Number_of_Subjects_to_be_affected_by_migration") + ": " + reportLog.getSubjectCount() + "<br>");
            sb.append(resterms.getString("Number_of_Event_CRF_to_be_affected_by_migration") + ": " + reportLog.getEventCrfCount() + "<br>");
            sb.append("<br>");
            sb.append(text1.toString() + "<br>");
        }
        if (reportLog.getErrors().size() != 0) {
            sb.append("<font size=\"3\" color=\"#D4A718\" ><b>");
            sb.append(resterms.getString("Errors") + ":");
            sb.append("</b></font>");
            sb.append("<br>");
            sb.append("<font color=\"red\"><b>");
            sb.append(text2.toString());
            sb.append("</b></font>");
            sb.append("<br>");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object redirect(HttpServletRequest request, HttpServletResponse response, String location) {
        try {
            response.sendRedirect(request.getContextPath() + location);
        }
        catch (Exception e) {
            this.logger.debug(e.getStackTrace().toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.dataSource = this.helperObject.getDataSource();
        this.cBean = this.helperObject.getcBean();
        this.reportLog = this.helperObject.getReportLog();
        this.stBean = this.helperObject.getStBean();
        this.resterms = this.helperObject.getResterms();
        this.userAccountBean = this.helperObject.getUserAccountBean();
        this.openClinicaMailSender = this.helperObject.getOpenClinicaMailSender();
        this.sessionFactory = this.helperObject.getSessionFactory();
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        this.helperObject.setSession(session);
        int i = 0;
        for (EventCRFBean eventCrfToMigrate : this.helperObject.getEventCrfListToMigrate()) {
            this.executeMigrationAction(this.helperObject, eventCrfToMigrate);
            if (++i % 50 == 0) {
                session.flush();
                session.clear();
            }
            StudySubjectBean ssBean = this.ssdao().findByPK(eventCrfToMigrate.getStudySubjectId());
            StudyBean sBean = this.sdao().findByPK(ssBean.getStudyId());
            StudyEventBean seBean = this.sedao().findByPK(eventCrfToMigrate.getStudyEventId());
            StudyEventDefinitionBean sedBean = this.seddao().findByPK(seBean.getStudyEventDefinitionId());
            this.reportLog.getLogs().add(this.cBean.getName() + "," + this.helperObject.getSourceCrfVersionBean().getName() + "," + this.helperObject.getTargetCrfVersionBean().getName() + "," + ssBean.getLabel() + "," + sBean.getName() + "," + sedBean.getName() + "," + seBean.getSampleOrdinal());
        }
        tx.commit();
        session.close();
        String fileName = new SimpleDateFormat("_yyyy-MM-dd-hhmmssSaa'.txt'").format(new Date());
        fileName = "logFile" + fileName;
        File file = this.createLogFile(fileName);
        PrintWriter writer = null;
        try {
            writer = this.openFile(file);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            this.logger.error("Error in creating file for logging report: ", (Throwable)e);
        }
        finally {
            writer.print(this.toStringTextFormat(this.reportLog, this.resterms, this.stBean, this.cBean));
            this.closeFile(writer);
        }
        String reportUrl = this.getReportUrl(fileName, this.helperObject.getUrlBase());
        String fullName = this.userAccountBean.getFirstName() + " " + this.userAccountBean.getLastName();
        StringBuilder body = new StringBuilder();
        body.append(this.resterms.getString("Dear") + " " + fullName + ",<br><br>" + this.resterms.getString("Batch_CRF_version_migration_has_finished_running") + "<br>" + this.resterms.getString("Study") + ": " + this.stBean.getName() + "<br>" + this.resterms.getString("CRF") + ": " + this.cBean.getName() + "<br><br>" + this.resterms.getString("A_summary_report_of_the_migration_is_available_here") + ":<br>" + reportUrl + "<br><br>" + this.resterms.getString("Thank_you_Your_OpenClinica_System"));
        this.logger.info(body.toString());
        this.openClinicaMailSender.sendEmail(this.userAccountBean.getEmail(), EmailEngine.getAdminEmail(), this.resterms.getString("Batch_Migration_Complete_For") + " " + this.stBean.getName(), body.toString(), Boolean.valueOf(true));
    }

    public void fillHelperObject(HelperObject helperObject) {
        helperObject.setUrlBase(CoreResources.getField((String)"sysURL").split("/MainMenu")[0]);
        helperObject.setOpenClinicaMailSender(this.openClinicaMailSender);
        helperObject.setDataSource(this.dataSource);
        helperObject.setResterms(this.resterms);
        helperObject.setEventCrfDao(this.eventCrfDao);
        helperObject.setStudyEventDao(this.studyEventDao);
        helperObject.setStudySubjectDao(this.studySubjectDao);
        helperObject.setCrfVersionDao(this.crfVersionDao);
        helperObject.setSessionFactory(this.sessionFactory);
    }
}

