/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.CrfVersionDao;
import org.akaza.openclinica.dao.hibernate.EventCrfDao;
import org.akaza.openclinica.dao.hibernate.ItemDao;
import org.akaza.openclinica.dao.hibernate.ItemDataDao;
import org.akaza.openclinica.dao.hibernate.ItemFormMetadataDao;
import org.akaza.openclinica.dao.hibernate.ItemGroupDao;
import org.akaza.openclinica.dao.hibernate.ItemGroupMetadataDao;
import org.akaza.openclinica.dao.hibernate.ResponseTypeDao;
import org.akaza.openclinica.dao.hibernate.StudyEventDao;
import org.akaza.openclinica.dao.hibernate.StudyEventDefinitionDao;
import org.akaza.openclinica.dao.hibernate.StudySubjectDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.domain.datamap.CrfVersion;
import org.akaza.openclinica.domain.datamap.EventCrf;
import org.akaza.openclinica.domain.datamap.Item;
import org.akaza.openclinica.domain.datamap.ItemData;
import org.akaza.openclinica.domain.datamap.ItemFormMetadata;
import org.akaza.openclinica.domain.datamap.ItemGroup;
import org.akaza.openclinica.domain.datamap.ItemGroupMetadata;
import org.akaza.openclinica.domain.datamap.ResponseType;
import org.akaza.openclinica.domain.datamap.StudyEvent;
import org.akaza.openclinica.domain.datamap.StudyEventDefinition;
import org.akaza.openclinica.domain.datamap.StudySubject;
import org.akaza.openclinica.service.pmanage.Authorization;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.web.pform.EnketoAPI;
import org.akaza.openclinica.web.pform.EnketoCredentials;
import org.akaza.openclinica.web.pform.PFormCache;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Controller
@RequestMapping(value={"/api/v1/editform"})
public class EditFormController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ServletContext context;
    @Autowired
    private CrfVersionDao crfVersionDao;
    @Autowired
    private StudyEventDao studyEventDao;
    @Autowired
    private StudyEventDefinitionDao studyEventDefinitionDao;
    @Autowired
    private StudySubjectDao studySubjectDao;
    @Autowired
    private EventCrfDao eventCrfDao;
    @Autowired
    private ItemDao itemDao;
    @Autowired
    private ItemGroupDao itemGroupDao;
    @Autowired
    private ItemGroupMetadataDao itemGroupMetadataDao;
    @Autowired
    private ItemFormMetadataDao itemFormMetadataDao;
    @Autowired
    private ResponseTypeDao responseTypeDao;
    @Autowired
    private ItemDataDao itemDataDao;
    public static final String FORM_CONTEXT = "ecid";
    ParticipantPortalRegistrar participantPortalRegistrar;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    UserAccountDAO udao;
    StudyDAO sdao;

    @RequestMapping(value={"/{studyOid}/url"}, method={RequestMethod.GET})
    public ResponseEntity<String> getEditUrl(@RequestParam(value="ecid") String formContext, @PathVariable(value="studyOid") String studyOID) throws Exception {
        String editURL = null;
        if (!this.mayProceed(studyOID)) {
            return new ResponseEntity(editURL, HttpStatus.NOT_ACCEPTABLE);
        }
        PFormCache cache = PFormCache.getInstance((ServletContext)this.context);
        HashMap userContext = cache.getSubjectContext(formContext);
        StudyEventDefinition eventDef = (StudyEventDefinition)this.studyEventDefinitionDao.findById(Integer.valueOf((String)userContext.get("studyEventDefinitionID")));
        CrfVersion crfVersion = this.crfVersionDao.findByOcOID((String)userContext.get("crfVersionOID"));
        StudySubject subject = this.studySubjectDao.findByOcOID((String)userContext.get("studySubjectOID"));
        StudyEvent event = this.studyEventDao.fetchByStudyEventDefOIDAndOrdinal(eventDef.getOc_oid(), Integer.valueOf((String)userContext.get("studyEventOrdinal")), Integer.valueOf(subject.getStudySubjectId()));
        EventCrf eventCrf = this.eventCrfDao.findByStudyEventIdStudySubjectIdCrfVersionId(event.getStudyEventId(), subject.getStudySubjectId(), crfVersion.getCrfVersionId());
        String populatedInstance = this.getPopulatedInstance(crfVersion, eventCrf);
        EnketoAPI enketo = new EnketoAPI(EnketoCredentials.getInstance((String)studyOID));
        String redirectUrl = this.getRedirectUrl(subject.getOcOid(), studyOID);
        editURL = enketo.getEditURL(crfVersion.getOcOid(), populatedInstance, formContext, redirectUrl).getEdit_url() + "&ecid=" + formContext;
        this.logger.debug("Generating Enketo edit url for form: " + editURL);
        return new ResponseEntity((Object)editURL, HttpStatus.ACCEPTED);
    }

    private String getRedirectUrl(String studySubjectOid, String studyOid) {
        String portalURL = CoreResources.getField((String)"portalURL");
        String url = "";
        if (portalURL != null && !portalURL.equals("")) {
            ParticipantPortalRegistrar registrar = new ParticipantPortalRegistrar();
            Authorization pManageAuthorization = registrar.getAuthorization(studyOid);
            try {
                URL pManageUrl = new URL(portalURL);
                if (pManageAuthorization != null && pManageAuthorization.getStudy() != null && pManageAuthorization.getStudy().getHost() != null && !pManageAuthorization.getStudy().getHost().equals("")) {
                    url = pManageUrl.getProtocol() + "://" + pManageAuthorization.getStudy().getHost() + "." + pManageUrl.getHost() + (pManageUrl.getPort() > 0 ? ":" + String.valueOf(pManageUrl.getPort()) : "");
                }
            }
            catch (MalformedURLException e) {
                this.logger.error("Error building redirect URL: " + e.getMessage());
                this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                return "";
            }
        }
        if (!url.equals("")) {
            url = url + "/#/event/" + studySubjectOid + "/dashboard";
        }
        return url;
    }

    private String getPopulatedInstance(CrfVersion crfVersion, EventCrf eventCrf) throws Exception {
        boolean isXform = false;
        if (crfVersion.getXform() != null && !crfVersion.getXform().equals("")) {
            isXform = true;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder build = docFactory.newDocumentBuilder();
        Document doc = build.newDocument();
        Element crfElement = null;
        crfElement = isXform ? doc.createElement(crfVersion.getXformName()) : doc.createElement(crfVersion.getOcOid());
        doc.appendChild(crfElement);
        ArrayList itemGroups = this.itemGroupDao.findByCrfVersionId(Integer.valueOf(crfVersion.getCrfVersionId()));
        for (ItemGroup itemGroup : itemGroups) {
            ItemGroupMetadata itemGroupMetadata = (ItemGroupMetadata)this.itemGroupMetadataDao.findByItemGroupCrfVersion(Integer.valueOf(itemGroup.getItemGroupId()), Integer.valueOf(crfVersion.getCrfVersionId())).get(0);
            ArrayList items = this.itemDao.findByItemGroupCrfVersionOrdered(Integer.valueOf(itemGroup.getItemGroupId()), Integer.valueOf(crfVersion.getCrfVersionId()));
            int maxGroupRepeat = this.itemDataDao.getMaxGroupRepeat(Integer.valueOf(eventCrf.getEventCrfId()), Integer.valueOf(((Item)items.get(0)).getItemId()));
            Boolean isrepeating = itemGroupMetadata.isRepeatingGroup();
            for (int i = 0; i < maxGroupRepeat; ++i) {
                Element groupElement = null;
                groupElement = isXform ? doc.createElement(itemGroup.getName()) : doc.createElement(itemGroup.getOcOid());
                Element repeatOrdinal = null;
                if (isrepeating.booleanValue()) {
                    repeatOrdinal = doc.createElement("OC.REPEAT_ORDINAL");
                    repeatOrdinal.setTextContent(String.valueOf(i + 1));
                    groupElement.appendChild(repeatOrdinal);
                }
                boolean hasItemData = false;
                for (Item item : items) {
                    ItemFormMetadata itemMetadata = this.itemFormMetadataDao.findByItemCrfVersion(Integer.valueOf(item.getItemId()), Integer.valueOf(crfVersion.getCrfVersionId()));
                    ItemData itemData = this.itemDataDao.findByItemEventCrfOrdinal(Integer.valueOf(item.getItemId()), Integer.valueOf(eventCrf.getEventCrfId()), Integer.valueOf(i + 1));
                    Element question = null;
                    question = crfVersion.getXform() != null && !crfVersion.getXform().equals("") ? doc.createElement(item.getName()) : doc.createElement(item.getOcOid());
                    if (itemData != null && itemData.getValue() != null && !itemData.getValue().equals("")) {
                        ResponseType responseType = this.responseTypeDao.findByItemFormMetaDataId(Integer.valueOf(itemMetadata.getItemFormMetadataId()));
                        String itemValue = itemData.getValue();
                        if (responseType.getResponseTypeId() == 3 || responseType.getResponseTypeId() == 7) {
                            itemValue = itemValue.replaceAll(",", " ");
                        }
                        question.setTextContent(itemValue);
                    }
                    if (itemData != null && itemData.isDeleted().booleanValue()) continue;
                    hasItemData = true;
                    groupElement.appendChild(question);
                }
                if (!hasItemData) continue;
                crfElement.appendChild(groupElement);
            }
        }
        TransformerFactory transformFactory = TransformerFactory.newInstance();
        Transformer transformer = transformFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        String instance = writer.toString();
        this.logger.debug("Editable instance = {}", (Object)instance);
        return instance;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private StudyBean getStudy(String oid) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByOid(oid);
        return studyBean;
    }

    private boolean mayProceed(String studyOid) throws Exception {
        boolean accessPermission = false;
        StudyBean siteStudy = this.getStudy(studyOid);
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(study.getOid()).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        String siteStatus = siteStudy.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus + "   siteStatus: " + siteStatus);
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && siteStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE")) {
            accessPermission = true;
        }
        return accessPermission;
    }
}

