/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.controller.SidebarInit;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.StudyModuleStatusDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.managestudy.StudyModuleStatus;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.pmanage.Authorization;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.StudyInfoPanel;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller(value="studyModuleController")
@RequestMapping(value={"/studymodule"})
@SessionAttributes(value={"studyModuleStatus"})
public class StudyModuleController {
    @Autowired
    @Qualifier(value="sidebarInit")
    private SidebarInit sidebarInit;
    @Autowired
    @Qualifier(value="studyModuleStatusDao")
    private StudyModuleStatusDao studyModuleStatusDao;
    @Autowired
    @Qualifier(value="ruleSetService")
    private RuleSetServiceInterface ruleSetService;
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    private StudyEventDefinitionDAO studyEventDefinitionDao;
    private CRFDAO crfDao;
    private StudyGroupClassDAO studyGroupClassDao;
    private StudyDAO studyDao;
    private UserAccountDAO userDao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String REG_MESSAGE = "regMessages";
    public static ResourceBundle respage;
    @Autowired
    CoreResources coreResources;

    @RequestMapping(value={"/{study}/deactivate"}, method={RequestMethod.GET})
    public String deactivateParticipate(@PathVariable(value="study") String studyOid, HttpServletRequest request) throws Exception {
        this.studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean study = this.studyDao.findByOid(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean spv = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        spv.setStudyId(study.getId());
        spv.setParameter("participantPortal");
        spv.setValue("disabled");
        if (spv.getId() > 0) {
            spvdao.update(spv);
        } else {
            spvdao.create(spv);
        }
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        currentStudy.getStudyParameterConfig().setParticipantPortal("disabled");
        return "redirect:/pages/studymodule";
    }

    @RequestMapping(value={"/{study}/deactivaterandomization"}, method={RequestMethod.GET})
    public String deactivateRandomization(@PathVariable(value="study") String studyOid, HttpServletRequest request) throws Exception {
        this.studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean study = this.studyDao.findByOid(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean spv = spvdao.findByHandleAndStudy(study.getId(), "randomization");
        spv.setStudyId(study.getId());
        spv.setParameter("randomization");
        spv.setValue("disabled");
        if (spv.getId() > 0) {
            spvdao.update(spv);
        } else {
            spvdao.create(spv);
        }
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        currentStudy.getStudyParameterConfig().setRandomization("disabled");
        return "redirect:/pages/studymodule";
    }

    @RequestMapping(value={"/{study}/reactivate"}, method={RequestMethod.GET})
    public String reactivateParticipate(@PathVariable(value="study") String studyOid, HttpServletRequest request) throws Exception {
        this.studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean study = this.studyDao.findByOid(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean spv = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        spv.setStudyId(study.getId());
        spv.setParameter("participantPortal");
        spv.setValue("enabled");
        if (spv.getId() > 0) {
            spvdao.update(spv);
        } else {
            spvdao.create(spv);
        }
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        currentStudy.getStudyParameterConfig().setParticipantPortal("enabled");
        return "redirect:/pages/studymodule";
    }

    @RequestMapping(value={"/{study}/reactivaterandomization"}, method={RequestMethod.GET})
    public String reactivateRandomization(@PathVariable(value="study") String studyOid, HttpServletRequest request) throws Exception {
        this.studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean study = this.studyDao.findByOid(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean spv = spvdao.findByHandleAndStudy(study.getId(), "randomization");
        spv.setStudyId(study.getId());
        spv.setParameter("randomization");
        spv.setValue("enabled");
        if (spv.getId() > 0) {
            spvdao.update(spv);
        } else {
            spvdao.create(spv);
        }
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        currentStudy.getStudyParameterConfig().setRandomization("enabled");
        return "redirect:/pages/studymodule";
    }

    @RequestMapping(value={"/{study}/register"}, method={RequestMethod.POST})
    public String registerParticipate(@PathVariable(value="study") String studyOid, HttpServletRequest request) throws Exception {
        this.studyDao = new StudyDAO((DataSource)this.dataSource);
        StudyBean study = this.studyDao.findByOid(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean spv = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        ParticipantPortalRegistrar registrar = new ParticipantPortalRegistrar();
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
        ResourceBundleProvider.updateLocale((Locale)locale);
        respage = ResourceBundleProvider.getPageMessagesBundle((Locale)locale);
        String hostName = request.getParameter("hostName");
        if (hostName == null || hostName.equals("")) {
            this.addRegMessage(request, respage.getString("participate_hostname_invalid"));
            return "redirect:/pages/studymodule";
        }
        String status = "";
        String nameAvailability = registrar.getHostNameAvailability(hostName);
        if (nameAvailability.equals("unavailable")) {
            this.addRegMessage(request, respage.getString("participate_hostname_not_available"));
            return "redirect:/pages/studymodule";
        }
        if (nameAvailability.equals("unknown")) {
            this.addRegMessage(request, respage.getString("participate_not_available"));
            return "redirect:/pages/studymodule";
        }
        if (nameAvailability.equals("invalid")) {
            this.addRegMessage(request, respage.getString("participate_hostname_invalid"));
            return "redirect:/pages/studymodule";
        }
        status = registrar.registerStudy(study.getOid(), hostName, study.getIdentifier());
        if (status.equals("")) {
            this.addRegMessage(request, respage.getString("participate_not_available"));
        } else {
            spv.setStudyId(study.getId());
            spv.setParameter("participantPortal");
            spv.setValue("enabled");
            if (spv.getId() > 0) {
                spvdao.update(spv);
            } else {
                spvdao.create(spv);
            }
            StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
            currentStudy.getStudyParameterConfig().setParticipantPortal("enabled");
        }
        return "redirect:/pages/studymodule";
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelMap handleMainPage(HttpServletRequest request, HttpServletResponse response) {
        ModelMap map = new ModelMap();
        StudyInfoPanel panel = new StudyInfoPanel();
        UserAccountBean userBean = (UserAccountBean)request.getSession().getAttribute("userBean");
        if (!this.mayProceed(request)) {
            try {
                response.sendRedirect(request.getContextPath() + "/MainMenu?message=authentication_failed");
            }
            catch (Exception e) {
                this.logger.error("Error while redirecting to MainMenu: ", (Throwable)e);
            }
            return null;
        }
        panel.reset();
        request.getSession().setAttribute("panel", (Object)panel);
        ResourceBundleProvider.updateLocale((Locale)LocaleResolver.getLocale((HttpServletRequest)request));
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        this.studyEventDefinitionDao = new StudyEventDefinitionDAO((DataSource)this.dataSource);
        this.crfDao = new CRFDAO((DataSource)this.dataSource);
        this.studyGroupClassDao = new StudyGroupClassDAO((DataSource)this.dataSource);
        this.studyDao = new StudyDAO((DataSource)this.dataSource);
        this.userDao = new UserAccountDAO((DataSource)this.dataSource);
        StudyModuleStatus sms = this.studyModuleStatusDao.findByStudyId(currentStudy.getId());
        if (sms == null) {
            sms = new StudyModuleStatus();
            sms.setStudyId(currentStudy.getId());
        }
        int crfCount = this.crfDao.findAllByStudy(currentStudy.getId()).size();
        int crfWithEventDefinition = this.crfDao.findAllActiveByDefinitions(currentStudy.getId()).size();
        int totalCrf = crfCount + crfWithEventDefinition;
        int eventDefinitionCount = this.studyEventDefinitionDao.findAllActiveByStudy(currentStudy).size();
        int subjectGroupCount = this.studyGroupClassDao.findAllActiveByStudy(currentStudy).size();
        int ruleCount = this.ruleSetService.getCountByStudy(currentStudy);
        int siteCount = this.studyDao.findOlnySiteIdsByStudy(currentStudy).size();
        int userCount = this.userDao.findAllUsersByStudy(currentStudy.getId()).size();
        ArrayList childStudies = this.studyDao.findAllByParent(currentStudy.getId());
        HashMap<String, Integer> childStudyUserCount = new HashMap<String, Integer>();
        for (StudyBean childStudy : childStudies) {
            childStudyUserCount.put(childStudy.getName(), this.userDao.findAllUsersByStudy(childStudy.getId()).size());
        }
        if (sms.getCrf() == 0) {
            sms.setCrf(1);
        }
        if (sms.getCrf() != 3 && totalCrf > 0) {
            sms.setCrf(2);
        }
        if (sms.getEventDefinition() == 0) {
            sms.setEventDefinition(1);
        }
        if (sms.getEventDefinition() != 3 && eventDefinitionCount > 0) {
            sms.setEventDefinition(2);
        }
        if (sms.getSubjectGroup() == 0) {
            sms.setSubjectGroup(1);
        }
        if (sms.getSubjectGroup() != 3 && subjectGroupCount > 0) {
            sms.setSubjectGroup(2);
        }
        if (sms.getRule() == 0) {
            sms.setRule(1);
        }
        if (sms.getRule() != 3 && ruleCount > 0) {
            sms.setRule(2);
        }
        if (sms.getSite() == 0) {
            sms.setSite(1);
        }
        if (sms.getSite() != 3 && siteCount > 0) {
            sms.setSite(2);
        }
        if (sms.getUsers() == 0) {
            sms.setUsers(1);
        }
        if (sms.getUsers() != 3 && userCount > 0) {
            sms.setUsers(2);
        }
        map.addAttribute((Object)sms);
        map.addAttribute("crfCount", (Object)totalCrf);
        map.addAttribute("eventDefinitionCount", (Object)eventDefinitionCount);
        map.addAttribute("subjectGroupCount", (Object)subjectGroupCount);
        map.addAttribute("ruleCount", (Object)ruleCount);
        map.addAttribute("siteCount", (Object)siteCount);
        map.addAttribute("userCount", (Object)userCount);
        map.addAttribute("childStudyUserCount", childStudyUserCount);
        map.addAttribute("studyId", (Object)currentStudy.getId());
        map.addAttribute("currentStudy", (Object)currentStudy);
        String portalURL = CoreResources.getField((String)"portalURL");
        map.addAttribute("portalURL", (Object)portalURL);
        if (portalURL != null && !portalURL.equals("")) {
            String participateOCStatus = currentStudy.getStudyParameterConfig().getParticipantPortal();
            ParticipantPortalRegistrar registrar = new ParticipantPortalRegistrar();
            Authorization pManageAuthorization = registrar.getAuthorization(currentStudy.getOid());
            String participateStatus = "";
            String url = "";
            try {
                URL pManageUrl = new URL(portalURL);
                if (pManageAuthorization != null && pManageAuthorization.getAuthorizationStatus() != null && pManageAuthorization.getAuthorizationStatus().getStatus() != null) {
                    participateStatus = pManageAuthorization.getAuthorizationStatus().getStatus();
                }
                map.addAttribute("participateURL", (Object)pManageUrl);
                map.addAttribute("participateOCStatus", (Object)participateOCStatus);
                map.addAttribute("participateStatus", (Object)participateStatus);
                if (pManageAuthorization != null && pManageAuthorization.getStudy() != null && pManageAuthorization.getStudy().getHost() != null && !pManageAuthorization.getStudy().getHost().equals("")) {
                    url = pManageUrl.getProtocol() + "://" + pManageAuthorization.getStudy().getHost() + "." + pManageUrl.getHost() + (pManageUrl.getPort() > 0 ? ":" + String.valueOf(pManageUrl.getPort()) : "");
                }
            }
            catch (MalformedURLException e) {
                this.logger.error(e.getMessage());
                this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            map.addAttribute("participateURLDisplay", (Object)url);
        }
        String moduleManager = CoreResources.getField((String)"moduleManager");
        map.addAttribute("moduleManager", (Object)moduleManager);
        if (moduleManager != null && !moduleManager.equals("")) {
            String randomizationOCStatus = currentStudy.getStudyParameterConfig().getRandomization();
            String randomizationStatus = "";
            Object randomizeUrl = null;
            map.addAttribute("randomizeURL", randomizeUrl);
            map.addAttribute("randomizationOCStatus", (Object)randomizationOCStatus);
            map.addAttribute("randomizationStatus", (Object)randomizationStatus);
        }
        if (null != this.coreResources) {
            map.addAttribute("ruleDesignerURL", (Object)CoreResources.getField((String)"designer.url"));
            map.addAttribute("contextPath", (Object)this.getContextPath(request));
            this.logMe("before checking getHostPath url = " + request.getRequestURL());
            map.addAttribute("hostPath", (Object)this.getHostPathFromSysUrl(CoreResources.getField((String)"sysURL.base"), request.getContextPath()));
            map.addAttribute("path", (Object)"pages/studymodule");
        }
        request.setAttribute("userBean", (Object)userBean);
        ArrayList statusMap = Status.toStudyUpdateMembersList();
        request.setAttribute("statusMap", (Object)statusMap);
        if (currentStudy.getParentStudyId() > 0) {
            StudyBean parentStudy = this.studyDao.findByPK(currentStudy.getParentStudyId());
            request.setAttribute("parentStudy", (Object)parentStudy);
        }
        ArrayList pageMessages = new ArrayList();
        if (request.getSession().getAttribute("pageMessages") != null) {
            pageMessages.addAll(ClassCastHelper.asList((Object)request.getSession().getAttribute("pageMessages"), String.class));
            request.setAttribute("pageMessages", pageMessages);
            request.getSession().removeAttribute("pageMessages");
        }
        ArrayList regMessages = new ArrayList();
        if (request.getSession().getAttribute(REG_MESSAGE) != null) {
            regMessages.addAll(ClassCastHelper.asList((Object)request.getSession().getAttribute(REG_MESSAGE), String.class));
            request.setAttribute(REG_MESSAGE, regMessages);
            request.getSession().removeAttribute(REG_MESSAGE);
        }
        return map;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String processSubmit(@ModelAttribute(value="studyModuleStatus") StudyModuleStatus studyModuleStatus, BindingResult result, SessionStatus status, HttpServletRequest request) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (request.getParameter("saveStudyStatus") == null) {
            this.studyModuleStatusDao.saveOrUpdate((DomainObject)studyModuleStatus);
            status.setComplete();
        } else {
            currentStudy.setOldStatus(currentStudy.getStatus());
            currentStudy.setStatus(Status.get((int)studyModuleStatus.getStudyStatus()));
            if (currentStudy.getParentStudyId() > 0) {
                this.studyDao.updateStudyStatus(currentStudy);
            } else {
                this.studyDao.updateStudyStatus(currentStudy);
            }
            ArrayList siteList = this.studyDao.findAllByParent(currentStudy.getId());
            if (siteList.size() > 0) {
                this.studyDao.updateSitesStatus(currentStudy);
            }
        }
        return "redirect:studymodule";
    }

    @ExceptionHandler(value={HttpSessionRequiredException.class})
    public String handleSessionRequiredException(HttpSessionRequiredException ex, HttpServletRequest request) {
        return "redirect:/MainMenu";
    }

    @ExceptionHandler(value={NullPointerException.class})
    public String handleNullPointerException(NullPointerException ex, HttpServletRequest request, HttpServletResponse response) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (currentStudy == null) {
            return "redirect:/MainMenu";
        }
        throw ex;
    }

    private void addRegMessage(HttpServletRequest request, String message) {
        ArrayList<String> regMessages = ClassCastHelper.asArrayList((Object)request.getSession().getAttribute(REG_MESSAGE), String.class);
        if (regMessages == null) {
            regMessages = new ArrayList<String>();
        }
        regMessages.add(message);
        this.logger.debug(message);
        request.getSession().setAttribute(REG_MESSAGE, regMessages);
    }

    public SidebarInit getSidebarInit() {
        return this.sidebarInit;
    }

    public void setSidebarInit(SidebarInit sidebarInit) {
        this.sidebarInit = sidebarInit;
    }

    public StudyModuleStatusDao getStudyModuleStatusDao() {
        return this.studyModuleStatusDao;
    }

    public BasicDataSource getDataSource() {
        return this.dataSource;
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath().replaceAll("/", "");
        return contextPath;
    }

    public String getRequestURLMinusServletPath(HttpServletRequest request) {
        String requestURLMinusServletPath = request.getRequestURL().toString().replaceAll(request.getServletPath(), "");
        this.logMe("processing.." + requestURLMinusServletPath);
        return requestURLMinusServletPath;
    }

    public String getHostPath(HttpServletRequest request) {
        this.logMe("into the getHostPath/....URL = " + request.getRequestURL() + "URI=" + request.getRequestURI() + "PROTOCOL=");
        String requestURLMinusServletPath = this.getRequestURLMinusServletPath(request);
        String hostPath = "";
        if (null != requestURLMinusServletPath) {
            String tmpPath = requestURLMinusServletPath.substring(0, requestURLMinusServletPath.lastIndexOf("/"));
            this.logMe("processing2..." + tmpPath);
            hostPath = tmpPath.substring(0, tmpPath.lastIndexOf("/"));
            this.logMe("processing2..." + hostPath);
        }
        this.logMe("after all the stripping returning" + hostPath);
        return hostPath;
    }

    public String getWebAppName(String servletCtxRealPath) {
        String webAppName = null;
        if (null != servletCtxRealPath) {
            String[] tokens = servletCtxRealPath.split("\\\\");
            webAppName = tokens[tokens.length - 1].trim();
        }
        return webAppName;
    }

    private boolean mayProceed(HttpServletRequest request) {
        StudyUserRoleBean currentRole = (StudyUserRoleBean)request.getSession().getAttribute("userRole");
        Role r = currentRole.getRole();
        return r.equals((Term)Role.ADMIN) || r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR);
    }

    private String getHostPathFromSysUrl(String sysURL, String contextPath) {
        return sysURL.replaceAll(contextPath + "/", "");
    }

    private void logMe(String msg) {
        this.logger.debug(msg);
    }
}

