/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.naming.directory.InitialDirContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.extract.ExtractPropertyBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.pmanage.Authorization;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/auth/api/v1/system"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class SystemController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    private JavaMailSenderImpl mailSender;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/systemstatus"}, method={RequestMethod.POST})
    public ResponseEntity<HashMap<String, String>> getSystemStatus() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("OpenClinica Version", CoreResources.getField((String)"OpenClinica.version"));
        map.put("Java Version", System.getProperty("java.version"));
        map.put("Java Class Path", System.getProperty("java.class.path"));
        map.put("Java Home", System.getProperty("java.home"));
        map.put("OS Name", System.getProperty("os.name"));
        map.put("OS Version", System.getProperty("os.version"));
        map.put("OS Architecture", System.getProperty("os.arch"));
        map.put("File Separator", System.getProperty("file.separator"));
        map.put("Path Separator", System.getProperty("path.separator"));
        map.put("Line Separator", System.getProperty("line.separator"));
        map.put("User Home", System.getProperty("user.home"));
        map.put("User Directory", System.getProperty("user.dir"));
        map.put("User Name", System.getProperty("user.name"));
        Map<String, String> env = System.getenv();
        for (String envName : env.keySet()) {
            System.out.format("%s=%s%n", envName, env.get(envName));
        }
        try {
            UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
            UserAccountBean uBean = udao.findByPK(1);
            if (uBean.getFirstName().equals("Root") && uBean.getLastName().equals("User")) {
                map.put("Root User Account First And Last Name", uBean.getFirstName() + " " + uBean.getLastName());
                map.put("Database Connection", "PASS");
            } else {
                map.put("Database Connection", "FAIL");
            }
        }
        catch (Exception e) {
            this.logger.error("Error while uBean accessing details", (Throwable)e);
        }
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.GET})
    public ResponseEntity<HashMap<String, Object>> getConfig() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HashMap map = new HashMap();
        HashMap<String, String> ocVersion = new HashMap<String, String>();
        ResourceBundle resLicense = ResourceBundleProvider.getLicensingBundle();
        String versionRelease = resLicense.getString("Version_release");
        ocVersion.put("OC Edition", resLicense.getString("footer.edition.2"));
        ocVersion.put("OC Version number", versionRelease.substring(versionRelease.indexOf("Version") + 9, versionRelease.lastIndexOf(45) - 1));
        ocVersion.put("OC Version Changeset", versionRelease.substring(versionRelease.indexOf("- Changeset") + 13));
        map.put("OC.Version", ocVersion);
        HashMap<String, Object> datainfo = new HashMap<String, Object>();
        HashMap<String, String> databaseConfiguration = new HashMap<String, String>();
        databaseConfiguration.put("dbType", CoreResources.getField((String)"dbType"));
        databaseConfiguration.put("db", CoreResources.getField((String)"db"));
        HashMap<String, String> emailSystem = new HashMap<String, String>();
        emailSystem.put("mailHost", CoreResources.getField((String)"mailHost"));
        emailSystem.put("mailPort", CoreResources.getField((String)"mailPort"));
        emailSystem.put("mailProtocol", CoreResources.getField((String)"mailProtocol"));
        emailSystem.put("mailSmtpAuth", CoreResources.getField((String)"mailSmtpAuth"));
        emailSystem.put("mailSmtpStarttls.enable", CoreResources.getField((String)"mailSmtpStarttls.enable"));
        emailSystem.put("mailSmtpsAuth", CoreResources.getField((String)"mailSmtpsAuth"));
        emailSystem.put("mailSmtpsStarttls.enable", CoreResources.getField((String)"mailSmtpsStarttls.enable"));
        emailSystem.put("mailSmtpConnectionTimeout", CoreResources.getField((String)"mailSmtpConnectionTimeout"));
        emailSystem.put("mailErrorMsg", CoreResources.getField((String)"mailErrorMsg"));
        HashMap<String, String> loggingConfiguration = new HashMap<String, String>();
        loggingConfiguration.put("log.dir", CoreResources.getField((String)"log.dir"));
        loggingConfiguration.put("logLocation", CoreResources.getField((String)"logLocation"));
        loggingConfiguration.put("logLevel", CoreResources.getField((String)"logLevel"));
        loggingConfiguration.put("syslog.host", CoreResources.getField((String)"syslog.host"));
        loggingConfiguration.put("syslog.port", CoreResources.getField((String)"syslog.port"));
        HashMap<String, String> news = new HashMap<String, String>();
        news.put("rssUrl", CoreResources.getField((String)"rssUrl"));
        news.put("rssMore", CoreResources.getField((String)"rssMore"));
        news.put("about.text1", CoreResources.getField((String)"about.text1"));
        news.put("about.text2", CoreResources.getField((String)"about.text2"));
        HashMap<String, String> crfFileUploadConfiguration = new HashMap<String, String>();
        crfFileUploadConfiguration.put("crfFileExtensions", CoreResources.getField((String)"crfFileExtensions"));
        crfFileUploadConfiguration.put("crfFileExtensionSettings", CoreResources.getField((String)"crfFileExtensionSettings"));
        HashMap<String, String> quartzSchedulerConfiguration = new HashMap<String, String>();
        quartzSchedulerConfiguration.put("org.quartz.jobStore.misfireThreshold", CoreResources.getField((String)"org.quartz.jobStore.misfireThreshold"));
        quartzSchedulerConfiguration.put("org.quartz.threadPool.threadCount", CoreResources.getField((String)"org.quartz.threadPool.threadCount"));
        quartzSchedulerConfiguration.put("org.quartz.threadPool.threadPriority", CoreResources.getField((String)"org.quartz.threadPool.threadPriority"));
        HashMap<String, String> facilityInformation = new HashMap<String, String>();
        facilityInformation.put("FacName", CoreResources.getField((String)"FacName"));
        facilityInformation.put("FacCity", CoreResources.getField((String)"FacCity"));
        facilityInformation.put("FacState", CoreResources.getField((String)"FacState"));
        facilityInformation.put("FacZIP", CoreResources.getField((String)"FacZIP"));
        facilityInformation.put("FacCountry", CoreResources.getField((String)"FacCountry"));
        facilityInformation.put("FacContactName", CoreResources.getField((String)"FacContactName"));
        facilityInformation.put("FacContactDegree", CoreResources.getField((String)"FacContactDegree"));
        facilityInformation.put("FacContactPhone", CoreResources.getField((String)"FacContactPhone"));
        facilityInformation.put("FacContactEmail", CoreResources.getField((String)"FacContactEmail"));
        HashMap<String, String> usageStatisticsConfiguration = new HashMap<String, String>();
        usageStatisticsConfiguration.put("collectStats", CoreResources.getField((String)"collectStats"));
        usageStatisticsConfiguration.put("usage.stats.host", CoreResources.getField((String)"usage.stats.host"));
        usageStatisticsConfiguration.put("usage.stats.port", CoreResources.getField((String)"usage.stats.port"));
        usageStatisticsConfiguration.put("OpenClinica.version", CoreResources.getField((String)"OpenClinica.version"));
        HashMap<String, String> ldapConfiguration = new HashMap<String, String>();
        ldapConfiguration.put("ldap.enabled", CoreResources.getField((String)"ldap.enabled"));
        ldapConfiguration.put("ldap.host", CoreResources.getField((String)"ldap.host"));
        ldapConfiguration.put("ldap.loginQuery", CoreResources.getField((String)"ldap.loginQuery"));
        ldapConfiguration.put("ldap.passwordRecoveryURL", CoreResources.getField((String)"ldap.passwordRecoveryURL"));
        ldapConfiguration.put("ldap.userSearch.baseDn", CoreResources.getField((String)"ldap.userSearch.baseDn"));
        ldapConfiguration.put("ldap.userSearch.query", CoreResources.getField((String)"ldap.userSearch.query"));
        ldapConfiguration.put("ldap.userData.distinguishedName", CoreResources.getField((String)"ldap.userData.distinguishedName"));
        ldapConfiguration.put("ldap.userData.username", CoreResources.getField((String)"ldap.userData.username"));
        ldapConfiguration.put("ldap.userData.firstName", CoreResources.getField((String)"ldap.userData.firstName"));
        ldapConfiguration.put("ldap.userData.lastName", CoreResources.getField((String)"ldap.userData.lastName"));
        ldapConfiguration.put("ldap.userData.email", CoreResources.getField((String)"ldap.userData.email"));
        ldapConfiguration.put("ldap.userData.organization", CoreResources.getField((String)"ldap.userData.organization"));
        datainfo.put("database configuration", databaseConfiguration);
        datainfo.put("filePath", CoreResources.getField((String)"filePath"));
        datainfo.put("attachedFileLocation", CoreResources.getField((String)"attachedFileLocation"));
        datainfo.put("userAccountNotification", CoreResources.getField((String)"userAccountNotification"));
        datainfo.put("adminEmail", CoreResources.getField((String)"adminEmail"));
        datainfo.put("mail protocol", emailSystem);
        datainfo.put("sysURL", CoreResources.getField((String)"sysURL"));
        datainfo.put("maxInactiveInterval", CoreResources.getField((String)"maxInactiveInterval"));
        datainfo.put("logging configuration", loggingConfiguration);
        datainfo.put("news", news);
        datainfo.put("crf file upload configuration", crfFileUploadConfiguration);
        datainfo.put("supportURL", CoreResources.getField((String)"supportURL"));
        datainfo.put("quartz scheduler configuration", quartzSchedulerConfiguration);
        datainfo.put("ccts.waitBeforeCommit", CoreResources.getField((String)"ccts.waitBeforeCommit"));
        datainfo.put("facility information", facilityInformation);
        datainfo.put("exportFilePath", CoreResources.getField((String)"exportFilePath"));
        datainfo.put("extract.number", CoreResources.getField((String)"extract.number"));
        datainfo.put("usage statistics configuration", usageStatisticsConfiguration);
        datainfo.put("designerURL", CoreResources.getField((String)"designerURL"));
        datainfo.put("ldap Configuration", ldapConfiguration);
        datainfo.put("portalURL", CoreResources.getField((String)"portalURL"));
        datainfo.put("moduleManager", CoreResources.getField((String)"moduleManager"));
        datainfo.put("xform.enabled", CoreResources.getField((String)"xform.enabled"));
        map.put("datainfo.properties", datainfo);
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @RequestMapping(value={"/extract"}, method={RequestMethod.GET})
    public ResponseEntity<HashMap<String, Object>> getExtractModule() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HashMap map = new HashMap();
        HashMap extractMap = new HashMap();
        ArrayList extracts = CoreResources.getExtractProperties();
        int n = 0;
        for (ExtractPropertyBean extract : extracts) {
            ++n;
            HashMap<String, String> extractmap = new HashMap<String, String>();
            extractmap.put("odmType", extract.getOdmType());
            extractmap.put("file", Arrays.toString(extract.getFileName()));
            extractmap.put("fileDescription", extract.getFiledescription());
            extractmap.put("linkText", extract.getLinkText());
            extractmap.put("helpText", extract.getHelpText());
            extractmap.put("location", extract.getFileLocation());
            extractmap.put("exportname", Arrays.toString(extract.getExportFileName()));
            extractmap.put("zip", String.valueOf(extract.getZipFormat()));
            extractmap.put("deleteOld", String.valueOf(extract.getDeleteOld()));
            extractmap.put("success", extract.getSuccessMessage());
            extractmap.put("failure", extract.getFailureMessage());
            extractMap.put("extract." + n, extractmap);
        }
        HashMap<String, String> extractDatamart = new HashMap<String, String>();
        HashMap datamartRole = new HashMap();
        String username = CoreResources.getExtractField((String)"db1.username");
        String password = CoreResources.getExtractField((String)"db1.password");
        String url = CoreResources.getExtractField((String)"db1.url");
        extractDatamart.put("db1.username", username);
        extractDatamart.put("db1.url", url);
        extractDatamart.put("db1.dataBase", CoreResources.getExtractField((String)"db1.dataBase"));
        HashMap<String, String> extractNumber = new HashMap<String, String>();
        extractNumber.put("extract.number", CoreResources.getExtractField((String)"extract.number"));
        extractMap.put("extract.number", extractNumber);
        HashMap<String, String> datamartMap = new HashMap<String, String>();
        try (Connection conn = DriverManager.getConnection(url, username, password);){
            datamartRole = this.getDbRoleProperties(conn, datamartRole, username);
            datamartMap.put("connection", "Open");
        }
        catch (Exception e) {
            datamartMap.put("connection", "Close");
        }
        map.put("extract.properties", extractMap);
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @RequestMapping(value={"/modules"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<HashMap<String, Object>>> getAllModules(HttpServletRequest request) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        ArrayList studyListMap = new ArrayList();
        HttpSession session = request.getSession();
        session.removeAttribute("ruledesigner");
        session.removeAttribute("messaging");
        session.removeAttribute("datamart");
        session.removeAttribute("webservice");
        session.removeAttribute("ldap");
        ArrayList studyList = this.getStudyList();
        for (StudyBean studyBean : studyList) {
            ArrayList<HashMap> listOfModules = new ArrayList<HashMap>();
            HashMap mapParticipantModule = this.getParticipateModule(studyBean);
            listOfModules.add(mapParticipantModule);
            HashMap mapRuleDesignerModule = this.getRuleDesignerModuleInSession(studyBean, session);
            listOfModules.add(mapRuleDesignerModule);
            HashMap mapMessagingModule = this.getMessagingModuleInSession(studyBean, session);
            listOfModules.add(mapMessagingModule);
            HashMap mapDatamartModule = this.getDatamartModuleInSession(studyBean, session);
            listOfModules.add(mapDatamartModule);
            HashMap mapWebServiceModule = this.getWebServiceModuleInSession(studyBean, session);
            listOfModules.add(mapWebServiceModule);
            HashMap mapLdapModule = this.getLdapModuleInSession(studyBean, session);
            listOfModules.add(mapLdapModule);
            HashMap<String, Object> mapStudy = new HashMap<String, Object>();
            mapStudy.put("Modules", listOfModules);
            mapStudy.put("Study Oid", studyBean.getOid());
            studyListMap.add(mapStudy);
        }
        return new ResponseEntity(studyListMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/modules/participate"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<HashMap<String, Object>>> getParticipateModule() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        ArrayList studyListMap = new ArrayList();
        ArrayList studyList = this.getStudyList();
        for (StudyBean studyBean : studyList) {
            HashMap mapParticipantModule = this.getParticipateModule(studyBean);
            HashMap<String, Object> mapStudy = new HashMap<String, Object>();
            mapStudy.put("Module", mapParticipantModule);
            mapStudy.put("Study Oid", studyBean.getOid());
            studyListMap.add(mapStudy);
        }
        return new ResponseEntity(studyListMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/modules/webservices"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<HashMap<String, Object>>> getWebServicesModule(HttpServletRequest request) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        ArrayList studyListMap = new ArrayList();
        HttpSession session = request.getSession();
        session.removeAttribute("webservice");
        ArrayList studyList = this.getStudyList();
        for (StudyBean studyBean : studyList) {
            HashMap mapRuleDesignerModule = this.getWebServiceModuleInSession(studyBean, session);
            HashMap<String, Object> mapStudy = new HashMap<String, Object>();
            mapStudy.put("Module", mapRuleDesignerModule);
            mapStudy.put("Study Oid", studyBean.getOid());
            studyListMap.add(mapStudy);
        }
        return new ResponseEntity(studyListMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/modules/ruledesigner"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<HashMap<String, Object>>> getRuleDesignerModule(HttpServletRequest request) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        ArrayList studyListMap = new ArrayList();
        HttpSession session = request.getSession();
        session.removeAttribute("ruledesigner");
        ArrayList studyList = this.getStudyList();
        for (StudyBean studyBean : studyList) {
            HashMap mapRuleDesignerModule = this.getRuleDesignerModuleInSession(studyBean, session);
            HashMap<String, Object> mapStudy = new HashMap<String, Object>();
            mapStudy.put("Module", mapRuleDesignerModule);
            mapStudy.put("Study Oid", studyBean.getOid());
            studyListMap.add(mapStudy);
        }
        return new ResponseEntity(studyListMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/modules/datamart"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<HashMap<String, Object>>> getDatamartModule(HttpServletRequest request) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HttpSession session = request.getSession();
        session.removeAttribute("datamart");
        ArrayList studyListMap = new ArrayList();
        ArrayList studyList = this.getStudyList();
        for (StudyBean studyBean : studyList) {
            HashMap mapDatamartModule = this.getDatamartModuleInSession(studyBean, session);
            HashMap<String, Object> mapStudy = new HashMap<String, Object>();
            mapStudy.put("Module", mapDatamartModule);
            mapStudy.put("Study Oid", studyBean.getOid());
            studyListMap.add(mapStudy);
        }
        return new ResponseEntity(studyListMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/modules/auth"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<HashMap<String, Object>>> getLdapModule(HttpServletRequest request) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        ArrayList studyListMap = new ArrayList();
        HttpSession session = request.getSession();
        session.removeAttribute("ldap");
        ArrayList studyList = this.getStudyList();
        for (StudyBean studyBean : studyList) {
            HashMap mapRuleDesignerModule = this.getLdapModuleInSession(studyBean, session);
            HashMap<String, Object> mapStudy = new HashMap<String, Object>();
            mapStudy.put("Module", mapRuleDesignerModule);
            mapStudy.put("Study Oid", studyBean.getOid());
            studyListMap.add(mapStudy);
        }
        return new ResponseEntity(studyListMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/modules/messaging"}, method={RequestMethod.GET})
    public ResponseEntity<ArrayList<HashMap<String, Object>>> getMessagingModule(HttpServletRequest request) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HttpSession session = request.getSession();
        session.removeAttribute("messaging");
        ArrayList studyListMap = new ArrayList();
        ArrayList studyList = this.getStudyList();
        for (StudyBean studyBean : studyList) {
            HashMap mapMessagingModule = this.getMessagingModuleInSession(studyBean, session);
            HashMap<String, Object> mapStudy = new HashMap<String, Object>();
            mapStudy.put("Module", mapMessagingModule);
            mapStudy.put("Study Oid", studyBean.getOid());
            studyListMap.add(mapStudy);
        }
        return new ResponseEntity(studyListMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/filesystem"}, method={RequestMethod.GET})
    public ResponseEntity<HashMap<String, Object>> getFileSystem() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        String filePath = CoreResources.getField((String)"filePath");
        File file = new File(filePath);
        filePath = filePath.substring(0, filePath.indexOf(".data"));
        String tomcatPath = filePath.substring(0, filePath.lastIndexOf("/"));
        File tomcatFile = new File(tomcatPath);
        float freeSpace = new File("/").getFreeSpace();
        map.put("Tomcat Directory Ownership", this.displayOwnerShipForTomcatDirectory(tomcatFile));
        map.put("Available Disk Space on Drive", freeSpace / 1024.0f / 1024.0f + " MB ");
        map.put("openClinica.data Directory & File Count & Size", this.displayOCDataDirectoryCountAndSize(file));
        return new ResponseEntity(map, HttpStatus.OK);
    }

    @RequestMapping(value={"/database"}, method={RequestMethod.GET})
    public ResponseEntity<HashMap<String, Object>> getDatabaseHealthCheck() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap mapRole = new HashMap();
        String username = CoreResources.getField((String)"dbUser");
        String password = CoreResources.getField((String)"dbPass");
        String url = CoreResources.getField((String)"url");
        try (Connection conn = DriverManager.getConnection(url, username, password);){
            map.put("Database Connection", "True");
            map.put("Version", String.valueOf(conn.getMetaData().getDatabaseProductVersion()));
            mapRole = this.getDbRoleProperties(conn, mapRole, username, Boolean.valueOf(true));
        }
        catch (Exception e) {
            map.put("connection", "False");
        }
        map.put("Role Properties", mapRole);
        return new ResponseEntity(map, HttpStatus.OK);
    }

    public ArrayList<String> displayDirectoryContents(File dir, ArrayList<String> list) {
        try {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    list.add((String)file.getCanonicalPath());
                    list = this.displayDirectoryContents(file, list);
                    continue;
                }
                list.add((String)file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            this.logger.error("Error while accessing directory contents: ", (Throwable)e);
        }
        return list;
    }

    public ArrayList<HashMap<String, Object>> displayOCDataDirectoryCountAndSize(File file) throws IOException {
        ArrayList<HashMap<String, Object>> listOfHashMaps = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> hashMap = null;
        if (file.isDirectory()) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("Read Access", this.getReadAccess(file));
            hashMap.put("Write Access", this.getWriteAccess(file));
            int count = 0;
            int fileCount = this.getFilesCount(file, count);
            int dirCount = this.getNumberOfSubFolders(file.getCanonicalPath().toString());
            long length = 0L;
            float sizeInByte = this.getFolderSize(file, length);
            hashMap.put("Folder Name", file.getName());
            hashMap.put("Files Count", String.valueOf(fileCount));
            hashMap.put("size", String.valueOf(sizeInByte / 1024.0f / 1024.0f) + " MB");
            listOfHashMaps.add(hashMap);
            if (dirCount != 0) {
                hashMap.put("Number of SubFolders", String.valueOf(dirCount));
                hashMap.put("Sub Folders", this.displaySubDirectoryCountAndSize(file));
            }
        }
        return listOfHashMaps;
    }

    public ArrayList<HashMap<String, Object>> displaySubDirectoryCountAndSize(File dir) throws IOException {
        File[] files;
        ArrayList<HashMap<String, Object>> listOfHashMaps = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> hashMap = null;
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory()) continue;
            hashMap = new HashMap<String, Object>();
            hashMap.put("Read Access", this.getReadAccess(file));
            hashMap.put("Write Access", this.getWriteAccess(file));
            int count = 0;
            int fileCount = this.getFilesCount(file, count);
            int dirCount = this.getNumberOfSubFolders(file.getCanonicalPath().toString());
            long length = 0L;
            float sizeInByte = this.getFolderSize(file, length);
            hashMap.put("Folder Name", file.getName());
            hashMap.put("Files Count", String.valueOf(fileCount));
            hashMap.put("size", String.valueOf(sizeInByte / 1024.0f / 1024.0f) + " MB");
            listOfHashMaps.add(hashMap);
            if (dirCount == 0) continue;
            hashMap.put("Number of SubFolders", String.valueOf(dirCount));
            hashMap.put("Sub Folders", this.displaySubDirectoryCountAndSize(file));
        }
        return listOfHashMaps;
    }

    public ArrayList<HashMap<String, Object>> displayOwnerShipForTomcatDirectory(File file) throws IOException {
        ArrayList<HashMap<String, Object>> listOfHashMaps = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> hashMap = null;
        if (file.isDirectory()) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("Read Access", this.getReadAccess(file));
            hashMap.put("Write Access", this.getWriteAccess(file));
            hashMap.put("Folder Name", file.getName());
            listOfHashMaps.add(hashMap);
            int dirCount = this.getNumberOfSubFolders(file.getCanonicalPath().toString());
            if (dirCount != 0) {
                hashMap.put("Sub Folders", this.displayOwnerShipForTomcatSubDirectories(file));
            }
        }
        return listOfHashMaps;
    }

    public ArrayList<HashMap<String, Object>> displayOwnerShipForTomcatSubDirectories(File dir) throws IOException {
        File[] files;
        ArrayList<HashMap<String, Object>> listOfHashMaps = new ArrayList<HashMap<String, Object>>();
        HashMap<String, String> hashMap = null;
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory()) continue;
            hashMap = new HashMap<String, String>();
            hashMap.put("Read Access", this.getReadAccess(file));
            hashMap.put("Write Access", this.getWriteAccess(file));
            hashMap.put("Folder Name", file.getName());
            listOfHashMaps.add(hashMap);
            int dirCount = this.getNumberOfSubFolders(file.getCanonicalPath().toString());
            if (dirCount == 0) continue;
        }
        return listOfHashMaps;
    }

    public int getNumberOfSubFolders(String filePath) {
        File file1 = new File(filePath);
        File[] listFiles = file1.listFiles();
        int dirCount = 0;
        if (listFiles != null) {
            for (File f : listFiles) {
                if (!f.isDirectory()) continue;
                ++dirCount;
            }
        }
        return dirCount;
    }

    public int getFilesCount(File file, int count) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    count = this.getFilesCount(f, count);
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    private long getFolderSize(File folder, long length) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            int count = files.length;
            for (int i = 0; i < count; ++i) {
                if (files[i].isFile()) {
                    length += files[i].length();
                    continue;
                }
                length = this.getFolderSize(files[i], length);
            }
        }
        return length;
    }

    public String getWriteAccess(File file) {
        if (file.canWrite()) {
            return "Yes";
        }
        return "No";
    }

    public String getReadAccess(File file) {
        if (file.canRead()) {
            return "Yes";
        }
        return "No";
    }

    public String sendEmail(JavaMailSenderImpl mailSender, String emailSubject, String message) throws OpenClinicaSystemException {
        this.logger.info("Sending email...");
        try {
            MimeMessage mimeMessage = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage);
            helper.setFrom(EmailEngine.getAdminEmail());
            helper.setTo("oc123@openclinica.com");
            helper.setSubject(emailSubject);
            helper.setText(message);
            mailSender.send(mimeMessage);
            return "ACTIVE";
        }
        catch (MailException me) {
            return "INACTIVE";
        }
        catch (MessagingException me) {
            return "INACTIVE";
        }
    }

    public HashMap<String, String> getDbRoleProperties(Connection conn, HashMap<String, String> mapRole, String username, Boolean withoutRoleName) throws SQLException {
        mapRole = this.getDbRoleProperties(conn, mapRole, username);
        if (withoutRoleName.booleanValue()) {
            mapRole.remove("RoleName");
        }
        return mapRole;
    }

    public HashMap<String, String> getDbRoleProperties(Connection conn, HashMap<String, String> mapRole, String username) throws SQLException {
        String query = "select * from pg_roles where rolname='" + username + "'";
        ResultSet resultSet = conn.prepareStatement(query).executeQuery();
        while (resultSet.next()) {
            mapRole.put("RoleName", resultSet.getString("rolname"));
            mapRole.put("SuperUser", resultSet.getString("rolsuper").equals("t") ? "True" : "False");
            mapRole.put("Inherit", resultSet.getString("rolinherit").equals("t") ? "True" : "False");
            mapRole.put("CreateRole", resultSet.getString("rolcreaterole").equals("t") ? "True" : "False");
            mapRole.put("CreateDb", resultSet.getString("rolcreatedb").equals("t") ? "True" : "False");
            mapRole.put("Login", resultSet.getString("rolcanlogin").equals("t") ? "True" : "False");
        }
        return mapRole;
    }

    public ArrayList<StudyBean> getStudyList() {
        StudyDAO sdao = new StudyDAO((DataSource)this.dataSource);
        ArrayList sBeans = sdao.findAllParents();
        return sBeans;
    }

    public StudyParameterValueBean getParticipateMod(StudyBean studyBean, String value) {
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(studyBean.getId(), value);
        return pStatus;
    }

    public HashMap<String, Object> getParticipateModule(StudyBean studyBean) {
        String portalURL = CoreResources.getField((String)"portalURL");
        StudyParameterValueBean spvBean = this.getParticipateMod(studyBean, "participantPortal");
        String ocParticipateStatus = "";
        if (spvBean.isActive()) {
            ocParticipateStatus = spvBean.getValue().toString();
        }
        String ocuiParticipateStatus = "";
        ParticipantPortalRegistrar participantPortalRegistrar = new ParticipantPortalRegistrar();
        if (ocParticipateStatus.equals("enabled")) {
            try {
                ocuiParticipateStatus = participantPortalRegistrar.getRegistrationStatus(studyBean.getOid());
            }
            catch (Exception e) {
                this.logger.error("Error while accessing participant portal registrar: ", (Throwable)e);
            }
        }
        HashMap<String, String> mapMetadata = new HashMap<String, String>();
        String url = "";
        URL pManageUrl = null;
        try {
            pManageUrl = new URL(portalURL);
        }
        catch (MalformedURLException e) {
            this.logger.error("Portal Url is not correct: ", (Throwable)e);
        }
        Authorization pManageAuthorization = participantPortalRegistrar.getAuthorization(studyBean.getOid());
        if (pManageAuthorization != null) {
            url = pManageUrl.getProtocol() + "://" + pManageAuthorization.getStudy().getHost() + "." + pManageUrl.getHost() + (pManageUrl.getPort() > 0 ? ":" + String.valueOf(pManageUrl.getPort()) : "");
            mapMetadata.put("Participate Url", url);
        }
        HashMap<String, Object> mapParticipate = new HashMap<String, Object>();
        mapParticipate.put("enabled", ocParticipateStatus.equals("enabled") ? "True" : "False");
        mapParticipate.put("status", ocuiParticipateStatus.equals("") ? "INACTIVE" : ocuiParticipateStatus);
        mapParticipate.put("metadata", mapMetadata);
        HashMap<String, Object> mapModule = new HashMap<String, Object>();
        mapModule.put("Participate", mapParticipate);
        return mapModule;
    }

    public HashMap<String, Object> getRuleDesignerModule(StudyBean studyBean) {
        String designerUrl = CoreResources.getField((String)"designerURL");
        String result = "";
        HttpURLConnection huc = null;
        try {
            URL u = new URL(designerUrl);
            huc = (HttpURLConnection)u.openConnection();
            huc.setRequestMethod("HEAD");
            huc.connect();
            result = huc.getResponseCode() == 200 ? "ACTIVE" : "INACTIVE";
        }
        catch (Exception ex) {
            result = "INACTIVE";
        }
        HashMap<String, String> mapMetadata = new HashMap<String, String>();
        mapMetadata.put("Designer URL", designerUrl);
        try {
            mapMetadata.put("Http Status Code", String.valueOf(huc.getResponseCode()));
        }
        catch (IOException e) {
            this.logger.error("Error adding the status code: ", (Throwable)e);
        }
        HashMap<String, Object> mapRuleDesigner = new HashMap<String, Object>();
        mapRuleDesigner.put("enabled", !designerUrl.equals("") ? "True" : "False");
        mapRuleDesigner.put("status", result);
        mapRuleDesigner.put("metadata", mapMetadata);
        HashMap<String, Object> mapModule = new HashMap<String, Object>();
        mapModule.put("Rule Designer", mapRuleDesigner);
        return mapModule;
    }

    public HashMap<String, Object> getMessagingModule(StudyBean studyBean) {
        String result = this.sendEmail(this.mailSender, "This is the Subject Of a Rest Call for Health Check", "This is the Body Of a Rest Call for Health Check");
        String mailProtocol = CoreResources.getField((String)"mailProtocol");
        String mailPort = CoreResources.getField((String)"mailPort");
        String mailHost = CoreResources.getField((String)"mailHost");
        HashMap<String, String> mapMetadata = new HashMap<String, String>();
        mapMetadata.put("mail.host", mailHost);
        mapMetadata.put("mail.protocol", mailProtocol);
        HashMap<String, Object> mapMessaging = new HashMap<String, Object>();
        mapMessaging.put("enabled", !mailProtocol.equals("") && !mailPort.equals("") && !mailHost.equals("") ? "True" : "False");
        mapMessaging.put("status", result);
        mapMessaging.put("metadata", mapMetadata);
        HashMap<String, Object> mapModule = new HashMap<String, Object>();
        mapModule.put("Messaging", mapMessaging);
        return mapModule;
    }

    public HashMap<String, Object> getDatamartModule(StudyBean studyBean) {
        HashMap datamartRole = new HashMap();
        String username = CoreResources.getExtractField((String)"db1.username");
        String password = CoreResources.getExtractField((String)"db1.password");
        String url = CoreResources.getExtractField((String)"db1.url");
        ArrayList extracts = CoreResources.getExtractProperties();
        String enabled = "False";
        for (ExtractPropertyBean extract : extracts) {
            if (!extract.getFiledescription().equalsIgnoreCase("Datamart")) continue;
            enabled = "True";
            break;
        }
        String result = "";
        try (Connection conn = DriverManager.getConnection(url, username, password);){
            datamartRole = this.getDbRoleProperties(conn, datamartRole, username);
            result = "ACTIVE";
        }
        catch (Exception e) {
            result = "INACTIVE";
        }
        HashMap<String, Object> mapMetadata = new HashMap<String, Object>();
        mapMetadata.put("db1.username", username);
        mapMetadata.put("db1.url", url);
        mapMetadata.put("db1.dataBase", CoreResources.getExtractField((String)"db1.dataBase"));
        mapMetadata.put("Role Properties", datamartRole);
        HashMap<String, Object> mapDatamart = new HashMap<String, Object>();
        mapDatamart.put("enabled", enabled);
        mapDatamart.put("status", result);
        mapDatamart.put("metadata", mapMetadata);
        HashMap<String, Object> mapModule = new HashMap<String, Object>();
        mapModule.put("Datamart", mapDatamart);
        return mapModule;
    }

    public HashMap<String, Object> getWebServiceModule(StudyBean studyBean) {
        String webserviceUrl = CoreResources.getField((String)"sysURL");
        webserviceUrl = webserviceUrl.replace("/MainMenu", "-ws");
        String result = "";
        HttpURLConnection huc = null;
        try {
            URL u = new URL(webserviceUrl);
            huc = (HttpURLConnection)u.openConnection();
            huc.setRequestMethod("HEAD");
            huc.connect();
            result = huc.getResponseCode() == 200 ? "ACTIVE" : "INACTIVE";
        }
        catch (Exception ex) {
            result = "INACTIVE";
        }
        HashMap<String, String> mapMetadata = new HashMap<String, String>();
        mapMetadata.put("WebService URL", webserviceUrl);
        try {
            mapMetadata.put("Http Status Code", String.valueOf(huc.getResponseCode()));
        }
        catch (IOException e) {
            this.logger.error("Error adding the status code: ", (Throwable)e);
        }
        HashMap<String, Object> mapWebService = new HashMap<String, Object>();
        mapWebService.put("enabled", !webserviceUrl.equals("") ? "True" : "False");
        mapWebService.put("status", result);
        mapWebService.put("metadata", mapMetadata);
        HashMap<String, Object> mapModule = new HashMap<String, Object>();
        mapModule.put("Web Service", mapWebService);
        return mapModule;
    }

    public HashMap<String, Object> getLdapModule(StudyBean studyBean) {
        String enabled = CoreResources.getField((String)"ldap.enabled");
        String ldapHost = CoreResources.getField((String)"ldap.host");
        String username = CoreResources.getField((String)"ldap.userDn");
        String password = CoreResources.getField((String)"ldap.password");
        String result = "";
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapHost);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        try {
            new InitialDirContext(env);
            result = "ACTIVE";
        }
        catch (Exception e) {
            result = "INACTIVE";
        }
        HashMap<String, String> mapMetadata = new HashMap<String, String>();
        mapMetadata.put("ldap.host", ldapHost);
        HashMap<String, Object> mapWebService = new HashMap<String, Object>();
        mapWebService.put("enabled", enabled.equalsIgnoreCase("true") ? "True" : "False");
        mapWebService.put("status", result);
        mapWebService.put("metadata", mapMetadata);
        HashMap<String, Object> mapModule = new HashMap<String, Object>();
        mapModule.put("Ldap", mapWebService);
        return mapModule;
    }

    public HashMap<String, Object> getRuleDesignerModuleInSession(StudyBean studyBean, HttpSession session) {
        HashMap mapModule = ClassCastHelper.asHashMap((Object)session.getAttribute("ruledesigner"), String.class, Object.class);
        if (mapModule == null) {
            mapModule = this.getRuleDesignerModule(studyBean);
            session.setAttribute("ruledesigner", (Object)mapModule);
        }
        return mapModule;
    }

    public HashMap<String, Object> getMessagingModuleInSession(StudyBean studyBean, HttpSession session) {
        HashMap mapModule = ClassCastHelper.asHashMap((Object)session.getAttribute("messaging"), String.class, Object.class);
        if (mapModule == null) {
            mapModule = this.getMessagingModule(studyBean);
            session.setAttribute("messaging", (Object)mapModule);
        }
        return mapModule;
    }

    public HashMap<String, Object> getDatamartModuleInSession(StudyBean studyBean, HttpSession session) {
        HashMap mapModule = ClassCastHelper.asHashMap((Object)session.getAttribute("datamart"), String.class, Object.class);
        if (mapModule == null) {
            mapModule = this.getDatamartModule(studyBean);
            session.setAttribute("datamart", (Object)mapModule);
        }
        return mapModule;
    }

    public HashMap<String, Object> getWebServiceModuleInSession(StudyBean studyBean, HttpSession session) {
        HashMap mapModule = ClassCastHelper.asHashMap((Object)session.getAttribute("webservice"), String.class, Object.class);
        if (mapModule == null) {
            mapModule = this.getWebServiceModule(studyBean);
            session.setAttribute("webservice", (Object)mapModule);
        }
        return mapModule;
    }

    public HashMap<String, Object> getLdapModuleInSession(StudyBean studyBean, HttpSession session) {
        HashMap mapModule = ClassCastHelper.asHashMap((Object)session.getAttribute("ldap"), String.class, Object.class);
        if (mapModule == null) {
            mapModule = this.getLdapModule(studyBean);
            session.setAttribute("ldap", (Object)mapModule);
        }
        return mapModule;
    }
}

