/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller.openrosa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.rule.FileProperties;
import org.akaza.openclinica.control.submit.UploadFileServlet;
import org.akaza.openclinica.controller.openrosa.OpenRosaSubmissionService;
import org.akaza.openclinica.controller.openrosa.PformSubmissionNotificationService;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.StudyDao;
import org.akaza.openclinica.dao.hibernate.StudyParameterValueDao;
import org.akaza.openclinica.domain.datamap.Study;
import org.akaza.openclinica.domain.datamap.StudyParameterValue;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.web.pform.PFormCache;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/openrosa"})
public class OpenRosaSubmissionController {
    @Autowired
    ServletContext context;
    @Autowired
    private OpenRosaSubmissionService openRosaSubmissionService;
    @Autowired
    private StudyDao studyDao;
    @Autowired
    private StudyParameterValueDao studyParameterValueDao;
    @Autowired
    PformSubmissionNotificationService notifier;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String FORM_CONTEXT = "ecid";

    @RequestMapping(value={"/{studyOID}/submission"}, method={RequestMethod.POST})
    public ResponseEntity<String> doSubmission(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="studyOID") String studyOID, @RequestParam(value="ecid") String ecid) {
        BindingResult errors;
        HashMap subjectContext;
        block9: {
            this.logger.info("Processing xform submission.");
            subjectContext = null;
            Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
            DataBinder dataBinder = new DataBinder(null);
            errors = dataBinder.getBindingResult();
            Study study = (Study)this.studyDao.findByOcOID(studyOID);
            String requestBody = null;
            HashMap<String, String> map = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> listOfUploadFilePaths = new ArrayList<HashMap<String, String>>();
            try {
                if (!this.mayProceed(studyOID)) {
                    this.logger.info("Submissions to the study not allowed.  Aborting submission.");
                    return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
                }
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    String dir = OpenRosaSubmissionController.getAttachedFilePath((String)studyOID);
                    FileProperties fileProperties = new FileProperties();
                    DiskFileItemFactory factory = new DiskFileItemFactory();
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                    upload.setFileSizeMax(fileProperties.getFileSizeMax().longValue());
                    List items = upload.parseRequest(request);
                    for (FileItem item : items) {
                        if (item.getContentType() != null && !item.getFieldName().equals("xml_submission_file")) {
                            if (!new File(dir).exists()) {
                                new File(dir).mkdirs();
                            }
                            File file = this.processUploadedFile(item, dir);
                            map.put(item.getFieldName(), file.getPath());
                            continue;
                        }
                        if (!item.getFieldName().equals("xml_submission_file")) continue;
                        requestBody = item.getString("UTF-8");
                    }
                    listOfUploadFilePaths.add(map);
                } else {
                    requestBody = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
                }
                PFormCache cache = PFormCache.getInstance((ServletContext)this.context);
                subjectContext = cache.getSubjectContext(ecid);
                this.openRosaSubmissionService.processRequest(study, subjectContext, requestBody, (Errors)errors, locale, listOfUploadFilePaths);
            }
            catch (Exception e) {
                this.logger.error("Exception while processing xform submission.");
                this.logger.error(e.getMessage());
                this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                if (errors.hasErrors()) break block9;
                this.logger.info("Submission caused internal error.  Sending error response.");
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (!errors.hasErrors()) {
            this.notifier.notify(studyOID, subjectContext);
            this.logger.info("Completed xform submission. Sending successful response");
            String responseMessage = "<OpenRosaResponse xmlns=\"http://openrosa.org/http/response\"><message>success</message></OpenRosaResponse>";
            return new ResponseEntity((Object)responseMessage, HttpStatus.CREATED);
        }
        this.logger.info("Submission contained errors. Sending error response");
        return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
    }

    private Study getParentStudy(String studyOid) {
        Study study = (Study)this.studyDao.findByOcOID(studyOid);
        Study parentStudy = study.getStudy();
        if (parentStudy != null && parentStudy.getStudyId() > 0) {
            return parentStudy;
        }
        return study;
    }

    private boolean mayProceed(String studyOid) throws Exception {
        return this.mayProceed(studyOid, null);
    }

    private boolean mayProceed(String studyOid, StudySubjectBean ssBean) throws Exception {
        boolean accessPermission = false;
        ParticipantPortalRegistrar participantPortalRegistrar = new ParticipantPortalRegistrar();
        Study study = this.getParentStudy(studyOid);
        StudyParameterValue pStatus = this.studyParameterValueDao.findByStudyIdParameter(study.getStudyId(), "participantPortal");
        String pManageStatus = participantPortalRegistrar.getRegistrationStatus(studyOid).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        if (ssBean == null) {
            this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus);
            if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE")) {
                accessPermission = true;
            }
        } else {
            this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus + "  studySubjectStatus: " + ssBean.getStatus().getName());
            if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE") && ssBean.getStatus() == Status.AVAILABLE) {
                accessPermission = true;
            }
        }
        return accessPermission;
    }

    public static String getAttachedFilePath(String studyOid) {
        String attachedFilePath = CoreResources.getField((String)"attached_file_location");
        attachedFilePath = attachedFilePath == null || attachedFilePath.length() <= 0 ? CoreResources.getField((String)"filePath") + "attached_files" + File.separator + studyOid + File.separator : attachedFilePath + studyOid + File.separator;
        return attachedFilePath;
    }

    private File processUploadedFile(FileItem item, String dirToSaveUploadedFileIn) {
        dirToSaveUploadedFileIn = dirToSaveUploadedFileIn == null ? System.getProperty("java.io.tmpdir") : dirToSaveUploadedFileIn;
        String fileName = item.getName();
        int startIndex = fileName.lastIndexOf(92);
        if (startIndex != -1) {
            fileName = fileName.substring(startIndex + 1, fileName.length());
        }
        File uploadedFile = new File(dirToSaveUploadedFileIn + File.separator + fileName);
        try {
            uploadedFile = new UploadFileServlet.OCFileRename(new UploadFileServlet()).rename(uploadedFile, item.getInputStream());
        }
        catch (IOException e) {
            throw new OpenClinicaSystemException(e.getMessage());
        }
        try {
            item.write(uploadedFile);
        }
        catch (Exception e) {
            throw new OpenClinicaSystemException(e.getMessage());
        }
        return uploadedFile;
    }
}

