/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.form.CellFactory;
import org.akaza.openclinica.view.form.CssRules;
import org.akaza.openclinica.view.form.RepeatManager;
import org.jdom.Content;
import org.jdom.Element;

public class ViewBuilderUtil {
    public boolean hasResponseLayout(List<DisplayItemBean> displayBeans) {
        for (DisplayItemBean dBean : displayBeans) {
            String responseName = dBean.getMetadata().getResponseSet().getResponseType().getName();
            if (responseName == null) {
                responseName = "";
            }
            if (!dBean.getMetadata().getResponseLayout().equalsIgnoreCase("horizontal") || !responseName.equalsIgnoreCase("radio") && !responseName.equalsIgnoreCase("checkbox")) continue;
            return true;
        }
        return false;
    }

    public int calcNumberofColumns(DisplayItemGroupBean displayGroup) {
        if (displayGroup == null || displayGroup.getItems().size() == 0) {
            return 0;
        }
        int columns = 0;
        for (DisplayItemBean disBean : displayGroup.getItems()) {
            String responseName = disBean.getMetadata().getResponseSet().getResponseType().getName();
            String responseLayout = disBean.getMetadata().getResponseLayout();
            if ((responseName.equalsIgnoreCase("radio") || responseName.equalsIgnoreCase("checkbox")) && responseLayout.equalsIgnoreCase("horizontal")) {
                columns += disBean.getMetadata().getResponseSet().getOptions().size();
                continue;
            }
            ++columns;
        }
        return columns;
    }

    public void addRemoveRowControl(Element row, String repeatParentId, boolean hasDarkBorders) {
        Element repeatCell = new Element("td");
        if (hasDarkBorders) {
            String cssClasses = CssRules.getClassNamesForTag((String)"td borders_on");
            repeatCell.setAttribute("class", cssClasses);
        } else {
            repeatCell = this.setClassNames(repeatCell);
        }
        repeatCell.addContent((Content)RepeatManager.createrepeatButtonControl((String)ResourceBundleProvider.getResWord((String)"remove"), (String)repeatParentId));
        row.addContent((Content)repeatCell);
    }

    public void createAddRowControl(Element tbody, String repeatParentId, int columnNumber, boolean hasDarkBorders) {
        Element addButtonRow = new Element("tr");
        Element addButtonCell = new Element("td");
        if (hasDarkBorders) {
            String cssClasses = CssRules.getClassNamesForTag((String)"td borders_on");
            addButtonCell.setAttribute("class", cssClasses);
        } else {
            addButtonCell = this.setClassNames(addButtonCell);
        }
        addButtonCell.setAttribute("style", "display:block;");
        addButtonCell.setAttribute("colspan", columnNumber + "");
        addButtonCell.addContent((Content)RepeatManager.createrepeatButtonControl((String)ResourceBundleProvider.getResWord((String)"add"), (String)repeatParentId));
        addButtonRow.addContent((Content)addButtonCell);
        tbody.addContent((Content)addButtonRow);
    }

    public Element setClassNames(Element styledElement) {
        String cssClasses = CssRules.getClassNamesForTag((String)styledElement.getName());
        return cssClasses.length() == 0 ? styledElement : styledElement.setAttribute("class", cssClasses);
    }

    public void showTitles(Element divRoot, SectionBean sectionBean) {
        if (divRoot == null || sectionBean.getInstructions().length() == 0 && sectionBean.getTitle().length() == 0 && sectionBean.getSubtitle().length() == 0) {
            return;
        }
        Element table = new Element("table");
        table.setAttribute("class", CssRules.getClassNamesForTag((String)"table section"));
        table.setAttribute("width", "100%");
        divRoot.addContent((Content)table);
        if (sectionBean.getTitle().length() > 0) {
            this.addTitles(sectionBean, table, "Title");
        }
        if (sectionBean.getSubtitle().length() > 0) {
            this.addTitles(sectionBean, table, "Subtitle");
        }
        if (sectionBean.getInstructions().length() > 0) {
            this.addTitles(sectionBean, table, "Instructions");
        }
    }

    public void addTitles(SectionBean sbean, Element table, String content) {
        Element tr = new Element("tr");
        tr.setAttribute("class", "aka_stripes");
        table.addContent((Content)tr);
        Element title = new Element("td");
        title.setAttribute("nowrap", "nowrap");
        title.setAttribute("class", "aka_table_cell_left");
        Element bold = new Element("b");
        bold.addContent(content + ":  ");
        title.addContent((Content)bold);
        if (content.equalsIgnoreCase("subtitle")) {
            title.addContent(sbean.getSubtitle());
        } else if (content.equalsIgnoreCase("title")) {
            title.addContent(sbean.getTitle());
        } else if (content.equalsIgnoreCase("instructions")) {
            title.addContent(sbean.getInstructions());
        }
        tr.addContent((Content)title);
    }

    public List<Element> generatePersistentMatrixRows(SortedMap<Integer, List<ItemDataBean>> sortedDataMap, List<DisplayItemBean> rowContentBeans, int tabIndex, String repeatParentId, boolean hasDiscrepancyMgt, boolean forPrinting, boolean hasDarkBorders) {
        ArrayList<Element> newRows = new ArrayList<Element>();
        CellFactory cellFactory = new CellFactory();
        RepeatManager repeatManager = new RepeatManager();
        boolean repeatFlag = true;
        String forcedParentId = "";
        for (Integer ordinal : sortedDataMap.keySet()) {
            Element tr = new Element("tr");
            List tempList = (List)sortedDataMap.get(ordinal);
            forcedParentId = ordinal - 1 + "";
            for (DisplayItemBean disItemBean : rowContentBeans) {
                for (ItemDataBean itemDBean : tempList) {
                    if (disItemBean.getItem().getId() != itemDBean.getItemId()) continue;
                    disItemBean.setData(itemDBean);
                    break;
                }
                String responseName = disItemBean.getMetadata().getResponseSet().getResponseType().getName();
                if (disItemBean.getMetadata().getResponseLayout().equalsIgnoreCase("horizontal") && (responseName.equalsIgnoreCase("checkbox") || responseName.equalsIgnoreCase("radio"))) {
                    Element[] elements;
                    for (Element el : elements = cellFactory.createCellContentsForChecks(responseName, disItemBean, Integer.valueOf(disItemBean.getMetadata().getResponseSet().getOptions().size()), Integer.valueOf(++tabIndex), true, forPrinting)) {
                        if (hasDarkBorders) {
                            String cssClasses = CssRules.getClassNamesForTag((String)"td borders_on");
                            el.setAttribute("class", cssClasses);
                        } else {
                            el = this.setClassNames(el);
                        }
                        if (repeatFlag) {
                            el = repeatManager.addChildRepeatAttributes(el, repeatParentId, Integer.valueOf(disItemBean.getItem().getId()), forcedParentId);
                        }
                        tr.addContent((Content)el);
                    }
                    continue;
                }
                Element td = new Element("td");
                if (hasDarkBorders) {
                    String cssClasses = CssRules.getClassNamesForTag((String)"td borders_on");
                    td.setAttribute("class", cssClasses);
                } else {
                    td = this.setClassNames(td);
                }
                td = cellFactory.createCellContents(td, responseName, disItemBean, Integer.valueOf(++tabIndex), hasDiscrepancyMgt, true, forPrinting);
                td = repeatManager.addChildRepeatAttributes(td, repeatParentId, Integer.valueOf(disItemBean.getItem().getId()), forcedParentId);
                tr.addContent((Content)td);
            }
            this.addRemoveRowControl(tr, repeatParentId, hasDarkBorders);
            newRows.add(tr);
        }
        return newRows;
    }

    public List<List<Element>> generatePersistentMatrixRowsNew(SortedMap<Integer, List<ItemDataBean>> sortedDataMap, List<DisplayItemBean> rowContentBeans, int tabIndex, String repeatParentId, boolean hasDiscrepancyMgt, boolean forPrinting, boolean hasDarkBorders, int maxColRows) {
        ArrayList<List<Element>> newRows = new ArrayList<List<Element>>();
        CellFactory cellFactory = new CellFactory();
        RepeatManager repeatManager = new RepeatManager();
        boolean repeatFlag = true;
        String forcedParentId = "";
        for (Integer ordinal : sortedDataMap.keySet()) {
            ArrayList<Element> rowList = new ArrayList<Element>();
            Element tr = new Element("tr");
            List tempList = (List)sortedDataMap.get(ordinal);
            forcedParentId = ordinal - 1 + "";
            int count = 0;
            for (DisplayItemBean disItemBean : rowContentBeans) {
                String responseName;
                ++count;
                for (ItemDataBean itemDBean : tempList) {
                    if (disItemBean.getItem().getId() != itemDBean.getItemId()) continue;
                    disItemBean.setData(itemDBean);
                    break;
                }
                if (((responseName = disItemBean.getMetadata().getResponseSet().getResponseType().getName()).equalsIgnoreCase("radio") || responseName.equalsIgnoreCase("multi-select") || responseName.equalsIgnoreCase("single-select") || responseName.equalsIgnoreCase("checkbox")) && forPrinting) {
                    responseName = "checkbox";
                }
                if (disItemBean.getMetadata().getResponseLayout().equalsIgnoreCase("horizontal") && (responseName.equalsIgnoreCase("checkbox") || responseName.equalsIgnoreCase("radio"))) {
                    Element[] elements;
                    for (Element el : elements = cellFactory.createCellContentsForChecks(responseName, disItemBean, Integer.valueOf(disItemBean.getMetadata().getResponseSet().getOptions().size()), Integer.valueOf(++tabIndex), true, forPrinting)) {
                        if (hasDarkBorders) {
                            String cssClasses = CssRules.getClassNamesForTag((String)"td borders_on");
                            el.setAttribute("class", cssClasses);
                        } else {
                            el = this.setClassNames(el);
                        }
                        if (repeatFlag) {
                            el = repeatManager.addChildRepeatAttributes(el, repeatParentId, Integer.valueOf(disItemBean.getItem().getId()), forcedParentId);
                        }
                        tr.addContent((Content)el);
                        if (count % maxColRows != 0) continue;
                        rowList.add(tr);
                        tr = new Element("tr");
                    }
                    continue;
                }
                Element td = new Element("td");
                if (hasDarkBorders) {
                    String cssClasses = CssRules.getClassNamesForTag((String)"td borders_on");
                    td.setAttribute("class", cssClasses);
                } else {
                    td = this.setClassNames(td);
                }
                td = cellFactory.createCellContents(td, responseName, disItemBean, Integer.valueOf(++tabIndex), hasDiscrepancyMgt, true, forPrinting);
                td = repeatManager.addChildRepeatAttributes(td, repeatParentId, Integer.valueOf(disItemBean.getItem().getId()), forcedParentId);
                tr.addContent((Content)td);
                if (count % maxColRows != 0) continue;
                rowList.add(tr);
                tr = new Element("tr");
            }
            if (count % maxColRows != 0) {
                rowList.add(tr);
            }
            newRows.add(rowList);
        }
        return newRows;
    }
}

