/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.crfdata;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.NullValue;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayItemBean;
import org.akaza.openclinica.bean.submit.DisplayItemBeanWrapper;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ResponseOptionBean;
import org.akaza.openclinica.bean.submit.crfdata.FormDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ImportItemDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ImportItemGroupDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ODMContainer;
import org.akaza.openclinica.bean.submit.crfdata.StudyEventDataBean;
import org.akaza.openclinica.bean.submit.crfdata.SubjectDataBean;
import org.akaza.openclinica.bean.submit.crfdata.SummaryStatsBean;
import org.akaza.openclinica.bean.submit.crfdata.UpsertOnBean;
import org.akaza.openclinica.control.form.DiscrepancyValidator;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.ImportCRFInfoContainer;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.web.crfdata.ImportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCRFDataService {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final DataSource ds;
    private ItemDataDAO itemDataDao;
    public static ResourceBundle respage;

    public ImportCRFDataService(DataSource ds, Locale locale) {
        ResourceBundleProvider.updateLocale((Locale)locale);
        respage = ResourceBundleProvider.getPageMessagesBundle((Locale)locale);
        this.ds = ds;
    }

    public List<EventCRFBean> fetchEventCRFBeans(ODMContainer odmContainer, UserAccountBean ub) {
        ArrayList<EventCRFBean> eventCRFBeans = new ArrayList<EventCRFBean>();
        ArrayList<Integer> eventCRFBeanIds = new ArrayList<Integer>();
        EventCRFDAO eventCrfDAO = new EventCRFDAO(this.ds);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.ds);
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.ds);
        StudyDAO studyDAO = new StudyDAO(this.ds);
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.ds);
        UpsertOnBean upsert = odmContainer.getCrfDataPostImportContainer().getUpsertOn();
        if (upsert == null) {
            upsert = new UpsertOnBean();
        }
        String studyOID = odmContainer.getCrfDataPostImportContainer().getStudyOID();
        StudyBean studyBean = studyDAO.findByOid(studyOID);
        ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
        for (SubjectDataBean subjectDataBean : subjectDataBeans) {
            ArrayList studyEventDataBeans = subjectDataBean.getStudyEventData();
            StudySubjectBean studySubjectBean = studySubjectDAO.findByOidAndStudy(subjectDataBean.getSubjectOID(), studyBean.getId());
            for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                ArrayList formDataBeans = studyEventDataBean.getFormData();
                String sampleOrdinal = studyEventDataBean.getStudyEventRepeatKey() == null ? "1" : studyEventDataBean.getStudyEventRepeatKey();
                StudyEventDefinitionBean studyEventDefinitionBean = studyEventDefinitionDAO.findByOidAndStudy(studyEventDataBean.getStudyEventOID(), studyBean.getId(), studyBean.getParentStudyId());
                this.logger.info("find all by def and subject " + studyEventDefinitionBean.getName() + " study subject " + studySubjectBean.getName());
                StudyEventBean studyEventBean = (StudyEventBean)studyEventDAO.findByStudySubjectIdAndDefinitionIdAndOrdinal(studySubjectBean.getId(), studyEventDefinitionBean.getId(), Integer.parseInt(sampleOrdinal));
                if (studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.LOCKED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.STOPPED)) {
                    return null;
                }
                for (FormDataBean formDataBean : formDataBeans) {
                    CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.ds);
                    ArrayList crfVersionBeans = crfVersionDAO.findAllByOid(formDataBean.getFormOID());
                    for (CRFVersionBean crfVersionBean : crfVersionBeans) {
                        ArrayList eventCrfBeans = eventCrfDAO.findByEventSubjectVersion(studyEventBean, studySubjectBean, crfVersionBean);
                        if (eventCrfBeans.isEmpty()) {
                            this.logger.debug("   found no event crfs from Study Event id " + studyEventBean.getId() + ", location " + studyEventBean.getLocation());
                            if ((studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.DATA_ENTRY_STARTED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.COMPLETED)) && upsert.isNotStarted()) {
                                EventCRFBean newEventCrfBean = new EventCRFBean();
                                newEventCrfBean.setStudyEventId(studyEventBean.getId());
                                newEventCrfBean.setStudySubjectId(studySubjectBean.getId());
                                newEventCrfBean.setCRFVersionId(crfVersionBean.getId());
                                newEventCrfBean.setDateInterviewed(new Date());
                                newEventCrfBean.setOwner(ub);
                                newEventCrfBean.setInterviewerName(ub.getName());
                                newEventCrfBean.setCompletionStatusId(1);
                                newEventCrfBean.setStatus(Status.AVAILABLE);
                                newEventCrfBean.setStage(DataEntryStage.INITIAL_DATA_ENTRY);
                                newEventCrfBean = eventCrfDAO.create(newEventCrfBean);
                                this.logger.debug("   created and added new event crf");
                                if (!eventCRFBeanIds.contains(newEventCrfBean.getId())) {
                                    eventCRFBeans.add(newEventCrfBean);
                                    eventCRFBeanIds.add(newEventCrfBean.getId());
                                }
                            }
                        }
                        for (EventCRFBean ecb : eventCrfBeans) {
                            Integer ecbId = new Integer(ecb.getId());
                            if ((!upsert.isDataEntryStarted() || !ecb.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY)) && (!upsert.isDataEntryComplete() || !ecb.getStage().equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE)) || eventCRFBeanIds.contains(ecbId)) continue;
                            eventCRFBeans.add(ecb);
                            eventCRFBeanIds.add(ecbId);
                        }
                    }
                }
            }
        }
        return eventCRFBeans;
    }

    public boolean eventCRFStatusesValid(ODMContainer odmContainer, UserAccountBean ub) {
        EventCRFDAO eventCrfDAO = new EventCRFDAO(this.ds);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.ds);
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.ds);
        StudyDAO studyDAO = new StudyDAO(this.ds);
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.ds);
        UpsertOnBean upsert = odmContainer.getCrfDataPostImportContainer().getUpsertOn();
        if (upsert == null) {
            upsert = new UpsertOnBean();
        }
        String studyOID = odmContainer.getCrfDataPostImportContainer().getStudyOID();
        StudyBean studyBean = studyDAO.findByOid(studyOID);
        ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
        for (SubjectDataBean subjectDataBean : subjectDataBeans) {
            ArrayList studyEventDataBeans = subjectDataBean.getStudyEventData();
            StudySubjectBean studySubjectBean = studySubjectDAO.findByOidAndStudy(subjectDataBean.getSubjectOID(), studyBean.getId());
            for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                ArrayList formDataBeans = studyEventDataBean.getFormData();
                String sampleOrdinal = studyEventDataBean.getStudyEventRepeatKey() == null ? "1" : studyEventDataBean.getStudyEventRepeatKey();
                StudyEventDefinitionBean studyEventDefinitionBean = studyEventDefinitionDAO.findByOidAndStudy(studyEventDataBean.getStudyEventOID(), studyBean.getId(), studyBean.getParentStudyId());
                this.logger.info("find all by def and subject " + studyEventDefinitionBean.getName() + " study subject " + studySubjectBean.getName());
                StudyEventBean studyEventBean = (StudyEventBean)studyEventDAO.findByStudySubjectIdAndDefinitionIdAndOrdinal(studySubjectBean.getId(), studyEventDefinitionBean.getId(), Integer.parseInt(sampleOrdinal));
                if (studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.LOCKED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.SIGNED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.STOPPED)) {
                    return true;
                }
                for (FormDataBean formDataBean : formDataBeans) {
                    CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.ds);
                    ArrayList crfVersionBeans = crfVersionDAO.findAllByOid(formDataBean.getFormOID());
                    for (CRFVersionBean crfVersionBean : crfVersionBeans) {
                        ArrayList eventCrfBeans = eventCrfDAO.findByEventSubjectVersion(studyEventBean, studySubjectBean, crfVersionBean);
                        if (eventCrfBeans.isEmpty()) {
                            this.logger.debug("   found no event crfs from Study Event id " + studyEventBean.getId() + ", location " + studyEventBean.getLocation());
                            if ((studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.SCHEDULED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.DATA_ENTRY_STARTED) || studyEventBean.getSubjectEventStatus().equals((Term)SubjectEventStatus.COMPLETED)) && !upsert.isNotStarted()) {
                                return false;
                            }
                        }
                        for (EventCRFBean ecb : eventCrfBeans) {
                            if (ecb.getStage().equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) && upsert.isDataEntryStarted() || ecb.getStage().equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) && upsert.isDataEntryComplete()) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public HashMap<Integer, String> fetchEventCRFStatuses(ODMContainer odmContainer) {
        HashMap<Integer, String> eventCRFStatuses = new HashMap<Integer, String>();
        EventCRFDAO eventCrfDAO = new EventCRFDAO(this.ds);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.ds);
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.ds);
        StudyDAO studyDAO = new StudyDAO(this.ds);
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.ds);
        String studyOID = odmContainer.getCrfDataPostImportContainer().getStudyOID();
        StudyBean studyBean = studyDAO.findByOid(studyOID);
        ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
        for (SubjectDataBean subjectDataBean : subjectDataBeans) {
            ArrayList studyEventDataBeans = subjectDataBean.getStudyEventData();
            StudySubjectBean studySubjectBean = studySubjectDAO.findByOidAndStudy(subjectDataBean.getSubjectOID(), studyBean.getId());
            for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                ArrayList formDataBeans = studyEventDataBean.getFormData();
                String sampleOrdinal = studyEventDataBean.getStudyEventRepeatKey() == null ? "1" : studyEventDataBean.getStudyEventRepeatKey();
                StudyEventDefinitionBean studyEventDefinitionBean = studyEventDefinitionDAO.findByOidAndStudy(studyEventDataBean.getStudyEventOID(), studyBean.getId(), studyBean.getParentStudyId());
                this.logger.info("find all by def and subject " + studyEventDefinitionBean.getName() + " study subject " + studySubjectBean.getName());
                StudyEventBean studyEventBean = (StudyEventBean)studyEventDAO.findByStudySubjectIdAndDefinitionIdAndOrdinal(studySubjectBean.getId(), studyEventDefinitionBean.getId(), Integer.parseInt(sampleOrdinal));
                for (FormDataBean formDataBean : formDataBeans) {
                    CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.ds);
                    ArrayList crfVersionBeans = crfVersionDAO.findAllByOid(formDataBean.getFormOID());
                    for (CRFVersionBean crfVersionBean : crfVersionBeans) {
                        ArrayList eventCrfBeans = eventCrfDAO.findByEventSubjectVersion(studyEventBean, studySubjectBean, crfVersionBean);
                        for (EventCRFBean ecb : eventCrfBeans) {
                            Integer ecbId = new Integer(ecb.getId());
                            if (eventCRFStatuses.keySet().contains(ecbId) || formDataBean.getEventCRFStatus() == null) continue;
                            eventCRFStatuses.put(ecb.getId(), formDataBean.getEventCRFStatus());
                        }
                    }
                }
            }
        }
        return eventCRFStatuses;
    }

    public SummaryStatsBean generateSummaryStatsBean(ODMContainer odmContainer, List<DisplayItemBeanWrapper> wrappers, ImportCRFInfoContainer importCrfInfo) {
        int countSubjects = 0;
        int countEventCRFs = 0;
        int discNotesGenerated = 0;
        for (DisplayItemBeanWrapper displayItemBeanWrapper : wrappers) {
            HashMap validations = displayItemBeanWrapper.getValidationErrors();
            discNotesGenerated += validations.size();
        }
        ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
        countSubjects += subjectDataBeans.size();
        for (SubjectDataBean subjectDataBean : subjectDataBeans) {
            ArrayList studyEventDataBeans = subjectDataBean.getStudyEventData();
            for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                ArrayList formDataBeans = studyEventDataBean.getFormData();
                countEventCRFs += formDataBeans.size();
            }
        }
        SummaryStatsBean summaryStatsBean = new SummaryStatsBean();
        summaryStatsBean.setDiscNoteCount(discNotesGenerated);
        summaryStatsBean.setEventCrfCount(countEventCRFs);
        summaryStatsBean.setStudySubjectCount(countSubjects);
        summaryStatsBean.setSkippedCrfCount(importCrfInfo.getCountSkippedEventCrfs());
        return summaryStatsBean;
    }

    public List<DisplayItemBeanWrapper> lookupValidationErrors(HttpServletRequest request, ODMContainer odmContainer, UserAccountBean ub, HashMap<String, String> totalValidationErrors, HashMap<String, String> hardValidationErrors, ArrayList<Integer> permittedEventCRFIds) throws OpenClinicaException {
        DisplayItemBeanWrapper displayItemBeanWrapper = null;
        HashMap validationErrors = new HashMap();
        ArrayList<DisplayItemBeanWrapper> wrappers = new ArrayList<DisplayItemBeanWrapper>();
        ImportHelper importHelper = new ImportHelper();
        FormDiscrepancyNotes discNotes = new FormDiscrepancyNotes();
        DiscrepancyValidator discValidator = new DiscrepancyValidator(request, discNotes);
        HashMap hardValidator = new HashMap();
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.ds);
        StudyDAO studyDAO = new StudyDAO(this.ds);
        StudyBean studyBean = studyDAO.findByOid(odmContainer.getCrfDataPostImportContainer().getStudyOID());
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.ds);
        StudyEventDefinitionDAO sedDao = new StudyEventDefinitionDAO(this.ds);
        HashMap<String, ItemDataBean> blankCheck = new HashMap<String, ItemDataBean>();
        ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
        int totalEventCRFCount = 0;
        int totalItemDataBeanCount = 0;
        for (SubjectDataBean subjectDataBean : subjectDataBeans) {
            ArrayList<DisplayItemBean> displayItemBeans = new ArrayList<DisplayItemBean>();
            this.logger.debug("iterating through subject data beans: found " + subjectDataBean.getSubjectOID());
            ArrayList studyEventDataBeans = subjectDataBean.getStudyEventData();
            totalEventCRFCount += studyEventDataBeans.size();
            StudySubjectBean studySubjectBean = studySubjectDAO.findByOidAndStudy(subjectDataBean.getSubjectOID(), studyBean.getId());
            for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                int parentStudyId = studyBean.getParentStudyId();
                StudyEventDefinitionBean sedBean = sedDao.findByOidAndStudy(studyEventDataBean.getStudyEventOID(), studyBean.getId(), parentStudyId);
                ArrayList formDataBeans = studyEventDataBean.getFormData();
                this.logger.debug("iterating through study event data beans: found " + studyEventDataBean.getStudyEventOID());
                int ordinal = 1;
                try {
                    ordinal = new Integer(studyEventDataBean.getStudyEventRepeatKey());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StudyEventBean studyEvent = (StudyEventBean)studyEventDAO.findByStudySubjectIdAndDefinitionIdAndOrdinal(studySubjectBean.getId(), sedBean.getId(), ordinal);
                displayItemBeans = new ArrayList();
                for (FormDataBean formDataBean : formDataBeans) {
                    HashMap<String, Integer> groupMaxOrdinals = new HashMap<String, Integer>();
                    displayItemBeanWrapper = null;
                    CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.ds);
                    EventCRFDAO eventCRFDAO = new EventCRFDAO(this.ds);
                    ArrayList crfVersionBeans = crfVersionDAO.findAllByOid(formDataBean.getFormOID());
                    ArrayList itemGroupDataBeans = formDataBean.getItemGroupData();
                    if (crfVersionBeans == null || crfVersionBeans.size() == 0) {
                        MessageFormat mf = new MessageFormat("");
                        mf.applyPattern(respage.getString("your_crf_version_oid_did_not_generate"));
                        Object[] arguments = new Object[]{formDataBean.getFormOID()};
                        throw new OpenClinicaException(mf.format(arguments), "");
                    }
                    CRFVersionBean crfVersion = (CRFVersionBean)crfVersionBeans.get(0);
                    this.logger.debug("iterating through form beans: found " + crfVersion.getOid());
                    EventCRFBean eventCRFBean = eventCRFDAO.findByEventCrfVersion(studyEvent, crfVersion);
                    EventDefinitionCRFDAO eventDefinitionCRFDAO = new EventDefinitionCRFDAO(this.ds);
                    EventDefinitionCRFBean eventDefinitionCRF = eventDefinitionCRFDAO.findByStudyEventIdAndCRFVersionId(studyBean, studyEvent.getId(), crfVersion.getId());
                    if (eventCRFBean == null) continue;
                    if (permittedEventCRFIds.contains(new Integer(eventCRFBean.getId()))) {
                        for (ImportItemGroupDataBean itemGroupDataBean : itemGroupDataBeans) {
                            groupMaxOrdinals.put(itemGroupDataBean.getItemGroupOID(), 1);
                        }
                        for (ImportItemGroupDataBean itemGroupDataBean : itemGroupDataBeans) {
                            DisplayItemBean displayItemBean;
                            Object blankCheckItems = new ArrayList();
                            ArrayList itemDataBeans = itemGroupDataBean.getItemData();
                            this.logger.debug("iterating through group beans: " + itemGroupDataBean.getItemGroupOID());
                            ItemGroupDAO itemGroupDAO = new ItemGroupDAO(this.ds);
                            ItemGroupBean testBean = itemGroupDAO.findByOid(itemGroupDataBean.getItemGroupOID());
                            if (testBean == null) {
                                MessageFormat mf = new MessageFormat("");
                                mf.applyPattern(respage.getString("your_item_group_oid_for_form_oid"));
                                Object[] arguments = new Object[]{itemGroupDataBean.getItemGroupOID(), formDataBean.getFormOID()};
                                throw new OpenClinicaException(mf.format(arguments), "");
                            }
                            totalItemDataBeanCount += itemDataBeans.size();
                            for (ImportItemDataBean importItemDataBean : itemDataBeans) {
                                this.logger.debug("   iterating through item data beans: " + importItemDataBean.getItemOID());
                                ItemDAO itemDAO = new ItemDAO(this.ds);
                                ItemFormMetadataDAO itemFormMetadataDAO = new ItemFormMetadataDAO(this.ds);
                                ArrayList itemBeans = itemDAO.findByOid(importItemDataBean.getItemOID());
                                if (!itemBeans.isEmpty()) {
                                    ItemBean itemBean = (ItemBean)itemBeans.get(0);
                                    this.logger.debug("   found " + itemBean.getName());
                                    displayItemBean = new DisplayItemBean();
                                    displayItemBean.setItem(itemBean);
                                    ArrayList metadataBeans = itemFormMetadataDAO.findAllByItemId(itemBean.getId());
                                    this.logger.debug("      found metadata item beans: " + metadataBeans.size());
                                    int groupOrdinal = 1;
                                    if (itemGroupDataBean.getItemGroupRepeatKey() != null) {
                                        try {
                                            groupOrdinal = new Integer(itemGroupDataBean.getItemGroupRepeatKey());
                                            if (groupOrdinal > (Integer)groupMaxOrdinals.get(itemGroupDataBean.getItemGroupOID())) {
                                                groupMaxOrdinals.put(itemGroupDataBean.getItemGroupOID(), groupOrdinal);
                                            }
                                        }
                                        catch (Exception e) {
                                            this.logger.debug("found npe for group ordinals, line 344!");
                                        }
                                    }
                                    ItemDataBean itemDataBean = this.createItemDataBean(itemBean, eventCRFBean, importItemDataBean.getValue(), ub, groupOrdinal);
                                    ((ArrayList)blankCheckItems).add(itemBean);
                                    String newKey = groupOrdinal + "_" + itemGroupDataBean.getItemGroupOID() + "_" + itemBean.getOid() + "_" + subjectDataBean.getSubjectOID();
                                    blankCheck.put(newKey, itemDataBean);
                                    this.logger.info("adding " + newKey + " to blank checks");
                                    if (!metadataBeans.isEmpty()) {
                                        ItemFormMetadataBean metadataBean = (ItemFormMetadataBean)metadataBeans.get(0);
                                        displayItemBean.setData(itemDataBean);
                                        displayItemBean.setMetadata(metadataBean);
                                        displayItemBean.setEventDefinitionCRF(eventDefinitionCRF);
                                        String eventCRFRepeatKey = studyEventDataBean.getStudyEventRepeatKey();
                                        this.attachValidator(displayItemBean, importHelper, discValidator, hardValidator, request, eventCRFRepeatKey, studySubjectBean.getOid());
                                        displayItemBeans.add(displayItemBean);
                                        continue;
                                    }
                                    MessageFormat mf = new MessageFormat("");
                                    mf.applyPattern(respage.getString("no_metadata_could_be_found"));
                                    Object[] arguments = new Object[]{importItemDataBean.getItemOID()};
                                    throw new OpenClinicaException(mf.format(arguments), "");
                                }
                                MessageFormat mf = new MessageFormat("");
                                mf.applyPattern(respage.getString("no_item_could_be_found"));
                                Object[] arguments = new Object[]{importItemDataBean.getItemOID()};
                                throw new OpenClinicaException(mf.format(arguments), "");
                            }
                            this.logger.debug(".. found blank check: " + blankCheck.toString());
                            for (int i = 1; i <= (Integer)groupMaxOrdinals.get(itemGroupDataBean.getItemGroupOID()); ++i) {
                                Iterator iterator = ((ArrayList)blankCheckItems).iterator();
                                while (iterator.hasNext()) {
                                    ItemBean itemBean = (ItemBean)iterator.next();
                                    String newKey = i + "_" + itemGroupDataBean.getItemGroupOID() + "_" + itemBean.getOid() + "_" + subjectDataBean.getSubjectOID();
                                    if (blankCheck.get(newKey) == null) {
                                        ItemDataBean itemDataCheck = this.getItemDataDao().findByItemIdAndEventCRFIdAndOrdinal(itemBean.getId(), eventCRFBean.getId(), i);
                                        this.logger.debug("found item data bean id: " + itemDataCheck.getId() + " for ordinal " + i);
                                        if (itemDataCheck.getId() == 0) {
                                            ItemDataBean blank = this.createItemDataBean(itemBean, eventCRFBean, "", ub, i);
                                            displayItemBean = new DisplayItemBean();
                                            displayItemBean.setItem(itemBean);
                                            displayItemBean.setData(blank);
                                            displayItemBean.setEventDefinitionCRF(eventDefinitionCRF);
                                            displayItemBeans.add(displayItemBean);
                                            this.logger.debug("... adding display item bean");
                                        }
                                    }
                                    this.logger.debug("found a blank at " + i + ", adding " + ((ArrayList)blankCheckItems).size() + " blank items");
                                }
                            }
                            blankCheckItems = new ArrayList();
                        }
                    }
                    CRFDAO crfDAO = new CRFDAO(this.ds);
                    CRFBean crfBean = crfDAO.findByVersionId(crfVersion.getCrfId());
                    validationErrors = discValidator.validate();
                    for (Object errorKey : validationErrors.keySet()) {
                        if (!totalValidationErrors.containsKey(errorKey.toString())) {
                            totalValidationErrors.put(errorKey.toString(), ((ArrayList)validationErrors.get(errorKey)).toString());
                        }
                        this.logger.debug("+++ adding " + errorKey.toString());
                    }
                    this.logger.debug("-- hard validation checks: --");
                    for (Object errorKey : hardValidator.keySet()) {
                        this.logger.debug(errorKey.toString() + " -- " + (String)hardValidator.get(errorKey));
                        hardValidationErrors.put(errorKey.toString(), (String)hardValidator.get(errorKey));
                    }
                    String studyEventId = studyEvent.getId() + "";
                    String crfVersionId = crfVersion.getId() + "";
                    this.logger.debug("creation of wrapper: original count of display item beans " + displayItemBeans.size() + ", count of item data beans " + totalItemDataBeanCount + " count of validation errors " + validationErrors.size() + " count of study subjects " + subjectDataBeans.size() + " count of event crfs " + totalEventCRFCount + " count of hard error checks " + hardValidator.size());
                    DataEntryStage dataEntryStage = eventCRFBean.getStage();
                    boolean overwrite = false;
                    if (dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE) || dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) || dataEntryStage.equals((Term)DataEntryStage.INITIAL_DATA_ENTRY) || dataEntryStage.equals((Term)DataEntryStage.DOUBLE_DATA_ENTRY)) {
                        overwrite = true;
                    }
                    displayItemBeanWrapper = new DisplayItemBeanWrapper(displayItemBeans, true, overwrite, validationErrors, studyEventId, crfVersionId, studyEventDataBean.getStudyEventOID(), studySubjectBean.getLabel(), eventCRFBean.getCreatedDate(), crfBean.getName(), crfVersion.getName(), studySubjectBean.getOid(), studyEventDataBean.getStudyEventRepeatKey());
                    validationErrors = new HashMap();
                    discValidator = new DiscrepancyValidator(request, discNotes);
                }
                if (displayItemBeanWrapper == null || displayItemBeans.size() <= 0) continue;
                wrappers.add(displayItemBeanWrapper);
            }
        }
        if (!hardValidator.isEmpty()) {
            // empty if block
        }
        return wrappers;
    }

    private ItemDataBean createItemDataBean(ItemBean itemBean, EventCRFBean eventCrfBean, String value, UserAccountBean ub, int ordinal) {
        ItemDataBean itemDataBean = new ItemDataBean();
        itemDataBean.setItemId(itemBean.getId());
        itemDataBean.setEventCRFId(eventCrfBean.getId());
        itemDataBean.setCreatedDate(new Date());
        itemDataBean.setOrdinal(ordinal);
        itemDataBean.setOwner(ub);
        itemDataBean.setStatus(Status.UNAVAILABLE);
        itemDataBean.setValue(value);
        return itemDataBean;
    }

    private void attachValidator(DisplayItemBean displayItemBean, ImportHelper importHelper, DiscrepancyValidator v, HashMap<String, String> hardv, HttpServletRequest request, String eventCRFRepeatKey, String studySubjectOID) throws OpenClinicaException {
        ResponseType rt = displayItemBean.getMetadata().getResponseSet().getResponseType();
        String itemOid = displayItemBean.getItem().getOid() + "_" + eventCRFRepeatKey + "_" + displayItemBean.getData().getOrdinal() + "_" + studySubjectOID;
        if (rt.equals((Term)ResponseType.TEXT) || rt.equals((Term)ResponseType.TEXTAREA)) {
            block32: {
                ItemFormMetadataBean ifm = displayItemBean.getMetadata();
                String widthDecimal = ifm.getWidthDecimal();
                if (displayItemBean.getItem().getDataType().equals((Term)ItemDataType.DATE)) {
                    if (!"".equals(displayItemBean.getData().getValue())) {
                        String dateValue = displayItemBean.getData().getValue();
                        SimpleDateFormat sdf_sqldate = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            Date originalDate = sdf_sqldate.parse(dateValue);
                            new SimpleDateFormat("MM/dd/yyyy").format(originalDate);
                            displayItemBean.getData().setValue(dateValue);
                        }
                        catch (ParseException pe1) {
                            MessageFormat mf = new MessageFormat("");
                            mf.applyPattern(respage.getString("you_have_a_date_value_which_is_not"));
                            Object[] arguments = new Object[]{displayItemBean.getItem().getOid()};
                            hardv.put(itemOid, mf.format(arguments));
                        }
                    }
                } else if (displayItemBean.getItem().getDataType().equals((Term)ItemDataType.ST)) {
                    int width = Validator.parseWidth((String)widthDecimal);
                    if (width > 0 && displayItemBean.getData().getValue().length() > width) {
                        hardv.put(itemOid, "This value exceeds required width=" + width);
                    }
                } else {
                    if (displayItemBean.getItem().getDataType().equals((Term)ItemDataType.INTEGER)) {
                        try {
                            new Integer(displayItemBean.getData().getValue());
                            int width = Validator.parseWidth((String)widthDecimal);
                            if (width > 0 && displayItemBean.getData().getValue().length() > width) {
                                hardv.put(itemOid, "This value exceeds required width=" + width);
                            }
                            break block32;
                        }
                        catch (Exception e) {
                            if (!"".equals(displayItemBean.getData().getValue())) {
                                hardv.put(itemOid, "This value is not an integer.");
                            }
                            break block32;
                        }
                    }
                    if (displayItemBean.getItem().getDataType().equals((Term)ItemDataType.REAL)) {
                        try {
                            int decimal;
                            new Float(displayItemBean.getData().getValue());
                            int width = Validator.parseWidth((String)widthDecimal);
                            if (width > 0 && displayItemBean.getData().getValue().length() > width) {
                                hardv.put(itemOid, "This value exceeds required width=" + width);
                            }
                            if ((decimal = Validator.parseDecimal((String)widthDecimal)) > 0 && BigDecimal.valueOf(new Double(displayItemBean.getData().getValue())).scale() > decimal) {
                                hardv.put(itemOid, "This value exceeds required decimal=" + decimal);
                            }
                        }
                        catch (Exception ee) {
                            if ("".equals(displayItemBean.getData().getValue())) break block32;
                            hardv.put(itemOid, "This value is not a real number.");
                        }
                    }
                }
            }
            request.setAttribute(itemOid, (Object)displayItemBean.getData().getValue());
            displayItemBean = importHelper.validateDisplayItemBeanText(v, displayItemBean, itemOid);
        } else if (rt.equals((Term)ResponseType.CALCULATION) || rt.equals((Term)ResponseType.GROUP_CALCULATION)) {
            ItemFormMetadataBean ifm;
            String widthDecimal;
            int decimal;
            if (displayItemBean.getItem().getDataType().equals((Term)ItemDataType.REAL) && (decimal = Validator.parseDecimal((String)(widthDecimal = (ifm = displayItemBean.getMetadata()).getWidthDecimal()))) > 0) {
                try {
                    Double d = new Double(displayItemBean.getData().getValue());
                    if (BigDecimal.valueOf(d).scale() > decimal) {
                        hardv.put(itemOid, "This value exceeds required decimal=" + decimal);
                    }
                }
                catch (Exception e) {
                    if (!"".equals(displayItemBean.getData().getValue())) {
                        hardv.put(itemOid, "This value is not a real number.");
                    }
                }
            }
        } else if (rt.equals((Term)ResponseType.RADIO) || rt.equals((Term)ResponseType.SELECT)) {
            String theValue = this.matchValueWithOptions(displayItemBean, displayItemBean.getData().getValue(), (List)displayItemBean.getMetadata().getResponseSet().getOptions());
            request.setAttribute(itemOid, (Object)theValue);
            this.logger.debug("        found the value for radio/single: " + theValue);
            if (theValue == null && displayItemBean.getData().getValue() != null && !displayItemBean.getData().getValue().isEmpty()) {
                this.logger.debug("-- theValue was NULL, the real value was " + displayItemBean.getData().getValue());
                hardv.put(itemOid, "This is not in the correct response set.");
            }
            displayItemBean = importHelper.validateDisplayItemBeanSingleCV(v, displayItemBean, itemOid);
        } else if (rt.equals((Term)ResponseType.CHECKBOX) || rt.equals((Term)ResponseType.SELECTMULTI)) {
            String theValue = this.matchValueWithManyOptions(displayItemBean, displayItemBean.getData().getValue(), (List)displayItemBean.getMetadata().getResponseSet().getOptions());
            request.setAttribute(itemOid, (Object)theValue);
            if (theValue == null && displayItemBean.getData().getValue() != null && !displayItemBean.getData().getValue().isEmpty()) {
                hardv.put(itemOid, "This is not in the correct response set.");
            }
            displayItemBean = importHelper.validateDisplayItemBeanMultipleCV(v, displayItemBean, itemOid);
        }
    }

    private String matchValueWithOptions(DisplayItemBean displayItemBean, String value, List<ResponseOptionBean> options) {
        String returnedValue = null;
        if (!options.isEmpty()) {
            for (ResponseOptionBean responseOptionBean : options) {
                if (!responseOptionBean.getValue().equals(value)) continue;
                displayItemBean.getData().setValue(responseOptionBean.getValue());
                return responseOptionBean.getValue();
            }
        }
        return returnedValue;
    }

    private String matchValueWithManyOptions(DisplayItemBean displayItemBean, String value, List<ResponseOptionBean> options) {
        String returnedValue = null;
        String entireOptions = "";
        String[] simValues = value.split(",");
        String simValue = value.replace(",", "");
        simValue = simValue.replace(" ", "");
        boolean checkComplete = true;
        if (!options.isEmpty()) {
            for (ResponseOptionBean responseOptionBean : options) {
                entireOptions = entireOptions + responseOptionBean.getValue();
            }
            entireOptions = entireOptions.replace(" ", "");
            ArrayList nullValues = displayItemBean.getEventDefinitionCRF().getNullValuesList();
            for (Object nullValue : nullValues) {
                NullValue nullValueTerm = (NullValue)nullValue;
                entireOptions = entireOptions + nullValueTerm.getName();
            }
            for (String sim : simValues) {
                checkComplete = entireOptions.contains(sim = sim.replace(" ", ""));
                if (checkComplete) continue;
                return returnedValue;
            }
        }
        return value;
    }

    public List<String> validateStudyMetadata(ODMContainer odmContainer, int currentStudyId) {
        ArrayList<String> errors;
        block22: {
            errors = new ArrayList<String>();
            MessageFormat mf = new MessageFormat("");
            try {
                StudyDAO studyDAO = new StudyDAO(this.ds);
                String studyOid = odmContainer.getCrfDataPostImportContainer().getStudyOID();
                StudyBean studyBean = studyDAO.findByOid(studyOid);
                if (studyBean == null) {
                    mf.applyPattern(respage.getString("your_study_oid_does_not_reference_an_existing"));
                    Object[] arguments = new Object[]{studyOid};
                    errors.add(mf.format(arguments));
                    this.logger.debug("unknown study OID");
                    throw new OpenClinicaException("Unknown Study OID", "");
                }
                if (studyBean.getId() != currentStudyId) {
                    mf.applyPattern(respage.getString("your_current_study_is_not_the_same_as"));
                    Object[] arguments = new Object[]{studyBean.getName()};
                    errors.add(mf.format(arguments));
                }
                ArrayList subjectDataBeans = odmContainer.getCrfDataPostImportContainer().getSubjectData();
                StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.ds);
                StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.ds);
                CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.ds);
                ItemGroupDAO itemGroupDAO = new ItemGroupDAO(this.ds);
                ItemDAO itemDAO = new ItemDAO(this.ds);
                if (subjectDataBeans == null) break block22;
                for (SubjectDataBean subjectDataBean : subjectDataBeans) {
                    ArrayList studyEventDataBeans;
                    String oid = subjectDataBean.getSubjectOID();
                    StudySubjectBean studySubjectBean = studySubjectDAO.findByOidAndStudy(oid, studyBean.getId());
                    if (studySubjectBean == null || !oid.equals(studySubjectBean.getOid())) {
                        mf.applyPattern(respage.getString("your_subject_oid_does_not_reference"));
                        Object[] arguments = new Object[]{oid};
                        errors.add(mf.format(arguments));
                        this.logger.debug("logged an error with subject oid " + oid);
                    }
                    if ((studyEventDataBeans = subjectDataBean.getStudyEventData()) == null) continue;
                    for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                        ArrayList formDataBeans;
                        String sedOid = studyEventDataBean.getStudyEventOID();
                        StudyEventDefinitionBean studyEventDefintionBean = studyEventDefinitionDAO.findByOidAndStudy(sedOid, studyBean.getId(), studyBean.getParentStudyId());
                        if (studyEventDefintionBean == null) {
                            mf.applyPattern(respage.getString("your_study_event_oid_for_subject_oid"));
                            Object[] arguments = new Object[]{sedOid, oid};
                            errors.add(mf.format(arguments));
                            this.logger.debug("logged an error with se oid " + sedOid + " and subject oid " + oid);
                        }
                        if ((formDataBeans = studyEventDataBean.getFormData()) == null) continue;
                        for (FormDataBean formDataBean : formDataBeans) {
                            String formOid = formDataBean.getFormOID();
                            ArrayList crfVersionBeans = crfVersionDAO.findAllByOid(formOid);
                            if (crfVersionBeans != null && crfVersionBeans.size() > 0) {
                                for (Object crfVersionBean : crfVersionBeans) {
                                    if (crfVersionBean != null) continue;
                                    mf.applyPattern(respage.getString("your_crf_version_oid_for_study_event_oid"));
                                    Object[] arguments = new Object[]{formOid, sedOid};
                                    errors.add(mf.format(arguments));
                                    this.logger.debug("logged an error with form " + formOid + " and se oid " + sedOid);
                                }
                            } else {
                                mf.applyPattern(respage.getString("your_crf_version_oid_did_not_generate"));
                                Object[] arguments = new Object[]{formOid};
                                errors.add(mf.format(arguments));
                            }
                            ArrayList itemGroupDataBeans = formDataBean.getItemGroupData();
                            if (itemGroupDataBeans != null) {
                                Object crfVersionBean;
                                crfVersionBean = itemGroupDataBeans.iterator();
                                while (crfVersionBean.hasNext()) {
                                    ImportItemGroupDataBean itemGroupDataBean = (ImportItemGroupDataBean)crfVersionBean.next();
                                    String itemGroupOID = itemGroupDataBean.getItemGroupOID();
                                    List itemGroupBeans = itemGroupDAO.findAllByOid(itemGroupOID);
                                    if (itemGroupBeans != null) {
                                        this.logger.debug("number of item group beans: " + itemGroupBeans.size());
                                        this.logger.debug("item group oid: " + itemGroupOID);
                                        for (ItemGroupBean itemGroupBean : itemGroupBeans) {
                                            if (itemGroupBean != null) continue;
                                            mf.applyPattern(respage.getString("your_item_group_oid_for_form_oid"));
                                            Object[] arguments = new Object[]{itemGroupOID, formOid};
                                            errors.add(mf.format(arguments));
                                        }
                                    } else {
                                        mf.applyPattern(respage.getString("the_item_group_oid_did_not"));
                                        Object[] arguments = new Object[]{itemGroupOID};
                                        errors.add(mf.format(arguments));
                                    }
                                    ArrayList itemDataBeans = itemGroupDataBean.getItemData();
                                    if (itemDataBeans != null) {
                                        ItemGroupBean itemGroupBean;
                                        itemGroupBean = itemDataBeans.iterator();
                                        while (itemGroupBean.hasNext()) {
                                            ImportItemDataBean itemDataBean = (ImportItemDataBean)itemGroupBean.next();
                                            String itemOID = itemDataBean.getItemOID();
                                            ArrayList itemBeans = itemDAO.findByOid(itemOID);
                                            if (itemBeans == null) continue;
                                            this.logger.debug("found itembeans: ");
                                            for (ItemBean itemBean : itemBeans) {
                                                if (itemBean == null) {
                                                    mf.applyPattern(respage.getString("your_item_oid_for_item_group_oid"));
                                                    Object[] arguments = new Object[]{itemOID, itemGroupOID};
                                                    errors.add(mf.format(arguments));
                                                    continue;
                                                }
                                                this.logger.debug("found " + itemBean.getOid() + ", passing");
                                            }
                                        }
                                        continue;
                                    }
                                    mf.applyPattern(respage.getString("the_item_group_oid_did_not_contain_item_data"));
                                    Object[] arguments = new Object[]{itemGroupOID};
                                    errors.add(mf.format(arguments));
                                }
                                continue;
                            }
                            mf.applyPattern(respage.getString("your_study_event_contains_no_form_data"));
                            Object[] arguments = new Object[]{sedOid};
                            errors.add(mf.format(arguments));
                        }
                    }
                }
            }
            catch (OpenClinicaException studyDAO) {
            }
            catch (NullPointerException npe) {
                this.logger.debug("found a nullpointer here");
            }
        }
        return errors;
    }

    private ItemDataDAO getItemDataDao() {
        this.itemDataDao = this.itemDataDao != null ? this.itemDataDao : new ItemDataDAO(this.ds);
        return this.itemDataDao;
    }
}

