/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.pform.widget;

import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.web.pform.widget.GroupWidget;
import org.akaza.openclinica.web.pform.widget.HeaderWidget;
import org.akaza.openclinica.web.pform.widget.InputWidget;
import org.akaza.openclinica.web.pform.widget.SectionTextWidget;
import org.akaza.openclinica.web.pform.widget.SectionWidget;
import org.akaza.openclinica.web.pform.widget.Select1Widget;
import org.akaza.openclinica.web.pform.widget.SelectWidget;
import org.akaza.openclinica.web.pform.widget.SubHeaderWidget;
import org.akaza.openclinica.web.pform.widget.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetFactory {
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_TEXTAREA = 2;
    public static final int TYPE_CHECKBOX = 3;
    public static final int TYPE_FILE = 4;
    public static final int TYPE_RADIO = 5;
    public static final int TYPE_SINGLE_SELECT = 6;
    public static final int TYPE_MULTI_SELECT = 7;
    public static final int TYPE_CALCULATION = 8;
    public static final int TYPE_GROUP_CALCULATION = 9;
    public static final int TYPE_INSTANT_CALCULATION = 10;
    public static final String SECTION_TEXT_TYPE_SUBTITLE = "SUBTITLE";
    public static final String SECTION_TEXT_TYPE_INSTRUCTIONS = "INSTRUCTIONS";
    protected final Logger log = LoggerFactory.getLogger(WidgetFactory.class);
    private CRFVersionBean version = null;

    public WidgetFactory(CRFVersionBean version) {
        this.version = version;
    }

    public Widget getItemWidget(ItemBean item, Integer widgetType, ItemGroupBean itemGroupBean, ItemFormMetadataBean itemFormMetaDataBean, boolean isItemRequired, String responseLayout, String expression) {
        if (responseLayout.equalsIgnoreCase("vertical")) {
            switch (widgetType) {
                case 1: {
                    return new InputWidget(this.version, item, null, itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
                case 6: {
                    return new Select1Widget(this.version, item, "minimal", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
                case 5: {
                    return new Select1Widget(this.version, item, "full", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
                case 7: {
                    return new SelectWidget(this.version, item, "minimal", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
                case 3: {
                    return new SelectWidget(this.version, item, "full", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
                case 2: {
                    return new InputWidget(this.version, item, "multiline", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
                case 8: {
                    return new InputWidget(this.version, item, null, itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
                case 9: {
                    return new InputWidget(this.version, item, null, itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
                }
            }
            this.log.debug("Unsupported form widget: " + widgetType + "  Skipping.");
            return null;
        }
        switch (widgetType) {
            case 1: {
                return new InputWidget(this.version, item, null, itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
            case 6: {
                return new Select1Widget(this.version, item, "minimal", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
            case 5: {
                return new Select1Widget(this.version, item, "horizontal-compact", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
            case 7: {
                return new SelectWidget(this.version, item, "minimal", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
            case 3: {
                return new SelectWidget(this.version, item, "horizontal", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
            case 2: {
                return new InputWidget(this.version, item, "multiline", itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
            case 8: {
                return new InputWidget(this.version, item, null, itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
            case 9: {
                return new InputWidget(this.version, item, null, itemGroupBean, itemFormMetaDataBean, isItemRequired, expression);
            }
        }
        this.log.debug("Unsupported form widget: " + widgetType + "  Skipping.");
        return null;
    }

    public Widget getHeaderWidget(ItemBean item, ItemFormMetadataBean itemMetaData, ItemGroupBean itemGroup, String expression) {
        int widgetType = itemMetaData.getResponseSet().getResponseType().getId();
        switch (widgetType) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                if (itemMetaData.getHeader() != null && !itemMetaData.getHeader().equals("")) {
                    return new HeaderWidget(this.version, item, itemMetaData, itemGroup, null, expression);
                }
                this.log.debug("No header found for widget: " + widgetType + ". Skipping.");
                return null;
            }
        }
        this.log.debug("Unsupported form widget: " + widgetType + ".  Skipping.");
        return null;
    }

    public Widget getSectionTextWidget(String versionOid, String field, SectionBean section) {
        switch (field) {
            case "SUBTITLE": {
                if (section.getSubtitle() != null && !section.getSubtitle().equals("")) {
                    return new SectionTextWidget(versionOid, section.getSubtitle(), Integer.valueOf(section.getId()), SECTION_TEXT_TYPE_SUBTITLE);
                }
                this.log.debug("No Subtitle found for Section. Skipping.");
                return null;
            }
            case "INSTRUCTIONS": {
                if (section.getInstructions() != null && !section.getSubtitle().equals("")) {
                    return new SectionTextWidget(versionOid, section.getInstructions(), Integer.valueOf(section.getId()), SECTION_TEXT_TYPE_INSTRUCTIONS);
                }
                this.log.debug("No Instructions found for Section. Skipping.");
                return null;
            }
        }
        this.log.debug("Unsupported Section Text widget: " + field + ".  Skipping.");
        return null;
    }

    public Widget getSubHeaderWidget(ItemBean item, ItemFormMetadataBean itemMetaData, ItemGroupBean itemGroup, String expression) {
        int widgetType = itemMetaData.getResponseSet().getResponseType().getId();
        switch (widgetType) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                if (itemMetaData.getSubHeader() != null && !itemMetaData.getSubHeader().equals("")) {
                    return new SubHeaderWidget(this.version, item, itemMetaData, itemGroup, null, expression);
                }
                this.log.debug("No SubHeader found for widget: " + widgetType + ". Skipping.");
                return null;
            }
        }
        this.log.debug("Unsupported form widget: " + widgetType + ".  Skipping.");
        return null;
    }

    public Widget getGroupWidget(ItemGroupBean itemGroup, CRFVersionBean version, String expression) {
        return new GroupWidget(itemGroup, version, expression);
    }

    public Widget getSectionWidget(SectionBean section, CRFVersionBean version, String expression) {
        return new SectionWidget(section, version, expression);
    }
}

