/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.restful;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.sql.DataSource;
import net.sf.json.JSON;
import net.sf.json.xml.XMLSerializer;
import org.akaza.openclinica.bean.extract.odm.FullReportBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.odmbeans.ODMBean;
import org.akaza.openclinica.bean.odmbeans.OdmClinicalDataBean;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.RuleSetRuleDao;
import org.akaza.openclinica.dao.hibernate.StudyDao;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.logic.odmExport.AdminDataCollector;
import org.akaza.openclinica.logic.odmExport.MetaDataCollector;

public class MetadataCollectorResource {
    private static final int INDENT_LEVEL = 2;
    private DataSource dataSource;
    private RuleSetRuleDao ruleSetRuleDao;
    private CoreResources coreResources;
    private StudyDao studyDaoHib;

    public StudyDao getStudyDaoHib() {
        return this.studyDaoHib;
    }

    public void setStudyDaoHib(StudyDao studyDaoHib) {
        this.studyDaoHib = studyDaoHib;
    }

    public CoreResources getCoreResources() {
        return this.coreResources;
    }

    public void setCoreResources(CoreResources coreResources) {
        this.coreResources = coreResources;
    }

    public RuleSetRuleDao getRuleSetRuleDao() {
        return this.ruleSetRuleDao;
    }

    public void setRuleSetRuleDao(RuleSetRuleDao ruleSetRuleDao) {
        this.ruleSetRuleDao = ruleSetRuleDao;
    }

    public StudyDAO getStudyDao() {
        return new StudyDAO(this.dataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String collectODMMetadata(String studyOID) {
        StudyBean studyBean = this.getStudyDao().findByOid(studyOID);
        MetaDataCollector mdc = new MetaDataCollector(this.dataSource, studyBean, this.getRuleSetRuleDao());
        AdminDataCollector adc = new AdminDataCollector(this.dataSource, studyBean);
        MetaDataCollector.setTextLength((int)200);
        ODMBean odmBean = mdc.getODMBean();
        odmBean.setSchemaLocation("http://www.cdisc.org/ns/odm/v1.3 OpenClinica-ODM1-3-0-OC2-0.xsd");
        ArrayList<String> xmlnsList = new ArrayList<String>();
        xmlnsList.add("xmlns=\"http://www.cdisc.org/ns/odm/v1.3\"");
        xmlnsList.add("xmlns:OpenClinica=\"http://www.openclinica.org/ns/odm_ext_v130/v3.1\"");
        xmlnsList.add("xmlns:OpenClinicaRules=\"http://www.openclinica.org/ns/rules/v3.1\"");
        odmBean.setXmlnsList(xmlnsList);
        odmBean.setODMVersion("oc1.3");
        mdc.setODMBean(odmBean);
        adc.setOdmbean(odmBean);
        mdc.collectFileData();
        adc.collectFileData();
        FullReportBean report = new FullReportBean();
        report.setAdminDataMap(adc.getOdmAdminDataMap());
        report.setOdmStudyMap(mdc.getOdmStudyMap());
        report.setCoreResources(this.getCoreResources());
        report.setOdmBean(mdc.getODMBean());
        report.setODMVersion("oc1.3");
        report.createStudyMetaOdmXml(Boolean.FALSE.booleanValue());
        return report.getXmlOutput().toString().trim();
    }

    public String collectODMMetadataJson(String studyOID) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        JSON json = xmlSerializer.read(this.collectODMMetadata(studyOID));
        return json.toString(2);
    }

    public JSON collectODMMetadataJson(String studyOID, String formVersionOID) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        return xmlSerializer.read(this.collectODMMetadataForForm(studyOID, formVersionOID));
    }

    public String collectODMMetadataJsonString(String studyOID, String formVersionOID) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        JSON json = xmlSerializer.read(this.collectODMMetadataForForm(studyOID, formVersionOID));
        return json.toString(2);
    }

    public String collectODMMetadataForForm(String studyOID, String formVersionOID) {
        StudyBean studyBean = this.getStudyDao().findByOid(studyOID);
        if (studyBean.isActive()) {
            studyBean = this.populateStudyBean(studyBean);
        }
        MetaDataCollector mdc = new MetaDataCollector(this.dataSource, studyBean, this.getRuleSetRuleDao());
        AdminDataCollector adc = new AdminDataCollector(this.dataSource, studyBean);
        MetaDataCollector.setTextLength((int)200);
        ODMBean odmBean = mdc.getODMBean();
        odmBean.setSchemaLocation("http://www.cdisc.org/ns/odm/v1.3 OpenClinica-ODM1-3-0-OC2-0.xsd");
        ArrayList<String> xmlnsList = new ArrayList<String>();
        xmlnsList.add("xmlns=\"http://www.cdisc.org/ns/odm/v1.3\"");
        xmlnsList.add("xmlns:OpenClinica=\"http://www.openclinica.org/ns/odm_ext_v130/v3.1\"");
        xmlnsList.add("xmlns:OpenClinicaRules=\"http://www.openclinica.org/ns/rules/v3.1\"");
        odmBean.setXmlnsList(xmlnsList);
        odmBean.setODMVersion("oc1.3");
        mdc.setODMBean(odmBean);
        adc.setOdmbean(odmBean);
        if (!studyBean.isActive()) {
            mdc.collectFileData(formVersionOID);
        } else {
            mdc.collectFileData();
        }
        adc.collectFileData();
        FullReportBean report = new FullReportBean();
        report.setAdminDataMap(adc.getOdmAdminDataMap());
        report.setOdmStudyMap(mdc.getOdmStudyMap());
        report.setCoreResources(this.getCoreResources());
        report.setOdmBean(mdc.getODMBean());
        report.setODMVersion("oc1.3");
        report.createStudyMetaOdmXml(Boolean.FALSE.booleanValue());
        return report.getXmlOutput().toString().trim();
    }

    public FullReportBean collectODMMetadataForClinicalData(String studyOID, String formVersionOID, LinkedHashMap<String, OdmClinicalDataBean> clinicalDataMap) {
        StudyBean studyBean = this.getStudyDao().findByOid(studyOID);
        if (studyBean.isActive()) {
            studyBean = this.populateStudyBean(studyBean);
        }
        MetaDataCollector mdc = new MetaDataCollector(this.dataSource, studyBean, this.getRuleSetRuleDao());
        AdminDataCollector adc = new AdminDataCollector(this.dataSource, studyBean);
        MetaDataCollector.setTextLength((int)200);
        ODMBean odmBean = mdc.getODMBean();
        odmBean.setSchemaLocation("http://www.cdisc.org/ns/odm/v1.3 OpenClinica-ODM1-3-0-OC2-0.xsd");
        ArrayList<String> xmlnsList = new ArrayList<String>();
        xmlnsList.add("xmlns=\"http://www.cdisc.org/ns/odm/v1.3\"");
        xmlnsList.add("xmlns:OpenClinica=\"http://www.openclinica.org/ns/odm_ext_v130/v3.1\"");
        xmlnsList.add("xmlns:OpenClinicaRules=\"http://www.openclinica.org/ns/rules/v3.1\"");
        odmBean.setXmlnsList(xmlnsList);
        odmBean.setODMVersion("oc1.3");
        mdc.setODMBean(odmBean);
        adc.setOdmbean(odmBean);
        if (!studyBean.isActive()) {
            mdc.collectFileData(formVersionOID);
        } else {
            mdc.collectFileData();
        }
        adc.collectFileData();
        FullReportBean report = new FullReportBean();
        report.setAdminDataMap(adc.getOdmAdminDataMap());
        report.setOdmStudyMap(mdc.getOdmStudyMap());
        report.setCoreResources(this.getCoreResources());
        report.setOdmBean(mdc.getODMBean());
        report.setClinicalDataMap(clinicalDataMap);
        report.setODMVersion("oc1.3");
        return report;
    }

    private StudyBean populateStudyBean(StudyBean studyBean) {
        StudyParameterValueDAO spvDao = new StudyParameterValueDAO(this.dataSource);
        ArrayList studyParameters = spvDao.findParamConfigByStudy(studyBean);
        studyBean.setStudyParameters(studyParameters);
        StudyConfigService scs = new StudyConfigService(this.dataSource);
        if (studyBean.getParentStudyId() <= 0) {
            studyBean = scs.setParametersForStudy(studyBean);
        } else {
            studyBean.setParentStudyName(this.getStudyDao().findByPK(studyBean.getParentStudyId()).getName());
            studyBean = scs.setParametersForSite(studyBean);
        }
        return studyBean;
    }
}

