/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.restful;

import com.sun.jersey.api.view.Viewable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.xml.XMLSerializer;
import org.akaza.openclinica.bean.extract.odm.FullReportBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.web.restful.ClinicalDataCollectorResource;
import org.akaza.openclinica.web.restful.JSONClinicalDataPostProcessor;
import org.akaza.openclinica.web.restful.MetadataCollectorResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="/clinicaldata")
@Component
@Scope(value="prototype")
public class ODMClinicaDataResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ODMClinicaDataResource.class);
    private static final int INDENT_LEVEL = 2;
    private ClinicalDataCollectorResource clinicalDataCollectorResource;
    private MetadataCollectorResource metadataCollectorResource;
    private DataSource dataSource;

    public MetadataCollectorResource getMetadataCollectorResource() {
        return this.metadataCollectorResource;
    }

    public void setMetadataCollectorResource(MetadataCollectorResource metadataCollectorResource) {
        this.metadataCollectorResource = metadataCollectorResource;
    }

    public ClinicalDataCollectorResource getClinicalDataCollectorResource() {
        return this.clinicalDataCollectorResource;
    }

    public void setClinicalDataCollectorResource(ClinicalDataCollectorResource clinicalDataCollectorResource) {
        this.clinicalDataCollectorResource = clinicalDataCollectorResource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @GET
    @Path(value="/json/view/{studyOID}/{studySubjectIdentifier}/{studyEventOID}/{formVersionOID}")
    @Produces(value={"application/json"})
    public String getODMClinicaldata(@PathParam(value="studyOID") String studyOID, @PathParam(value="formVersionOID") String formVersionOID, @PathParam(value="studyEventOID") String studyEventOID, @PathParam(value="studySubjectIdentifier") String studySubjectIdentifier, @DefaultValue(value="n") @QueryParam(value="includeDNs") String includeDns, @DefaultValue(value="n") @QueryParam(value="includeAudits") String includeAudits, @Context HttpServletRequest request) {
        LOGGER.debug("Requesting clinical data resource");
        boolean includeDN = false;
        boolean includeAudit = false;
        if (includeDns.equalsIgnoreCase("no") || includeDns.equalsIgnoreCase("n")) {
            includeDN = false;
        }
        if (includeAudits.equalsIgnoreCase("no") || includeAudits.equalsIgnoreCase("n")) {
            includeAudit = false;
        }
        if (includeDns.equalsIgnoreCase("yes") || includeDns.equalsIgnoreCase("y")) {
            includeDN = true;
        }
        if (includeAudits.equalsIgnoreCase("yes") || includeAudits.equalsIgnoreCase("y")) {
            includeAudit = true;
        }
        int userId = ((UserAccountBean)request.getSession().getAttribute("userBean")).getId();
        XMLSerializer xmlSerializer = new XMLSerializer();
        FullReportBean report = this.getMetadataCollectorResource().collectODMMetadataForClinicalData(studyOID, formVersionOID, this.getClinicalDataCollectorResource().generateClinicalData(studyOID, this.getStudySubjectOID(studySubjectIdentifier, studyOID), studyEventOID, formVersionOID, includeDN, includeAudit, request.getLocale(), userId));
        if (report.getClinicalDataMap() == null) {
            return null;
        }
        report.createOdmXml(true);
        xmlSerializer.setTypeHintsEnabled(true);
        JSON json = xmlSerializer.read(report.getXmlOutput().toString().trim());
        JSONClinicalDataPostProcessor processor = new JSONClinicalDataPostProcessor(request.getLocale());
        processor.process((JSON)((JSONObject)json));
        return json.toString(2);
    }

    @GET
    @Path(value="/html/print/{studyOID}/{studySubjectIdentifier}/{eventOID}/{formVersionOID}")
    public Viewable getPrintCRFController(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="studyOID") String studyOID, @PathParam(value="studySubjectIdentifier") String studySubjectIdentifier, @PathParam(value="eventOID") String eventOID, @PathParam(value="formVersionOID") String formVersionOID, @DefaultValue(value="n") @QueryParam(value="includeDNs") String includeDns, @DefaultValue(value="n") @QueryParam(value="includeAudits") String includeAudits) throws Exception {
        request.setCharacterEncoding("UTF-8");
        request.setAttribute("studyOID", (Object)studyOID);
        request.setAttribute("studySubjectOID", (Object)this.getStudySubjectOID(studySubjectIdentifier, studyOID));
        request.setAttribute("eventOID", (Object)eventOID);
        request.setAttribute("formVersionOID", (Object)formVersionOID);
        request.setAttribute("includeAudits", (Object)includeAudits);
        request.setAttribute("includeDNs", (Object)includeDns);
        return new Viewable("/WEB-INF/jsp/printcrf.jsp", null);
    }

    @GET
    @Path(value="/xml/view/{studyOID}/{studySubjectIdentifier}/{studyEventOID}/{formVersionOID}")
    @Produces(value={"text/xml"})
    public String getODMMetadata(@PathParam(value="studyOID") String studyOID, @PathParam(value="formVersionOID") String formVersionOID, @PathParam(value="studySubjectIdentifier") String studySubjectIdentifier, @PathParam(value="studyEventOID") String studyEventOID, @DefaultValue(value="n") @QueryParam(value="includeDNs") String includeDns, @DefaultValue(value="n") @QueryParam(value="includeAudits") String includeAudits, @Context HttpServletRequest request) {
        LOGGER.debug("Requesting clinical data resource");
        boolean includeDN = false;
        boolean includeAudit = false;
        int userId = ((UserAccountBean)request.getSession().getAttribute("userBean")).getId();
        if (includeDns.equalsIgnoreCase("no") || includeDns.equalsIgnoreCase("n")) {
            includeDN = false;
        }
        if (includeAudits.equalsIgnoreCase("no") || includeAudits.equalsIgnoreCase("n")) {
            includeAudit = false;
        }
        if (includeDns.equalsIgnoreCase("yes") || includeDns.equalsIgnoreCase("y")) {
            includeDN = true;
        }
        if (includeAudits.equalsIgnoreCase("yes") || includeAudits.equalsIgnoreCase("y")) {
            includeAudit = true;
        }
        FullReportBean report = this.getMetadataCollectorResource().collectODMMetadataForClinicalData(studyOID, formVersionOID, this.getClinicalDataCollectorResource().generateClinicalData(studyOID, this.getStudySubjectOID(studySubjectIdentifier, studyOID), studyEventOID, formVersionOID, includeDN, includeAudit, request.getLocale(), userId));
        report.createOdmXml(true);
        LOGGER.debug(report.getXmlOutput().toString().trim());
        return report.getXmlOutput().toString().trim();
    }

    private String getStudySubjectOID(String subjectIdentifier, String studyOID) {
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.getDataSource());
        StudySubjectBean studySubject = studySubjectDAO.findByOid(subjectIdentifier);
        if (subjectIdentifier.equals("*") || studySubject != null && studySubject.getOid() != null) {
            return subjectIdentifier;
        }
        StudyDAO studyDAO = new StudyDAO(this.getDataSource());
        StudyBean study = studyDAO.findByOid(studyOID);
        studySubject = studySubjectDAO.findByLabelAndStudy(subjectIdentifier, study);
        if (studySubject != null && studySubject.getOid() != null) {
            return studySubject.getOid();
        }
        return subjectIdentifier;
    }
}

